# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Spanner
      module V1
        # Spanner Change Streams enable customers to capture and stream out changes to
        # their Spanner databases in real-time. A change stream
        # can be created with option partition_mode='IMMUTABLE_KEY_RANGE' or
        # partition_mode='MUTABLE_KEY_RANGE'.
        #
        # This message is only used in Change Streams created with the option
        # partition_mode='MUTABLE_KEY_RANGE'. Spanner automatically creates a special
        # Table-Valued Function (TVF) along with each Change Streams. The function
        # provides access to the change stream's records. The function is named
        # READ_<change_stream_name> (where <change_stream_name> is the
        # name of the change stream), and it returns a table with only one column
        # called ChangeRecord.
        # @!attribute [rw] data_change_record
        #   @return [::Google::Cloud::Spanner::V1::ChangeStreamRecord::DataChangeRecord]
        #     Data change record describing a data change for a change stream
        #     partition.
        #
        #     Note: The following fields are mutually exclusive: `data_change_record`, `heartbeat_record`, `partition_start_record`, `partition_end_record`, `partition_event_record`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] heartbeat_record
        #   @return [::Google::Cloud::Spanner::V1::ChangeStreamRecord::HeartbeatRecord]
        #     Heartbeat record describing a heartbeat for a change stream partition.
        #
        #     Note: The following fields are mutually exclusive: `heartbeat_record`, `data_change_record`, `partition_start_record`, `partition_end_record`, `partition_event_record`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] partition_start_record
        #   @return [::Google::Cloud::Spanner::V1::ChangeStreamRecord::PartitionStartRecord]
        #     Partition start record describing a new change stream partition.
        #
        #     Note: The following fields are mutually exclusive: `partition_start_record`, `data_change_record`, `heartbeat_record`, `partition_end_record`, `partition_event_record`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] partition_end_record
        #   @return [::Google::Cloud::Spanner::V1::ChangeStreamRecord::PartitionEndRecord]
        #     Partition end record describing a terminated change stream partition.
        #
        #     Note: The following fields are mutually exclusive: `partition_end_record`, `data_change_record`, `heartbeat_record`, `partition_start_record`, `partition_event_record`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] partition_event_record
        #   @return [::Google::Cloud::Spanner::V1::ChangeStreamRecord::PartitionEventRecord]
        #     Partition event record describing key range changes for a change stream
        #     partition.
        #
        #     Note: The following fields are mutually exclusive: `partition_event_record`, `data_change_record`, `heartbeat_record`, `partition_start_record`, `partition_end_record`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class ChangeStreamRecord
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A data change record contains a set of changes to a table with the same
          # modification type (insert, update, or delete) committed at the same commit
          # timestamp in one change stream partition for the same transaction. Multiple
          # data change records can be returned for the same transaction across
          # multiple change stream partitions.
          # @!attribute [rw] commit_timestamp
          #   @return [::Google::Protobuf::Timestamp]
          #     Indicates the timestamp in which the change was committed.
          #     DataChangeRecord.commit_timestamps,
          #     PartitionStartRecord.start_timestamps,
          #     PartitionEventRecord.commit_timestamps, and
          #     PartitionEndRecord.end_timestamps can have the same value in the same
          #     partition.
          # @!attribute [rw] record_sequence
          #   @return [::String]
          #     Record sequence numbers are unique and monotonically increasing (but not
          #     necessarily contiguous) for a specific timestamp across record
          #     types in the same partition. To guarantee ordered processing, the reader
          #     should process records (of potentially different types) in
          #     record_sequence order for a specific timestamp in the same partition.
          #
          #     The record sequence number ordering across partitions is only meaningful
          #     in the context of a specific transaction. Record sequence numbers are
          #     unique across partitions for a specific transaction. Sort the
          #     DataChangeRecords for the same
          #     {::Google::Cloud::Spanner::V1::ChangeStreamRecord::DataChangeRecord#server_transaction_id server_transaction_id}
          #     by
          #     {::Google::Cloud::Spanner::V1::ChangeStreamRecord::DataChangeRecord#record_sequence record_sequence}
          #     to reconstruct the ordering of the changes within the transaction.
          # @!attribute [rw] server_transaction_id
          #   @return [::String]
          #     Provides a globally unique string that represents the transaction in
          #     which the change was committed. Multiple transactions can have the same
          #     commit timestamp, but each transaction has a unique
          #     server_transaction_id.
          # @!attribute [rw] is_last_record_in_transaction_in_partition
          #   @return [::Boolean]
          #     Indicates whether this is the last record for a transaction in the
          #      current partition. Clients can use this field to determine when all
          #      records for a transaction in the current partition have been received.
          # @!attribute [rw] table
          #   @return [::String]
          #     Name of the table affected by the change.
          # @!attribute [rw] column_metadata
          #   @return [::Array<::Google::Cloud::Spanner::V1::ChangeStreamRecord::DataChangeRecord::ColumnMetadata>]
          #     Provides metadata describing the columns associated with the
          #     {::Google::Cloud::Spanner::V1::ChangeStreamRecord::DataChangeRecord#mods mods} listed
          #     below.
          # @!attribute [rw] mods
          #   @return [::Array<::Google::Cloud::Spanner::V1::ChangeStreamRecord::DataChangeRecord::Mod>]
          #     Describes the changes that were made.
          # @!attribute [rw] mod_type
          #   @return [::Google::Cloud::Spanner::V1::ChangeStreamRecord::DataChangeRecord::ModType]
          #     Describes the type of change.
          # @!attribute [rw] value_capture_type
          #   @return [::Google::Cloud::Spanner::V1::ChangeStreamRecord::DataChangeRecord::ValueCaptureType]
          #     Describes the value capture type that was specified in the change stream
          #     configuration when this change was captured.
          # @!attribute [rw] number_of_records_in_transaction
          #   @return [::Integer]
          #     Indicates the number of data change records that are part of this
          #     transaction across all change stream partitions. This value can be used
          #     to assemble all the records associated with a particular transaction.
          # @!attribute [rw] number_of_partitions_in_transaction
          #   @return [::Integer]
          #     Indicates the number of partitions that return data change records for
          #     this transaction. This value can be helpful in assembling all records
          #     associated with a particular transaction.
          # @!attribute [rw] transaction_tag
          #   @return [::String]
          #     Indicates the transaction tag associated with this transaction.
          # @!attribute [rw] is_system_transaction
          #   @return [::Boolean]
          #     Indicates whether the transaction is a system transaction. System
          #     transactions include those issued by time-to-live (TTL), column backfill,
          #     etc.
          class DataChangeRecord
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Metadata for a column.
            # @!attribute [rw] name
            #   @return [::String]
            #     Name of the column.
            # @!attribute [rw] type
            #   @return [::Google::Cloud::Spanner::V1::Type]
            #     Type of the column.
            # @!attribute [rw] is_primary_key
            #   @return [::Boolean]
            #     Indicates whether the column is a primary key column.
            # @!attribute [rw] ordinal_position
            #   @return [::Integer]
            #     Ordinal position of the column based on the original table definition
            #     in the schema starting with a value of 1.
            class ColumnMetadata
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Returns the value and associated metadata for a particular field of the
            # {::Google::Cloud::Spanner::V1::ChangeStreamRecord::DataChangeRecord::Mod Mod}.
            # @!attribute [rw] column_metadata_index
            #   @return [::Integer]
            #     Index within the repeated
            #     {::Google::Cloud::Spanner::V1::ChangeStreamRecord::DataChangeRecord#column_metadata column_metadata}
            #     field, to obtain the column metadata for the column that was modified.
            # @!attribute [rw] value
            #   @return [::Google::Protobuf::Value]
            #     The value of the column.
            class ModValue
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # A mod describes all data changes in a watched table row.
            # @!attribute [rw] keys
            #   @return [::Array<::Google::Cloud::Spanner::V1::ChangeStreamRecord::DataChangeRecord::ModValue>]
            #     Returns the value of the primary key of the modified row.
            # @!attribute [rw] old_values
            #   @return [::Array<::Google::Cloud::Spanner::V1::ChangeStreamRecord::DataChangeRecord::ModValue>]
            #     Returns the old values before the change for the modified columns.
            #     Always empty for
            #     {::Google::Cloud::Spanner::V1::ChangeStreamRecord::DataChangeRecord::ModType::INSERT INSERT},
            #     or if old values are not being captured specified by
            #     {::Google::Cloud::Spanner::V1::ChangeStreamRecord::DataChangeRecord::ValueCaptureType value_capture_type}.
            # @!attribute [rw] new_values
            #   @return [::Array<::Google::Cloud::Spanner::V1::ChangeStreamRecord::DataChangeRecord::ModValue>]
            #     Returns the new values after the change for the modified columns.
            #     Always empty for
            #     {::Google::Cloud::Spanner::V1::ChangeStreamRecord::DataChangeRecord::ModType::DELETE DELETE}.
            class Mod
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Mod type describes the type of change Spanner applied to the data. For
            # example, if the client submits an INSERT_OR_UPDATE request, Spanner will
            # perform an insert if there is no existing row and return ModType INSERT.
            # Alternatively, if there is an existing row, Spanner will perform an
            # update and return ModType UPDATE.
            module ModType
              # Not specified.
              MOD_TYPE_UNSPECIFIED = 0

              # Indicates data was inserted.
              INSERT = 10

              # Indicates existing data was updated.
              UPDATE = 20

              # Indicates existing data was deleted.
              DELETE = 30
            end

            # Value capture type describes which values are recorded in the data
            # change record.
            module ValueCaptureType
              # Not specified.
              VALUE_CAPTURE_TYPE_UNSPECIFIED = 0

              # Records both old and new values of the modified watched columns.
              OLD_AND_NEW_VALUES = 10

              # Records only new values of the modified watched columns.
              NEW_VALUES = 20

              # Records new values of all watched columns, including modified and
              # unmodified columns.
              NEW_ROW = 30

              # Records the new values of all watched columns, including modified and
              # unmodified columns. Also records the old values of the modified
              # columns.
              NEW_ROW_AND_OLD_VALUES = 40
            end
          end

          # A heartbeat record is returned as a progress indicator, when there are no
          # data changes or any other partition record types in the change stream
          # partition.
          # @!attribute [rw] timestamp
          #   @return [::Google::Protobuf::Timestamp]
          #     Indicates the timestamp at which the query has returned all the records
          #     in the change stream partition with timestamp <= heartbeat timestamp.
          #     The heartbeat timestamp will not be the same as the timestamps of other
          #     record types in the same partition.
          class HeartbeatRecord
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A partition start record serves as a notification that the client should
          # schedule the partitions to be queried. PartitionStartRecord returns
          # information about one or more partitions.
          # @!attribute [rw] start_timestamp
          #   @return [::Google::Protobuf::Timestamp]
          #     Start timestamp at which the partitions should be queried to return
          #     change stream records with timestamps >= start_timestamp.
          #     DataChangeRecord.commit_timestamps,
          #     PartitionStartRecord.start_timestamps,
          #     PartitionEventRecord.commit_timestamps, and
          #     PartitionEndRecord.end_timestamps can have the same value in the same
          #     partition.
          # @!attribute [rw] record_sequence
          #   @return [::String]
          #     Record sequence numbers are unique and monotonically increasing (but not
          #     necessarily contiguous) for a specific timestamp across record
          #     types in the same partition. To guarantee ordered processing, the reader
          #     should process records (of potentially different types) in
          #     record_sequence order for a specific timestamp in the same partition.
          # @!attribute [rw] partition_tokens
          #   @return [::Array<::String>]
          #     Unique partition identifiers to be used in queries.
          class PartitionStartRecord
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A partition end record serves as a notification that the client should stop
          # reading the partition. No further records are expected to be retrieved on
          # it.
          # @!attribute [rw] end_timestamp
          #   @return [::Google::Protobuf::Timestamp]
          #     End timestamp at which the change stream partition is terminated. All
          #     changes generated by this partition will have timestamps <=
          #     end_timestamp. DataChangeRecord.commit_timestamps,
          #     PartitionStartRecord.start_timestamps,
          #     PartitionEventRecord.commit_timestamps, and
          #     PartitionEndRecord.end_timestamps can have the same value in the same
          #     partition. PartitionEndRecord is the last record returned for a
          #     partition.
          # @!attribute [rw] record_sequence
          #   @return [::String]
          #     Record sequence numbers are unique and monotonically increasing (but not
          #     necessarily contiguous) for a specific timestamp across record
          #     types in the same partition. To guarantee ordered processing, the reader
          #     should process records (of potentially different types) in
          #     record_sequence order for a specific timestamp in the same partition.
          # @!attribute [rw] partition_token
          #   @return [::String]
          #     Unique partition identifier describing the terminated change stream
          #     partition.
          #     {::Google::Cloud::Spanner::V1::ChangeStreamRecord::PartitionEndRecord#partition_token partition_token}
          #     is equal to the partition token of the change stream partition currently
          #     queried to return this PartitionEndRecord.
          class PartitionEndRecord
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A partition event record describes key range changes for a change stream
          # partition. The changes to a row defined by its primary key can be captured
          # in one change stream partition for a specific time range, and then be
          # captured in a different change stream partition for a different time range.
          # This movement of key ranges across change stream partitions is a reflection
          # of activities, such as Spanner's dynamic splitting and load balancing, etc.
          # Processing this event is needed if users want to guarantee processing of
          # the changes for any key in timestamp order. If time ordered processing of
          # changes for a primary key is not needed, this event can be ignored.
          # To guarantee time ordered processing for each primary key, if the event
          # describes move-ins, the reader of this partition needs to wait until the
          # readers of the source partitions have processed all records with timestamps
          # <= this PartitionEventRecord.commit_timestamp, before advancing beyond this
          # PartitionEventRecord. If the event describes move-outs, the reader can
          # notify the readers of the destination partitions that they can continue
          # processing.
          # @!attribute [rw] commit_timestamp
          #   @return [::Google::Protobuf::Timestamp]
          #     Indicates the commit timestamp at which the key range change occurred.
          #     DataChangeRecord.commit_timestamps,
          #     PartitionStartRecord.start_timestamps,
          #     PartitionEventRecord.commit_timestamps, and
          #     PartitionEndRecord.end_timestamps can have the same value in the same
          #     partition.
          # @!attribute [rw] record_sequence
          #   @return [::String]
          #     Record sequence numbers are unique and monotonically increasing (but not
          #     necessarily contiguous) for a specific timestamp across record
          #     types in the same partition. To guarantee ordered processing, the reader
          #     should process records (of potentially different types) in
          #     record_sequence order for a specific timestamp in the same partition.
          # @!attribute [rw] partition_token
          #   @return [::String]
          #     Unique partition identifier describing the partition this event
          #     occurred on.
          #     {::Google::Cloud::Spanner::V1::ChangeStreamRecord::PartitionEventRecord#partition_token partition_token}
          #     is equal to the partition token of the change stream partition currently
          #     queried to return this PartitionEventRecord.
          # @!attribute [rw] move_in_events
          #   @return [::Array<::Google::Cloud::Spanner::V1::ChangeStreamRecord::PartitionEventRecord::MoveInEvent>]
          #     Set when one or more key ranges are moved into the change stream
          #     partition identified by
          #     {::Google::Cloud::Spanner::V1::ChangeStreamRecord::PartitionEventRecord#partition_token partition_token}.
          #
          #     Example: Two key ranges are moved into partition (P1) from partition (P2)
          #     and partition (P3) in a single transaction at timestamp T.
          #
          #     The PartitionEventRecord returned in P1 will reflect the move as:
          #
          #     PartitionEventRecord {
          #       commit_timestamp: T
          #       partition_token: "P1"
          #       move_in_events {
          #         source_partition_token: "P2"
          #       }
          #       move_in_events {
          #         source_partition_token: "P3"
          #       }
          #     }
          #
          #     The PartitionEventRecord returned in P2 will reflect the move as:
          #
          #     PartitionEventRecord {
          #       commit_timestamp: T
          #       partition_token: "P2"
          #       move_out_events {
          #         destination_partition_token: "P1"
          #       }
          #     }
          #
          #     The PartitionEventRecord returned in P3 will reflect the move as:
          #
          #     PartitionEventRecord {
          #       commit_timestamp: T
          #       partition_token: "P3"
          #       move_out_events {
          #         destination_partition_token: "P1"
          #       }
          #     }
          # @!attribute [rw] move_out_events
          #   @return [::Array<::Google::Cloud::Spanner::V1::ChangeStreamRecord::PartitionEventRecord::MoveOutEvent>]
          #     Set when one or more key ranges are moved out of the change stream
          #     partition identified by
          #     {::Google::Cloud::Spanner::V1::ChangeStreamRecord::PartitionEventRecord#partition_token partition_token}.
          #
          #     Example: Two key ranges are moved out of partition (P1) to partition (P2)
          #     and partition (P3) in a single transaction at timestamp T.
          #
          #     The PartitionEventRecord returned in P1 will reflect the move as:
          #
          #     PartitionEventRecord {
          #       commit_timestamp: T
          #       partition_token: "P1"
          #       move_out_events {
          #         destination_partition_token: "P2"
          #       }
          #       move_out_events {
          #         destination_partition_token: "P3"
          #       }
          #     }
          #
          #     The PartitionEventRecord returned in P2 will reflect the move as:
          #
          #     PartitionEventRecord {
          #       commit_timestamp: T
          #       partition_token: "P2"
          #       move_in_events {
          #         source_partition_token: "P1"
          #       }
          #     }
          #
          #     The PartitionEventRecord returned in P3 will reflect the move as:
          #
          #     PartitionEventRecord {
          #       commit_timestamp: T
          #       partition_token: "P3"
          #       move_in_events {
          #         source_partition_token: "P1"
          #       }
          #     }
          class PartitionEventRecord
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Describes move-in of the key ranges into the change stream partition
            # identified by
            # {::Google::Cloud::Spanner::V1::ChangeStreamRecord::PartitionEventRecord#partition_token partition_token}.
            #
            # To maintain processing the changes for a particular key in timestamp
            # order, the query processing the change stream partition identified by
            # {::Google::Cloud::Spanner::V1::ChangeStreamRecord::PartitionEventRecord#partition_token partition_token}
            # should not advance beyond the partition event record commit timestamp
            # until the queries processing the source change stream partitions have
            # processed all change stream records with timestamps <= the partition
            # event record commit timestamp.
            # @!attribute [rw] source_partition_token
            #   @return [::String]
            #     An unique partition identifier describing the source change stream
            #     partition that recorded changes for the key range that is moving
            #     into this partition.
            class MoveInEvent
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Describes move-out of the key ranges out of the change stream partition
            # identified by
            # {::Google::Cloud::Spanner::V1::ChangeStreamRecord::PartitionEventRecord#partition_token partition_token}.
            #
            # To maintain processing the changes for a particular key in timestamp
            # order, the query processing the
            # {::Google::Cloud::Spanner::V1::ChangeStreamRecord::PartitionEventRecord::MoveOutEvent MoveOutEvent}
            # in the partition identified by
            # {::Google::Cloud::Spanner::V1::ChangeStreamRecord::PartitionEventRecord#partition_token partition_token}
            # should inform the queries processing the destination partitions that
            # they can unblock and proceed processing records past the
            # {::Google::Cloud::Spanner::V1::ChangeStreamRecord::PartitionEventRecord#commit_timestamp commit_timestamp}.
            # @!attribute [rw] destination_partition_token
            #   @return [::String]
            #     An unique partition identifier describing the destination change
            #     stream partition that will record changes for the key range that is
            #     moving out of this partition.
            class MoveOutEvent
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end
      end
    end
  end
end
