# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Spanner
      module V1
        module Spanner
          # Path helper methods for the Spanner API.
          module Paths
            ##
            # Create a fully-qualified Database resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/instances/{instance}/databases/{database}`
            #
            # @param project [String]
            # @param instance [String]
            # @param database [String]
            #
            # @return [::String]
            def database_path project:, instance:, database:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "instance cannot contain /" if instance.to_s.include? "/"

              "projects/#{project}/instances/#{instance}/databases/#{database}"
            end

            ##
            # Create a fully-qualified Session resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/instances/{instance}/databases/{database}/sessions/{session}`
            #
            # @param project [String]
            # @param instance [String]
            # @param database [String]
            # @param session [String]
            #
            # @return [::String]
            def session_path project:, instance:, database:, session:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "instance cannot contain /" if instance.to_s.include? "/"
              raise ::ArgumentError, "database cannot contain /" if database.to_s.include? "/"

              "projects/#{project}/instances/#{instance}/databases/#{database}/sessions/#{session}"
            end

            extend self
          end
        end
      end
    end
  end
end
