# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/spanner/v1/spanner_pb"

module Google
  module Cloud
    module Spanner
      module V1
        module Spanner
          ##
          # Client for the Spanner service.
          #
          # Cloud Spanner API
          #
          # The Cloud Spanner API can be used to manage sessions and execute
          # transactions on data stored in Cloud Spanner databases.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "spanner.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :spanner_stub

            ##
            # Configure the Spanner Client class.
            #
            # See {::Google::Cloud::Spanner::V1::Spanner::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all Spanner clients
            #   ::Google::Cloud::Spanner::V1::Spanner::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "Spanner", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.create_session.timeout = 30.0
                default_config.rpcs.create_session.retry_policy = {
                  initial_delay: 0.25, max_delay: 32.0, multiplier: 1.3, retry_codes: [14, 8]
                }

                default_config.rpcs.batch_create_sessions.timeout = 60.0
                default_config.rpcs.batch_create_sessions.retry_policy = {
                  initial_delay: 0.25, max_delay: 32.0, multiplier: 1.3, retry_codes: [14, 8]
                }

                default_config.rpcs.get_session.timeout = 30.0
                default_config.rpcs.get_session.retry_policy = {
                  initial_delay: 0.25, max_delay: 32.0, multiplier: 1.3, retry_codes: [14, 8]
                }

                default_config.rpcs.list_sessions.timeout = 3600.0
                default_config.rpcs.list_sessions.retry_policy = {
                  initial_delay: 0.25, max_delay: 32.0, multiplier: 1.3, retry_codes: [14, 8]
                }

                default_config.rpcs.delete_session.timeout = 30.0
                default_config.rpcs.delete_session.retry_policy = {
                  initial_delay: 0.25, max_delay: 32.0, multiplier: 1.3, retry_codes: [14, 8]
                }

                default_config.rpcs.execute_sql.timeout = 30.0
                default_config.rpcs.execute_sql.retry_policy = {
                  initial_delay: 0.25, max_delay: 32.0, multiplier: 1.3, retry_codes: [14, 8]
                }

                default_config.rpcs.execute_streaming_sql.timeout = 3600.0

                default_config.rpcs.execute_batch_dml.timeout = 30.0
                default_config.rpcs.execute_batch_dml.retry_policy = {
                  initial_delay: 0.25, max_delay: 32.0, multiplier: 1.3, retry_codes: [14, 8]
                }

                default_config.rpcs.read.timeout = 30.0
                default_config.rpcs.read.retry_policy = {
                  initial_delay: 0.25, max_delay: 32.0, multiplier: 1.3, retry_codes: [14, 8]
                }

                default_config.rpcs.streaming_read.timeout = 3600.0

                default_config.rpcs.begin_transaction.timeout = 30.0
                default_config.rpcs.begin_transaction.retry_policy = {
                  initial_delay: 0.25, max_delay: 32.0, multiplier: 1.3, retry_codes: [14, 8]
                }

                default_config.rpcs.commit.timeout = 3600.0
                default_config.rpcs.commit.retry_policy = {
                  initial_delay: 0.25, max_delay: 32.0, multiplier: 1.3, retry_codes: [14, 8]
                }

                default_config.rpcs.rollback.timeout = 30.0
                default_config.rpcs.rollback.retry_policy = {
                  initial_delay: 0.25, max_delay: 32.0, multiplier: 1.3, retry_codes: [14, 8]
                }

                default_config.rpcs.partition_query.timeout = 30.0
                default_config.rpcs.partition_query.retry_policy = {
                  initial_delay: 0.25, max_delay: 32.0, multiplier: 1.3, retry_codes: [14, 8]
                }

                default_config.rpcs.partition_read.timeout = 30.0
                default_config.rpcs.partition_read.retry_policy = {
                  initial_delay: 0.25, max_delay: 32.0, multiplier: 1.3, retry_codes: [14, 8]
                }

                default_config.rpcs.batch_write.timeout = 3600.0

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the Spanner Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::Spanner::V1::Spanner::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @spanner_stub.universe_domain
            end

            ##
            # Create a new Spanner client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::Spanner::V1::Spanner::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::Spanner::V1::Spanner::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Spanner client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/spanner/v1/spanner_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @spanner_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::Spanner::V1::Spanner::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @spanner_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end
            end

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @spanner_stub.logger
            end

            # Service calls

            ##
            # Creates a new session. A session can be used to perform
            # transactions that read and/or modify data in a Cloud Spanner database.
            # Sessions are meant to be reused for many consecutive
            # transactions.
            #
            # Sessions can only execute one transaction at a time. To execute
            # multiple concurrent read-write/write-only transactions, create
            # multiple sessions. Note that standalone reads and queries use a
            # transaction internally, and count toward the one transaction
            # limit.
            #
            # Active sessions use additional server resources, so it's a good idea to
            # delete idle and unneeded sessions.
            # Aside from explicit deletes, Cloud Spanner can delete sessions when no
            # operations are sent for more than an hour. If a session is deleted,
            # requests to it return `NOT_FOUND`.
            #
            # Idle sessions can be kept alive by sending a trivial SQL query
            # periodically, for example, `"SELECT 1"`.
            #
            # @overload create_session(request, options = nil)
            #   Pass arguments to `create_session` via a request object, either of type
            #   {::Google::Cloud::Spanner::V1::CreateSessionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Spanner::V1::CreateSessionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_session(database: nil, session: nil)
            #   Pass arguments to `create_session` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param database [::String]
            #     Required. The database in which the new session is created.
            #   @param session [::Google::Cloud::Spanner::V1::Session, ::Hash]
            #     Required. The session to create.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Spanner::V1::Session]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Spanner::V1::Session]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/spanner/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Spanner::V1::Spanner::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Spanner::V1::CreateSessionRequest.new
            #
            #   # Call the create_session method.
            #   result = client.create_session request
            #
            #   # The returned object is of type Google::Cloud::Spanner::V1::Session.
            #   p result
            #
            def create_session request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::V1::CreateSessionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_session.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Spanner::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.database
                header_params["database"] = request.database
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_session.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_session.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @spanner_stub.call_rpc :create_session, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates multiple new sessions.
            #
            # This API can be used to initialize a session cache on the clients.
            # See https://goo.gl/TgSFN2 for best practices on session cache management.
            #
            # @overload batch_create_sessions(request, options = nil)
            #   Pass arguments to `batch_create_sessions` via a request object, either of type
            #   {::Google::Cloud::Spanner::V1::BatchCreateSessionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Spanner::V1::BatchCreateSessionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload batch_create_sessions(database: nil, session_template: nil, session_count: nil)
            #   Pass arguments to `batch_create_sessions` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param database [::String]
            #     Required. The database in which the new sessions are created.
            #   @param session_template [::Google::Cloud::Spanner::V1::Session, ::Hash]
            #     Parameters to apply to each created session.
            #   @param session_count [::Integer]
            #     Required. The number of sessions to be created in this batch call. At least
            #     one session is created. The API can return fewer than the requested number
            #     of sessions. If a specific number of sessions are desired, the client can
            #     make additional calls to `BatchCreateSessions` (adjusting
            #     {::Google::Cloud::Spanner::V1::BatchCreateSessionsRequest#session_count session_count}
            #     as necessary).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Spanner::V1::BatchCreateSessionsResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Spanner::V1::BatchCreateSessionsResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/spanner/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Spanner::V1::Spanner::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Spanner::V1::BatchCreateSessionsRequest.new
            #
            #   # Call the batch_create_sessions method.
            #   result = client.batch_create_sessions request
            #
            #   # The returned object is of type Google::Cloud::Spanner::V1::BatchCreateSessionsResponse.
            #   p result
            #
            def batch_create_sessions request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::V1::BatchCreateSessionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.batch_create_sessions.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Spanner::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.database
                header_params["database"] = request.database
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.batch_create_sessions.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.batch_create_sessions.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @spanner_stub.call_rpc :batch_create_sessions, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a session. Returns `NOT_FOUND` if the session doesn't exist.
            # This is mainly useful for determining whether a session is still
            # alive.
            #
            # @overload get_session(request, options = nil)
            #   Pass arguments to `get_session` via a request object, either of type
            #   {::Google::Cloud::Spanner::V1::GetSessionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Spanner::V1::GetSessionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_session(name: nil)
            #   Pass arguments to `get_session` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the session to retrieve.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Spanner::V1::Session]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Spanner::V1::Session]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/spanner/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Spanner::V1::Spanner::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Spanner::V1::GetSessionRequest.new
            #
            #   # Call the get_session method.
            #   result = client.get_session request
            #
            #   # The returned object is of type Google::Cloud::Spanner::V1::Session.
            #   p result
            #
            def get_session request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::V1::GetSessionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_session.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Spanner::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_session.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_session.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @spanner_stub.call_rpc :get_session, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists all sessions in a given database.
            #
            # @overload list_sessions(request, options = nil)
            #   Pass arguments to `list_sessions` via a request object, either of type
            #   {::Google::Cloud::Spanner::V1::ListSessionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Spanner::V1::ListSessionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_sessions(database: nil, page_size: nil, page_token: nil, filter: nil)
            #   Pass arguments to `list_sessions` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param database [::String]
            #     Required. The database in which to list sessions.
            #   @param page_size [::Integer]
            #     Number of sessions to be returned in the response. If 0 or less, defaults
            #     to the server's maximum allowed page size.
            #   @param page_token [::String]
            #     If non-empty, `page_token` should contain a
            #     {::Google::Cloud::Spanner::V1::ListSessionsResponse#next_page_token next_page_token}
            #     from a previous
            #     {::Google::Cloud::Spanner::V1::ListSessionsResponse ListSessionsResponse}.
            #   @param filter [::String]
            #     An expression for filtering the results of the request. Filter rules are
            #     case insensitive. The fields eligible for filtering are:
            #
            #       * `labels.key` where key is the name of a label
            #
            #     Some examples of using filters are:
            #
            #       * `labels.env:*` --> The session has the label "env".
            #       * `labels.env:dev` --> The session has the label "env" and the value of
            #                            the label contains the string "dev".
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Spanner::V1::Session>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Spanner::V1::Session>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/spanner/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Spanner::V1::Spanner::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Spanner::V1::ListSessionsRequest.new
            #
            #   # Call the list_sessions method.
            #   result = client.list_sessions request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Spanner::V1::Session.
            #     p item
            #   end
            #
            def list_sessions request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::V1::ListSessionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_sessions.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Spanner::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.database
                header_params["database"] = request.database
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_sessions.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_sessions.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @spanner_stub.call_rpc :list_sessions, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @spanner_stub, :list_sessions, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Ends a session, releasing server resources associated with it. This
            # asynchronously triggers the cancellation of any operations that are running
            # with this session.
            #
            # @overload delete_session(request, options = nil)
            #   Pass arguments to `delete_session` via a request object, either of type
            #   {::Google::Cloud::Spanner::V1::DeleteSessionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Spanner::V1::DeleteSessionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_session(name: nil)
            #   Pass arguments to `delete_session` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the session to delete.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/spanner/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Spanner::V1::Spanner::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Spanner::V1::DeleteSessionRequest.new
            #
            #   # Call the delete_session method.
            #   result = client.delete_session request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_session request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::V1::DeleteSessionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_session.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Spanner::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_session.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_session.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @spanner_stub.call_rpc :delete_session, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Executes an SQL statement, returning all results in a single reply. This
            # method can't be used to return a result set larger than 10 MiB;
            # if the query yields more data than that, the query fails with
            # a `FAILED_PRECONDITION` error.
            #
            # Operations inside read-write transactions might return `ABORTED`. If
            # this occurs, the application should restart the transaction from
            # the beginning. See {::Google::Cloud::Spanner::V1::Transaction Transaction} for more
            # details.
            #
            # Larger result sets can be fetched in streaming fashion by calling
            # {::Google::Cloud::Spanner::V1::Spanner::Client#execute_streaming_sql ExecuteStreamingSql}
            # instead.
            #
            # The query string can be SQL or [Graph Query Language
            # (GQL)](https://cloud.google.com/spanner/docs/reference/standard-sql/graph-intro).
            #
            # @overload execute_sql(request, options = nil)
            #   Pass arguments to `execute_sql` via a request object, either of type
            #   {::Google::Cloud::Spanner::V1::ExecuteSqlRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Spanner::V1::ExecuteSqlRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload execute_sql(session: nil, transaction: nil, sql: nil, params: nil, param_types: nil, resume_token: nil, query_mode: nil, partition_token: nil, seqno: nil, query_options: nil, request_options: nil, directed_read_options: nil, data_boost_enabled: nil, last_statement: nil, routing_hint: nil)
            #   Pass arguments to `execute_sql` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param session [::String]
            #     Required. The session in which the SQL query should be performed.
            #   @param transaction [::Google::Cloud::Spanner::V1::TransactionSelector, ::Hash]
            #     The transaction to use.
            #
            #     For queries, if none is provided, the default is a temporary read-only
            #     transaction with strong concurrency.
            #
            #     Standard DML statements require a read-write transaction. To protect
            #     against replays, single-use transactions are not supported. The caller
            #     must either supply an existing transaction ID or begin a new transaction.
            #
            #     Partitioned DML requires an existing Partitioned DML transaction ID.
            #   @param sql [::String]
            #     Required. The SQL string.
            #   @param params [::Google::Protobuf::Struct, ::Hash]
            #     Parameter names and values that bind to placeholders in the SQL string.
            #
            #     A parameter placeholder consists of the `@` character followed by the
            #     parameter name (for example, `@firstName`). Parameter names must conform
            #     to the naming requirements of identifiers as specified at
            #     https://cloud.google.com/spanner/docs/lexical#identifiers.
            #
            #     Parameters can appear anywhere that a literal value is expected. The same
            #     parameter name can be used more than once, for example:
            #
            #     `"WHERE id > @msg_id AND id < @msg_id + 100"`
            #
            #     It's an error to execute a SQL statement with unbound parameters.
            #   @param param_types [::Hash{::String => ::Google::Cloud::Spanner::V1::Type, ::Hash}]
            #     It isn't always possible for Cloud Spanner to infer the right SQL type
            #     from a JSON value. For example, values of type `BYTES` and values
            #     of type `STRING` both appear in
            #     {::Google::Cloud::Spanner::V1::ExecuteSqlRequest#params params} as JSON strings.
            #
            #     In these cases, you can use `param_types` to specify the exact
            #     SQL type for some or all of the SQL statement parameters. See the
            #     definition of {::Google::Cloud::Spanner::V1::Type Type} for more information
            #     about SQL types.
            #   @param resume_token [::String]
            #     If this request is resuming a previously interrupted SQL statement
            #     execution, `resume_token` should be copied from the last
            #     {::Google::Cloud::Spanner::V1::PartialResultSet PartialResultSet} yielded before the
            #     interruption. Doing this enables the new SQL statement execution to resume
            #     where the last one left off. The rest of the request parameters must
            #     exactly match the request that yielded this token.
            #   @param query_mode [::Google::Cloud::Spanner::V1::ExecuteSqlRequest::QueryMode]
            #     Used to control the amount of debugging information returned in
            #     {::Google::Cloud::Spanner::V1::ResultSetStats ResultSetStats}. If
            #     {::Google::Cloud::Spanner::V1::ExecuteSqlRequest#partition_token partition_token} is
            #     set, {::Google::Cloud::Spanner::V1::ExecuteSqlRequest#query_mode query_mode} can only
            #     be set to
            #     {::Google::Cloud::Spanner::V1::ExecuteSqlRequest::QueryMode::NORMAL QueryMode.NORMAL}.
            #   @param partition_token [::String]
            #     If present, results are restricted to the specified partition
            #     previously created using `PartitionQuery`. There must be an exact
            #     match for the values of fields common to this message and the
            #     `PartitionQueryRequest` message used to create this `partition_token`.
            #   @param seqno [::Integer]
            #     A per-transaction sequence number used to identify this request. This field
            #     makes each request idempotent such that if the request is received multiple
            #     times, at most one succeeds.
            #
            #     The sequence number must be monotonically increasing within the
            #     transaction. If a request arrives for the first time with an out-of-order
            #     sequence number, the transaction can be aborted. Replays of previously
            #     handled requests yield the same response as the first execution.
            #
            #     Required for DML statements. Ignored for queries.
            #   @param query_options [::Google::Cloud::Spanner::V1::ExecuteSqlRequest::QueryOptions, ::Hash]
            #     Query optimizer configuration to use for the given query.
            #   @param request_options [::Google::Cloud::Spanner::V1::RequestOptions, ::Hash]
            #     Common options for this request.
            #   @param directed_read_options [::Google::Cloud::Spanner::V1::DirectedReadOptions, ::Hash]
            #     Directed read options for this request.
            #   @param data_boost_enabled [::Boolean]
            #     If this is for a partitioned query and this field is set to `true`, the
            #     request is executed with Spanner Data Boost independent compute resources.
            #
            #     If the field is set to `true` but the request doesn't set
            #     `partition_token`, the API returns an `INVALID_ARGUMENT` error.
            #   @param last_statement [::Boolean]
            #     Optional. If set to `true`, this statement marks the end of the
            #     transaction. After this statement executes, you must commit or abort the
            #     transaction. Attempts to execute any other requests against this
            #     transaction (including reads and queries) are rejected.
            #
            #     For DML statements, setting this option might cause some error reporting to
            #     be deferred until commit time (for example, validation of unique
            #     constraints). Given this, successful execution of a DML statement shouldn't
            #     be assumed until a subsequent `Commit` call completes successfully.
            #   @param routing_hint [::Google::Cloud::Spanner::V1::RoutingHint, ::Hash]
            #     Optional. If present, it makes the Spanner requests location-aware.
            #
            #     It gives the server hints that can be used to route the request
            #     to an appropriate server, potentially significantly decreasing latency and
            #     improving throughput. To achieve improved performance, most fields must be
            #     filled in with accurate values.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Spanner::V1::ResultSet]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Spanner::V1::ResultSet]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/spanner/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Spanner::V1::Spanner::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Spanner::V1::ExecuteSqlRequest.new
            #
            #   # Call the execute_sql method.
            #   result = client.execute_sql request
            #
            #   # The returned object is of type Google::Cloud::Spanner::V1::ResultSet.
            #   p result
            #
            def execute_sql request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::V1::ExecuteSqlRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.execute_sql.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Spanner::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.session
                header_params["session"] = request.session
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.execute_sql.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.execute_sql.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @spanner_stub.call_rpc :execute_sql, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Like {::Google::Cloud::Spanner::V1::Spanner::Client#execute_sql ExecuteSql}, except returns the
            # result set as a stream. Unlike
            # {::Google::Cloud::Spanner::V1::Spanner::Client#execute_sql ExecuteSql}, there is no limit on
            # the size of the returned result set. However, no individual row in the
            # result set can exceed 100 MiB, and no column value can exceed 10 MiB.
            #
            # The query string can be SQL or [Graph Query Language
            # (GQL)](https://cloud.google.com/spanner/docs/reference/standard-sql/graph-intro).
            #
            # @overload execute_streaming_sql(request, options = nil)
            #   Pass arguments to `execute_streaming_sql` via a request object, either of type
            #   {::Google::Cloud::Spanner::V1::ExecuteSqlRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Spanner::V1::ExecuteSqlRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload execute_streaming_sql(session: nil, transaction: nil, sql: nil, params: nil, param_types: nil, resume_token: nil, query_mode: nil, partition_token: nil, seqno: nil, query_options: nil, request_options: nil, directed_read_options: nil, data_boost_enabled: nil, last_statement: nil, routing_hint: nil)
            #   Pass arguments to `execute_streaming_sql` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param session [::String]
            #     Required. The session in which the SQL query should be performed.
            #   @param transaction [::Google::Cloud::Spanner::V1::TransactionSelector, ::Hash]
            #     The transaction to use.
            #
            #     For queries, if none is provided, the default is a temporary read-only
            #     transaction with strong concurrency.
            #
            #     Standard DML statements require a read-write transaction. To protect
            #     against replays, single-use transactions are not supported. The caller
            #     must either supply an existing transaction ID or begin a new transaction.
            #
            #     Partitioned DML requires an existing Partitioned DML transaction ID.
            #   @param sql [::String]
            #     Required. The SQL string.
            #   @param params [::Google::Protobuf::Struct, ::Hash]
            #     Parameter names and values that bind to placeholders in the SQL string.
            #
            #     A parameter placeholder consists of the `@` character followed by the
            #     parameter name (for example, `@firstName`). Parameter names must conform
            #     to the naming requirements of identifiers as specified at
            #     https://cloud.google.com/spanner/docs/lexical#identifiers.
            #
            #     Parameters can appear anywhere that a literal value is expected. The same
            #     parameter name can be used more than once, for example:
            #
            #     `"WHERE id > @msg_id AND id < @msg_id + 100"`
            #
            #     It's an error to execute a SQL statement with unbound parameters.
            #   @param param_types [::Hash{::String => ::Google::Cloud::Spanner::V1::Type, ::Hash}]
            #     It isn't always possible for Cloud Spanner to infer the right SQL type
            #     from a JSON value. For example, values of type `BYTES` and values
            #     of type `STRING` both appear in
            #     {::Google::Cloud::Spanner::V1::ExecuteSqlRequest#params params} as JSON strings.
            #
            #     In these cases, you can use `param_types` to specify the exact
            #     SQL type for some or all of the SQL statement parameters. See the
            #     definition of {::Google::Cloud::Spanner::V1::Type Type} for more information
            #     about SQL types.
            #   @param resume_token [::String]
            #     If this request is resuming a previously interrupted SQL statement
            #     execution, `resume_token` should be copied from the last
            #     {::Google::Cloud::Spanner::V1::PartialResultSet PartialResultSet} yielded before the
            #     interruption. Doing this enables the new SQL statement execution to resume
            #     where the last one left off. The rest of the request parameters must
            #     exactly match the request that yielded this token.
            #   @param query_mode [::Google::Cloud::Spanner::V1::ExecuteSqlRequest::QueryMode]
            #     Used to control the amount of debugging information returned in
            #     {::Google::Cloud::Spanner::V1::ResultSetStats ResultSetStats}. If
            #     {::Google::Cloud::Spanner::V1::ExecuteSqlRequest#partition_token partition_token} is
            #     set, {::Google::Cloud::Spanner::V1::ExecuteSqlRequest#query_mode query_mode} can only
            #     be set to
            #     {::Google::Cloud::Spanner::V1::ExecuteSqlRequest::QueryMode::NORMAL QueryMode.NORMAL}.
            #   @param partition_token [::String]
            #     If present, results are restricted to the specified partition
            #     previously created using `PartitionQuery`. There must be an exact
            #     match for the values of fields common to this message and the
            #     `PartitionQueryRequest` message used to create this `partition_token`.
            #   @param seqno [::Integer]
            #     A per-transaction sequence number used to identify this request. This field
            #     makes each request idempotent such that if the request is received multiple
            #     times, at most one succeeds.
            #
            #     The sequence number must be monotonically increasing within the
            #     transaction. If a request arrives for the first time with an out-of-order
            #     sequence number, the transaction can be aborted. Replays of previously
            #     handled requests yield the same response as the first execution.
            #
            #     Required for DML statements. Ignored for queries.
            #   @param query_options [::Google::Cloud::Spanner::V1::ExecuteSqlRequest::QueryOptions, ::Hash]
            #     Query optimizer configuration to use for the given query.
            #   @param request_options [::Google::Cloud::Spanner::V1::RequestOptions, ::Hash]
            #     Common options for this request.
            #   @param directed_read_options [::Google::Cloud::Spanner::V1::DirectedReadOptions, ::Hash]
            #     Directed read options for this request.
            #   @param data_boost_enabled [::Boolean]
            #     If this is for a partitioned query and this field is set to `true`, the
            #     request is executed with Spanner Data Boost independent compute resources.
            #
            #     If the field is set to `true` but the request doesn't set
            #     `partition_token`, the API returns an `INVALID_ARGUMENT` error.
            #   @param last_statement [::Boolean]
            #     Optional. If set to `true`, this statement marks the end of the
            #     transaction. After this statement executes, you must commit or abort the
            #     transaction. Attempts to execute any other requests against this
            #     transaction (including reads and queries) are rejected.
            #
            #     For DML statements, setting this option might cause some error reporting to
            #     be deferred until commit time (for example, validation of unique
            #     constraints). Given this, successful execution of a DML statement shouldn't
            #     be assumed until a subsequent `Commit` call completes successfully.
            #   @param routing_hint [::Google::Cloud::Spanner::V1::RoutingHint, ::Hash]
            #     Optional. If present, it makes the Spanner requests location-aware.
            #
            #     It gives the server hints that can be used to route the request
            #     to an appropriate server, potentially significantly decreasing latency and
            #     improving throughput. To achieve improved performance, most fields must be
            #     filled in with accurate values.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Enumerable<::Google::Cloud::Spanner::V1::PartialResultSet>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Enumerable<::Google::Cloud::Spanner::V1::PartialResultSet>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/spanner/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Spanner::V1::Spanner::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Spanner::V1::ExecuteSqlRequest.new
            #
            #   # Call the execute_streaming_sql method to start streaming.
            #   output = client.execute_streaming_sql request
            #
            #   # The returned object is a streamed enumerable yielding elements of type
            #   # ::Google::Cloud::Spanner::V1::PartialResultSet
            #   output.each do |current_response|
            #     p current_response
            #   end
            #
            def execute_streaming_sql request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::V1::ExecuteSqlRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.execute_streaming_sql.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Spanner::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.session
                header_params["session"] = request.session
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.execute_streaming_sql.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.execute_streaming_sql.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @spanner_stub.call_rpc :execute_streaming_sql, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Executes a batch of SQL DML statements. This method allows many statements
            # to be run with lower latency than submitting them sequentially with
            # {::Google::Cloud::Spanner::V1::Spanner::Client#execute_sql ExecuteSql}.
            #
            # Statements are executed in sequential order. A request can succeed even if
            # a statement fails. The
            # {::Google::Cloud::Spanner::V1::ExecuteBatchDmlResponse#status ExecuteBatchDmlResponse.status}
            # field in the response provides information about the statement that failed.
            # Clients must inspect this field to determine whether an error occurred.
            #
            # Execution stops after the first failed statement; the remaining statements
            # are not executed.
            #
            # @overload execute_batch_dml(request, options = nil)
            #   Pass arguments to `execute_batch_dml` via a request object, either of type
            #   {::Google::Cloud::Spanner::V1::ExecuteBatchDmlRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Spanner::V1::ExecuteBatchDmlRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload execute_batch_dml(session: nil, transaction: nil, statements: nil, seqno: nil, request_options: nil, last_statements: nil)
            #   Pass arguments to `execute_batch_dml` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param session [::String]
            #     Required. The session in which the DML statements should be performed.
            #   @param transaction [::Google::Cloud::Spanner::V1::TransactionSelector, ::Hash]
            #     Required. The transaction to use. Must be a read-write transaction.
            #
            #     To protect against replays, single-use transactions are not supported. The
            #     caller must either supply an existing transaction ID or begin a new
            #     transaction.
            #   @param statements [::Array<::Google::Cloud::Spanner::V1::ExecuteBatchDmlRequest::Statement, ::Hash>]
            #     Required. The list of statements to execute in this batch. Statements are
            #     executed serially, such that the effects of statement `i` are visible to
            #     statement `i+1`. Each statement must be a DML statement. Execution stops at
            #     the first failed statement; the remaining statements are not executed.
            #
            #     Callers must provide at least one statement.
            #   @param seqno [::Integer]
            #     Required. A per-transaction sequence number used to identify this request.
            #     This field makes each request idempotent such that if the request is
            #     received multiple times, at most one succeeds.
            #
            #     The sequence number must be monotonically increasing within the
            #     transaction. If a request arrives for the first time with an out-of-order
            #     sequence number, the transaction might be aborted. Replays of previously
            #     handled requests yield the same response as the first execution.
            #   @param request_options [::Google::Cloud::Spanner::V1::RequestOptions, ::Hash]
            #     Common options for this request.
            #   @param last_statements [::Boolean]
            #     Optional. If set to `true`, this request marks the end of the transaction.
            #     After these statements execute, you must commit or abort the transaction.
            #     Attempts to execute any other requests against this transaction
            #     (including reads and queries) are rejected.
            #
            #     Setting this option might cause some error reporting to be deferred until
            #     commit time (for example, validation of unique constraints). Given this,
            #     successful execution of statements shouldn't be assumed until a subsequent
            #     `Commit` call completes successfully.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Spanner::V1::ExecuteBatchDmlResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Spanner::V1::ExecuteBatchDmlResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/spanner/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Spanner::V1::Spanner::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Spanner::V1::ExecuteBatchDmlRequest.new
            #
            #   # Call the execute_batch_dml method.
            #   result = client.execute_batch_dml request
            #
            #   # The returned object is of type Google::Cloud::Spanner::V1::ExecuteBatchDmlResponse.
            #   p result
            #
            def execute_batch_dml request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::V1::ExecuteBatchDmlRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.execute_batch_dml.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Spanner::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.session
                header_params["session"] = request.session
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.execute_batch_dml.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.execute_batch_dml.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @spanner_stub.call_rpc :execute_batch_dml, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Reads rows from the database using key lookups and scans, as a
            # simple key/value style alternative to
            # {::Google::Cloud::Spanner::V1::Spanner::Client#execute_sql ExecuteSql}. This method can't be
            # used to return a result set larger than 10 MiB; if the read matches more
            # data than that, the read fails with a `FAILED_PRECONDITION`
            # error.
            #
            # Reads inside read-write transactions might return `ABORTED`. If
            # this occurs, the application should restart the transaction from
            # the beginning. See {::Google::Cloud::Spanner::V1::Transaction Transaction} for more
            # details.
            #
            # Larger result sets can be yielded in streaming fashion by calling
            # {::Google::Cloud::Spanner::V1::Spanner::Client#streaming_read StreamingRead} instead.
            #
            # @overload read(request, options = nil)
            #   Pass arguments to `read` via a request object, either of type
            #   {::Google::Cloud::Spanner::V1::ReadRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Spanner::V1::ReadRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload read(session: nil, transaction: nil, table: nil, index: nil, columns: nil, key_set: nil, limit: nil, resume_token: nil, partition_token: nil, request_options: nil, directed_read_options: nil, data_boost_enabled: nil, order_by: nil, lock_hint: nil, routing_hint: nil)
            #   Pass arguments to `read` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param session [::String]
            #     Required. The session in which the read should be performed.
            #   @param transaction [::Google::Cloud::Spanner::V1::TransactionSelector, ::Hash]
            #     The transaction to use. If none is provided, the default is a
            #     temporary read-only transaction with strong concurrency.
            #   @param table [::String]
            #     Required. The name of the table in the database to be read.
            #   @param index [::String]
            #     If non-empty, the name of an index on
            #     {::Google::Cloud::Spanner::V1::ReadRequest#table table}. This index is used instead of
            #     the table primary key when interpreting
            #     {::Google::Cloud::Spanner::V1::ReadRequest#key_set key_set} and sorting result rows.
            #     See {::Google::Cloud::Spanner::V1::ReadRequest#key_set key_set} for further
            #     information.
            #   @param columns [::Array<::String>]
            #     Required. The columns of {::Google::Cloud::Spanner::V1::ReadRequest#table table} to be
            #     returned for each row matching this request.
            #   @param key_set [::Google::Cloud::Spanner::V1::KeySet, ::Hash]
            #     Required. `key_set` identifies the rows to be yielded. `key_set` names the
            #     primary keys of the rows in {::Google::Cloud::Spanner::V1::ReadRequest#table table} to
            #     be yielded, unless {::Google::Cloud::Spanner::V1::ReadRequest#index index} is present.
            #     If {::Google::Cloud::Spanner::V1::ReadRequest#index index} is present, then
            #     {::Google::Cloud::Spanner::V1::ReadRequest#key_set key_set} instead names index keys
            #     in {::Google::Cloud::Spanner::V1::ReadRequest#index index}.
            #
            #     If the {::Google::Cloud::Spanner::V1::ReadRequest#partition_token partition_token}
            #     field is empty, rows are yielded in table primary key order (if
            #     {::Google::Cloud::Spanner::V1::ReadRequest#index index} is empty) or index key order
            #     (if {::Google::Cloud::Spanner::V1::ReadRequest#index index} is non-empty). If the
            #     {::Google::Cloud::Spanner::V1::ReadRequest#partition_token partition_token} field
            #     isn't empty, rows are yielded in an unspecified order.
            #
            #     It isn't an error for the `key_set` to name rows that don't
            #     exist in the database. Read yields nothing for nonexistent rows.
            #   @param limit [::Integer]
            #     If greater than zero, only the first `limit` rows are yielded. If `limit`
            #     is zero, the default is no limit. A limit can't be specified if
            #     `partition_token` is set.
            #   @param resume_token [::String]
            #     If this request is resuming a previously interrupted read,
            #     `resume_token` should be copied from the last
            #     {::Google::Cloud::Spanner::V1::PartialResultSet PartialResultSet} yielded before the
            #     interruption. Doing this enables the new read to resume where the last read
            #     left off. The rest of the request parameters must exactly match the request
            #     that yielded this token.
            #   @param partition_token [::String]
            #     If present, results are restricted to the specified partition
            #     previously created using `PartitionRead`. There must be an exact
            #     match for the values of fields common to this message and the
            #     PartitionReadRequest message used to create this partition_token.
            #   @param request_options [::Google::Cloud::Spanner::V1::RequestOptions, ::Hash]
            #     Common options for this request.
            #   @param directed_read_options [::Google::Cloud::Spanner::V1::DirectedReadOptions, ::Hash]
            #     Directed read options for this request.
            #   @param data_boost_enabled [::Boolean]
            #     If this is for a partitioned read and this field is set to `true`, the
            #     request is executed with Spanner Data Boost independent compute resources.
            #
            #     If the field is set to `true` but the request doesn't set
            #     `partition_token`, the API returns an `INVALID_ARGUMENT` error.
            #   @param order_by [::Google::Cloud::Spanner::V1::ReadRequest::OrderBy]
            #     Optional. Order for the returned rows.
            #
            #     By default, Spanner returns result rows in primary key order except for
            #     PartitionRead requests. For applications that don't require rows to be
            #     returned in primary key (`ORDER_BY_PRIMARY_KEY`) order, setting
            #     `ORDER_BY_NO_ORDER` option allows Spanner to optimize row retrieval,
            #     resulting in lower latencies in certain cases (for example, bulk point
            #     lookups).
            #   @param lock_hint [::Google::Cloud::Spanner::V1::ReadRequest::LockHint]
            #     Optional. Lock Hint for the request, it can only be used with read-write
            #     transactions.
            #   @param routing_hint [::Google::Cloud::Spanner::V1::RoutingHint, ::Hash]
            #     Optional. If present, it makes the Spanner requests location-aware.
            #
            #     It gives the server hints that can be used to route the request
            #     to an appropriate server, potentially significantly decreasing latency and
            #     improving throughput. To achieve improved performance, most fields must be
            #     filled in with accurate values.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Spanner::V1::ResultSet]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Spanner::V1::ResultSet]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/spanner/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Spanner::V1::Spanner::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Spanner::V1::ReadRequest.new
            #
            #   # Call the read method.
            #   result = client.read request
            #
            #   # The returned object is of type Google::Cloud::Spanner::V1::ResultSet.
            #   p result
            #
            def read request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::V1::ReadRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.read.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Spanner::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.session
                header_params["session"] = request.session
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.read.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.read.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @spanner_stub.call_rpc :read, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Like {::Google::Cloud::Spanner::V1::Spanner::Client#read Read}, except returns the result set
            # as a stream. Unlike {::Google::Cloud::Spanner::V1::Spanner::Client#read Read}, there is no
            # limit on the size of the returned result set. However, no individual row in
            # the result set can exceed 100 MiB, and no column value can exceed
            # 10 MiB.
            #
            # @overload streaming_read(request, options = nil)
            #   Pass arguments to `streaming_read` via a request object, either of type
            #   {::Google::Cloud::Spanner::V1::ReadRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Spanner::V1::ReadRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload streaming_read(session: nil, transaction: nil, table: nil, index: nil, columns: nil, key_set: nil, limit: nil, resume_token: nil, partition_token: nil, request_options: nil, directed_read_options: nil, data_boost_enabled: nil, order_by: nil, lock_hint: nil, routing_hint: nil)
            #   Pass arguments to `streaming_read` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param session [::String]
            #     Required. The session in which the read should be performed.
            #   @param transaction [::Google::Cloud::Spanner::V1::TransactionSelector, ::Hash]
            #     The transaction to use. If none is provided, the default is a
            #     temporary read-only transaction with strong concurrency.
            #   @param table [::String]
            #     Required. The name of the table in the database to be read.
            #   @param index [::String]
            #     If non-empty, the name of an index on
            #     {::Google::Cloud::Spanner::V1::ReadRequest#table table}. This index is used instead of
            #     the table primary key when interpreting
            #     {::Google::Cloud::Spanner::V1::ReadRequest#key_set key_set} and sorting result rows.
            #     See {::Google::Cloud::Spanner::V1::ReadRequest#key_set key_set} for further
            #     information.
            #   @param columns [::Array<::String>]
            #     Required. The columns of {::Google::Cloud::Spanner::V1::ReadRequest#table table} to be
            #     returned for each row matching this request.
            #   @param key_set [::Google::Cloud::Spanner::V1::KeySet, ::Hash]
            #     Required. `key_set` identifies the rows to be yielded. `key_set` names the
            #     primary keys of the rows in {::Google::Cloud::Spanner::V1::ReadRequest#table table} to
            #     be yielded, unless {::Google::Cloud::Spanner::V1::ReadRequest#index index} is present.
            #     If {::Google::Cloud::Spanner::V1::ReadRequest#index index} is present, then
            #     {::Google::Cloud::Spanner::V1::ReadRequest#key_set key_set} instead names index keys
            #     in {::Google::Cloud::Spanner::V1::ReadRequest#index index}.
            #
            #     If the {::Google::Cloud::Spanner::V1::ReadRequest#partition_token partition_token}
            #     field is empty, rows are yielded in table primary key order (if
            #     {::Google::Cloud::Spanner::V1::ReadRequest#index index} is empty) or index key order
            #     (if {::Google::Cloud::Spanner::V1::ReadRequest#index index} is non-empty). If the
            #     {::Google::Cloud::Spanner::V1::ReadRequest#partition_token partition_token} field
            #     isn't empty, rows are yielded in an unspecified order.
            #
            #     It isn't an error for the `key_set` to name rows that don't
            #     exist in the database. Read yields nothing for nonexistent rows.
            #   @param limit [::Integer]
            #     If greater than zero, only the first `limit` rows are yielded. If `limit`
            #     is zero, the default is no limit. A limit can't be specified if
            #     `partition_token` is set.
            #   @param resume_token [::String]
            #     If this request is resuming a previously interrupted read,
            #     `resume_token` should be copied from the last
            #     {::Google::Cloud::Spanner::V1::PartialResultSet PartialResultSet} yielded before the
            #     interruption. Doing this enables the new read to resume where the last read
            #     left off. The rest of the request parameters must exactly match the request
            #     that yielded this token.
            #   @param partition_token [::String]
            #     If present, results are restricted to the specified partition
            #     previously created using `PartitionRead`. There must be an exact
            #     match for the values of fields common to this message and the
            #     PartitionReadRequest message used to create this partition_token.
            #   @param request_options [::Google::Cloud::Spanner::V1::RequestOptions, ::Hash]
            #     Common options for this request.
            #   @param directed_read_options [::Google::Cloud::Spanner::V1::DirectedReadOptions, ::Hash]
            #     Directed read options for this request.
            #   @param data_boost_enabled [::Boolean]
            #     If this is for a partitioned read and this field is set to `true`, the
            #     request is executed with Spanner Data Boost independent compute resources.
            #
            #     If the field is set to `true` but the request doesn't set
            #     `partition_token`, the API returns an `INVALID_ARGUMENT` error.
            #   @param order_by [::Google::Cloud::Spanner::V1::ReadRequest::OrderBy]
            #     Optional. Order for the returned rows.
            #
            #     By default, Spanner returns result rows in primary key order except for
            #     PartitionRead requests. For applications that don't require rows to be
            #     returned in primary key (`ORDER_BY_PRIMARY_KEY`) order, setting
            #     `ORDER_BY_NO_ORDER` option allows Spanner to optimize row retrieval,
            #     resulting in lower latencies in certain cases (for example, bulk point
            #     lookups).
            #   @param lock_hint [::Google::Cloud::Spanner::V1::ReadRequest::LockHint]
            #     Optional. Lock Hint for the request, it can only be used with read-write
            #     transactions.
            #   @param routing_hint [::Google::Cloud::Spanner::V1::RoutingHint, ::Hash]
            #     Optional. If present, it makes the Spanner requests location-aware.
            #
            #     It gives the server hints that can be used to route the request
            #     to an appropriate server, potentially significantly decreasing latency and
            #     improving throughput. To achieve improved performance, most fields must be
            #     filled in with accurate values.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Enumerable<::Google::Cloud::Spanner::V1::PartialResultSet>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Enumerable<::Google::Cloud::Spanner::V1::PartialResultSet>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/spanner/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Spanner::V1::Spanner::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Spanner::V1::ReadRequest.new
            #
            #   # Call the streaming_read method to start streaming.
            #   output = client.streaming_read request
            #
            #   # The returned object is a streamed enumerable yielding elements of type
            #   # ::Google::Cloud::Spanner::V1::PartialResultSet
            #   output.each do |current_response|
            #     p current_response
            #   end
            #
            def streaming_read request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::V1::ReadRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.streaming_read.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Spanner::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.session
                header_params["session"] = request.session
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.streaming_read.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.streaming_read.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @spanner_stub.call_rpc :streaming_read, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Begins a new transaction. This step can often be skipped:
            # {::Google::Cloud::Spanner::V1::Spanner::Client#read Read},
            # {::Google::Cloud::Spanner::V1::Spanner::Client#execute_sql ExecuteSql} and
            # {::Google::Cloud::Spanner::V1::Spanner::Client#commit Commit} can begin a new transaction as a
            # side-effect.
            #
            # @overload begin_transaction(request, options = nil)
            #   Pass arguments to `begin_transaction` via a request object, either of type
            #   {::Google::Cloud::Spanner::V1::BeginTransactionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Spanner::V1::BeginTransactionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload begin_transaction(session: nil, options: nil, request_options: nil, mutation_key: nil)
            #   Pass arguments to `begin_transaction` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param session [::String]
            #     Required. The session in which the transaction runs.
            #   @param options [::Google::Cloud::Spanner::V1::TransactionOptions, ::Hash]
            #     Required. Options for the new transaction.
            #   @param request_options [::Google::Cloud::Spanner::V1::RequestOptions, ::Hash]
            #     Common options for this request.
            #     Priority is ignored for this request. Setting the priority in this
            #     `request_options` struct doesn't do anything. To set the priority for a
            #     transaction, set it on the reads and writes that are part of this
            #     transaction instead.
            #   @param mutation_key [::Google::Cloud::Spanner::V1::Mutation, ::Hash]
            #     Optional. Required for read-write transactions on a multiplexed session
            #     that commit mutations but don't perform any reads or queries. You must
            #     randomly select one of the mutations from the mutation set and send it as a
            #     part of this request.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Spanner::V1::Transaction]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Spanner::V1::Transaction]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/spanner/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Spanner::V1::Spanner::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Spanner::V1::BeginTransactionRequest.new
            #
            #   # Call the begin_transaction method.
            #   result = client.begin_transaction request
            #
            #   # The returned object is of type Google::Cloud::Spanner::V1::Transaction.
            #   p result
            #
            def begin_transaction request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::V1::BeginTransactionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.begin_transaction.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Spanner::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.session
                header_params["session"] = request.session
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.begin_transaction.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.begin_transaction.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @spanner_stub.call_rpc :begin_transaction, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Commits a transaction. The request includes the mutations to be
            # applied to rows in the database.
            #
            # `Commit` might return an `ABORTED` error. This can occur at any time;
            # commonly, the cause is conflicts with concurrent
            # transactions. However, it can also happen for a variety of other
            # reasons. If `Commit` returns `ABORTED`, the caller should retry
            # the transaction from the beginning, reusing the same session.
            #
            # On very rare occasions, `Commit` might return `UNKNOWN`. This can happen,
            # for example, if the client job experiences a 1+ hour networking failure.
            # At that point, Cloud Spanner has lost track of the transaction outcome and
            # we recommend that you perform another read from the database to see the
            # state of things as they are now.
            #
            # @overload commit(request, options = nil)
            #   Pass arguments to `commit` via a request object, either of type
            #   {::Google::Cloud::Spanner::V1::CommitRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Spanner::V1::CommitRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload commit(session: nil, transaction_id: nil, single_use_transaction: nil, mutations: nil, return_commit_stats: nil, max_commit_delay: nil, request_options: nil, precommit_token: nil)
            #   Pass arguments to `commit` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param session [::String]
            #     Required. The session in which the transaction to be committed is running.
            #   @param transaction_id [::String]
            #     Commit a previously-started transaction.
            #
            #     Note: The following parameters are mutually exclusive: `transaction_id`, `single_use_transaction`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param single_use_transaction [::Google::Cloud::Spanner::V1::TransactionOptions, ::Hash]
            #     Execute mutations in a temporary transaction. Note that unlike
            #     commit of a previously-started transaction, commit with a
            #     temporary transaction is non-idempotent. That is, if the
            #     `CommitRequest` is sent to Cloud Spanner more than once (for
            #     instance, due to retries in the application, or in the
            #     transport library), it's possible that the mutations are
            #     executed more than once. If this is undesirable, use
            #     {::Google::Cloud::Spanner::V1::Spanner::Client#begin_transaction BeginTransaction} and
            #     {::Google::Cloud::Spanner::V1::Spanner::Client#commit Commit} instead.
            #
            #     Note: The following parameters are mutually exclusive: `single_use_transaction`, `transaction_id`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param mutations [::Array<::Google::Cloud::Spanner::V1::Mutation, ::Hash>]
            #     The mutations to be executed when this transaction commits. All
            #     mutations are applied atomically, in the order they appear in
            #     this list.
            #   @param return_commit_stats [::Boolean]
            #     If `true`, then statistics related to the transaction is included in
            #     the {::Google::Cloud::Spanner::V1::CommitResponse#commit_stats CommitResponse}.
            #     Default value is `false`.
            #   @param max_commit_delay [::Google::Protobuf::Duration, ::Hash]
            #     Optional. The amount of latency this request is configured to incur in
            #     order to improve throughput. If this field isn't set, Spanner assumes
            #     requests are relatively latency sensitive and automatically determines an
            #     appropriate delay time. You can specify a commit delay value between 0 and
            #     500 ms.
            #   @param request_options [::Google::Cloud::Spanner::V1::RequestOptions, ::Hash]
            #     Common options for this request.
            #   @param precommit_token [::Google::Cloud::Spanner::V1::MultiplexedSessionPrecommitToken, ::Hash]
            #     Optional. If the read-write transaction was executed on a multiplexed
            #     session, then you must include the precommit token with the highest
            #     sequence number received in this transaction attempt. Failing to do so
            #     results in a `FailedPrecondition` error.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Spanner::V1::CommitResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Spanner::V1::CommitResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/spanner/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Spanner::V1::Spanner::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Spanner::V1::CommitRequest.new
            #
            #   # Call the commit method.
            #   result = client.commit request
            #
            #   # The returned object is of type Google::Cloud::Spanner::V1::CommitResponse.
            #   p result
            #
            def commit request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::V1::CommitRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.commit.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Spanner::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.session
                header_params["session"] = request.session
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.commit.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.commit.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @spanner_stub.call_rpc :commit, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Rolls back a transaction, releasing any locks it holds. It's a good
            # idea to call this for any transaction that includes one or more
            # {::Google::Cloud::Spanner::V1::Spanner::Client#read Read} or
            # {::Google::Cloud::Spanner::V1::Spanner::Client#execute_sql ExecuteSql} requests and ultimately
            # decides not to commit.
            #
            # `Rollback` returns `OK` if it successfully aborts the transaction, the
            # transaction was already aborted, or the transaction isn't
            # found. `Rollback` never returns `ABORTED`.
            #
            # @overload rollback(request, options = nil)
            #   Pass arguments to `rollback` via a request object, either of type
            #   {::Google::Cloud::Spanner::V1::RollbackRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Spanner::V1::RollbackRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload rollback(session: nil, transaction_id: nil)
            #   Pass arguments to `rollback` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param session [::String]
            #     Required. The session in which the transaction to roll back is running.
            #   @param transaction_id [::String]
            #     Required. The transaction to roll back.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/spanner/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Spanner::V1::Spanner::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Spanner::V1::RollbackRequest.new
            #
            #   # Call the rollback method.
            #   result = client.rollback request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def rollback request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::V1::RollbackRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.rollback.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Spanner::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.session
                header_params["session"] = request.session
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.rollback.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.rollback.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @spanner_stub.call_rpc :rollback, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a set of partition tokens that can be used to execute a query
            # operation in parallel. Each of the returned partition tokens can be used
            # by {::Google::Cloud::Spanner::V1::Spanner::Client#execute_streaming_sql ExecuteStreamingSql} to
            # specify a subset of the query result to read. The same session and
            # read-only transaction must be used by the `PartitionQueryRequest` used to
            # create the partition tokens and the `ExecuteSqlRequests` that use the
            # partition tokens.
            #
            # Partition tokens become invalid when the session used to create them
            # is deleted, is idle for too long, begins a new transaction, or becomes too
            # old. When any of these happen, it isn't possible to resume the query, and
            # the whole operation must be restarted from the beginning.
            #
            # @overload partition_query(request, options = nil)
            #   Pass arguments to `partition_query` via a request object, either of type
            #   {::Google::Cloud::Spanner::V1::PartitionQueryRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Spanner::V1::PartitionQueryRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload partition_query(session: nil, transaction: nil, sql: nil, params: nil, param_types: nil, partition_options: nil)
            #   Pass arguments to `partition_query` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param session [::String]
            #     Required. The session used to create the partitions.
            #   @param transaction [::Google::Cloud::Spanner::V1::TransactionSelector, ::Hash]
            #     Read-only snapshot transactions are supported, read and write and
            #     single-use transactions are not.
            #   @param sql [::String]
            #     Required. The query request to generate partitions for. The request fails
            #     if the query isn't root partitionable. For a query to be root
            #     partitionable, it needs to satisfy a few conditions. For example, if the
            #     query execution plan contains a distributed union operator, then it must be
            #     the first operator in the plan. For more information about other
            #     conditions, see [Read data in
            #     parallel](https://cloud.google.com/spanner/docs/reads#read_data_in_parallel).
            #
            #     The query request must not contain DML commands, such as `INSERT`,
            #     `UPDATE`, or `DELETE`. Use
            #     {::Google::Cloud::Spanner::V1::Spanner::Client#execute_streaming_sql `ExecuteStreamingSql`} with
            #     a `PartitionedDml` transaction for large, partition-friendly DML
            #     operations.
            #   @param params [::Google::Protobuf::Struct, ::Hash]
            #     Parameter names and values that bind to placeholders in the SQL string.
            #
            #     A parameter placeholder consists of the `@` character followed by the
            #     parameter name (for example, `@firstName`). Parameter names can contain
            #     letters, numbers, and underscores.
            #
            #     Parameters can appear anywhere that a literal value is expected. The same
            #     parameter name can be used more than once, for example:
            #
            #     `"WHERE id > @msg_id AND id < @msg_id + 100"`
            #
            #     It's an error to execute a SQL statement with unbound parameters.
            #   @param param_types [::Hash{::String => ::Google::Cloud::Spanner::V1::Type, ::Hash}]
            #     It isn't always possible for Cloud Spanner to infer the right SQL type
            #     from a JSON value. For example, values of type `BYTES` and values
            #     of type `STRING` both appear in
            #     {::Google::Cloud::Spanner::V1::PartitionQueryRequest#params params} as JSON strings.
            #
            #     In these cases, `param_types` can be used to specify the exact
            #     SQL type for some or all of the SQL query parameters. See the
            #     definition of {::Google::Cloud::Spanner::V1::Type Type} for more information
            #     about SQL types.
            #   @param partition_options [::Google::Cloud::Spanner::V1::PartitionOptions, ::Hash]
            #     Additional options that affect how many partitions are created.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Spanner::V1::PartitionResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Spanner::V1::PartitionResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/spanner/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Spanner::V1::Spanner::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Spanner::V1::PartitionQueryRequest.new
            #
            #   # Call the partition_query method.
            #   result = client.partition_query request
            #
            #   # The returned object is of type Google::Cloud::Spanner::V1::PartitionResponse.
            #   p result
            #
            def partition_query request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::V1::PartitionQueryRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.partition_query.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Spanner::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.session
                header_params["session"] = request.session
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.partition_query.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.partition_query.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @spanner_stub.call_rpc :partition_query, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a set of partition tokens that can be used to execute a read
            # operation in parallel. Each of the returned partition tokens can be used
            # by {::Google::Cloud::Spanner::V1::Spanner::Client#streaming_read StreamingRead} to specify a
            # subset of the read result to read. The same session and read-only
            # transaction must be used by the `PartitionReadRequest` used to create the
            # partition tokens and the `ReadRequests` that use the partition tokens.
            # There are no ordering guarantees on rows returned among the returned
            # partition tokens, or even within each individual `StreamingRead` call
            # issued with a `partition_token`.
            #
            # Partition tokens become invalid when the session used to create them
            # is deleted, is idle for too long, begins a new transaction, or becomes too
            # old. When any of these happen, it isn't possible to resume the read, and
            # the whole operation must be restarted from the beginning.
            #
            # @overload partition_read(request, options = nil)
            #   Pass arguments to `partition_read` via a request object, either of type
            #   {::Google::Cloud::Spanner::V1::PartitionReadRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Spanner::V1::PartitionReadRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload partition_read(session: nil, transaction: nil, table: nil, index: nil, columns: nil, key_set: nil, partition_options: nil)
            #   Pass arguments to `partition_read` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param session [::String]
            #     Required. The session used to create the partitions.
            #   @param transaction [::Google::Cloud::Spanner::V1::TransactionSelector, ::Hash]
            #     Read only snapshot transactions are supported, read/write and single use
            #     transactions are not.
            #   @param table [::String]
            #     Required. The name of the table in the database to be read.
            #   @param index [::String]
            #     If non-empty, the name of an index on
            #     {::Google::Cloud::Spanner::V1::PartitionReadRequest#table table}. This index is used
            #     instead of the table primary key when interpreting
            #     {::Google::Cloud::Spanner::V1::PartitionReadRequest#key_set key_set} and sorting
            #     result rows. See {::Google::Cloud::Spanner::V1::PartitionReadRequest#key_set key_set}
            #     for further information.
            #   @param columns [::Array<::String>]
            #     The columns of {::Google::Cloud::Spanner::V1::PartitionReadRequest#table table} to be
            #     returned for each row matching this request.
            #   @param key_set [::Google::Cloud::Spanner::V1::KeySet, ::Hash]
            #     Required. `key_set` identifies the rows to be yielded. `key_set` names the
            #     primary keys of the rows in
            #     {::Google::Cloud::Spanner::V1::PartitionReadRequest#table table} to be yielded, unless
            #     {::Google::Cloud::Spanner::V1::PartitionReadRequest#index index} is present. If
            #     {::Google::Cloud::Spanner::V1::PartitionReadRequest#index index} is present, then
            #     {::Google::Cloud::Spanner::V1::PartitionReadRequest#key_set key_set} instead names
            #     index keys in {::Google::Cloud::Spanner::V1::PartitionReadRequest#index index}.
            #
            #     It isn't an error for the `key_set` to name rows that don't
            #     exist in the database. Read yields nothing for nonexistent rows.
            #   @param partition_options [::Google::Cloud::Spanner::V1::PartitionOptions, ::Hash]
            #     Additional options that affect how many partitions are created.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Spanner::V1::PartitionResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Spanner::V1::PartitionResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/spanner/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Spanner::V1::Spanner::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Spanner::V1::PartitionReadRequest.new
            #
            #   # Call the partition_read method.
            #   result = client.partition_read request
            #
            #   # The returned object is of type Google::Cloud::Spanner::V1::PartitionResponse.
            #   p result
            #
            def partition_read request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::V1::PartitionReadRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.partition_read.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Spanner::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.session
                header_params["session"] = request.session
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.partition_read.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.partition_read.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @spanner_stub.call_rpc :partition_read, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Batches the supplied mutation groups in a collection of efficient
            # transactions. All mutations in a group are committed atomically. However,
            # mutations across groups can be committed non-atomically in an unspecified
            # order and thus, they must be independent of each other. Partial failure is
            # possible, that is, some groups might have been committed successfully,
            # while some might have failed. The results of individual batches are
            # streamed into the response as the batches are applied.
            #
            # `BatchWrite` requests are not replay protected, meaning that each mutation
            # group can be applied more than once. Replays of non-idempotent mutations
            # can have undesirable effects. For example, replays of an insert mutation
            # can produce an already exists error or if you use generated or commit
            # timestamp-based keys, it can result in additional rows being added to the
            # mutation's table. We recommend structuring your mutation groups to be
            # idempotent to avoid this issue.
            #
            # @overload batch_write(request, options = nil)
            #   Pass arguments to `batch_write` via a request object, either of type
            #   {::Google::Cloud::Spanner::V1::BatchWriteRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Spanner::V1::BatchWriteRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload batch_write(session: nil, request_options: nil, mutation_groups: nil, exclude_txn_from_change_streams: nil)
            #   Pass arguments to `batch_write` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param session [::String]
            #     Required. The session in which the batch request is to be run.
            #   @param request_options [::Google::Cloud::Spanner::V1::RequestOptions, ::Hash]
            #     Common options for this request.
            #   @param mutation_groups [::Array<::Google::Cloud::Spanner::V1::BatchWriteRequest::MutationGroup, ::Hash>]
            #     Required. The groups of mutations to be applied.
            #   @param exclude_txn_from_change_streams [::Boolean]
            #     Optional. If you don't set the `exclude_txn_from_change_streams` option or
            #     if it's set to `false`, then any change streams monitoring columns modified
            #     by transactions will capture the updates made within that transaction.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Enumerable<::Google::Cloud::Spanner::V1::BatchWriteResponse>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Enumerable<::Google::Cloud::Spanner::V1::BatchWriteResponse>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/spanner/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Spanner::V1::Spanner::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Spanner::V1::BatchWriteRequest.new
            #
            #   # Call the batch_write method to start streaming.
            #   output = client.batch_write request
            #
            #   # The returned object is a streamed enumerable yielding elements of type
            #   # ::Google::Cloud::Spanner::V1::BatchWriteResponse
            #   output.each do |current_response|
            #     p current_response
            #   end
            #
            def batch_write request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::V1::BatchWriteRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.batch_write.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Spanner::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.session
                header_params["session"] = request.session
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.batch_write.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.batch_write.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @spanner_stub.call_rpc :batch_write, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the Spanner API.
            #
            # This class represents the configuration for Spanner,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::Spanner::V1::Spanner::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # create_session to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::Spanner::V1::Spanner::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_session.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::Spanner::V1::Spanner::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_session.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::Spanner::V1::Spanner::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "spanner.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the Spanner API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `create_session`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_session
                ##
                # RPC-specific configuration for `batch_create_sessions`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :batch_create_sessions
                ##
                # RPC-specific configuration for `get_session`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_session
                ##
                # RPC-specific configuration for `list_sessions`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_sessions
                ##
                # RPC-specific configuration for `delete_session`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_session
                ##
                # RPC-specific configuration for `execute_sql`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :execute_sql
                ##
                # RPC-specific configuration for `execute_streaming_sql`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :execute_streaming_sql
                ##
                # RPC-specific configuration for `execute_batch_dml`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :execute_batch_dml
                ##
                # RPC-specific configuration for `read`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :read
                ##
                # RPC-specific configuration for `streaming_read`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :streaming_read
                ##
                # RPC-specific configuration for `begin_transaction`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :begin_transaction
                ##
                # RPC-specific configuration for `commit`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :commit
                ##
                # RPC-specific configuration for `rollback`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :rollback
                ##
                # RPC-specific configuration for `partition_query`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :partition_query
                ##
                # RPC-specific configuration for `partition_read`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :partition_read
                ##
                # RPC-specific configuration for `batch_write`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :batch_write

                # @private
                def initialize parent_rpcs = nil
                  create_session_config = parent_rpcs.create_session if parent_rpcs.respond_to? :create_session
                  @create_session = ::Gapic::Config::Method.new create_session_config
                  batch_create_sessions_config = parent_rpcs.batch_create_sessions if parent_rpcs.respond_to? :batch_create_sessions
                  @batch_create_sessions = ::Gapic::Config::Method.new batch_create_sessions_config
                  get_session_config = parent_rpcs.get_session if parent_rpcs.respond_to? :get_session
                  @get_session = ::Gapic::Config::Method.new get_session_config
                  list_sessions_config = parent_rpcs.list_sessions if parent_rpcs.respond_to? :list_sessions
                  @list_sessions = ::Gapic::Config::Method.new list_sessions_config
                  delete_session_config = parent_rpcs.delete_session if parent_rpcs.respond_to? :delete_session
                  @delete_session = ::Gapic::Config::Method.new delete_session_config
                  execute_sql_config = parent_rpcs.execute_sql if parent_rpcs.respond_to? :execute_sql
                  @execute_sql = ::Gapic::Config::Method.new execute_sql_config
                  execute_streaming_sql_config = parent_rpcs.execute_streaming_sql if parent_rpcs.respond_to? :execute_streaming_sql
                  @execute_streaming_sql = ::Gapic::Config::Method.new execute_streaming_sql_config
                  execute_batch_dml_config = parent_rpcs.execute_batch_dml if parent_rpcs.respond_to? :execute_batch_dml
                  @execute_batch_dml = ::Gapic::Config::Method.new execute_batch_dml_config
                  read_config = parent_rpcs.read if parent_rpcs.respond_to? :read
                  @read = ::Gapic::Config::Method.new read_config
                  streaming_read_config = parent_rpcs.streaming_read if parent_rpcs.respond_to? :streaming_read
                  @streaming_read = ::Gapic::Config::Method.new streaming_read_config
                  begin_transaction_config = parent_rpcs.begin_transaction if parent_rpcs.respond_to? :begin_transaction
                  @begin_transaction = ::Gapic::Config::Method.new begin_transaction_config
                  commit_config = parent_rpcs.commit if parent_rpcs.respond_to? :commit
                  @commit = ::Gapic::Config::Method.new commit_config
                  rollback_config = parent_rpcs.rollback if parent_rpcs.respond_to? :rollback
                  @rollback = ::Gapic::Config::Method.new rollback_config
                  partition_query_config = parent_rpcs.partition_query if parent_rpcs.respond_to? :partition_query
                  @partition_query = ::Gapic::Config::Method.new partition_query_config
                  partition_read_config = parent_rpcs.partition_read if parent_rpcs.respond_to? :partition_read
                  @partition_read = ::Gapic::Config::Method.new partition_read_config
                  batch_write_config = parent_rpcs.batch_write if parent_rpcs.respond_to? :batch_write
                  @batch_write = ::Gapic::Config::Method.new batch_write_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
