# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Spanner
      module Admin
        module Instance
          module V1
            # @!attribute [rw] location
            #   @return [::String]
            #     The location of the serving resources, e.g., "us-central1".
            # @!attribute [rw] type
            #   @return [::Google::Cloud::Spanner::Admin::Instance::V1::ReplicaInfo::ReplicaType]
            #     The type of replica.
            # @!attribute [rw] default_leader_location
            #   @return [::Boolean]
            #     If true, this location is designated as the default leader location where
            #     leader replicas are placed. See the [region types
            #     documentation](https://cloud.google.com/spanner/docs/instances#region_types)
            #     for more details.
            class ReplicaInfo
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Indicates the type of replica.  See the [replica types
              # documentation](https://cloud.google.com/spanner/docs/replication#replica_types)
              # for more details.
              module ReplicaType
                # Not specified.
                TYPE_UNSPECIFIED = 0

                # Read-write replicas support both reads and writes. These replicas:
                #
                # * Maintain a full copy of your data.
                # * Serve reads.
                # * Can vote whether to commit a write.
                # * Participate in leadership election.
                # * Are eligible to become a leader.
                READ_WRITE = 1

                # Read-only replicas only support reads (not writes). Read-only replicas:
                #
                # * Maintain a full copy of your data.
                # * Serve reads.
                # * Do not participate in voting to commit writes.
                # * Are not eligible to become a leader.
                READ_ONLY = 2

                # Witness replicas don't support reads but do participate in voting to
                # commit writes. Witness replicas:
                #
                # * Do not maintain a full copy of data.
                # * Do not serve reads.
                # * Vote whether to commit writes.
                # * Participate in leader election but are not eligible to become leader.
                WITNESS = 3
              end
            end

            # A possible configuration for a Cloud Spanner instance. Configurations
            # define the geographic placement of nodes and their replication.
            # @!attribute [rw] name
            #   @return [::String]
            #     A unique identifier for the instance configuration.  Values
            #     are of the form
            #     `projects/<project>/instanceConfigs/[a-z][-a-z0-9]*`.
            #
            #     User instance configuration must start with `custom-`.
            # @!attribute [rw] display_name
            #   @return [::String]
            #     The name of this instance configuration as it appears in UIs.
            # @!attribute [r] config_type
            #   @return [::Google::Cloud::Spanner::Admin::Instance::V1::InstanceConfig::Type]
            #     Output only. Whether this instance configuration is a Google-managed or
            #     user-managed configuration.
            # @!attribute [rw] replicas
            #   @return [::Array<::Google::Cloud::Spanner::Admin::Instance::V1::ReplicaInfo>]
            #     The geographic placement of nodes in this instance configuration and their
            #     replication properties.
            #
            #     To create user-managed configurations, input
            #     `replicas` must include all replicas in `replicas` of the `base_config`
            #     and include one or more replicas in the `optional_replicas` of the
            #     `base_config`.
            # @!attribute [r] optional_replicas
            #   @return [::Array<::Google::Cloud::Spanner::Admin::Instance::V1::ReplicaInfo>]
            #     Output only. The available optional replicas to choose from for
            #     user-managed configurations. Populated for Google-managed configurations.
            # @!attribute [rw] base_config
            #   @return [::String]
            #     Base configuration name, e.g. projects/<project_name>/instanceConfigs/nam3,
            #     based on which this configuration is created. Only set for user-managed
            #     configurations. `base_config` must refer to a configuration of type
            #     `GOOGLE_MANAGED` in the same project as this configuration.
            # @!attribute [rw] labels
            #   @return [::Google::Protobuf::Map{::String => ::String}]
            #     Cloud Labels are a flexible and lightweight mechanism for organizing cloud
            #     resources into groups that reflect a customer's organizational needs and
            #     deployment strategies. Cloud Labels can be used to filter collections of
            #     resources. They can be used to control how resource metrics are aggregated.
            #     And they can be used as arguments to policy management rules (e.g. route,
            #     firewall, load balancing, etc.).
            #
            #      * Label keys must be between 1 and 63 characters long and must conform to
            #        the following regular expression: `[a-z][a-z0-9_-]{0,62}`.
            #      * Label values must be between 0 and 63 characters long and must conform
            #        to the regular expression `[a-z0-9_-]{0,63}`.
            #      * No more than 64 labels can be associated with a given resource.
            #
            #     See https://goo.gl/xmQnxf for more information on and examples of labels.
            #
            #     If you plan to use labels in your own code, please note that additional
            #     characters may be allowed in the future. Therefore, you are advised to use
            #     an internal label representation, such as JSON, which doesn't rely upon
            #     specific characters being disallowed.  For example, representing labels
            #     as the string:  name + "_" + value  would prove problematic if we were to
            #     allow "_" in a future release.
            # @!attribute [rw] etag
            #   @return [::String]
            #     etag is used for optimistic concurrency control as a way
            #     to help prevent simultaneous updates of a instance configuration from
            #     overwriting each other. It is strongly suggested that systems make use of
            #     the etag in the read-modify-write cycle to perform instance configuration
            #     updates in order to avoid race conditions: An etag is returned in the
            #     response which contains instance configurations, and systems are expected
            #     to put that etag in the request to update instance configuration to ensure
            #     that their change is applied to the same version of the instance
            #     configuration. If no etag is provided in the call to update the instance
            #     configuration, then the existing instance configuration is overwritten
            #     blindly.
            # @!attribute [rw] leader_options
            #   @return [::Array<::String>]
            #     Allowed values of the "default_leader" schema option for databases in
            #     instances that use this instance configuration.
            # @!attribute [r] reconciling
            #   @return [::Boolean]
            #     Output only. If true, the instance configuration is being created or
            #     updated. If false, there are no ongoing operations for the instance
            #     configuration.
            # @!attribute [r] state
            #   @return [::Google::Cloud::Spanner::Admin::Instance::V1::InstanceConfig::State]
            #     Output only. The current instance configuration state. Applicable only for
            #     `USER_MANAGED` configurations.
            # @!attribute [r] free_instance_availability
            #   @return [::Google::Cloud::Spanner::Admin::Instance::V1::InstanceConfig::FreeInstanceAvailability]
            #     Output only. Describes whether free instances are available to be created
            #     in this instance configuration.
            # @!attribute [r] quorum_type
            #   @return [::Google::Cloud::Spanner::Admin::Instance::V1::InstanceConfig::QuorumType]
            #     Output only. The `QuorumType` of the instance configuration.
            # @!attribute [r] storage_limit_per_processing_unit
            #   @return [::Integer]
            #     Output only. The storage limit in bytes per processing unit.
            class InstanceConfig
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # @!attribute [rw] key
              #   @return [::String]
              # @!attribute [rw] value
              #   @return [::String]
              class LabelsEntry
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end

              # The type of this configuration.
              module Type
                # Unspecified.
                TYPE_UNSPECIFIED = 0

                # Google-managed configuration.
                GOOGLE_MANAGED = 1

                # User-managed configuration.
                USER_MANAGED = 2
              end

              # Indicates the current state of the instance configuration.
              module State
                # Not specified.
                STATE_UNSPECIFIED = 0

                # The instance configuration is still being created.
                CREATING = 1

                # The instance configuration is fully created and ready to be used to
                # create instances.
                READY = 2
              end

              # Describes the availability for free instances to be created in an instance
              # configuration.
              module FreeInstanceAvailability
                # Not specified.
                FREE_INSTANCE_AVAILABILITY_UNSPECIFIED = 0

                # Indicates that free instances are available to be created in this
                # instance configuration.
                AVAILABLE = 1

                # Indicates that free instances are not supported in this instance
                # configuration.
                UNSUPPORTED = 2

                # Indicates that free instances are currently not available to be created
                # in this instance configuration.
                DISABLED = 3

                # Indicates that additional free instances cannot be created in this
                # instance configuration because the project has reached its limit of free
                # instances.
                QUOTA_EXCEEDED = 4
              end

              # Indicates the quorum type of this instance configuration.
              module QuorumType
                # Quorum type not specified.
                QUORUM_TYPE_UNSPECIFIED = 0

                # An instance configuration tagged with `REGION` quorum type forms a write
                # quorum in a single region.
                REGION = 1

                # An instance configuration tagged with the `DUAL_REGION` quorum type forms
                # a write quorum with exactly two read-write regions in a multi-region
                # configuration.
                #
                # This instance configuration requires failover in the event of
                # regional failures.
                DUAL_REGION = 2

                # An instance configuration tagged with the `MULTI_REGION` quorum type
                # forms a write quorum from replicas that are spread across more than one
                # region in a multi-region configuration.
                MULTI_REGION = 3
              end
            end

            # ReplicaComputeCapacity describes the amount of server resources that are
            # allocated to each replica identified by the replica selection.
            # @!attribute [rw] replica_selection
            #   @return [::Google::Cloud::Spanner::Admin::Instance::V1::ReplicaSelection]
            #     Required. Identifies replicas by specified properties.
            #     All replicas in the selection have the same amount of compute capacity.
            # @!attribute [rw] node_count
            #   @return [::Integer]
            #     The number of nodes allocated to each replica.
            #
            #     This may be zero in API responses for instances that are not yet in
            #     state `READY`.
            #
            #     Note: The following fields are mutually exclusive: `node_count`, `processing_units`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] processing_units
            #   @return [::Integer]
            #     The number of processing units allocated to each replica.
            #
            #     This may be zero in API responses for instances that are not yet in
            #     state `READY`.
            #
            #     Note: The following fields are mutually exclusive: `processing_units`, `node_count`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            class ReplicaComputeCapacity
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Autoscaling configuration for an instance.
            # @!attribute [rw] autoscaling_limits
            #   @return [::Google::Cloud::Spanner::Admin::Instance::V1::AutoscalingConfig::AutoscalingLimits]
            #     Required. Autoscaling limits for an instance.
            # @!attribute [rw] autoscaling_targets
            #   @return [::Google::Cloud::Spanner::Admin::Instance::V1::AutoscalingConfig::AutoscalingTargets]
            #     Required. The autoscaling targets for an instance.
            # @!attribute [rw] asymmetric_autoscaling_options
            #   @return [::Array<::Google::Cloud::Spanner::Admin::Instance::V1::AutoscalingConfig::AsymmetricAutoscalingOption>]
            #     Optional. Optional asymmetric autoscaling options.
            #     Replicas matching the replica selection criteria will be autoscaled
            #     independently from other replicas. The autoscaler will scale the replicas
            #     based on the utilization of replicas identified by the replica selection.
            #     Replica selections should not overlap with each other.
            #
            #     Other replicas (those do not match any replica selection) will be
            #     autoscaled together and will have the same compute capacity allocated to
            #     them.
            class AutoscalingConfig
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # The autoscaling limits for the instance. Users can define the minimum and
              # maximum compute capacity allocated to the instance, and the autoscaler will
              # only scale within that range. Users can either use nodes or processing
              # units to specify the limits, but should use the same unit to set both the
              # min_limit and max_limit.
              # @!attribute [rw] min_nodes
              #   @return [::Integer]
              #     Minimum number of nodes allocated to the instance. If set, this number
              #     should be greater than or equal to 1.
              #
              #     Note: The following fields are mutually exclusive: `min_nodes`, `min_processing_units`. If a field in that set is populated, all other fields in the set will automatically be cleared.
              # @!attribute [rw] min_processing_units
              #   @return [::Integer]
              #     Minimum number of processing units allocated to the instance. If set,
              #     this number should be multiples of 1000.
              #
              #     Note: The following fields are mutually exclusive: `min_processing_units`, `min_nodes`. If a field in that set is populated, all other fields in the set will automatically be cleared.
              # @!attribute [rw] max_nodes
              #   @return [::Integer]
              #     Maximum number of nodes allocated to the instance. If set, this number
              #     should be greater than or equal to min_nodes.
              #
              #     Note: The following fields are mutually exclusive: `max_nodes`, `max_processing_units`. If a field in that set is populated, all other fields in the set will automatically be cleared.
              # @!attribute [rw] max_processing_units
              #   @return [::Integer]
              #     Maximum number of processing units allocated to the instance. If set,
              #     this number should be multiples of 1000 and be greater than or equal to
              #     min_processing_units.
              #
              #     Note: The following fields are mutually exclusive: `max_processing_units`, `max_nodes`. If a field in that set is populated, all other fields in the set will automatically be cleared.
              class AutoscalingLimits
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end

              # The autoscaling targets for an instance.
              # @!attribute [rw] high_priority_cpu_utilization_percent
              #   @return [::Integer]
              #     Optional. The target high priority cpu utilization percentage that the
              #     autoscaler should be trying to achieve for the instance. This number is
              #     on a scale from 0 (no utilization) to 100 (full utilization). The valid
              #     range is [10, 90] inclusive. If not specified or set to 0, the autoscaler
              #     skips scaling based on high priority CPU utilization.
              # @!attribute [rw] total_cpu_utilization_percent
              #   @return [::Integer]
              #     Optional. The target total CPU utilization percentage that the autoscaler
              #     should be trying to achieve for the instance. This number is on a scale
              #     from 0 (no utilization) to 100 (full utilization). The valid range is
              #     [10, 90] inclusive. If not specified or set to 0, the autoscaler skips
              #     scaling based on total CPU utilization. If both
              #     `high_priority_cpu_utilization_percent` and
              #     `total_cpu_utilization_percent` are specified, the autoscaler provisions
              #     the larger of the two required compute capacities to satisfy both
              #     targets.
              # @!attribute [rw] storage_utilization_percent
              #   @return [::Integer]
              #     Required. The target storage utilization percentage that the autoscaler
              #     should be trying to achieve for the instance. This number is on a scale
              #     from 0 (no utilization) to 100 (full utilization). The valid range is
              #     [10, 99] inclusive.
              class AutoscalingTargets
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end

              # AsymmetricAutoscalingOption specifies the scaling of replicas identified by
              # the given selection.
              # @!attribute [rw] replica_selection
              #   @return [::Google::Cloud::Spanner::Admin::Instance::V1::ReplicaSelection]
              #     Required. Selects the replicas to which this AsymmetricAutoscalingOption
              #     applies. Only read-only replicas are supported.
              # @!attribute [rw] overrides
              #   @return [::Google::Cloud::Spanner::Admin::Instance::V1::AutoscalingConfig::AsymmetricAutoscalingOption::AutoscalingConfigOverrides]
              #     Optional. Overrides applied to the top-level autoscaling configuration
              #     for the selected replicas.
              class AsymmetricAutoscalingOption
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods

                # Overrides the top-level autoscaling configuration for the replicas
                # identified by `replica_selection`. All fields in this message are
                # optional. Any unspecified fields will use the corresponding values from
                # the top-level autoscaling configuration.
                # @!attribute [rw] autoscaling_limits
                #   @return [::Google::Cloud::Spanner::Admin::Instance::V1::AutoscalingConfig::AutoscalingLimits]
                #     Optional. If specified, overrides the min/max limit in the top-level
                #     autoscaling configuration for the selected replicas.
                # @!attribute [rw] autoscaling_target_high_priority_cpu_utilization_percent
                #   @return [::Integer]
                #     Optional. If specified, overrides the autoscaling target
                #     high_priority_cpu_utilization_percent in the top-level autoscaling
                #     configuration for the selected replicas.
                # @!attribute [rw] autoscaling_target_total_cpu_utilization_percent
                #   @return [::Integer]
                #     Optional. If specified, overrides the
                #     autoscaling target `total_cpu_utilization_percent`
                #     in the top-level autoscaling configuration for the selected replicas.
                # @!attribute [rw] disable_high_priority_cpu_autoscaling
                #   @return [::Boolean]
                #     Optional. If true, disables high priority CPU autoscaling for the
                #     selected replicas and ignores
                #     {::Google::Cloud::Spanner::Admin::Instance::V1::AutoscalingConfig::AutoscalingTargets#high_priority_cpu_utilization_percent high_priority_cpu_utilization_percent}
                #     in the top-level autoscaling configuration.
                #
                #     When setting this field to true, setting
                #     {::Google::Cloud::Spanner::Admin::Instance::V1::AutoscalingConfig::AsymmetricAutoscalingOption::AutoscalingConfigOverrides#autoscaling_target_high_priority_cpu_utilization_percent autoscaling_target_high_priority_cpu_utilization_percent}
                #     field to a non-zero value for the same replica is not supported.
                #
                #     If false, the
                #     {::Google::Cloud::Spanner::Admin::Instance::V1::AutoscalingConfig::AsymmetricAutoscalingOption::AutoscalingConfigOverrides#autoscaling_target_high_priority_cpu_utilization_percent autoscaling_target_high_priority_cpu_utilization_percent}
                #     field in the replica will be used if set to a non-zero value.
                #     Otherwise, the
                #     {::Google::Cloud::Spanner::Admin::Instance::V1::AutoscalingConfig::AutoscalingTargets#high_priority_cpu_utilization_percent high_priority_cpu_utilization_percent}
                #     field in the top-level autoscaling configuration will be used.
                #
                #     Setting both
                #     {::Google::Cloud::Spanner::Admin::Instance::V1::AutoscalingConfig::AsymmetricAutoscalingOption::AutoscalingConfigOverrides#disable_high_priority_cpu_autoscaling disable_high_priority_cpu_autoscaling}
                #     and
                #     {::Google::Cloud::Spanner::Admin::Instance::V1::AutoscalingConfig::AsymmetricAutoscalingOption::AutoscalingConfigOverrides#disable_total_cpu_autoscaling disable_total_cpu_autoscaling}
                #     to true for the same replica is not supported.
                # @!attribute [rw] disable_total_cpu_autoscaling
                #   @return [::Boolean]
                #     Optional. If true, disables total CPU autoscaling for the selected
                #     replicas and ignores
                #     {::Google::Cloud::Spanner::Admin::Instance::V1::AutoscalingConfig::AutoscalingTargets#total_cpu_utilization_percent total_cpu_utilization_percent}
                #     in the top-level autoscaling configuration.
                #
                #     When setting this field to true, setting
                #     {::Google::Cloud::Spanner::Admin::Instance::V1::AutoscalingConfig::AsymmetricAutoscalingOption::AutoscalingConfigOverrides#autoscaling_target_total_cpu_utilization_percent autoscaling_target_total_cpu_utilization_percent}
                #     field to a non-zero value for the same replica is not supported.
                #
                #     If false, the
                #     {::Google::Cloud::Spanner::Admin::Instance::V1::AutoscalingConfig::AsymmetricAutoscalingOption::AutoscalingConfigOverrides#autoscaling_target_total_cpu_utilization_percent autoscaling_target_total_cpu_utilization_percent}
                #     field in the replica will be used if set to a non-zero value.
                #     Otherwise, the
                #     {::Google::Cloud::Spanner::Admin::Instance::V1::AutoscalingConfig::AutoscalingTargets#total_cpu_utilization_percent total_cpu_utilization_percent}
                #     field in the top-level autoscaling configuration will be used.
                #
                #     Setting both
                #     {::Google::Cloud::Spanner::Admin::Instance::V1::AutoscalingConfig::AsymmetricAutoscalingOption::AutoscalingConfigOverrides#disable_high_priority_cpu_autoscaling disable_high_priority_cpu_autoscaling}
                #     and
                #     {::Google::Cloud::Spanner::Admin::Instance::V1::AutoscalingConfig::AsymmetricAutoscalingOption::AutoscalingConfigOverrides#disable_total_cpu_autoscaling disable_total_cpu_autoscaling}
                #     to true for the same replica is not supported.
                class AutoscalingConfigOverrides
                  include ::Google::Protobuf::MessageExts
                  extend ::Google::Protobuf::MessageExts::ClassMethods
                end
              end
            end

            # An isolated set of Cloud Spanner resources on which databases can be hosted.
            # @!attribute [rw] name
            #   @return [::String]
            #     Required. A unique identifier for the instance, which cannot be changed
            #     after the instance is created. Values are of the form
            #     `projects/<project>/instances/[a-z][-a-z0-9]*[a-z0-9]`. The final
            #     segment of the name must be between 2 and 64 characters in length.
            # @!attribute [rw] config
            #   @return [::String]
            #     Required. The name of the instance's configuration. Values are of the form
            #     `projects/<project>/instanceConfigs/<configuration>`. See
            #     also {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceConfig InstanceConfig} and
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#list_instance_configs ListInstanceConfigs}.
            # @!attribute [rw] display_name
            #   @return [::String]
            #     Required. The descriptive name for this instance as it appears in UIs.
            #     Must be unique per project and between 4 and 30 characters in length.
            # @!attribute [rw] node_count
            #   @return [::Integer]
            #     The number of nodes allocated to this instance. At most, one of either
            #     `node_count` or `processing_units` should be present in the message.
            #
            #     Users can set the `node_count` field to specify the target number of nodes
            #     allocated to the instance.
            #
            #     If autoscaling is enabled, `node_count` is treated as an `OUTPUT_ONLY`
            #     field and reflects the current number of nodes allocated to the instance.
            #
            #     This might be zero in API responses for instances that are not yet in the
            #     `READY` state.
            #
            #
            #     For more information, see
            #     [Compute capacity, nodes, and processing
            #     units](https://cloud.google.com/spanner/docs/compute-capacity).
            # @!attribute [rw] processing_units
            #   @return [::Integer]
            #     The number of processing units allocated to this instance. At most, one of
            #     either `processing_units` or `node_count` should be present in the message.
            #
            #     Users can set the `processing_units` field to specify the target number of
            #     processing units allocated to the instance.
            #
            #     If autoscaling is enabled, `processing_units` is treated as an
            #     `OUTPUT_ONLY` field and reflects the current number of processing units
            #     allocated to the instance.
            #
            #     This might be zero in API responses for instances that are not yet in the
            #     `READY` state.
            #
            #
            #     For more information, see
            #     [Compute capacity, nodes and processing
            #     units](https://cloud.google.com/spanner/docs/compute-capacity).
            # @!attribute [r] replica_compute_capacity
            #   @return [::Array<::Google::Cloud::Spanner::Admin::Instance::V1::ReplicaComputeCapacity>]
            #     Output only. Lists the compute capacity per ReplicaSelection. A replica
            #     selection identifies a set of replicas with common properties. Replicas
            #     identified by a ReplicaSelection are scaled with the same compute capacity.
            # @!attribute [rw] autoscaling_config
            #   @return [::Google::Cloud::Spanner::Admin::Instance::V1::AutoscalingConfig]
            #     Optional. The autoscaling configuration. Autoscaling is enabled if this
            #     field is set. When autoscaling is enabled, node_count and processing_units
            #     are treated as OUTPUT_ONLY fields and reflect the current compute capacity
            #     allocated to the instance.
            # @!attribute [r] state
            #   @return [::Google::Cloud::Spanner::Admin::Instance::V1::Instance::State]
            #     Output only. The current instance state. For
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#create_instance CreateInstance},
            #     the state must be either omitted or set to `CREATING`. For
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#update_instance UpdateInstance},
            #     the state must be either omitted or set to `READY`.
            # @!attribute [rw] labels
            #   @return [::Google::Protobuf::Map{::String => ::String}]
            #     Cloud Labels are a flexible and lightweight mechanism for organizing cloud
            #     resources into groups that reflect a customer's organizational needs and
            #     deployment strategies. Cloud Labels can be used to filter collections of
            #     resources. They can be used to control how resource metrics are aggregated.
            #     And they can be used as arguments to policy management rules (e.g. route,
            #     firewall, load balancing, etc.).
            #
            #      * Label keys must be between 1 and 63 characters long and must conform to
            #        the following regular expression: `[a-z][a-z0-9_-]{0,62}`.
            #      * Label values must be between 0 and 63 characters long and must conform
            #        to the regular expression `[a-z0-9_-]{0,63}`.
            #      * No more than 64 labels can be associated with a given resource.
            #
            #     See https://goo.gl/xmQnxf for more information on and examples of labels.
            #
            #     If you plan to use labels in your own code, please note that additional
            #     characters may be allowed in the future. And so you are advised to use an
            #     internal label representation, such as JSON, which doesn't rely upon
            #     specific characters being disallowed.  For example, representing labels
            #     as the string:  name + "_" + value  would prove problematic if we were to
            #     allow "_" in a future release.
            # @!attribute [rw] instance_type
            #   @return [::Google::Cloud::Spanner::Admin::Instance::V1::Instance::InstanceType]
            #     The `InstanceType` of the current instance.
            # @!attribute [rw] endpoint_uris
            #   @return [::Array<::String>]
            #     Deprecated. This field is not populated.
            # @!attribute [r] create_time
            #   @return [::Google::Protobuf::Timestamp]
            #     Output only. The time at which the instance was created.
            # @!attribute [r] update_time
            #   @return [::Google::Protobuf::Timestamp]
            #     Output only. The time at which the instance was most recently updated.
            # @!attribute [rw] free_instance_metadata
            #   @return [::Google::Cloud::Spanner::Admin::Instance::V1::FreeInstanceMetadata]
            #     Free instance metadata. Only populated for free instances.
            # @!attribute [rw] edition
            #   @return [::Google::Cloud::Spanner::Admin::Instance::V1::Instance::Edition]
            #     Optional. The `Edition` of the current instance.
            # @!attribute [rw] default_backup_schedule_type
            #   @return [::Google::Cloud::Spanner::Admin::Instance::V1::Instance::DefaultBackupScheduleType]
            #     Optional. Controls the default backup schedule behavior for new databases
            #     within the instance. By default, a backup schedule is created automatically
            #     when a new database is created in a new instance.
            #
            #     Note that the `AUTOMATIC` value isn't permitted for free instances,
            #     as backups and backup schedules aren't supported for free instances.
            #
            #     In the `GetInstance` or `ListInstances` response, if the value of
            #     `default_backup_schedule_type` isn't set, or set to `NONE`, Spanner doesn't
            #     create a default backup schedule for new databases in the instance.
            class Instance
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # @!attribute [rw] key
              #   @return [::String]
              # @!attribute [rw] value
              #   @return [::String]
              class LabelsEntry
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end

              # Indicates the current state of the instance.
              module State
                # Not specified.
                STATE_UNSPECIFIED = 0

                # The instance is still being created. Resources may not be
                # available yet, and operations such as database creation may not
                # work.
                CREATING = 1

                # The instance is fully created and ready to do work such as
                # creating databases.
                READY = 2
              end

              # The type of this instance. The type can be used to distinguish product
              # variants, that can affect aspects like: usage restrictions, quotas and
              # billing. Currently this is used to distinguish FREE_INSTANCE vs PROVISIONED
              # instances.
              module InstanceType
                # Not specified.
                INSTANCE_TYPE_UNSPECIFIED = 0

                # Provisioned instances have dedicated resources, standard usage limits and
                # support.
                PROVISIONED = 1

                # Free instances provide no guarantee for dedicated resources,
                # [node_count, processing_units] should be 0. They come
                # with stricter usage limits and limited support.
                FREE_INSTANCE = 2
              end

              # The edition selected for this instance. Different editions provide
              # different capabilities at different price points.
              module Edition
                # Edition not specified.
                EDITION_UNSPECIFIED = 0

                # Standard edition.
                STANDARD = 1

                # Enterprise edition.
                ENTERPRISE = 2

                # Enterprise Plus edition.
                ENTERPRISE_PLUS = 3
              end

              # Indicates the
              # [default backup
              # schedule](https://cloud.google.com/spanner/docs/backup#default-backup-schedules)
              # behavior for new databases within the instance.
              module DefaultBackupScheduleType
                # Not specified.
                DEFAULT_BACKUP_SCHEDULE_TYPE_UNSPECIFIED = 0

                # A default backup schedule isn't created automatically when a new database
                # is created in the instance.
                NONE = 1

                # A default backup schedule is created automatically when a new database
                # is created in the instance. The default backup schedule creates a full
                # backup every 24 hours. These full backups are retained for 7 days.
                # You can edit or delete the default backup schedule once it's created.
                AUTOMATIC = 2
              end
            end

            # The request for
            # {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#list_instance_configs ListInstanceConfigs}.
            # @!attribute [rw] parent
            #   @return [::String]
            #     Required. The name of the project for which a list of supported instance
            #     configurations is requested. Values are of the form
            #     `projects/<project>`.
            # @!attribute [rw] page_size
            #   @return [::Integer]
            #     Number of instance configurations to be returned in the response. If 0 or
            #     less, defaults to the server's maximum allowed page size.
            # @!attribute [rw] page_token
            #   @return [::String]
            #     If non-empty, `page_token` should contain a
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::ListInstanceConfigsResponse#next_page_token next_page_token}
            #     from a previous
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::ListInstanceConfigsResponse ListInstanceConfigsResponse}.
            class ListInstanceConfigsRequest
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The response for
            # {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#list_instance_configs ListInstanceConfigs}.
            # @!attribute [rw] instance_configs
            #   @return [::Array<::Google::Cloud::Spanner::Admin::Instance::V1::InstanceConfig>]
            #     The list of requested instance configurations.
            # @!attribute [rw] next_page_token
            #   @return [::String]
            #     `next_page_token` can be sent in a subsequent
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#list_instance_configs ListInstanceConfigs}
            #     call to fetch more of the matching instance configurations.
            class ListInstanceConfigsResponse
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The request for
            # {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#get_instance_config GetInstanceConfigRequest}.
            # @!attribute [rw] name
            #   @return [::String]
            #     Required. The name of the requested instance configuration. Values are of
            #     the form `projects/<project>/instanceConfigs/<config>`.
            class GetInstanceConfigRequest
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The request for
            # {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#create_instance_config CreateInstanceConfig}.
            # @!attribute [rw] parent
            #   @return [::String]
            #     Required. The name of the project in which to create the instance
            #     configuration. Values are of the form `projects/<project>`.
            # @!attribute [rw] instance_config_id
            #   @return [::String]
            #     Required. The ID of the instance configuration to create. Valid identifiers
            #     are of the form `custom-[-a-z0-9]*[a-z0-9]` and must be between 2 and 64
            #     characters in length. The `custom-` prefix is required to avoid name
            #     conflicts with Google-managed configurations.
            # @!attribute [rw] instance_config
            #   @return [::Google::Cloud::Spanner::Admin::Instance::V1::InstanceConfig]
            #     Required. The `InstanceConfig` proto of the configuration to create.
            #     `instance_config.name` must be
            #     `<parent>/instanceConfigs/<instance_config_id>`.
            #     `instance_config.base_config` must be a Google-managed configuration name,
            #     e.g. <parent>/instanceConfigs/us-east1, <parent>/instanceConfigs/nam3.
            # @!attribute [rw] validate_only
            #   @return [::Boolean]
            #     An option to validate, but not actually execute, a request,
            #     and provide the same response.
            class CreateInstanceConfigRequest
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The request for
            # {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#update_instance_config UpdateInstanceConfig}.
            # @!attribute [rw] instance_config
            #   @return [::Google::Cloud::Spanner::Admin::Instance::V1::InstanceConfig]
            #     Required. The user instance configuration to update, which must always
            #     include the instance configuration name. Otherwise, only fields mentioned
            #     in
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::UpdateInstanceConfigRequest#update_mask update_mask}
            #     need be included. To prevent conflicts of concurrent updates,
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceConfig#reconciling etag} can
            #     be used.
            # @!attribute [rw] update_mask
            #   @return [::Google::Protobuf::FieldMask]
            #     Required. A mask specifying which fields in
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceConfig InstanceConfig} should be
            #     updated. The field mask must always be specified; this prevents any future
            #     fields in {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceConfig InstanceConfig}
            #     from being erased accidentally by clients that do not know about them. Only
            #     display_name and labels can be updated.
            # @!attribute [rw] validate_only
            #   @return [::Boolean]
            #     An option to validate, but not actually execute, a request,
            #     and provide the same response.
            class UpdateInstanceConfigRequest
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The request for
            # {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#delete_instance_config DeleteInstanceConfig}.
            # @!attribute [rw] name
            #   @return [::String]
            #     Required. The name of the instance configuration to be deleted.
            #     Values are of the form
            #     `projects/<project>/instanceConfigs/<instance_config>`
            # @!attribute [rw] etag
            #   @return [::String]
            #     Used for optimistic concurrency control as a way to help prevent
            #     simultaneous deletes of an instance configuration from overwriting each
            #     other. If not empty, the API
            #     only deletes the instance configuration when the etag provided matches the
            #     current status of the requested instance configuration. Otherwise, deletes
            #     the instance configuration without checking the current status of the
            #     requested instance configuration.
            # @!attribute [rw] validate_only
            #   @return [::Boolean]
            #     An option to validate, but not actually execute, a request,
            #     and provide the same response.
            class DeleteInstanceConfigRequest
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The request for
            # {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#list_instance_config_operations ListInstanceConfigOperations}.
            # @!attribute [rw] parent
            #   @return [::String]
            #     Required. The project of the instance configuration operations.
            #     Values are of the form `projects/<project>`.
            # @!attribute [rw] filter
            #   @return [::String]
            #     An expression that filters the list of returned operations.
            #
            #     A filter expression consists of a field name, a
            #     comparison operator, and a value for filtering.
            #     The value must be a string, a number, or a boolean. The comparison operator
            #     must be one of: `<`, `>`, `<=`, `>=`, `!=`, `=`, or `:`.
            #     Colon `:` is the contains operator. Filter rules are not case sensitive.
            #
            #     The following fields in the Operation are eligible for filtering:
            #
            #       * `name` - The name of the long-running operation
            #       * `done` - False if the operation is in progress, else true.
            #       * `metadata.@type` - the type of metadata. For example, the type string
            #          for
            #          {::Google::Cloud::Spanner::Admin::Instance::V1::CreateInstanceConfigMetadata CreateInstanceConfigMetadata}
            #          is
            #          `type.googleapis.com/google.spanner.admin.instance.v1.CreateInstanceConfigMetadata`.
            #       * `metadata.<field_name>` - any field in metadata.value.
            #          `metadata.@type` must be specified first, if filtering on metadata
            #          fields.
            #       * `error` - Error associated with the long-running operation.
            #       * `response.@type` - the type of response.
            #       * `response.<field_name>` - any field in response.value.
            #
            #     You can combine multiple expressions by enclosing each expression in
            #     parentheses. By default, expressions are combined with AND logic. However,
            #     you can specify AND, OR, and NOT logic explicitly.
            #
            #     Here are a few examples:
            #
            #       * `done:true` - The operation is complete.
            #       * `(metadata.@type=` \
            #         `type.googleapis.com/google.spanner.admin.instance.v1.CreateInstanceConfigMetadata)
            #         AND` \
            #         `(metadata.instance_config.name:custom-config) AND` \
            #         `(metadata.progress.start_time < \"2021-03-28T14:50:00Z\") AND` \
            #         `(error:*)` - Return operations where:
            #         * The operation's metadata type is
            #         {::Google::Cloud::Spanner::Admin::Instance::V1::CreateInstanceConfigMetadata CreateInstanceConfigMetadata}.
            #         * The instance configuration name contains "custom-config".
            #         * The operation started before 2021-03-28T14:50:00Z.
            #         * The operation resulted in an error.
            # @!attribute [rw] page_size
            #   @return [::Integer]
            #     Number of operations to be returned in the response. If 0 or
            #     less, defaults to the server's maximum allowed page size.
            # @!attribute [rw] page_token
            #   @return [::String]
            #     If non-empty, `page_token` should contain a
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::ListInstanceConfigOperationsResponse#next_page_token next_page_token}
            #     from a previous
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::ListInstanceConfigOperationsResponse ListInstanceConfigOperationsResponse}
            #     to the same `parent` and with the same `filter`.
            class ListInstanceConfigOperationsRequest
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The response for
            # {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#list_instance_config_operations ListInstanceConfigOperations}.
            # @!attribute [rw] operations
            #   @return [::Array<::Google::Longrunning::Operation>]
            #     The list of matching instance configuration long-running operations. Each
            #     operation's name will be
            #     prefixed by the name of the instance configuration. The operation's
            #     metadata field type
            #     `metadata.type_url` describes the type of the metadata.
            # @!attribute [rw] next_page_token
            #   @return [::String]
            #     `next_page_token` can be sent in a subsequent
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#list_instance_config_operations ListInstanceConfigOperations}
            #     call to fetch more of the matching metadata.
            class ListInstanceConfigOperationsResponse
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The request for
            # {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#get_instance GetInstance}.
            # @!attribute [rw] name
            #   @return [::String]
            #     Required. The name of the requested instance. Values are of the form
            #     `projects/<project>/instances/<instance>`.
            # @!attribute [rw] field_mask
            #   @return [::Google::Protobuf::FieldMask]
            #     If field_mask is present, specifies the subset of
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::Instance Instance} fields that should be
            #     returned. If absent, all
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::Instance Instance} fields are returned.
            class GetInstanceRequest
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The request for
            # {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#create_instance CreateInstance}.
            # @!attribute [rw] parent
            #   @return [::String]
            #     Required. The name of the project in which to create the instance. Values
            #     are of the form `projects/<project>`.
            # @!attribute [rw] instance_id
            #   @return [::String]
            #     Required. The ID of the instance to create.  Valid identifiers are of the
            #     form `[a-z][-a-z0-9]*[a-z0-9]` and must be between 2 and 64 characters in
            #     length.
            # @!attribute [rw] instance
            #   @return [::Google::Cloud::Spanner::Admin::Instance::V1::Instance]
            #     Required. The instance to create.  The name may be omitted, but if
            #     specified must be `<parent>/instances/<instance_id>`.
            class CreateInstanceRequest
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The request for
            # {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#list_instances ListInstances}.
            # @!attribute [rw] parent
            #   @return [::String]
            #     Required. The name of the project for which a list of instances is
            #     requested. Values are of the form `projects/<project>`.
            # @!attribute [rw] page_size
            #   @return [::Integer]
            #     Number of instances to be returned in the response. If 0 or less, defaults
            #     to the server's maximum allowed page size.
            # @!attribute [rw] page_token
            #   @return [::String]
            #     If non-empty, `page_token` should contain a
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancesResponse#next_page_token next_page_token}
            #     from a previous
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancesResponse ListInstancesResponse}.
            # @!attribute [rw] filter
            #   @return [::String]
            #     An expression for filtering the results of the request. Filter rules are
            #     case insensitive. The fields eligible for filtering are:
            #
            #       * `name`
            #       * `display_name`
            #       * `labels.key` where key is the name of a label
            #
            #     Some examples of using filters are:
            #
            #       * `name:*` --> The instance has a name.
            #       * `name:Howl` --> The instance's name contains the string "howl".
            #       * `name:HOWL` --> Equivalent to above.
            #       * `NAME:howl` --> Equivalent to above.
            #       * `labels.env:*` --> The instance has the label "env".
            #       * `labels.env:dev` --> The instance has the label "env" and the value of
            #                            the label contains the string "dev".
            #       * `name:howl labels.env:dev` --> The instance's name contains "howl" and
            #                                      it has the label "env" with its value
            #                                      containing "dev".
            # @!attribute [rw] instance_deadline
            #   @return [::Google::Protobuf::Timestamp]
            #     Deadline used while retrieving metadata for instances.
            #     Instances whose metadata cannot be retrieved within this deadline will be
            #     added to
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancesResponse#unreachable unreachable}
            #     in
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancesResponse ListInstancesResponse}.
            class ListInstancesRequest
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The response for
            # {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#list_instances ListInstances}.
            # @!attribute [rw] instances
            #   @return [::Array<::Google::Cloud::Spanner::Admin::Instance::V1::Instance>]
            #     The list of requested instances.
            # @!attribute [rw] next_page_token
            #   @return [::String]
            #     `next_page_token` can be sent in a subsequent
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#list_instances ListInstances}
            #     call to fetch more of the matching instances.
            # @!attribute [rw] unreachable
            #   @return [::Array<::String>]
            #     The list of unreachable instances.
            #     It includes the names of instances whose metadata could not be retrieved
            #     within
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancesRequest#instance_deadline instance_deadline}.
            class ListInstancesResponse
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The request for
            # {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#update_instance UpdateInstance}.
            # @!attribute [rw] instance
            #   @return [::Google::Cloud::Spanner::Admin::Instance::V1::Instance]
            #     Required. The instance to update, which must always include the instance
            #     name.  Otherwise, only fields mentioned in
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::UpdateInstanceRequest#field_mask field_mask}
            #     need be included.
            # @!attribute [rw] field_mask
            #   @return [::Google::Protobuf::FieldMask]
            #     Required. A mask specifying which fields in
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::Instance Instance} should be updated.
            #     The field mask must always be specified; this prevents any future fields in
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::Instance Instance} from being erased
            #     accidentally by clients that do not know about them.
            class UpdateInstanceRequest
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The request for
            # {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#delete_instance DeleteInstance}.
            # @!attribute [rw] name
            #   @return [::String]
            #     Required. The name of the instance to be deleted. Values are of the form
            #     `projects/<project>/instances/<instance>`
            class DeleteInstanceRequest
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Metadata type for the operation returned by
            # {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#create_instance CreateInstance}.
            # @!attribute [rw] instance
            #   @return [::Google::Cloud::Spanner::Admin::Instance::V1::Instance]
            #     The instance being created.
            # @!attribute [rw] start_time
            #   @return [::Google::Protobuf::Timestamp]
            #     The time at which the
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#create_instance CreateInstance}
            #     request was received.
            # @!attribute [rw] cancel_time
            #   @return [::Google::Protobuf::Timestamp]
            #     The time at which this operation was cancelled. If set, this operation is
            #     in the process of undoing itself (which is guaranteed to succeed) and
            #     cannot be cancelled again.
            # @!attribute [rw] end_time
            #   @return [::Google::Protobuf::Timestamp]
            #     The time at which this operation failed or was completed successfully.
            # @!attribute [rw] expected_fulfillment_period
            #   @return [::Google::Cloud::Spanner::Admin::Instance::V1::FulfillmentPeriod]
            #     The expected fulfillment period of this create operation.
            class CreateInstanceMetadata
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Metadata type for the operation returned by
            # {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#update_instance UpdateInstance}.
            # @!attribute [rw] instance
            #   @return [::Google::Cloud::Spanner::Admin::Instance::V1::Instance]
            #     The desired end state of the update.
            # @!attribute [rw] start_time
            #   @return [::Google::Protobuf::Timestamp]
            #     The time at which
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#update_instance UpdateInstance}
            #     request was received.
            # @!attribute [rw] cancel_time
            #   @return [::Google::Protobuf::Timestamp]
            #     The time at which this operation was cancelled. If set, this operation is
            #     in the process of undoing itself (which is guaranteed to succeed) and
            #     cannot be cancelled again.
            # @!attribute [rw] end_time
            #   @return [::Google::Protobuf::Timestamp]
            #     The time at which this operation failed or was completed successfully.
            # @!attribute [rw] expected_fulfillment_period
            #   @return [::Google::Cloud::Spanner::Admin::Instance::V1::FulfillmentPeriod]
            #     The expected fulfillment period of this update operation.
            class UpdateInstanceMetadata
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Free instance specific metadata that is kept even after an instance has been
            # upgraded for tracking purposes.
            # @!attribute [r] expire_time
            #   @return [::Google::Protobuf::Timestamp]
            #     Output only. Timestamp after which the instance will either be upgraded or
            #     scheduled for deletion after a grace period. ExpireBehavior is used to
            #     choose between upgrading or scheduling the free instance for deletion. This
            #     timestamp is set during the creation of a free instance.
            # @!attribute [r] upgrade_time
            #   @return [::Google::Protobuf::Timestamp]
            #     Output only. If present, the timestamp at which the free instance was
            #     upgraded to a provisioned instance.
            # @!attribute [rw] expire_behavior
            #   @return [::Google::Cloud::Spanner::Admin::Instance::V1::FreeInstanceMetadata::ExpireBehavior]
            #     Specifies the expiration behavior of a free instance. The default of
            #     ExpireBehavior is `REMOVE_AFTER_GRACE_PERIOD`. This can be modified during
            #     or after creation, and before expiration.
            class FreeInstanceMetadata
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Allows users to change behavior when a free instance expires.
              module ExpireBehavior
                # Not specified.
                EXPIRE_BEHAVIOR_UNSPECIFIED = 0

                # When the free instance expires, upgrade the instance to a provisioned
                # instance.
                FREE_TO_PROVISIONED = 1

                # When the free instance expires, disable the instance, and delete it
                # after the grace period passes if it has not been upgraded.
                REMOVE_AFTER_GRACE_PERIOD = 2
              end
            end

            # Metadata type for the operation returned by
            # {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#create_instance_config CreateInstanceConfig}.
            # @!attribute [rw] instance_config
            #   @return [::Google::Cloud::Spanner::Admin::Instance::V1::InstanceConfig]
            #     The target instance configuration end state.
            # @!attribute [rw] progress
            #   @return [::Google::Cloud::Spanner::Admin::Instance::V1::OperationProgress]
            #     The progress of the
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#create_instance_config CreateInstanceConfig}
            #     operation.
            # @!attribute [rw] cancel_time
            #   @return [::Google::Protobuf::Timestamp]
            #     The time at which this operation was cancelled.
            class CreateInstanceConfigMetadata
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Metadata type for the operation returned by
            # {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#update_instance_config UpdateInstanceConfig}.
            # @!attribute [rw] instance_config
            #   @return [::Google::Cloud::Spanner::Admin::Instance::V1::InstanceConfig]
            #     The desired instance configuration after updating.
            # @!attribute [rw] progress
            #   @return [::Google::Cloud::Spanner::Admin::Instance::V1::OperationProgress]
            #     The progress of the
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#update_instance_config UpdateInstanceConfig}
            #     operation.
            # @!attribute [rw] cancel_time
            #   @return [::Google::Protobuf::Timestamp]
            #     The time at which this operation was cancelled.
            class UpdateInstanceConfigMetadata
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # An isolated set of Cloud Spanner resources that databases can define
            # placements on.
            # @!attribute [rw] name
            #   @return [::String]
            #     Required. A unique identifier for the instance partition. Values are of the
            #     form
            #     `projects/<project>/instances/<instance>/instancePartitions/[a-z][-a-z0-9]*[a-z0-9]`.
            #     The final segment of the name must be between 2 and 64 characters in
            #     length. An instance partition's name cannot be changed after the instance
            #     partition is created.
            # @!attribute [rw] config
            #   @return [::String]
            #     Required. The name of the instance partition's configuration. Values are of
            #     the form `projects/<project>/instanceConfigs/<configuration>`. See also
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceConfig InstanceConfig} and
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#list_instance_configs ListInstanceConfigs}.
            # @!attribute [rw] display_name
            #   @return [::String]
            #     Required. The descriptive name for this instance partition as it appears in
            #     UIs. Must be unique per project and between 4 and 30 characters in length.
            # @!attribute [rw] node_count
            #   @return [::Integer]
            #     The number of nodes allocated to this instance partition.
            #
            #     Users can set the `node_count` field to specify the target number of
            #     nodes allocated to the instance partition.
            #
            #     This may be zero in API responses for instance partitions that are not
            #     yet in state `READY`.
            #
            #     Note: The following fields are mutually exclusive: `node_count`, `processing_units`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] processing_units
            #   @return [::Integer]
            #     The number of processing units allocated to this instance partition.
            #
            #     Users can set the `processing_units` field to specify the target number
            #     of processing units allocated to the instance partition.
            #
            #     This might be zero in API responses for instance partitions that are not
            #     yet in the `READY` state.
            #
            #     Note: The following fields are mutually exclusive: `processing_units`, `node_count`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] autoscaling_config
            #   @return [::Google::Cloud::Spanner::Admin::Instance::V1::AutoscalingConfig]
            #     Optional. The autoscaling configuration. Autoscaling is enabled if this
            #     field is set. When autoscaling is enabled, fields in compute_capacity are
            #     treated as OUTPUT_ONLY fields and reflect the current compute capacity
            #     allocated to the instance partition.
            # @!attribute [r] state
            #   @return [::Google::Cloud::Spanner::Admin::Instance::V1::InstancePartition::State]
            #     Output only. The current instance partition state.
            # @!attribute [r] create_time
            #   @return [::Google::Protobuf::Timestamp]
            #     Output only. The time at which the instance partition was created.
            # @!attribute [r] update_time
            #   @return [::Google::Protobuf::Timestamp]
            #     Output only. The time at which the instance partition was most recently
            #     updated.
            # @!attribute [r] referencing_databases
            #   @return [::Array<::String>]
            #     Output only. The names of the databases that reference this
            #     instance partition. Referencing databases should share the parent instance.
            #     The existence of any referencing database prevents the instance partition
            #     from being deleted.
            # @!attribute [r] referencing_backups
            #   @deprecated This field is deprecated and may be removed in the next major version update.
            #   @return [::Array<::String>]
            #     Output only. Deprecated: This field is not populated.
            #     Output only. The names of the backups that reference this instance
            #     partition. Referencing backups should share the parent instance. The
            #     existence of any referencing backup prevents the instance partition from
            #     being deleted.
            # @!attribute [rw] etag
            #   @return [::String]
            #     Used for optimistic concurrency control as a way
            #     to help prevent simultaneous updates of a instance partition from
            #     overwriting each other. It is strongly suggested that systems make use of
            #     the etag in the read-modify-write cycle to perform instance partition
            #     updates in order to avoid race conditions: An etag is returned in the
            #     response which contains instance partitions, and systems are expected to
            #     put that etag in the request to update instance partitions to ensure that
            #     their change will be applied to the same version of the instance partition.
            #     If no etag is provided in the call to update instance partition, then the
            #     existing instance partition is overwritten blindly.
            class InstancePartition
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Indicates the current state of the instance partition.
              module State
                # Not specified.
                STATE_UNSPECIFIED = 0

                # The instance partition is still being created. Resources may not be
                # available yet, and operations such as creating placements using this
                # instance partition may not work.
                CREATING = 1

                # The instance partition is fully created and ready to do work such as
                # creating placements and using in databases.
                READY = 2
              end
            end

            # Metadata type for the operation returned by
            # {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#create_instance_partition CreateInstancePartition}.
            # @!attribute [rw] instance_partition
            #   @return [::Google::Cloud::Spanner::Admin::Instance::V1::InstancePartition]
            #     The instance partition being created.
            # @!attribute [rw] start_time
            #   @return [::Google::Protobuf::Timestamp]
            #     The time at which the
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#create_instance_partition CreateInstancePartition}
            #     request was received.
            # @!attribute [rw] cancel_time
            #   @return [::Google::Protobuf::Timestamp]
            #     The time at which this operation was cancelled. If set, this operation is
            #     in the process of undoing itself (which is guaranteed to succeed) and
            #     cannot be cancelled again.
            # @!attribute [rw] end_time
            #   @return [::Google::Protobuf::Timestamp]
            #     The time at which this operation failed or was completed successfully.
            class CreateInstancePartitionMetadata
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The request for
            # {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#create_instance_partition CreateInstancePartition}.
            # @!attribute [rw] parent
            #   @return [::String]
            #     Required. The name of the instance in which to create the instance
            #     partition. Values are of the form
            #     `projects/<project>/instances/<instance>`.
            # @!attribute [rw] instance_partition_id
            #   @return [::String]
            #     Required. The ID of the instance partition to create. Valid identifiers are
            #     of the form `[a-z][-a-z0-9]*[a-z0-9]` and must be between 2 and 64
            #     characters in length.
            # @!attribute [rw] instance_partition
            #   @return [::Google::Cloud::Spanner::Admin::Instance::V1::InstancePartition]
            #     Required. The instance partition to create. The instance_partition.name may
            #     be omitted, but if specified must be
            #     `<parent>/instancePartitions/<instance_partition_id>`.
            class CreateInstancePartitionRequest
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The request for
            # {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#delete_instance_partition DeleteInstancePartition}.
            # @!attribute [rw] name
            #   @return [::String]
            #     Required. The name of the instance partition to be deleted.
            #     Values are of the form
            #     `projects/{project}/instances/{instance}/instancePartitions/{instance_partition}`
            # @!attribute [rw] etag
            #   @return [::String]
            #     Optional. If not empty, the API only deletes the instance partition when
            #     the etag provided matches the current status of the requested instance
            #     partition. Otherwise, deletes the instance partition without checking the
            #     current status of the requested instance partition.
            class DeleteInstancePartitionRequest
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The request for
            # {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#get_instance_partition GetInstancePartition}.
            # @!attribute [rw] name
            #   @return [::String]
            #     Required. The name of the requested instance partition. Values are of
            #     the form
            #     `projects/{project}/instances/{instance}/instancePartitions/{instance_partition}`.
            class GetInstancePartitionRequest
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The request for
            # {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#update_instance_partition UpdateInstancePartition}.
            # @!attribute [rw] instance_partition
            #   @return [::Google::Cloud::Spanner::Admin::Instance::V1::InstancePartition]
            #     Required. The instance partition to update, which must always include the
            #     instance partition name. Otherwise, only fields mentioned in
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::UpdateInstancePartitionRequest#field_mask field_mask}
            #     need be included.
            # @!attribute [rw] field_mask
            #   @return [::Google::Protobuf::FieldMask]
            #     Required. A mask specifying which fields in
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::InstancePartition InstancePartition}
            #     should be updated. The field mask must always be specified; this prevents
            #     any future fields in
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::InstancePartition InstancePartition}
            #     from being erased accidentally by clients that do not know about them.
            class UpdateInstancePartitionRequest
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Metadata type for the operation returned by
            # {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#update_instance_partition UpdateInstancePartition}.
            # @!attribute [rw] instance_partition
            #   @return [::Google::Cloud::Spanner::Admin::Instance::V1::InstancePartition]
            #     The desired end state of the update.
            # @!attribute [rw] start_time
            #   @return [::Google::Protobuf::Timestamp]
            #     The time at which
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#update_instance_partition UpdateInstancePartition}
            #     request was received.
            # @!attribute [rw] cancel_time
            #   @return [::Google::Protobuf::Timestamp]
            #     The time at which this operation was cancelled. If set, this operation is
            #     in the process of undoing itself (which is guaranteed to succeed) and
            #     cannot be cancelled again.
            # @!attribute [rw] end_time
            #   @return [::Google::Protobuf::Timestamp]
            #     The time at which this operation failed or was completed successfully.
            class UpdateInstancePartitionMetadata
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The request for
            # {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#list_instance_partitions ListInstancePartitions}.
            # @!attribute [rw] parent
            #   @return [::String]
            #     Required. The instance whose instance partitions should be listed. Values
            #     are of the form `projects/<project>/instances/<instance>`. Use `{instance}
            #     = '-'` to list instance partitions for all Instances in a project, e.g.,
            #     `projects/myproject/instances/-`.
            # @!attribute [rw] page_size
            #   @return [::Integer]
            #     Number of instance partitions to be returned in the response. If 0 or less,
            #     defaults to the server's maximum allowed page size.
            # @!attribute [rw] page_token
            #   @return [::String]
            #     If non-empty, `page_token` should contain a
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancePartitionsResponse#next_page_token next_page_token}
            #     from a previous
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancePartitionsResponse ListInstancePartitionsResponse}.
            # @!attribute [rw] instance_partition_deadline
            #   @return [::Google::Protobuf::Timestamp]
            #     Optional. Deadline used while retrieving metadata for instance partitions.
            #     Instance partitions whose metadata cannot be retrieved within this deadline
            #     will be added to
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancePartitionsResponse#unreachable unreachable}
            #     in
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancePartitionsResponse ListInstancePartitionsResponse}.
            class ListInstancePartitionsRequest
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The response for
            # {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#list_instance_partitions ListInstancePartitions}.
            # @!attribute [rw] instance_partitions
            #   @return [::Array<::Google::Cloud::Spanner::Admin::Instance::V1::InstancePartition>]
            #     The list of requested instancePartitions.
            # @!attribute [rw] next_page_token
            #   @return [::String]
            #     `next_page_token` can be sent in a subsequent
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#list_instance_partitions ListInstancePartitions}
            #     call to fetch more of the matching instance partitions.
            # @!attribute [rw] unreachable
            #   @return [::Array<::String>]
            #     The list of unreachable instances or instance partitions.
            #     It includes the names of instances or instance partitions whose metadata
            #     could not be retrieved within
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancePartitionsRequest#instance_partition_deadline instance_partition_deadline}.
            class ListInstancePartitionsResponse
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The request for
            # {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#list_instance_partition_operations ListInstancePartitionOperations}.
            # @!attribute [rw] parent
            #   @return [::String]
            #     Required. The parent instance of the instance partition operations.
            #     Values are of the form `projects/<project>/instances/<instance>`.
            # @!attribute [rw] filter
            #   @return [::String]
            #     Optional. An expression that filters the list of returned operations.
            #
            #     A filter expression consists of a field name, a
            #     comparison operator, and a value for filtering.
            #     The value must be a string, a number, or a boolean. The comparison operator
            #     must be one of: `<`, `>`, `<=`, `>=`, `!=`, `=`, or `:`.
            #     Colon `:` is the contains operator. Filter rules are not case sensitive.
            #
            #     The following fields in the Operation are eligible for filtering:
            #
            #       * `name` - The name of the long-running operation
            #       * `done` - False if the operation is in progress, else true.
            #       * `metadata.@type` - the type of metadata. For example, the type string
            #          for
            #          {::Google::Cloud::Spanner::Admin::Instance::V1::CreateInstancePartitionMetadata CreateInstancePartitionMetadata}
            #          is
            #          `type.googleapis.com/google.spanner.admin.instance.v1.CreateInstancePartitionMetadata`.
            #       * `metadata.<field_name>` - any field in metadata.value.
            #          `metadata.@type` must be specified first, if filtering on metadata
            #          fields.
            #       * `error` - Error associated with the long-running operation.
            #       * `response.@type` - the type of response.
            #       * `response.<field_name>` - any field in response.value.
            #
            #     You can combine multiple expressions by enclosing each expression in
            #     parentheses. By default, expressions are combined with AND logic. However,
            #     you can specify AND, OR, and NOT logic explicitly.
            #
            #     Here are a few examples:
            #
            #       * `done:true` - The operation is complete.
            #       * `(metadata.@type=` \
            #         `type.googleapis.com/google.spanner.admin.instance.v1.CreateInstancePartitionMetadata)
            #         AND` \
            #         `(metadata.instance_partition.name:custom-instance-partition) AND` \
            #         `(metadata.start_time < \"2021-03-28T14:50:00Z\") AND` \
            #         `(error:*)` - Return operations where:
            #         * The operation's metadata type is
            #         {::Google::Cloud::Spanner::Admin::Instance::V1::CreateInstancePartitionMetadata CreateInstancePartitionMetadata}.
            #         * The instance partition name contains "custom-instance-partition".
            #         * The operation started before 2021-03-28T14:50:00Z.
            #         * The operation resulted in an error.
            # @!attribute [rw] page_size
            #   @return [::Integer]
            #     Optional. Number of operations to be returned in the response. If 0 or
            #     less, defaults to the server's maximum allowed page size.
            # @!attribute [rw] page_token
            #   @return [::String]
            #     Optional. If non-empty, `page_token` should contain a
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancePartitionOperationsResponse#next_page_token next_page_token}
            #     from a previous
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancePartitionOperationsResponse ListInstancePartitionOperationsResponse}
            #     to the same `parent` and with the same `filter`.
            # @!attribute [rw] instance_partition_deadline
            #   @return [::Google::Protobuf::Timestamp]
            #     Optional. Deadline used while retrieving metadata for instance partition
            #     operations. Instance partitions whose operation metadata cannot be
            #     retrieved within this deadline will be added to
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancePartitionOperationsResponse#unreachable_instance_partitions unreachable_instance_partitions}
            #     in
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancePartitionOperationsResponse ListInstancePartitionOperationsResponse}.
            class ListInstancePartitionOperationsRequest
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The response for
            # {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#list_instance_partition_operations ListInstancePartitionOperations}.
            # @!attribute [rw] operations
            #   @return [::Array<::Google::Longrunning::Operation>]
            #     The list of matching instance partition long-running operations. Each
            #     operation's name will be
            #     prefixed by the instance partition's name. The operation's
            #     metadata field type
            #     `metadata.type_url` describes the type of the metadata.
            # @!attribute [rw] next_page_token
            #   @return [::String]
            #     `next_page_token` can be sent in a subsequent
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#list_instance_partition_operations ListInstancePartitionOperations}
            #     call to fetch more of the matching metadata.
            # @!attribute [rw] unreachable_instance_partitions
            #   @return [::Array<::String>]
            #     The list of unreachable instance partitions.
            #     It includes the names of instance partitions whose operation metadata could
            #     not be retrieved within
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancePartitionOperationsRequest#instance_partition_deadline instance_partition_deadline}.
            class ListInstancePartitionOperationsResponse
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The request for
            # {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#move_instance MoveInstance}.
            # @!attribute [rw] name
            #   @return [::String]
            #     Required. The instance to move.
            #     Values are of the form `projects/<project>/instances/<instance>`.
            # @!attribute [rw] target_config
            #   @return [::String]
            #     Required. The target instance configuration where to move the instance.
            #     Values are of the form `projects/<project>/instanceConfigs/<config>`.
            class MoveInstanceRequest
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The response for
            # {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#move_instance MoveInstance}.
            class MoveInstanceResponse
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Metadata type for the operation returned by
            # {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#move_instance MoveInstance}.
            # @!attribute [rw] target_config
            #   @return [::String]
            #     The target instance configuration where to move the instance.
            #     Values are of the form `projects/<project>/instanceConfigs/<config>`.
            # @!attribute [rw] progress
            #   @return [::Google::Cloud::Spanner::Admin::Instance::V1::OperationProgress]
            #     The progress of the
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Client#move_instance MoveInstance}
            #     operation.
            #     {::Google::Cloud::Spanner::Admin::Instance::V1::OperationProgress#progress_percent progress_percent}
            #     is reset when cancellation is requested.
            # @!attribute [rw] cancel_time
            #   @return [::Google::Protobuf::Timestamp]
            #     The time at which this operation was cancelled.
            class MoveInstanceMetadata
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end
      end
    end
  end
end
