# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/spanner/admin/instance/v1/spanner_instance_admin_pb"

module Google
  module Cloud
    module Spanner
      module Admin
        module Instance
          module V1
            module InstanceAdmin
              module Rest
                ##
                # REST service stub for the InstanceAdmin service.
                # Service stub contains baseline method implementations
                # including transcoding, making the REST call, and deserialing the response.
                #
                class ServiceStub
                  # @private
                  def initialize endpoint:, endpoint_template:, universe_domain:, credentials:, logger:
                    # These require statements are intentionally placed here to initialize
                    # the REST modules only when it's required.
                    require "gapic/rest"

                    @client_stub = ::Gapic::Rest::ClientStub.new endpoint: endpoint,
                                                                 endpoint_template: endpoint_template,
                                                                 universe_domain: universe_domain,
                                                                 credentials: credentials,
                                                                 numeric_enums: true,
                                                                 service_name: self.class,
                                                                 raise_faraday_errors: false,
                                                                 logger: logger
                  end

                  ##
                  # The effective universe domain
                  #
                  # @return [String]
                  #
                  def universe_domain
                    @client_stub.universe_domain
                  end

                  ##
                  # The effective endpoint
                  #
                  # @return [String]
                  #
                  def endpoint
                    @client_stub.endpoint
                  end

                  ##
                  # The logger used for request/response debug logging.
                  #
                  # @return [Logger]
                  #
                  def logger stub: false
                    stub ? @client_stub.stub_logger : @client_stub.logger
                  end

                  ##
                  # Baseline implementation for the list_instance_configs REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Instance::V1::ListInstanceConfigsRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Spanner::Admin::Instance::V1::ListInstanceConfigsResponse]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Spanner::Admin::Instance::V1::ListInstanceConfigsResponse]
                  #   A result object deserialized from the server's reply
                  def list_instance_configs request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_list_instance_configs_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "list_instance_configs",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Spanner::Admin::Instance::V1::ListInstanceConfigsResponse.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the get_instance_config REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Instance::V1::GetInstanceConfigRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Spanner::Admin::Instance::V1::InstanceConfig]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Spanner::Admin::Instance::V1::InstanceConfig]
                  #   A result object deserialized from the server's reply
                  def get_instance_config request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_get_instance_config_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "get_instance_config",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Spanner::Admin::Instance::V1::InstanceConfig.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the create_instance_config REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Instance::V1::CreateInstanceConfigRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Longrunning::Operation]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Longrunning::Operation]
                  #   A result object deserialized from the server's reply
                  def create_instance_config request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_create_instance_config_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "create_instance_config",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Longrunning::Operation.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the update_instance_config REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Instance::V1::UpdateInstanceConfigRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Longrunning::Operation]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Longrunning::Operation]
                  #   A result object deserialized from the server's reply
                  def update_instance_config request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_update_instance_config_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "update_instance_config",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Longrunning::Operation.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the delete_instance_config REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Instance::V1::DeleteInstanceConfigRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Protobuf::Empty]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Protobuf::Empty]
                  #   A result object deserialized from the server's reply
                  def delete_instance_config request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_delete_instance_config_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "delete_instance_config",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Protobuf::Empty.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the list_instance_config_operations REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Instance::V1::ListInstanceConfigOperationsRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Spanner::Admin::Instance::V1::ListInstanceConfigOperationsResponse]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Spanner::Admin::Instance::V1::ListInstanceConfigOperationsResponse]
                  #   A result object deserialized from the server's reply
                  def list_instance_config_operations request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_list_instance_config_operations_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "list_instance_config_operations",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Spanner::Admin::Instance::V1::ListInstanceConfigOperationsResponse.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the list_instances REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancesRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancesResponse]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancesResponse]
                  #   A result object deserialized from the server's reply
                  def list_instances request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_list_instances_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "list_instances",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancesResponse.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the list_instance_partitions REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancePartitionsRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancePartitionsResponse]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancePartitionsResponse]
                  #   A result object deserialized from the server's reply
                  def list_instance_partitions request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_list_instance_partitions_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "list_instance_partitions",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancePartitionsResponse.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the get_instance REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Instance::V1::GetInstanceRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Spanner::Admin::Instance::V1::Instance]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Spanner::Admin::Instance::V1::Instance]
                  #   A result object deserialized from the server's reply
                  def get_instance request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_get_instance_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "get_instance",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Spanner::Admin::Instance::V1::Instance.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the create_instance REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Instance::V1::CreateInstanceRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Longrunning::Operation]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Longrunning::Operation]
                  #   A result object deserialized from the server's reply
                  def create_instance request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_create_instance_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "create_instance",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Longrunning::Operation.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the update_instance REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Instance::V1::UpdateInstanceRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Longrunning::Operation]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Longrunning::Operation]
                  #   A result object deserialized from the server's reply
                  def update_instance request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_update_instance_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "update_instance",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Longrunning::Operation.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the delete_instance REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Instance::V1::DeleteInstanceRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Protobuf::Empty]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Protobuf::Empty]
                  #   A result object deserialized from the server's reply
                  def delete_instance request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_delete_instance_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "delete_instance",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Protobuf::Empty.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the set_iam_policy REST call
                  #
                  # @param request_pb [::Google::Iam::V1::SetIamPolicyRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Iam::V1::Policy]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Iam::V1::Policy]
                  #   A result object deserialized from the server's reply
                  def set_iam_policy request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_set_iam_policy_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "set_iam_policy",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Iam::V1::Policy.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the get_iam_policy REST call
                  #
                  # @param request_pb [::Google::Iam::V1::GetIamPolicyRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Iam::V1::Policy]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Iam::V1::Policy]
                  #   A result object deserialized from the server's reply
                  def get_iam_policy request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_get_iam_policy_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "get_iam_policy",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Iam::V1::Policy.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the test_iam_permissions REST call
                  #
                  # @param request_pb [::Google::Iam::V1::TestIamPermissionsRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Iam::V1::TestIamPermissionsResponse]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Iam::V1::TestIamPermissionsResponse]
                  #   A result object deserialized from the server's reply
                  def test_iam_permissions request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_test_iam_permissions_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "test_iam_permissions",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Iam::V1::TestIamPermissionsResponse.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the get_instance_partition REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Instance::V1::GetInstancePartitionRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Spanner::Admin::Instance::V1::InstancePartition]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Spanner::Admin::Instance::V1::InstancePartition]
                  #   A result object deserialized from the server's reply
                  def get_instance_partition request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_get_instance_partition_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "get_instance_partition",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Spanner::Admin::Instance::V1::InstancePartition.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the create_instance_partition REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Instance::V1::CreateInstancePartitionRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Longrunning::Operation]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Longrunning::Operation]
                  #   A result object deserialized from the server's reply
                  def create_instance_partition request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_create_instance_partition_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "create_instance_partition",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Longrunning::Operation.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the delete_instance_partition REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Instance::V1::DeleteInstancePartitionRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Protobuf::Empty]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Protobuf::Empty]
                  #   A result object deserialized from the server's reply
                  def delete_instance_partition request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_delete_instance_partition_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "delete_instance_partition",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Protobuf::Empty.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the update_instance_partition REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Instance::V1::UpdateInstancePartitionRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Longrunning::Operation]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Longrunning::Operation]
                  #   A result object deserialized from the server's reply
                  def update_instance_partition request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_update_instance_partition_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "update_instance_partition",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Longrunning::Operation.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the list_instance_partition_operations REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancePartitionOperationsRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancePartitionOperationsResponse]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancePartitionOperationsResponse]
                  #   A result object deserialized from the server's reply
                  def list_instance_partition_operations request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_list_instance_partition_operations_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "list_instance_partition_operations",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancePartitionOperationsResponse.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the move_instance REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Instance::V1::MoveInstanceRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Longrunning::Operation]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Longrunning::Operation]
                  #   A result object deserialized from the server's reply
                  def move_instance request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_move_instance_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "move_instance",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Longrunning::Operation.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the list_instance_configs REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Instance::V1::ListInstanceConfigsRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_list_instance_configs_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :get,
                                                              uri_template: "/v1/{parent}/instanceConfigs",
                                                              matches: [
                                                                ["parent", %r{^projects/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the get_instance_config REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Instance::V1::GetInstanceConfigRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_get_instance_config_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :get,
                                                              uri_template: "/v1/{name}",
                                                              matches: [
                                                                ["name", %r{^projects/[^/]+/instanceConfigs/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the create_instance_config REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Instance::V1::CreateInstanceConfigRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_create_instance_config_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :post,
                                                              uri_template: "/v1/{parent}/instanceConfigs",
                                                              body: "*",
                                                              matches: [
                                                                ["parent", %r{^projects/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the update_instance_config REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Instance::V1::UpdateInstanceConfigRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_update_instance_config_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :patch,
                                                              uri_template: "/v1/{instance_config.name}",
                                                              body: "*",
                                                              matches: [
                                                                ["instance_config.name", %r{^projects/[^/]+/instanceConfigs/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the delete_instance_config REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Instance::V1::DeleteInstanceConfigRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_delete_instance_config_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :delete,
                                                              uri_template: "/v1/{name}",
                                                              matches: [
                                                                ["name", %r{^projects/[^/]+/instanceConfigs/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the list_instance_config_operations REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Instance::V1::ListInstanceConfigOperationsRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_list_instance_config_operations_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :get,
                                                              uri_template: "/v1/{parent}/instanceConfigOperations",
                                                              matches: [
                                                                ["parent", %r{^projects/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the list_instances REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancesRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_list_instances_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :get,
                                                              uri_template: "/v1/{parent}/instances",
                                                              matches: [
                                                                ["parent", %r{^projects/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the list_instance_partitions REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancePartitionsRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_list_instance_partitions_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :get,
                                                              uri_template: "/v1/{parent}/instancePartitions",
                                                              matches: [
                                                                ["parent", %r{^projects/[^/]+/instances/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the get_instance REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Instance::V1::GetInstanceRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_get_instance_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :get,
                                                              uri_template: "/v1/{name}",
                                                              matches: [
                                                                ["name", %r{^projects/[^/]+/instances/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the create_instance REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Instance::V1::CreateInstanceRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_create_instance_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :post,
                                                              uri_template: "/v1/{parent}/instances",
                                                              body: "*",
                                                              matches: [
                                                                ["parent", %r{^projects/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the update_instance REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Instance::V1::UpdateInstanceRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_update_instance_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :patch,
                                                              uri_template: "/v1/{instance.name}",
                                                              body: "*",
                                                              matches: [
                                                                ["instance.name", %r{^projects/[^/]+/instances/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the delete_instance REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Instance::V1::DeleteInstanceRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_delete_instance_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :delete,
                                                              uri_template: "/v1/{name}",
                                                              matches: [
                                                                ["name", %r{^projects/[^/]+/instances/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the set_iam_policy REST call
                  #
                  # @param request_pb [::Google::Iam::V1::SetIamPolicyRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_set_iam_policy_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :post,
                                                              uri_template: "/v1/{resource}:setIamPolicy",
                                                              body: "*",
                                                              matches: [
                                                                ["resource", %r{^projects/[^/]+/instances/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the get_iam_policy REST call
                  #
                  # @param request_pb [::Google::Iam::V1::GetIamPolicyRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_get_iam_policy_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :post,
                                                              uri_template: "/v1/{resource}:getIamPolicy",
                                                              body: "*",
                                                              matches: [
                                                                ["resource", %r{^projects/[^/]+/instances/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the test_iam_permissions REST call
                  #
                  # @param request_pb [::Google::Iam::V1::TestIamPermissionsRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_test_iam_permissions_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :post,
                                                              uri_template: "/v1/{resource}:testIamPermissions",
                                                              body: "*",
                                                              matches: [
                                                                ["resource", %r{^projects/[^/]+/instances/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the get_instance_partition REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Instance::V1::GetInstancePartitionRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_get_instance_partition_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :get,
                                                              uri_template: "/v1/{name}",
                                                              matches: [
                                                                ["name", %r{^projects/[^/]+/instances/[^/]+/instancePartitions/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the create_instance_partition REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Instance::V1::CreateInstancePartitionRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_create_instance_partition_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :post,
                                                              uri_template: "/v1/{parent}/instancePartitions",
                                                              body: "*",
                                                              matches: [
                                                                ["parent", %r{^projects/[^/]+/instances/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the delete_instance_partition REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Instance::V1::DeleteInstancePartitionRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_delete_instance_partition_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :delete,
                                                              uri_template: "/v1/{name}",
                                                              matches: [
                                                                ["name", %r{^projects/[^/]+/instances/[^/]+/instancePartitions/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the update_instance_partition REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Instance::V1::UpdateInstancePartitionRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_update_instance_partition_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :patch,
                                                              uri_template: "/v1/{instance_partition.name}",
                                                              body: "*",
                                                              matches: [
                                                                ["instance_partition.name", %r{^projects/[^/]+/instances/[^/]+/instancePartitions/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the list_instance_partition_operations REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancePartitionOperationsRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_list_instance_partition_operations_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :get,
                                                              uri_template: "/v1/{parent}/instancePartitionOperations",
                                                              matches: [
                                                                ["parent", %r{^projects/[^/]+/instances/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the move_instance REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Instance::V1::MoveInstanceRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_move_instance_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :post,
                                                              uri_template: "/v1/{name}:move",
                                                              body: "*",
                                                              matches: [
                                                                ["name", %r{^projects/[^/]+/instances/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
