# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/spanner/admin/instance/v1/spanner_instance_admin_pb"
require "google/cloud/spanner/admin/instance/v1/instance_admin/rest/service_stub"

module Google
  module Cloud
    module Spanner
      module Admin
        module Instance
          module V1
            module InstanceAdmin
              module Rest
                ##
                # REST client for the InstanceAdmin service.
                #
                # Cloud Spanner Instance Admin API
                #
                # The Cloud Spanner Instance Admin API can be used to create, delete,
                # modify and list instances. Instances are dedicated Cloud Spanner serving
                # and storage resources to be used by Cloud Spanner databases.
                #
                # Each instance has a "configuration", which dictates where the
                # serving resources for the Cloud Spanner instance are located (e.g.,
                # US-central, Europe). Configurations are created by Google based on
                # resource availability.
                #
                # Cloud Spanner billing is based on the instances that exist and their
                # sizes. After an instance exists, there are no additional
                # per-database or per-operation charges for use of the instance
                # (though there may be additional network bandwidth charges).
                # Instances offer isolation: problems with databases in one instance
                # will not affect other instances. However, within an instance
                # databases can affect each other. For example, if one database in an
                # instance receives a lot of requests and consumes most of the
                # instance resources, fewer resources are available for other
                # databases in that instance, and their performance may suffer.
                #
                class Client
                  # @private
                  API_VERSION = ""

                  # @private
                  DEFAULT_ENDPOINT_TEMPLATE = "spanner.$UNIVERSE_DOMAIN$"

                  include Paths

                  # @private
                  attr_reader :instance_admin_stub

                  ##
                  # Configure the InstanceAdmin Client class.
                  #
                  # See {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Rest::Client::Configuration}
                  # for a description of the configuration fields.
                  #
                  # @example
                  #
                  #   # Modify the configuration for all InstanceAdmin clients
                  #   ::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Rest::Client.configure do |config|
                  #     config.timeout = 10.0
                  #   end
                  #
                  # @yield [config] Configure the Client client.
                  # @yieldparam config [Client::Configuration]
                  #
                  # @return [Client::Configuration]
                  #
                  def self.configure
                    @configure ||= begin
                      namespace = ["Google", "Cloud", "Spanner", "Admin", "Instance", "V1"]
                      parent_config = while namespace.any?
                                        parent_name = namespace.join "::"
                                        parent_const = const_get parent_name
                                        break parent_const.configure if parent_const.respond_to? :configure
                                        namespace.pop
                                      end
                      default_config = Client::Configuration.new parent_config

                      default_config.rpcs.list_instance_configs.timeout = 3600.0
                      default_config.rpcs.list_instance_configs.retry_policy = {
                        initial_delay: 1.0, max_delay: 32.0, multiplier: 1.3, retry_codes: [14, 4]
                      }

                      default_config.rpcs.get_instance_config.timeout = 3600.0
                      default_config.rpcs.get_instance_config.retry_policy = {
                        initial_delay: 1.0, max_delay: 32.0, multiplier: 1.3, retry_codes: [14, 4]
                      }

                      default_config.rpcs.list_instances.timeout = 3600.0
                      default_config.rpcs.list_instances.retry_policy = {
                        initial_delay: 1.0, max_delay: 32.0, multiplier: 1.3, retry_codes: [14, 4]
                      }

                      default_config.rpcs.get_instance.timeout = 3600.0
                      default_config.rpcs.get_instance.retry_policy = {
                        initial_delay: 1.0, max_delay: 32.0, multiplier: 1.3, retry_codes: [14, 4]
                      }

                      default_config.rpcs.create_instance.timeout = 3600.0

                      default_config.rpcs.update_instance.timeout = 3600.0

                      default_config.rpcs.delete_instance.timeout = 3600.0
                      default_config.rpcs.delete_instance.retry_policy = {
                        initial_delay: 1.0, max_delay: 32.0, multiplier: 1.3, retry_codes: [14, 4]
                      }

                      default_config.rpcs.set_iam_policy.timeout = 30.0

                      default_config.rpcs.get_iam_policy.timeout = 30.0
                      default_config.rpcs.get_iam_policy.retry_policy = {
                        initial_delay: 1.0, max_delay: 32.0, multiplier: 1.3, retry_codes: [14, 4]
                      }

                      default_config.rpcs.test_iam_permissions.timeout = 30.0

                      default_config
                    end
                    yield @configure if block_given?
                    @configure
                  end

                  ##
                  # Configure the InstanceAdmin Client instance.
                  #
                  # The configuration is set to the derived mode, meaning that values can be changed,
                  # but structural changes (adding new fields, etc.) are not allowed. Structural changes
                  # should be made on {Client.configure}.
                  #
                  # See {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Rest::Client::Configuration}
                  # for a description of the configuration fields.
                  #
                  # @yield [config] Configure the Client client.
                  # @yieldparam config [Client::Configuration]
                  #
                  # @return [Client::Configuration]
                  #
                  def configure
                    yield @config if block_given?
                    @config
                  end

                  ##
                  # The effective universe domain
                  #
                  # @return [String]
                  #
                  def universe_domain
                    @instance_admin_stub.universe_domain
                  end

                  ##
                  # Create a new InstanceAdmin REST client object.
                  #
                  # @example
                  #
                  #   # Create a client using the default configuration
                  #   client = ::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Rest::Client.new
                  #
                  #   # Create a client using a custom configuration
                  #   client = ::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Rest::Client.new do |config|
                  #     config.timeout = 10.0
                  #   end
                  #
                  # @yield [config] Configure the InstanceAdmin client.
                  # @yieldparam config [Client::Configuration]
                  #
                  def initialize
                    # Create the configuration object
                    @config = Configuration.new Client.configure

                    # Yield the configuration if needed
                    yield @config if block_given?

                    # Create credentials
                    credentials = @config.credentials
                    # Use self-signed JWT if the endpoint is unchanged from default,
                    # but only if the default endpoint does not have a region prefix.
                    enable_self_signed_jwt = @config.endpoint.nil? ||
                                             (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                             !@config.endpoint.split(".").first.include?("-"))
                    credentials ||= Credentials.default scope: @config.scope,
                                                        enable_self_signed_jwt: enable_self_signed_jwt
                    if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                      credentials = Credentials.new credentials, scope: @config.scope
                    end

                    @quota_project_id = @config.quota_project
                    @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                    @operations_client = ::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Rest::Operations.new do |config|
                      config.credentials = credentials
                      config.quota_project = @quota_project_id
                      config.endpoint = @config.endpoint
                      config.universe_domain = @config.universe_domain
                    end

                    @instance_admin_stub = ::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Rest::ServiceStub.new(
                      endpoint: @config.endpoint,
                      endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                      universe_domain: @config.universe_domain,
                      credentials: credentials,
                      logger: @config.logger
                    )

                    @instance_admin_stub.logger(stub: true)&.info do |entry|
                      entry.set_system_name
                      entry.set_service
                      entry.message = "Created client for #{entry.service}"
                      entry.set_credentials_fields credentials
                      entry.set "customEndpoint", @config.endpoint if @config.endpoint
                      entry.set "defaultTimeout", @config.timeout if @config.timeout
                      entry.set "quotaProject", @quota_project_id if @quota_project_id
                    end
                  end

                  ##
                  # Get the associated client for long-running operations.
                  #
                  # @return [::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Rest::Operations]
                  #
                  attr_reader :operations_client

                  ##
                  # The logger used for request/response debug logging.
                  #
                  # @return [Logger]
                  #
                  def logger
                    @instance_admin_stub.logger
                  end

                  # Service calls

                  ##
                  # Lists the supported instance configurations for a given project.
                  #
                  # Returns both Google-managed configurations and user-managed
                  # configurations.
                  #
                  # @overload list_instance_configs(request, options = nil)
                  #   Pass arguments to `list_instance_configs` via a request object, either of type
                  #   {::Google::Cloud::Spanner::Admin::Instance::V1::ListInstanceConfigsRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Spanner::Admin::Instance::V1::ListInstanceConfigsRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload list_instance_configs(parent: nil, page_size: nil, page_token: nil)
                  #   Pass arguments to `list_instance_configs` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param parent [::String]
                  #     Required. The name of the project for which a list of supported instance
                  #     configurations is requested. Values are of the form
                  #     `projects/<project>`.
                  #   @param page_size [::Integer]
                  #     Number of instance configurations to be returned in the response. If 0 or
                  #     less, defaults to the server's maximum allowed page size.
                  #   @param page_token [::String]
                  #     If non-empty, `page_token` should contain a
                  #     {::Google::Cloud::Spanner::Admin::Instance::V1::ListInstanceConfigsResponse#next_page_token next_page_token}
                  #     from a previous
                  #     {::Google::Cloud::Spanner::Admin::Instance::V1::ListInstanceConfigsResponse ListInstanceConfigsResponse}.
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Spanner::Admin::Instance::V1::InstanceConfig>]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Spanner::Admin::Instance::V1::InstanceConfig>]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/instance/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Spanner::Admin::Instance::V1::ListInstanceConfigsRequest.new
                  #
                  #   # Call the list_instance_configs method.
                  #   result = client.list_instance_configs request
                  #
                  #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
                  #   # over elements, and API calls will be issued to fetch pages as needed.
                  #   result.each do |item|
                  #     # Each element is of type ::Google::Cloud::Spanner::Admin::Instance::V1::InstanceConfig.
                  #     p item
                  #   end
                  #
                  def list_instance_configs request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::Admin::Instance::V1::ListInstanceConfigsRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.list_instance_configs.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Instance::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.list_instance_configs.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.list_instance_configs.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @instance_admin_stub.list_instance_configs request, options do |result, operation|
                      result = ::Gapic::Rest::PagedEnumerable.new @instance_admin_stub, :list_instance_configs, "instance_configs", request, result, options
                      yield result, operation if block_given?
                      throw :response, result
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Gets information about a particular instance configuration.
                  #
                  # @overload get_instance_config(request, options = nil)
                  #   Pass arguments to `get_instance_config` via a request object, either of type
                  #   {::Google::Cloud::Spanner::Admin::Instance::V1::GetInstanceConfigRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Spanner::Admin::Instance::V1::GetInstanceConfigRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload get_instance_config(name: nil)
                  #   Pass arguments to `get_instance_config` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param name [::String]
                  #     Required. The name of the requested instance configuration. Values are of
                  #     the form `projects/<project>/instanceConfigs/<config>`.
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Spanner::Admin::Instance::V1::InstanceConfig]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Spanner::Admin::Instance::V1::InstanceConfig]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/instance/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Spanner::Admin::Instance::V1::GetInstanceConfigRequest.new
                  #
                  #   # Call the get_instance_config method.
                  #   result = client.get_instance_config request
                  #
                  #   # The returned object is of type Google::Cloud::Spanner::Admin::Instance::V1::InstanceConfig.
                  #   p result
                  #
                  def get_instance_config request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::Admin::Instance::V1::GetInstanceConfigRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.get_instance_config.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Instance::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.get_instance_config.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.get_instance_config.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @instance_admin_stub.get_instance_config request, options do |result, operation|
                      yield result, operation if block_given?
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Creates an instance configuration and begins preparing it to be used. The
                  # returned long-running operation
                  # can be used to track the progress of preparing the new
                  # instance configuration. The instance configuration name is assigned by the
                  # caller. If the named instance configuration already exists,
                  # `CreateInstanceConfig` returns `ALREADY_EXISTS`.
                  #
                  # Immediately after the request returns:
                  #
                  #   * The instance configuration is readable via the API, with all requested
                  #     attributes. The instance configuration's
                  #     {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceConfig#reconciling reconciling}
                  #     field is set to true. Its state is `CREATING`.
                  #
                  # While the operation is pending:
                  #
                  #   * Cancelling the operation renders the instance configuration immediately
                  #     unreadable via the API.
                  #   * Except for deleting the creating resource, all other attempts to modify
                  #     the instance configuration are rejected.
                  #
                  # Upon completion of the returned operation:
                  #
                  #   * Instances can be created using the instance configuration.
                  #   * The instance configuration's
                  #   {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceConfig#reconciling reconciling}
                  #   field becomes false. Its state becomes `READY`.
                  #
                  # The returned long-running operation will
                  # have a name of the format
                  # `<instance_config_name>/operations/<operation_id>` and can be used to track
                  # creation of the instance configuration. The
                  # metadata field type is
                  # {::Google::Cloud::Spanner::Admin::Instance::V1::CreateInstanceConfigMetadata CreateInstanceConfigMetadata}.
                  # The response field type is
                  # {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceConfig InstanceConfig}, if
                  # successful.
                  #
                  # Authorization requires `spanner.instanceConfigs.create` permission on
                  # the resource
                  # {::Google::Cloud::Spanner::Admin::Instance::V1::CreateInstanceConfigRequest#parent parent}.
                  #
                  # @overload create_instance_config(request, options = nil)
                  #   Pass arguments to `create_instance_config` via a request object, either of type
                  #   {::Google::Cloud::Spanner::Admin::Instance::V1::CreateInstanceConfigRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Spanner::Admin::Instance::V1::CreateInstanceConfigRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload create_instance_config(parent: nil, instance_config_id: nil, instance_config: nil, validate_only: nil)
                  #   Pass arguments to `create_instance_config` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param parent [::String]
                  #     Required. The name of the project in which to create the instance
                  #     configuration. Values are of the form `projects/<project>`.
                  #   @param instance_config_id [::String]
                  #     Required. The ID of the instance configuration to create. Valid identifiers
                  #     are of the form `custom-[-a-z0-9]*[a-z0-9]` and must be between 2 and 64
                  #     characters in length. The `custom-` prefix is required to avoid name
                  #     conflicts with Google-managed configurations.
                  #   @param instance_config [::Google::Cloud::Spanner::Admin::Instance::V1::InstanceConfig, ::Hash]
                  #     Required. The `InstanceConfig` proto of the configuration to create.
                  #     `instance_config.name` must be
                  #     `<parent>/instanceConfigs/<instance_config_id>`.
                  #     `instance_config.base_config` must be a Google-managed configuration name,
                  #     e.g. <parent>/instanceConfigs/us-east1, <parent>/instanceConfigs/nam3.
                  #   @param validate_only [::Boolean]
                  #     An option to validate, but not actually execute, a request,
                  #     and provide the same response.
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Gapic::Operation]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Gapic::Operation]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/instance/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Spanner::Admin::Instance::V1::CreateInstanceConfigRequest.new
                  #
                  #   # Call the create_instance_config method.
                  #   result = client.create_instance_config request
                  #
                  #   # The returned object is of type Gapic::Operation. You can use it to
                  #   # check the status of an operation, cancel it, or wait for results.
                  #   # Here is how to wait for a response.
                  #   result.wait_until_done! timeout: 60
                  #   if result.response?
                  #     p result.response
                  #   else
                  #     puts "No response received."
                  #   end
                  #
                  def create_instance_config request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::Admin::Instance::V1::CreateInstanceConfigRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.create_instance_config.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Instance::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.create_instance_config.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.create_instance_config.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @instance_admin_stub.create_instance_config request, options do |result, operation|
                      result = ::Gapic::Operation.new result, @operations_client, options: options
                      yield result, operation if block_given?
                      throw :response, result
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Updates an instance configuration. The returned
                  # long-running operation can be used to track
                  # the progress of updating the instance. If the named instance configuration
                  # does not exist, returns `NOT_FOUND`.
                  #
                  # Only user-managed configurations can be updated.
                  #
                  # Immediately after the request returns:
                  #
                  #   * The instance configuration's
                  #     {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceConfig#reconciling reconciling}
                  #     field is set to true.
                  #
                  # While the operation is pending:
                  #
                  #   * Cancelling the operation sets its metadata's
                  #     {::Google::Cloud::Spanner::Admin::Instance::V1::UpdateInstanceConfigMetadata#cancel_time cancel_time}.
                  #     The operation is guaranteed to succeed at undoing all changes, after
                  #     which point it terminates with a `CANCELLED` status.
                  #   * All other attempts to modify the instance configuration are rejected.
                  #   * Reading the instance configuration via the API continues to give the
                  #     pre-request values.
                  #
                  # Upon completion of the returned operation:
                  #
                  #   * Creating instances using the instance configuration uses the new
                  #     values.
                  #   * The new values of the instance configuration are readable via the API.
                  #   * The instance configuration's
                  #   {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceConfig#reconciling reconciling}
                  #   field becomes false.
                  #
                  # The returned long-running operation will
                  # have a name of the format
                  # `<instance_config_name>/operations/<operation_id>` and can be used to track
                  # the instance configuration modification.  The
                  # metadata field type is
                  # {::Google::Cloud::Spanner::Admin::Instance::V1::UpdateInstanceConfigMetadata UpdateInstanceConfigMetadata}.
                  # The response field type is
                  # {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceConfig InstanceConfig}, if
                  # successful.
                  #
                  # Authorization requires `spanner.instanceConfigs.update` permission on
                  # the resource {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceConfig#name name}.
                  #
                  # @overload update_instance_config(request, options = nil)
                  #   Pass arguments to `update_instance_config` via a request object, either of type
                  #   {::Google::Cloud::Spanner::Admin::Instance::V1::UpdateInstanceConfigRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Spanner::Admin::Instance::V1::UpdateInstanceConfigRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload update_instance_config(instance_config: nil, update_mask: nil, validate_only: nil)
                  #   Pass arguments to `update_instance_config` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param instance_config [::Google::Cloud::Spanner::Admin::Instance::V1::InstanceConfig, ::Hash]
                  #     Required. The user instance configuration to update, which must always
                  #     include the instance configuration name. Otherwise, only fields mentioned
                  #     in
                  #     {::Google::Cloud::Spanner::Admin::Instance::V1::UpdateInstanceConfigRequest#update_mask update_mask}
                  #     need be included. To prevent conflicts of concurrent updates,
                  #     {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceConfig#reconciling etag} can
                  #     be used.
                  #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
                  #     Required. A mask specifying which fields in
                  #     {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceConfig InstanceConfig} should be
                  #     updated. The field mask must always be specified; this prevents any future
                  #     fields in {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceConfig InstanceConfig}
                  #     from being erased accidentally by clients that do not know about them. Only
                  #     display_name and labels can be updated.
                  #   @param validate_only [::Boolean]
                  #     An option to validate, but not actually execute, a request,
                  #     and provide the same response.
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Gapic::Operation]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Gapic::Operation]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/instance/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Spanner::Admin::Instance::V1::UpdateInstanceConfigRequest.new
                  #
                  #   # Call the update_instance_config method.
                  #   result = client.update_instance_config request
                  #
                  #   # The returned object is of type Gapic::Operation. You can use it to
                  #   # check the status of an operation, cancel it, or wait for results.
                  #   # Here is how to wait for a response.
                  #   result.wait_until_done! timeout: 60
                  #   if result.response?
                  #     p result.response
                  #   else
                  #     puts "No response received."
                  #   end
                  #
                  def update_instance_config request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::Admin::Instance::V1::UpdateInstanceConfigRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.update_instance_config.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Instance::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.update_instance_config.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.update_instance_config.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @instance_admin_stub.update_instance_config request, options do |result, operation|
                      result = ::Gapic::Operation.new result, @operations_client, options: options
                      yield result, operation if block_given?
                      throw :response, result
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Deletes the instance configuration. Deletion is only allowed when no
                  # instances are using the configuration. If any instances are using
                  # the configuration, returns `FAILED_PRECONDITION`.
                  #
                  # Only user-managed configurations can be deleted.
                  #
                  # Authorization requires `spanner.instanceConfigs.delete` permission on
                  # the resource {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceConfig#name name}.
                  #
                  # @overload delete_instance_config(request, options = nil)
                  #   Pass arguments to `delete_instance_config` via a request object, either of type
                  #   {::Google::Cloud::Spanner::Admin::Instance::V1::DeleteInstanceConfigRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Spanner::Admin::Instance::V1::DeleteInstanceConfigRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload delete_instance_config(name: nil, etag: nil, validate_only: nil)
                  #   Pass arguments to `delete_instance_config` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param name [::String]
                  #     Required. The name of the instance configuration to be deleted.
                  #     Values are of the form
                  #     `projects/<project>/instanceConfigs/<instance_config>`
                  #   @param etag [::String]
                  #     Used for optimistic concurrency control as a way to help prevent
                  #     simultaneous deletes of an instance configuration from overwriting each
                  #     other. If not empty, the API
                  #     only deletes the instance configuration when the etag provided matches the
                  #     current status of the requested instance configuration. Otherwise, deletes
                  #     the instance configuration without checking the current status of the
                  #     requested instance configuration.
                  #   @param validate_only [::Boolean]
                  #     An option to validate, but not actually execute, a request,
                  #     and provide the same response.
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Protobuf::Empty]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Protobuf::Empty]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/instance/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Spanner::Admin::Instance::V1::DeleteInstanceConfigRequest.new
                  #
                  #   # Call the delete_instance_config method.
                  #   result = client.delete_instance_config request
                  #
                  #   # The returned object is of type Google::Protobuf::Empty.
                  #   p result
                  #
                  def delete_instance_config request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::Admin::Instance::V1::DeleteInstanceConfigRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.delete_instance_config.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Instance::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.delete_instance_config.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.delete_instance_config.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @instance_admin_stub.delete_instance_config request, options do |result, operation|
                      yield result, operation if block_given?
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Lists the user-managed instance configuration long-running
                  # operations in the given project. An instance
                  # configuration operation has a name of the form
                  # `projects/<project>/instanceConfigs/<instance_config>/operations/<operation>`.
                  # The long-running operation
                  # metadata field type
                  # `metadata.type_url` describes the type of the metadata. Operations returned
                  # include those that have completed/failed/canceled within the last 7 days,
                  # and pending operations. Operations returned are ordered by
                  # `operation.metadata.value.start_time` in descending order starting
                  # from the most recently started operation.
                  #
                  # @overload list_instance_config_operations(request, options = nil)
                  #   Pass arguments to `list_instance_config_operations` via a request object, either of type
                  #   {::Google::Cloud::Spanner::Admin::Instance::V1::ListInstanceConfigOperationsRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Spanner::Admin::Instance::V1::ListInstanceConfigOperationsRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload list_instance_config_operations(parent: nil, filter: nil, page_size: nil, page_token: nil)
                  #   Pass arguments to `list_instance_config_operations` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param parent [::String]
                  #     Required. The project of the instance configuration operations.
                  #     Values are of the form `projects/<project>`.
                  #   @param filter [::String]
                  #     An expression that filters the list of returned operations.
                  #
                  #     A filter expression consists of a field name, a
                  #     comparison operator, and a value for filtering.
                  #     The value must be a string, a number, or a boolean. The comparison operator
                  #     must be one of: `<`, `>`, `<=`, `>=`, `!=`, `=`, or `:`.
                  #     Colon `:` is the contains operator. Filter rules are not case sensitive.
                  #
                  #     The following fields in the Operation are eligible for filtering:
                  #
                  #       * `name` - The name of the long-running operation
                  #       * `done` - False if the operation is in progress, else true.
                  #       * `metadata.@type` - the type of metadata. For example, the type string
                  #          for
                  #          {::Google::Cloud::Spanner::Admin::Instance::V1::CreateInstanceConfigMetadata CreateInstanceConfigMetadata}
                  #          is
                  #          `type.googleapis.com/google.spanner.admin.instance.v1.CreateInstanceConfigMetadata`.
                  #       * `metadata.<field_name>` - any field in metadata.value.
                  #          `metadata.@type` must be specified first, if filtering on metadata
                  #          fields.
                  #       * `error` - Error associated with the long-running operation.
                  #       * `response.@type` - the type of response.
                  #       * `response.<field_name>` - any field in response.value.
                  #
                  #     You can combine multiple expressions by enclosing each expression in
                  #     parentheses. By default, expressions are combined with AND logic. However,
                  #     you can specify AND, OR, and NOT logic explicitly.
                  #
                  #     Here are a few examples:
                  #
                  #       * `done:true` - The operation is complete.
                  #       * `(metadata.@type=` \
                  #         `type.googleapis.com/google.spanner.admin.instance.v1.CreateInstanceConfigMetadata)
                  #         AND` \
                  #         `(metadata.instance_config.name:custom-config) AND` \
                  #         `(metadata.progress.start_time < \"2021-03-28T14:50:00Z\") AND` \
                  #         `(error:*)` - Return operations where:
                  #         * The operation's metadata type is
                  #         {::Google::Cloud::Spanner::Admin::Instance::V1::CreateInstanceConfigMetadata CreateInstanceConfigMetadata}.
                  #         * The instance configuration name contains "custom-config".
                  #         * The operation started before 2021-03-28T14:50:00Z.
                  #         * The operation resulted in an error.
                  #   @param page_size [::Integer]
                  #     Number of operations to be returned in the response. If 0 or
                  #     less, defaults to the server's maximum allowed page size.
                  #   @param page_token [::String]
                  #     If non-empty, `page_token` should contain a
                  #     {::Google::Cloud::Spanner::Admin::Instance::V1::ListInstanceConfigOperationsResponse#next_page_token next_page_token}
                  #     from a previous
                  #     {::Google::Cloud::Spanner::Admin::Instance::V1::ListInstanceConfigOperationsResponse ListInstanceConfigOperationsResponse}
                  #     to the same `parent` and with the same `filter`.
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Gapic::Operation]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Gapic::Operation]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/instance/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Spanner::Admin::Instance::V1::ListInstanceConfigOperationsRequest.new
                  #
                  #   # Call the list_instance_config_operations method.
                  #   result = client.list_instance_config_operations request
                  #
                  #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
                  #   # over elements, and API calls will be issued to fetch pages as needed.
                  #   result.each do |item|
                  #     # Each element is of type ::Google::Longrunning::Operation.
                  #     p item
                  #   end
                  #
                  def list_instance_config_operations request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::Admin::Instance::V1::ListInstanceConfigOperationsRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.list_instance_config_operations.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Instance::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.list_instance_config_operations.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.list_instance_config_operations.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @instance_admin_stub.list_instance_config_operations request, options do |result, operation|
                      result = ::Gapic::Rest::PagedEnumerable.new @instance_admin_stub, :list_instance_config_operations, "operations", request, result, options
                      yield result, operation if block_given?
                      throw :response, result
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Lists all instances in the given project.
                  #
                  # @overload list_instances(request, options = nil)
                  #   Pass arguments to `list_instances` via a request object, either of type
                  #   {::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancesRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancesRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload list_instances(parent: nil, page_size: nil, page_token: nil, filter: nil, instance_deadline: nil)
                  #   Pass arguments to `list_instances` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param parent [::String]
                  #     Required. The name of the project for which a list of instances is
                  #     requested. Values are of the form `projects/<project>`.
                  #   @param page_size [::Integer]
                  #     Number of instances to be returned in the response. If 0 or less, defaults
                  #     to the server's maximum allowed page size.
                  #   @param page_token [::String]
                  #     If non-empty, `page_token` should contain a
                  #     {::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancesResponse#next_page_token next_page_token}
                  #     from a previous
                  #     {::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancesResponse ListInstancesResponse}.
                  #   @param filter [::String]
                  #     An expression for filtering the results of the request. Filter rules are
                  #     case insensitive. The fields eligible for filtering are:
                  #
                  #       * `name`
                  #       * `display_name`
                  #       * `labels.key` where key is the name of a label
                  #
                  #     Some examples of using filters are:
                  #
                  #       * `name:*` --> The instance has a name.
                  #       * `name:Howl` --> The instance's name contains the string "howl".
                  #       * `name:HOWL` --> Equivalent to above.
                  #       * `NAME:howl` --> Equivalent to above.
                  #       * `labels.env:*` --> The instance has the label "env".
                  #       * `labels.env:dev` --> The instance has the label "env" and the value of
                  #                            the label contains the string "dev".
                  #       * `name:howl labels.env:dev` --> The instance's name contains "howl" and
                  #                                      it has the label "env" with its value
                  #                                      containing "dev".
                  #   @param instance_deadline [::Google::Protobuf::Timestamp, ::Hash]
                  #     Deadline used while retrieving metadata for instances.
                  #     Instances whose metadata cannot be retrieved within this deadline will be
                  #     added to
                  #     {::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancesResponse#unreachable unreachable}
                  #     in
                  #     {::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancesResponse ListInstancesResponse}.
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Spanner::Admin::Instance::V1::Instance>]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Spanner::Admin::Instance::V1::Instance>]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/instance/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Spanner::Admin::Instance::V1::ListInstancesRequest.new
                  #
                  #   # Call the list_instances method.
                  #   result = client.list_instances request
                  #
                  #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
                  #   # over elements, and API calls will be issued to fetch pages as needed.
                  #   result.each do |item|
                  #     # Each element is of type ::Google::Cloud::Spanner::Admin::Instance::V1::Instance.
                  #     p item
                  #   end
                  #
                  def list_instances request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancesRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.list_instances.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Instance::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.list_instances.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.list_instances.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @instance_admin_stub.list_instances request, options do |result, operation|
                      result = ::Gapic::Rest::PagedEnumerable.new @instance_admin_stub, :list_instances, "instances", request, result, options
                      yield result, operation if block_given?
                      throw :response, result
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Lists all instance partitions for the given instance.
                  #
                  # @overload list_instance_partitions(request, options = nil)
                  #   Pass arguments to `list_instance_partitions` via a request object, either of type
                  #   {::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancePartitionsRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancePartitionsRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload list_instance_partitions(parent: nil, page_size: nil, page_token: nil, instance_partition_deadline: nil)
                  #   Pass arguments to `list_instance_partitions` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param parent [::String]
                  #     Required. The instance whose instance partitions should be listed. Values
                  #     are of the form `projects/<project>/instances/<instance>`. Use `{instance}
                  #     = '-'` to list instance partitions for all Instances in a project, e.g.,
                  #     `projects/myproject/instances/-`.
                  #   @param page_size [::Integer]
                  #     Number of instance partitions to be returned in the response. If 0 or less,
                  #     defaults to the server's maximum allowed page size.
                  #   @param page_token [::String]
                  #     If non-empty, `page_token` should contain a
                  #     {::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancePartitionsResponse#next_page_token next_page_token}
                  #     from a previous
                  #     {::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancePartitionsResponse ListInstancePartitionsResponse}.
                  #   @param instance_partition_deadline [::Google::Protobuf::Timestamp, ::Hash]
                  #     Optional. Deadline used while retrieving metadata for instance partitions.
                  #     Instance partitions whose metadata cannot be retrieved within this deadline
                  #     will be added to
                  #     {::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancePartitionsResponse#unreachable unreachable}
                  #     in
                  #     {::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancePartitionsResponse ListInstancePartitionsResponse}.
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Spanner::Admin::Instance::V1::InstancePartition>]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Spanner::Admin::Instance::V1::InstancePartition>]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/instance/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Spanner::Admin::Instance::V1::ListInstancePartitionsRequest.new
                  #
                  #   # Call the list_instance_partitions method.
                  #   result = client.list_instance_partitions request
                  #
                  #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
                  #   # over elements, and API calls will be issued to fetch pages as needed.
                  #   result.each do |item|
                  #     # Each element is of type ::Google::Cloud::Spanner::Admin::Instance::V1::InstancePartition.
                  #     p item
                  #   end
                  #
                  def list_instance_partitions request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancePartitionsRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.list_instance_partitions.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Instance::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.list_instance_partitions.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.list_instance_partitions.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @instance_admin_stub.list_instance_partitions request, options do |result, operation|
                      result = ::Gapic::Rest::PagedEnumerable.new @instance_admin_stub, :list_instance_partitions, "instance_partitions", request, result, options
                      yield result, operation if block_given?
                      throw :response, result
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Gets information about a particular instance.
                  #
                  # @overload get_instance(request, options = nil)
                  #   Pass arguments to `get_instance` via a request object, either of type
                  #   {::Google::Cloud::Spanner::Admin::Instance::V1::GetInstanceRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Spanner::Admin::Instance::V1::GetInstanceRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload get_instance(name: nil, field_mask: nil)
                  #   Pass arguments to `get_instance` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param name [::String]
                  #     Required. The name of the requested instance. Values are of the form
                  #     `projects/<project>/instances/<instance>`.
                  #   @param field_mask [::Google::Protobuf::FieldMask, ::Hash]
                  #     If field_mask is present, specifies the subset of
                  #     {::Google::Cloud::Spanner::Admin::Instance::V1::Instance Instance} fields that should be
                  #     returned. If absent, all
                  #     {::Google::Cloud::Spanner::Admin::Instance::V1::Instance Instance} fields are returned.
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Spanner::Admin::Instance::V1::Instance]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Spanner::Admin::Instance::V1::Instance]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/instance/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Spanner::Admin::Instance::V1::GetInstanceRequest.new
                  #
                  #   # Call the get_instance method.
                  #   result = client.get_instance request
                  #
                  #   # The returned object is of type Google::Cloud::Spanner::Admin::Instance::V1::Instance.
                  #   p result
                  #
                  def get_instance request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::Admin::Instance::V1::GetInstanceRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.get_instance.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Instance::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.get_instance.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.get_instance.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @instance_admin_stub.get_instance request, options do |result, operation|
                      yield result, operation if block_given?
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Creates an instance and begins preparing it to begin serving. The
                  # returned long-running operation
                  # can be used to track the progress of preparing the new
                  # instance. The instance name is assigned by the caller. If the
                  # named instance already exists, `CreateInstance` returns
                  # `ALREADY_EXISTS`.
                  #
                  # Immediately upon completion of this request:
                  #
                  #   * The instance is readable via the API, with all requested attributes
                  #     but no allocated resources. Its state is `CREATING`.
                  #
                  # Until completion of the returned operation:
                  #
                  #   * Cancelling the operation renders the instance immediately unreadable
                  #     via the API.
                  #   * The instance can be deleted.
                  #   * All other attempts to modify the instance are rejected.
                  #
                  # Upon completion of the returned operation:
                  #
                  #   * Billing for all successfully-allocated resources begins (some types
                  #     may have lower than the requested levels).
                  #   * Databases can be created in the instance.
                  #   * The instance's allocated resource levels are readable via the API.
                  #   * The instance's state becomes `READY`.
                  #
                  # The returned long-running operation will
                  # have a name of the format `<instance_name>/operations/<operation_id>` and
                  # can be used to track creation of the instance.  The
                  # metadata field type is
                  # {::Google::Cloud::Spanner::Admin::Instance::V1::CreateInstanceMetadata CreateInstanceMetadata}.
                  # The response field type is
                  # {::Google::Cloud::Spanner::Admin::Instance::V1::Instance Instance}, if successful.
                  #
                  # @overload create_instance(request, options = nil)
                  #   Pass arguments to `create_instance` via a request object, either of type
                  #   {::Google::Cloud::Spanner::Admin::Instance::V1::CreateInstanceRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Spanner::Admin::Instance::V1::CreateInstanceRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload create_instance(parent: nil, instance_id: nil, instance: nil)
                  #   Pass arguments to `create_instance` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param parent [::String]
                  #     Required. The name of the project in which to create the instance. Values
                  #     are of the form `projects/<project>`.
                  #   @param instance_id [::String]
                  #     Required. The ID of the instance to create.  Valid identifiers are of the
                  #     form `[a-z][-a-z0-9]*[a-z0-9]` and must be between 2 and 64 characters in
                  #     length.
                  #   @param instance [::Google::Cloud::Spanner::Admin::Instance::V1::Instance, ::Hash]
                  #     Required. The instance to create.  The name may be omitted, but if
                  #     specified must be `<parent>/instances/<instance_id>`.
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Gapic::Operation]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Gapic::Operation]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/instance/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Spanner::Admin::Instance::V1::CreateInstanceRequest.new
                  #
                  #   # Call the create_instance method.
                  #   result = client.create_instance request
                  #
                  #   # The returned object is of type Gapic::Operation. You can use it to
                  #   # check the status of an operation, cancel it, or wait for results.
                  #   # Here is how to wait for a response.
                  #   result.wait_until_done! timeout: 60
                  #   if result.response?
                  #     p result.response
                  #   else
                  #     puts "No response received."
                  #   end
                  #
                  def create_instance request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::Admin::Instance::V1::CreateInstanceRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.create_instance.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Instance::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.create_instance.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.create_instance.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @instance_admin_stub.create_instance request, options do |result, operation|
                      result = ::Gapic::Operation.new result, @operations_client, options: options
                      yield result, operation if block_given?
                      throw :response, result
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Updates an instance, and begins allocating or releasing resources
                  # as requested. The returned long-running operation can be used to track the
                  # progress of updating the instance. If the named instance does not
                  # exist, returns `NOT_FOUND`.
                  #
                  # Immediately upon completion of this request:
                  #
                  #   * For resource types for which a decrease in the instance's allocation
                  #     has been requested, billing is based on the newly-requested level.
                  #
                  # Until completion of the returned operation:
                  #
                  #   * Cancelling the operation sets its metadata's
                  #     {::Google::Cloud::Spanner::Admin::Instance::V1::UpdateInstanceMetadata#cancel_time cancel_time},
                  #     and begins restoring resources to their pre-request values. The
                  #     operation is guaranteed to succeed at undoing all resource changes,
                  #     after which point it terminates with a `CANCELLED` status.
                  #   * All other attempts to modify the instance are rejected.
                  #   * Reading the instance via the API continues to give the pre-request
                  #     resource levels.
                  #
                  # Upon completion of the returned operation:
                  #
                  #   * Billing begins for all successfully-allocated resources (some types
                  #     may have lower than the requested levels).
                  #   * All newly-reserved resources are available for serving the instance's
                  #     tables.
                  #   * The instance's new resource levels are readable via the API.
                  #
                  # The returned long-running operation will
                  # have a name of the format `<instance_name>/operations/<operation_id>` and
                  # can be used to track the instance modification.  The
                  # metadata field type is
                  # {::Google::Cloud::Spanner::Admin::Instance::V1::UpdateInstanceMetadata UpdateInstanceMetadata}.
                  # The response field type is
                  # {::Google::Cloud::Spanner::Admin::Instance::V1::Instance Instance}, if successful.
                  #
                  # Authorization requires `spanner.instances.update` permission on
                  # the resource {::Google::Cloud::Spanner::Admin::Instance::V1::Instance#name name}.
                  #
                  # @overload update_instance(request, options = nil)
                  #   Pass arguments to `update_instance` via a request object, either of type
                  #   {::Google::Cloud::Spanner::Admin::Instance::V1::UpdateInstanceRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Spanner::Admin::Instance::V1::UpdateInstanceRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload update_instance(instance: nil, field_mask: nil)
                  #   Pass arguments to `update_instance` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param instance [::Google::Cloud::Spanner::Admin::Instance::V1::Instance, ::Hash]
                  #     Required. The instance to update, which must always include the instance
                  #     name.  Otherwise, only fields mentioned in
                  #     {::Google::Cloud::Spanner::Admin::Instance::V1::UpdateInstanceRequest#field_mask field_mask}
                  #     need be included.
                  #   @param field_mask [::Google::Protobuf::FieldMask, ::Hash]
                  #     Required. A mask specifying which fields in
                  #     {::Google::Cloud::Spanner::Admin::Instance::V1::Instance Instance} should be updated.
                  #     The field mask must always be specified; this prevents any future fields in
                  #     {::Google::Cloud::Spanner::Admin::Instance::V1::Instance Instance} from being erased
                  #     accidentally by clients that do not know about them.
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Gapic::Operation]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Gapic::Operation]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/instance/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Spanner::Admin::Instance::V1::UpdateInstanceRequest.new
                  #
                  #   # Call the update_instance method.
                  #   result = client.update_instance request
                  #
                  #   # The returned object is of type Gapic::Operation. You can use it to
                  #   # check the status of an operation, cancel it, or wait for results.
                  #   # Here is how to wait for a response.
                  #   result.wait_until_done! timeout: 60
                  #   if result.response?
                  #     p result.response
                  #   else
                  #     puts "No response received."
                  #   end
                  #
                  def update_instance request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::Admin::Instance::V1::UpdateInstanceRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.update_instance.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Instance::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.update_instance.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.update_instance.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @instance_admin_stub.update_instance request, options do |result, operation|
                      result = ::Gapic::Operation.new result, @operations_client, options: options
                      yield result, operation if block_given?
                      throw :response, result
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Deletes an instance.
                  #
                  # Immediately upon completion of the request:
                  #
                  #   * Billing ceases for all of the instance's reserved resources.
                  #
                  # Soon afterward:
                  #
                  #   * The instance and *all of its databases* immediately and
                  #     irrevocably disappear from the API. All data in the databases
                  #     is permanently deleted.
                  #
                  # @overload delete_instance(request, options = nil)
                  #   Pass arguments to `delete_instance` via a request object, either of type
                  #   {::Google::Cloud::Spanner::Admin::Instance::V1::DeleteInstanceRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Spanner::Admin::Instance::V1::DeleteInstanceRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload delete_instance(name: nil)
                  #   Pass arguments to `delete_instance` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param name [::String]
                  #     Required. The name of the instance to be deleted. Values are of the form
                  #     `projects/<project>/instances/<instance>`
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Protobuf::Empty]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Protobuf::Empty]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/instance/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Spanner::Admin::Instance::V1::DeleteInstanceRequest.new
                  #
                  #   # Call the delete_instance method.
                  #   result = client.delete_instance request
                  #
                  #   # The returned object is of type Google::Protobuf::Empty.
                  #   p result
                  #
                  def delete_instance request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::Admin::Instance::V1::DeleteInstanceRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.delete_instance.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Instance::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.delete_instance.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.delete_instance.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @instance_admin_stub.delete_instance request, options do |result, operation|
                      yield result, operation if block_given?
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Sets the access control policy on an instance resource. Replaces any
                  # existing policy.
                  #
                  # Authorization requires `spanner.instances.setIamPolicy` on
                  # [resource][google.iam.v1.SetIamPolicyRequest.resource].
                  #
                  # @overload set_iam_policy(request, options = nil)
                  #   Pass arguments to `set_iam_policy` via a request object, either of type
                  #   {::Google::Iam::V1::SetIamPolicyRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Iam::V1::SetIamPolicyRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload set_iam_policy(resource: nil, policy: nil, update_mask: nil)
                  #   Pass arguments to `set_iam_policy` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param resource [::String]
                  #     REQUIRED: The resource for which the policy is being specified.
                  #     See the operation documentation for the appropriate value for this field.
                  #   @param policy [::Google::Iam::V1::Policy, ::Hash]
                  #     REQUIRED: The complete policy to be applied to the `resource`. The size of
                  #     the policy is limited to a few 10s of KB. An empty policy is a
                  #     valid policy but certain Cloud Platform services (such as Projects)
                  #     might reject them.
                  #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
                  #     OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
                  #     the fields in the mask will be modified. If no mask is provided, the
                  #     following default mask is used:
                  #
                  #     `paths: "bindings, etag"`
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Iam::V1::Policy]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Iam::V1::Policy]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/instance/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Iam::V1::SetIamPolicyRequest.new
                  #
                  #   # Call the set_iam_policy method.
                  #   result = client.set_iam_policy request
                  #
                  #   # The returned object is of type Google::Iam::V1::Policy.
                  #   p result
                  #
                  def set_iam_policy request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::SetIamPolicyRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.set_iam_policy.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Instance::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.set_iam_policy.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.set_iam_policy.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @instance_admin_stub.set_iam_policy request, options do |result, operation|
                      yield result, operation if block_given?
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Gets the access control policy for an instance resource. Returns an empty
                  # policy if an instance exists but does not have a policy set.
                  #
                  # Authorization requires `spanner.instances.getIamPolicy` on
                  # [resource][google.iam.v1.GetIamPolicyRequest.resource].
                  #
                  # @overload get_iam_policy(request, options = nil)
                  #   Pass arguments to `get_iam_policy` via a request object, either of type
                  #   {::Google::Iam::V1::GetIamPolicyRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Iam::V1::GetIamPolicyRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload get_iam_policy(resource: nil, options: nil)
                  #   Pass arguments to `get_iam_policy` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param resource [::String]
                  #     REQUIRED: The resource for which the policy is being requested.
                  #     See the operation documentation for the appropriate value for this field.
                  #   @param options [::Google::Iam::V1::GetPolicyOptions, ::Hash]
                  #     OPTIONAL: A `GetPolicyOptions` object for specifying options to
                  #     `GetIamPolicy`.
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Iam::V1::Policy]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Iam::V1::Policy]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/instance/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Iam::V1::GetIamPolicyRequest.new
                  #
                  #   # Call the get_iam_policy method.
                  #   result = client.get_iam_policy request
                  #
                  #   # The returned object is of type Google::Iam::V1::Policy.
                  #   p result
                  #
                  def get_iam_policy request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::GetIamPolicyRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.get_iam_policy.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Instance::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.get_iam_policy.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.get_iam_policy.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @instance_admin_stub.get_iam_policy request, options do |result, operation|
                      yield result, operation if block_given?
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Returns permissions that the caller has on the specified instance resource.
                  #
                  # Attempting this RPC on a non-existent Cloud Spanner instance resource will
                  # result in a NOT_FOUND error if the user has `spanner.instances.list`
                  # permission on the containing Google Cloud Project. Otherwise returns an
                  # empty set of permissions.
                  #
                  # @overload test_iam_permissions(request, options = nil)
                  #   Pass arguments to `test_iam_permissions` via a request object, either of type
                  #   {::Google::Iam::V1::TestIamPermissionsRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Iam::V1::TestIamPermissionsRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload test_iam_permissions(resource: nil, permissions: nil)
                  #   Pass arguments to `test_iam_permissions` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param resource [::String]
                  #     REQUIRED: The resource for which the policy detail is being requested.
                  #     See the operation documentation for the appropriate value for this field.
                  #   @param permissions [::Array<::String>]
                  #     The set of permissions to check for the `resource`. Permissions with
                  #     wildcards (such as '*' or 'storage.*') are not allowed. For more
                  #     information see
                  #     [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Iam::V1::TestIamPermissionsResponse]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Iam::V1::TestIamPermissionsResponse]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/instance/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Iam::V1::TestIamPermissionsRequest.new
                  #
                  #   # Call the test_iam_permissions method.
                  #   result = client.test_iam_permissions request
                  #
                  #   # The returned object is of type Google::Iam::V1::TestIamPermissionsResponse.
                  #   p result
                  #
                  def test_iam_permissions request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::TestIamPermissionsRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.test_iam_permissions.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Instance::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.test_iam_permissions.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.test_iam_permissions.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @instance_admin_stub.test_iam_permissions request, options do |result, operation|
                      yield result, operation if block_given?
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Gets information about a particular instance partition.
                  #
                  # @overload get_instance_partition(request, options = nil)
                  #   Pass arguments to `get_instance_partition` via a request object, either of type
                  #   {::Google::Cloud::Spanner::Admin::Instance::V1::GetInstancePartitionRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Spanner::Admin::Instance::V1::GetInstancePartitionRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload get_instance_partition(name: nil)
                  #   Pass arguments to `get_instance_partition` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param name [::String]
                  #     Required. The name of the requested instance partition. Values are of
                  #     the form
                  #     `projects/{project}/instances/{instance}/instancePartitions/{instance_partition}`.
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Spanner::Admin::Instance::V1::InstancePartition]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Spanner::Admin::Instance::V1::InstancePartition]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/instance/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Spanner::Admin::Instance::V1::GetInstancePartitionRequest.new
                  #
                  #   # Call the get_instance_partition method.
                  #   result = client.get_instance_partition request
                  #
                  #   # The returned object is of type Google::Cloud::Spanner::Admin::Instance::V1::InstancePartition.
                  #   p result
                  #
                  def get_instance_partition request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::Admin::Instance::V1::GetInstancePartitionRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.get_instance_partition.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Instance::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.get_instance_partition.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.get_instance_partition.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @instance_admin_stub.get_instance_partition request, options do |result, operation|
                      yield result, operation if block_given?
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Creates an instance partition and begins preparing it to be used. The
                  # returned long-running operation
                  # can be used to track the progress of preparing the new instance partition.
                  # The instance partition name is assigned by the caller. If the named
                  # instance partition already exists, `CreateInstancePartition` returns
                  # `ALREADY_EXISTS`.
                  #
                  # Immediately upon completion of this request:
                  #
                  #   * The instance partition is readable via the API, with all requested
                  #     attributes but no allocated resources. Its state is `CREATING`.
                  #
                  # Until completion of the returned operation:
                  #
                  #   * Cancelling the operation renders the instance partition immediately
                  #     unreadable via the API.
                  #   * The instance partition can be deleted.
                  #   * All other attempts to modify the instance partition are rejected.
                  #
                  # Upon completion of the returned operation:
                  #
                  #   * Billing for all successfully-allocated resources begins (some types
                  #     may have lower than the requested levels).
                  #   * Databases can start using this instance partition.
                  #   * The instance partition's allocated resource levels are readable via the
                  #     API.
                  #   * The instance partition's state becomes `READY`.
                  #
                  # The returned long-running operation will
                  # have a name of the format
                  # `<instance_partition_name>/operations/<operation_id>` and can be used to
                  # track creation of the instance partition.  The
                  # metadata field type is
                  # {::Google::Cloud::Spanner::Admin::Instance::V1::CreateInstancePartitionMetadata CreateInstancePartitionMetadata}.
                  # The response field type is
                  # {::Google::Cloud::Spanner::Admin::Instance::V1::InstancePartition InstancePartition}, if
                  # successful.
                  #
                  # @overload create_instance_partition(request, options = nil)
                  #   Pass arguments to `create_instance_partition` via a request object, either of type
                  #   {::Google::Cloud::Spanner::Admin::Instance::V1::CreateInstancePartitionRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Spanner::Admin::Instance::V1::CreateInstancePartitionRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload create_instance_partition(parent: nil, instance_partition_id: nil, instance_partition: nil)
                  #   Pass arguments to `create_instance_partition` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param parent [::String]
                  #     Required. The name of the instance in which to create the instance
                  #     partition. Values are of the form
                  #     `projects/<project>/instances/<instance>`.
                  #   @param instance_partition_id [::String]
                  #     Required. The ID of the instance partition to create. Valid identifiers are
                  #     of the form `[a-z][-a-z0-9]*[a-z0-9]` and must be between 2 and 64
                  #     characters in length.
                  #   @param instance_partition [::Google::Cloud::Spanner::Admin::Instance::V1::InstancePartition, ::Hash]
                  #     Required. The instance partition to create. The instance_partition.name may
                  #     be omitted, but if specified must be
                  #     `<parent>/instancePartitions/<instance_partition_id>`.
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Gapic::Operation]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Gapic::Operation]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/instance/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Spanner::Admin::Instance::V1::CreateInstancePartitionRequest.new
                  #
                  #   # Call the create_instance_partition method.
                  #   result = client.create_instance_partition request
                  #
                  #   # The returned object is of type Gapic::Operation. You can use it to
                  #   # check the status of an operation, cancel it, or wait for results.
                  #   # Here is how to wait for a response.
                  #   result.wait_until_done! timeout: 60
                  #   if result.response?
                  #     p result.response
                  #   else
                  #     puts "No response received."
                  #   end
                  #
                  def create_instance_partition request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::Admin::Instance::V1::CreateInstancePartitionRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.create_instance_partition.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Instance::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.create_instance_partition.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.create_instance_partition.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @instance_admin_stub.create_instance_partition request, options do |result, operation|
                      result = ::Gapic::Operation.new result, @operations_client, options: options
                      yield result, operation if block_given?
                      throw :response, result
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Deletes an existing instance partition. Requires that the
                  # instance partition is not used by any database or backup and is not the
                  # default instance partition of an instance.
                  #
                  # Authorization requires `spanner.instancePartitions.delete` permission on
                  # the resource
                  # {::Google::Cloud::Spanner::Admin::Instance::V1::InstancePartition#name name}.
                  #
                  # @overload delete_instance_partition(request, options = nil)
                  #   Pass arguments to `delete_instance_partition` via a request object, either of type
                  #   {::Google::Cloud::Spanner::Admin::Instance::V1::DeleteInstancePartitionRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Spanner::Admin::Instance::V1::DeleteInstancePartitionRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload delete_instance_partition(name: nil, etag: nil)
                  #   Pass arguments to `delete_instance_partition` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param name [::String]
                  #     Required. The name of the instance partition to be deleted.
                  #     Values are of the form
                  #     `projects/{project}/instances/{instance}/instancePartitions/{instance_partition}`
                  #   @param etag [::String]
                  #     Optional. If not empty, the API only deletes the instance partition when
                  #     the etag provided matches the current status of the requested instance
                  #     partition. Otherwise, deletes the instance partition without checking the
                  #     current status of the requested instance partition.
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Protobuf::Empty]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Protobuf::Empty]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/instance/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Spanner::Admin::Instance::V1::DeleteInstancePartitionRequest.new
                  #
                  #   # Call the delete_instance_partition method.
                  #   result = client.delete_instance_partition request
                  #
                  #   # The returned object is of type Google::Protobuf::Empty.
                  #   p result
                  #
                  def delete_instance_partition request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::Admin::Instance::V1::DeleteInstancePartitionRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.delete_instance_partition.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Instance::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.delete_instance_partition.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.delete_instance_partition.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @instance_admin_stub.delete_instance_partition request, options do |result, operation|
                      yield result, operation if block_given?
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Updates an instance partition, and begins allocating or releasing resources
                  # as requested. The returned long-running operation can be used to track the
                  # progress of updating the instance partition. If the named instance
                  # partition does not exist, returns `NOT_FOUND`.
                  #
                  # Immediately upon completion of this request:
                  #
                  #   * For resource types for which a decrease in the instance partition's
                  #   allocation has been requested, billing is based on the newly-requested
                  #   level.
                  #
                  # Until completion of the returned operation:
                  #
                  #   * Cancelling the operation sets its metadata's
                  #     {::Google::Cloud::Spanner::Admin::Instance::V1::UpdateInstancePartitionMetadata#cancel_time cancel_time},
                  #     and begins restoring resources to their pre-request values. The
                  #     operation is guaranteed to succeed at undoing all resource changes,
                  #     after which point it terminates with a `CANCELLED` status.
                  #   * All other attempts to modify the instance partition are rejected.
                  #   * Reading the instance partition via the API continues to give the
                  #     pre-request resource levels.
                  #
                  # Upon completion of the returned operation:
                  #
                  #   * Billing begins for all successfully-allocated resources (some types
                  #     may have lower than the requested levels).
                  #   * All newly-reserved resources are available for serving the instance
                  #     partition's tables.
                  #   * The instance partition's new resource levels are readable via the API.
                  #
                  # The returned long-running operation will
                  # have a name of the format
                  # `<instance_partition_name>/operations/<operation_id>` and can be used to
                  # track the instance partition modification. The
                  # metadata field type is
                  # {::Google::Cloud::Spanner::Admin::Instance::V1::UpdateInstancePartitionMetadata UpdateInstancePartitionMetadata}.
                  # The response field type is
                  # {::Google::Cloud::Spanner::Admin::Instance::V1::InstancePartition InstancePartition}, if
                  # successful.
                  #
                  # Authorization requires `spanner.instancePartitions.update` permission on
                  # the resource
                  # {::Google::Cloud::Spanner::Admin::Instance::V1::InstancePartition#name name}.
                  #
                  # @overload update_instance_partition(request, options = nil)
                  #   Pass arguments to `update_instance_partition` via a request object, either of type
                  #   {::Google::Cloud::Spanner::Admin::Instance::V1::UpdateInstancePartitionRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Spanner::Admin::Instance::V1::UpdateInstancePartitionRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload update_instance_partition(instance_partition: nil, field_mask: nil)
                  #   Pass arguments to `update_instance_partition` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param instance_partition [::Google::Cloud::Spanner::Admin::Instance::V1::InstancePartition, ::Hash]
                  #     Required. The instance partition to update, which must always include the
                  #     instance partition name. Otherwise, only fields mentioned in
                  #     {::Google::Cloud::Spanner::Admin::Instance::V1::UpdateInstancePartitionRequest#field_mask field_mask}
                  #     need be included.
                  #   @param field_mask [::Google::Protobuf::FieldMask, ::Hash]
                  #     Required. A mask specifying which fields in
                  #     {::Google::Cloud::Spanner::Admin::Instance::V1::InstancePartition InstancePartition}
                  #     should be updated. The field mask must always be specified; this prevents
                  #     any future fields in
                  #     {::Google::Cloud::Spanner::Admin::Instance::V1::InstancePartition InstancePartition}
                  #     from being erased accidentally by clients that do not know about them.
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Gapic::Operation]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Gapic::Operation]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/instance/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Spanner::Admin::Instance::V1::UpdateInstancePartitionRequest.new
                  #
                  #   # Call the update_instance_partition method.
                  #   result = client.update_instance_partition request
                  #
                  #   # The returned object is of type Gapic::Operation. You can use it to
                  #   # check the status of an operation, cancel it, or wait for results.
                  #   # Here is how to wait for a response.
                  #   result.wait_until_done! timeout: 60
                  #   if result.response?
                  #     p result.response
                  #   else
                  #     puts "No response received."
                  #   end
                  #
                  def update_instance_partition request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::Admin::Instance::V1::UpdateInstancePartitionRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.update_instance_partition.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Instance::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.update_instance_partition.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.update_instance_partition.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @instance_admin_stub.update_instance_partition request, options do |result, operation|
                      result = ::Gapic::Operation.new result, @operations_client, options: options
                      yield result, operation if block_given?
                      throw :response, result
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Lists instance partition long-running operations in the given instance.
                  # An instance partition operation has a name of the form
                  # `projects/<project>/instances/<instance>/instancePartitions/<instance_partition>/operations/<operation>`.
                  # The long-running operation
                  # metadata field type
                  # `metadata.type_url` describes the type of the metadata. Operations returned
                  # include those that have completed/failed/canceled within the last 7 days,
                  # and pending operations. Operations returned are ordered by
                  # `operation.metadata.value.start_time` in descending order starting from the
                  # most recently started operation.
                  #
                  # Authorization requires `spanner.instancePartitionOperations.list`
                  # permission on the resource
                  # {::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancePartitionOperationsRequest#parent parent}.
                  #
                  # @overload list_instance_partition_operations(request, options = nil)
                  #   Pass arguments to `list_instance_partition_operations` via a request object, either of type
                  #   {::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancePartitionOperationsRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancePartitionOperationsRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload list_instance_partition_operations(parent: nil, filter: nil, page_size: nil, page_token: nil, instance_partition_deadline: nil)
                  #   Pass arguments to `list_instance_partition_operations` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param parent [::String]
                  #     Required. The parent instance of the instance partition operations.
                  #     Values are of the form `projects/<project>/instances/<instance>`.
                  #   @param filter [::String]
                  #     Optional. An expression that filters the list of returned operations.
                  #
                  #     A filter expression consists of a field name, a
                  #     comparison operator, and a value for filtering.
                  #     The value must be a string, a number, or a boolean. The comparison operator
                  #     must be one of: `<`, `>`, `<=`, `>=`, `!=`, `=`, or `:`.
                  #     Colon `:` is the contains operator. Filter rules are not case sensitive.
                  #
                  #     The following fields in the Operation are eligible for filtering:
                  #
                  #       * `name` - The name of the long-running operation
                  #       * `done` - False if the operation is in progress, else true.
                  #       * `metadata.@type` - the type of metadata. For example, the type string
                  #          for
                  #          {::Google::Cloud::Spanner::Admin::Instance::V1::CreateInstancePartitionMetadata CreateInstancePartitionMetadata}
                  #          is
                  #          `type.googleapis.com/google.spanner.admin.instance.v1.CreateInstancePartitionMetadata`.
                  #       * `metadata.<field_name>` - any field in metadata.value.
                  #          `metadata.@type` must be specified first, if filtering on metadata
                  #          fields.
                  #       * `error` - Error associated with the long-running operation.
                  #       * `response.@type` - the type of response.
                  #       * `response.<field_name>` - any field in response.value.
                  #
                  #     You can combine multiple expressions by enclosing each expression in
                  #     parentheses. By default, expressions are combined with AND logic. However,
                  #     you can specify AND, OR, and NOT logic explicitly.
                  #
                  #     Here are a few examples:
                  #
                  #       * `done:true` - The operation is complete.
                  #       * `(metadata.@type=` \
                  #         `type.googleapis.com/google.spanner.admin.instance.v1.CreateInstancePartitionMetadata)
                  #         AND` \
                  #         `(metadata.instance_partition.name:custom-instance-partition) AND` \
                  #         `(metadata.start_time < \"2021-03-28T14:50:00Z\") AND` \
                  #         `(error:*)` - Return operations where:
                  #         * The operation's metadata type is
                  #         {::Google::Cloud::Spanner::Admin::Instance::V1::CreateInstancePartitionMetadata CreateInstancePartitionMetadata}.
                  #         * The instance partition name contains "custom-instance-partition".
                  #         * The operation started before 2021-03-28T14:50:00Z.
                  #         * The operation resulted in an error.
                  #   @param page_size [::Integer]
                  #     Optional. Number of operations to be returned in the response. If 0 or
                  #     less, defaults to the server's maximum allowed page size.
                  #   @param page_token [::String]
                  #     Optional. If non-empty, `page_token` should contain a
                  #     {::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancePartitionOperationsResponse#next_page_token next_page_token}
                  #     from a previous
                  #     {::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancePartitionOperationsResponse ListInstancePartitionOperationsResponse}
                  #     to the same `parent` and with the same `filter`.
                  #   @param instance_partition_deadline [::Google::Protobuf::Timestamp, ::Hash]
                  #     Optional. Deadline used while retrieving metadata for instance partition
                  #     operations. Instance partitions whose operation metadata cannot be
                  #     retrieved within this deadline will be added to
                  #     {::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancePartitionOperationsResponse#unreachable_instance_partitions unreachable_instance_partitions}
                  #     in
                  #     {::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancePartitionOperationsResponse ListInstancePartitionOperationsResponse}.
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Gapic::Operation]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Gapic::Operation]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/instance/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Spanner::Admin::Instance::V1::ListInstancePartitionOperationsRequest.new
                  #
                  #   # Call the list_instance_partition_operations method.
                  #   result = client.list_instance_partition_operations request
                  #
                  #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
                  #   # over elements, and API calls will be issued to fetch pages as needed.
                  #   result.each do |item|
                  #     # Each element is of type ::Google::Longrunning::Operation.
                  #     p item
                  #   end
                  #
                  def list_instance_partition_operations request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::Admin::Instance::V1::ListInstancePartitionOperationsRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.list_instance_partition_operations.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Instance::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.list_instance_partition_operations.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.list_instance_partition_operations.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @instance_admin_stub.list_instance_partition_operations request, options do |result, operation|
                      result = ::Gapic::Rest::PagedEnumerable.new @instance_admin_stub, :list_instance_partition_operations, "operations", request, result, options
                      yield result, operation if block_given?
                      throw :response, result
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Moves an instance to the target instance configuration. You can use the
                  # returned long-running operation to track
                  # the progress of moving the instance.
                  #
                  # `MoveInstance` returns `FAILED_PRECONDITION` if the instance meets any of
                  # the following criteria:
                  #
                  #   * Is undergoing a move to a different instance configuration
                  #   * Has backups
                  #   * Has an ongoing update
                  #   * Contains any CMEK-enabled databases
                  #   * Is a free trial instance
                  #
                  # While the operation is pending:
                  #
                  #   * All other attempts to modify the instance, including changes to its
                  #     compute capacity, are rejected.
                  #   * The following database and backup admin operations are rejected:
                  #
                  #     * `DatabaseAdmin.CreateDatabase`
                  #     * `DatabaseAdmin.UpdateDatabaseDdl` (disabled if default_leader is
                  #        specified in the request.)
                  #     * `DatabaseAdmin.RestoreDatabase`
                  #     * `DatabaseAdmin.CreateBackup`
                  #     * `DatabaseAdmin.CopyBackup`
                  #
                  #   * Both the source and target instance configurations are subject to
                  #     hourly compute and storage charges.
                  #   * The instance might experience higher read-write latencies and a higher
                  #     transaction abort rate. However, moving an instance doesn't cause any
                  #     downtime.
                  #
                  # The returned long-running operation has
                  # a name of the format
                  # `<instance_name>/operations/<operation_id>` and can be used to track
                  # the move instance operation. The
                  # metadata field type is
                  # {::Google::Cloud::Spanner::Admin::Instance::V1::MoveInstanceMetadata MoveInstanceMetadata}.
                  # The response field type is
                  # {::Google::Cloud::Spanner::Admin::Instance::V1::Instance Instance},
                  # if successful.
                  # Cancelling the operation sets its metadata's
                  # {::Google::Cloud::Spanner::Admin::Instance::V1::MoveInstanceMetadata#cancel_time cancel_time}.
                  # Cancellation is not immediate because it involves moving any data
                  # previously moved to the target instance configuration back to the original
                  # instance configuration. You can use this operation to track the progress of
                  # the cancellation. Upon successful completion of the cancellation, the
                  # operation terminates with `CANCELLED` status.
                  #
                  # If not cancelled, upon completion of the returned operation:
                  #
                  #   * The instance successfully moves to the target instance
                  #     configuration.
                  #   * You are billed for compute and storage in target instance
                  #   configuration.
                  #
                  # Authorization requires the `spanner.instances.update` permission on
                  # the resource {::Google::Cloud::Spanner::Admin::Instance::V1::Instance instance}.
                  #
                  # For more details, see
                  # [Move an instance](https://cloud.google.com/spanner/docs/move-instance).
                  #
                  # @overload move_instance(request, options = nil)
                  #   Pass arguments to `move_instance` via a request object, either of type
                  #   {::Google::Cloud::Spanner::Admin::Instance::V1::MoveInstanceRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Spanner::Admin::Instance::V1::MoveInstanceRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload move_instance(name: nil, target_config: nil)
                  #   Pass arguments to `move_instance` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param name [::String]
                  #     Required. The instance to move.
                  #     Values are of the form `projects/<project>/instances/<instance>`.
                  #   @param target_config [::String]
                  #     Required. The target instance configuration where to move the instance.
                  #     Values are of the form `projects/<project>/instanceConfigs/<config>`.
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Gapic::Operation]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Gapic::Operation]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/instance/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Spanner::Admin::Instance::V1::MoveInstanceRequest.new
                  #
                  #   # Call the move_instance method.
                  #   result = client.move_instance request
                  #
                  #   # The returned object is of type Gapic::Operation. You can use it to
                  #   # check the status of an operation, cancel it, or wait for results.
                  #   # Here is how to wait for a response.
                  #   result.wait_until_done! timeout: 60
                  #   if result.response?
                  #     p result.response
                  #   else
                  #     puts "No response received."
                  #   end
                  #
                  def move_instance request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::Admin::Instance::V1::MoveInstanceRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.move_instance.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Instance::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.move_instance.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.move_instance.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @instance_admin_stub.move_instance request, options do |result, operation|
                      result = ::Gapic::Operation.new result, @operations_client, options: options
                      yield result, operation if block_given?
                      throw :response, result
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Configuration class for the InstanceAdmin REST API.
                  #
                  # This class represents the configuration for InstanceAdmin REST,
                  # providing control over timeouts, retry behavior, logging, transport
                  # parameters, and other low-level controls. Certain parameters can also be
                  # applied individually to specific RPCs. See
                  # {::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Rest::Client::Configuration::Rpcs}
                  # for a list of RPCs that can be configured independently.
                  #
                  # Configuration can be applied globally to all clients, or to a single client
                  # on construction.
                  #
                  # @example
                  #
                  #   # Modify the global config, setting the timeout for
                  #   # list_instance_configs to 20 seconds,
                  #   # and all remaining timeouts to 10 seconds.
                  #   ::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Rest::Client.configure do |config|
                  #     config.timeout = 10.0
                  #     config.rpcs.list_instance_configs.timeout = 20.0
                  #   end
                  #
                  #   # Apply the above configuration only to a new client.
                  #   client = ::Google::Cloud::Spanner::Admin::Instance::V1::InstanceAdmin::Rest::Client.new do |config|
                  #     config.timeout = 10.0
                  #     config.rpcs.list_instance_configs.timeout = 20.0
                  #   end
                  #
                  # @!attribute [rw] endpoint
                  #   A custom service endpoint, as a hostname or hostname:port. The default is
                  #   nil, indicating to use the default endpoint in the current universe domain.
                  #   @return [::String,nil]
                  # @!attribute [rw] credentials
                  #   Credentials to send with calls. You may provide any of the following types:
                  #    *  (`String`) The path to a service account key file in JSON format
                  #    *  (`Hash`) A service account key as a Hash
                  #    *  (`Google::Auth::Credentials`) A googleauth credentials object
                  #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
                  #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
                  #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
                  #    *  (`nil`) indicating no credentials
                  #
                  #   Warning: If you accept a credential configuration (JSON file or Hash) from an
                  #   external source for authentication to Google Cloud, you must validate it before
                  #   providing it to a Google API client library. Providing an unvalidated credential
                  #   configuration to Google APIs can compromise the security of your systems and data.
                  #   For more information, refer to [Validate credential configurations from external
                  #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
                  #   @return [::Object]
                  # @!attribute [rw] scope
                  #   The OAuth scopes
                  #   @return [::Array<::String>]
                  # @!attribute [rw] lib_name
                  #   The library name as recorded in instrumentation and logging
                  #   @return [::String]
                  # @!attribute [rw] lib_version
                  #   The library version as recorded in instrumentation and logging
                  #   @return [::String]
                  # @!attribute [rw] timeout
                  #   The call timeout in seconds.
                  #   @return [::Numeric]
                  # @!attribute [rw] metadata
                  #   Additional headers to be sent with the call.
                  #   @return [::Hash{::Symbol=>::String}]
                  # @!attribute [rw] retry_policy
                  #   The retry policy. The value is a hash with the following keys:
                  #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                  #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                  #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                  #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                  #       trigger a retry.
                  #   @return [::Hash]
                  # @!attribute [rw] quota_project
                  #   A separate project against which to charge quota.
                  #   @return [::String]
                  # @!attribute [rw] universe_domain
                  #   The universe domain within which to make requests. This determines the
                  #   default endpoint URL. The default value of nil uses the environment
                  #   universe (usually the default "googleapis.com" universe).
                  #   @return [::String,nil]
                  # @!attribute [rw] logger
                  #   A custom logger to use for request/response debug logging, or the value
                  #   `:default` (the default) to construct a default logger, or `nil` to
                  #   explicitly disable logging.
                  #   @return [::Logger,:default,nil]
                  #
                  class Configuration
                    extend ::Gapic::Config

                    # @private
                    # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                    DEFAULT_ENDPOINT = "spanner.googleapis.com"

                    config_attr :endpoint,      nil, ::String, nil
                    config_attr :credentials,   nil do |value|
                      allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                      allowed.any? { |klass| klass === value }
                    end
                    config_attr :scope,         nil, ::String, ::Array, nil
                    config_attr :lib_name,      nil, ::String, nil
                    config_attr :lib_version,   nil, ::String, nil
                    config_attr :timeout,       nil, ::Numeric, nil
                    config_attr :metadata,      nil, ::Hash, nil
                    config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                    config_attr :quota_project, nil, ::String, nil
                    config_attr :universe_domain, nil, ::String, nil
                    config_attr :logger, :default, ::Logger, nil, :default

                    # @private
                    def initialize parent_config = nil
                      @parent_config = parent_config unless parent_config.nil?

                      yield self if block_given?
                    end

                    ##
                    # Configurations for individual RPCs
                    # @return [Rpcs]
                    #
                    def rpcs
                      @rpcs ||= begin
                        parent_rpcs = nil
                        parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                        Rpcs.new parent_rpcs
                      end
                    end

                    ##
                    # Configuration RPC class for the InstanceAdmin API.
                    #
                    # Includes fields providing the configuration for each RPC in this service.
                    # Each configuration object is of type `Gapic::Config::Method` and includes
                    # the following configuration fields:
                    #
                    #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                    #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                    #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                    #     include the following keys:
                    #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                    #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                    #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                    #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                    #         trigger a retry.
                    #
                    class Rpcs
                      ##
                      # RPC-specific configuration for `list_instance_configs`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :list_instance_configs
                      ##
                      # RPC-specific configuration for `get_instance_config`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :get_instance_config
                      ##
                      # RPC-specific configuration for `create_instance_config`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :create_instance_config
                      ##
                      # RPC-specific configuration for `update_instance_config`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :update_instance_config
                      ##
                      # RPC-specific configuration for `delete_instance_config`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :delete_instance_config
                      ##
                      # RPC-specific configuration for `list_instance_config_operations`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :list_instance_config_operations
                      ##
                      # RPC-specific configuration for `list_instances`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :list_instances
                      ##
                      # RPC-specific configuration for `list_instance_partitions`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :list_instance_partitions
                      ##
                      # RPC-specific configuration for `get_instance`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :get_instance
                      ##
                      # RPC-specific configuration for `create_instance`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :create_instance
                      ##
                      # RPC-specific configuration for `update_instance`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :update_instance
                      ##
                      # RPC-specific configuration for `delete_instance`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :delete_instance
                      ##
                      # RPC-specific configuration for `set_iam_policy`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :set_iam_policy
                      ##
                      # RPC-specific configuration for `get_iam_policy`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :get_iam_policy
                      ##
                      # RPC-specific configuration for `test_iam_permissions`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :test_iam_permissions
                      ##
                      # RPC-specific configuration for `get_instance_partition`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :get_instance_partition
                      ##
                      # RPC-specific configuration for `create_instance_partition`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :create_instance_partition
                      ##
                      # RPC-specific configuration for `delete_instance_partition`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :delete_instance_partition
                      ##
                      # RPC-specific configuration for `update_instance_partition`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :update_instance_partition
                      ##
                      # RPC-specific configuration for `list_instance_partition_operations`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :list_instance_partition_operations
                      ##
                      # RPC-specific configuration for `move_instance`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :move_instance

                      # @private
                      def initialize parent_rpcs = nil
                        list_instance_configs_config = parent_rpcs.list_instance_configs if parent_rpcs.respond_to? :list_instance_configs
                        @list_instance_configs = ::Gapic::Config::Method.new list_instance_configs_config
                        get_instance_config_config = parent_rpcs.get_instance_config if parent_rpcs.respond_to? :get_instance_config
                        @get_instance_config = ::Gapic::Config::Method.new get_instance_config_config
                        create_instance_config_config = parent_rpcs.create_instance_config if parent_rpcs.respond_to? :create_instance_config
                        @create_instance_config = ::Gapic::Config::Method.new create_instance_config_config
                        update_instance_config_config = parent_rpcs.update_instance_config if parent_rpcs.respond_to? :update_instance_config
                        @update_instance_config = ::Gapic::Config::Method.new update_instance_config_config
                        delete_instance_config_config = parent_rpcs.delete_instance_config if parent_rpcs.respond_to? :delete_instance_config
                        @delete_instance_config = ::Gapic::Config::Method.new delete_instance_config_config
                        list_instance_config_operations_config = parent_rpcs.list_instance_config_operations if parent_rpcs.respond_to? :list_instance_config_operations
                        @list_instance_config_operations = ::Gapic::Config::Method.new list_instance_config_operations_config
                        list_instances_config = parent_rpcs.list_instances if parent_rpcs.respond_to? :list_instances
                        @list_instances = ::Gapic::Config::Method.new list_instances_config
                        list_instance_partitions_config = parent_rpcs.list_instance_partitions if parent_rpcs.respond_to? :list_instance_partitions
                        @list_instance_partitions = ::Gapic::Config::Method.new list_instance_partitions_config
                        get_instance_config = parent_rpcs.get_instance if parent_rpcs.respond_to? :get_instance
                        @get_instance = ::Gapic::Config::Method.new get_instance_config
                        create_instance_config = parent_rpcs.create_instance if parent_rpcs.respond_to? :create_instance
                        @create_instance = ::Gapic::Config::Method.new create_instance_config
                        update_instance_config = parent_rpcs.update_instance if parent_rpcs.respond_to? :update_instance
                        @update_instance = ::Gapic::Config::Method.new update_instance_config
                        delete_instance_config = parent_rpcs.delete_instance if parent_rpcs.respond_to? :delete_instance
                        @delete_instance = ::Gapic::Config::Method.new delete_instance_config
                        set_iam_policy_config = parent_rpcs.set_iam_policy if parent_rpcs.respond_to? :set_iam_policy
                        @set_iam_policy = ::Gapic::Config::Method.new set_iam_policy_config
                        get_iam_policy_config = parent_rpcs.get_iam_policy if parent_rpcs.respond_to? :get_iam_policy
                        @get_iam_policy = ::Gapic::Config::Method.new get_iam_policy_config
                        test_iam_permissions_config = parent_rpcs.test_iam_permissions if parent_rpcs.respond_to? :test_iam_permissions
                        @test_iam_permissions = ::Gapic::Config::Method.new test_iam_permissions_config
                        get_instance_partition_config = parent_rpcs.get_instance_partition if parent_rpcs.respond_to? :get_instance_partition
                        @get_instance_partition = ::Gapic::Config::Method.new get_instance_partition_config
                        create_instance_partition_config = parent_rpcs.create_instance_partition if parent_rpcs.respond_to? :create_instance_partition
                        @create_instance_partition = ::Gapic::Config::Method.new create_instance_partition_config
                        delete_instance_partition_config = parent_rpcs.delete_instance_partition if parent_rpcs.respond_to? :delete_instance_partition
                        @delete_instance_partition = ::Gapic::Config::Method.new delete_instance_partition_config
                        update_instance_partition_config = parent_rpcs.update_instance_partition if parent_rpcs.respond_to? :update_instance_partition
                        @update_instance_partition = ::Gapic::Config::Method.new update_instance_partition_config
                        list_instance_partition_operations_config = parent_rpcs.list_instance_partition_operations if parent_rpcs.respond_to? :list_instance_partition_operations
                        @list_instance_partition_operations = ::Gapic::Config::Method.new list_instance_partition_operations_config
                        move_instance_config = parent_rpcs.move_instance if parent_rpcs.respond_to? :move_instance
                        @move_instance = ::Gapic::Config::Method.new move_instance_config

                        yield self if block_given?
                      end
                    end
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
