# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Spanner
      module Admin
        module Database
          module V1
            # Defines specifications of the backup schedule.
            # @!attribute [rw] cron_spec
            #   @return [::Google::Cloud::Spanner::Admin::Database::V1::CrontabSpec]
            #     Cron style schedule specification.
            class BackupScheduleSpec
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # BackupSchedule expresses the automated backup creation specification for a
            # Spanner database.
            # Next ID: 10
            # @!attribute [rw] name
            #   @return [::String]
            #     Identifier. Output only for the
            #     [CreateBackupSchedule][DatabaseAdmin.CreateBackupSchededule] operation.
            #     Required for the
            #     {::Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Client#update_backup_schedule UpdateBackupSchedule}
            #     operation. A globally unique identifier for the backup schedule which
            #     cannot be changed. Values are of the form
            #     `projects/<project>/instances/<instance>/databases/<database>/backupSchedules/[a-z][a-z0-9_\-]*[a-z0-9]`
            #     The final segment of the name must be between 2 and 60 characters in
            #     length.
            # @!attribute [rw] spec
            #   @return [::Google::Cloud::Spanner::Admin::Database::V1::BackupScheduleSpec]
            #     Optional. The schedule specification based on which the backup creations
            #     are triggered.
            # @!attribute [rw] retention_duration
            #   @return [::Google::Protobuf::Duration]
            #     Optional. The retention duration of a backup that must be at least 6 hours
            #     and at most 366 days. The backup is eligible to be automatically deleted
            #     once the retention period has elapsed.
            # @!attribute [rw] encryption_config
            #   @return [::Google::Cloud::Spanner::Admin::Database::V1::CreateBackupEncryptionConfig]
            #     Optional. The encryption configuration that will be used to encrypt the
            #     backup. If this field is not specified, the backup will use the same
            #     encryption configuration as the database.
            # @!attribute [rw] full_backup_spec
            #   @return [::Google::Cloud::Spanner::Admin::Database::V1::FullBackupSpec]
            #     The schedule creates only full backups.
            #
            #     Note: The following fields are mutually exclusive: `full_backup_spec`, `incremental_backup_spec`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] incremental_backup_spec
            #   @return [::Google::Cloud::Spanner::Admin::Database::V1::IncrementalBackupSpec]
            #     The schedule creates incremental backup chains.
            #
            #     Note: The following fields are mutually exclusive: `incremental_backup_spec`, `full_backup_spec`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [r] update_time
            #   @return [::Google::Protobuf::Timestamp]
            #     Output only. The timestamp at which the schedule was last updated.
            #     If the schedule has never been updated, this field contains the timestamp
            #     when the schedule was first created.
            class BackupSchedule
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # CrontabSpec can be used to specify the version time and frequency at
            # which the backup should be created.
            # @!attribute [rw] text
            #   @return [::String]
            #     Required. Textual representation of the crontab. User can customize the
            #     backup frequency and the backup version time using the cron
            #     expression. The version time must be in UTC timezone.
            #
            #     The backup will contain an externally consistent copy of the
            #     database at the version time. Allowed frequencies are 12 hour, 1 day,
            #     1 week and 1 month. Examples of valid cron specifications:
            #       * `0 2/12 * * * ` : every 12 hours at (2, 14) hours past midnight in UTC.
            #       * `0 2,14 * * * ` : every 12 hours at (2,14) hours past midnight in UTC.
            #       * `0 2 * * * `    : once a day at 2 past midnight in UTC.
            #       * `0 2 * * 0 `    : once a week every Sunday at 2 past midnight in UTC.
            #       * `0 2 8 * * `    : once a month on 8th day at 2 past midnight in UTC.
            # @!attribute [r] time_zone
            #   @return [::String]
            #     Output only. The time zone of the times in `CrontabSpec.text`. Currently
            #     only UTC is supported.
            # @!attribute [r] creation_window
            #   @return [::Google::Protobuf::Duration]
            #     Output only. Schedule backups will contain an externally consistent copy
            #     of the database at the version time specified in
            #     `schedule_spec.cron_spec`. However, Spanner may not initiate the creation
            #     of the scheduled backups at that version time. Spanner will initiate
            #     the creation of scheduled backups within the time window bounded by the
            #     version_time specified in `schedule_spec.cron_spec` and version_time +
            #     `creation_window`.
            class CrontabSpec
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The request for
            # {::Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Client#create_backup_schedule CreateBackupSchedule}.
            # @!attribute [rw] parent
            #   @return [::String]
            #     Required. The name of the database that this backup schedule applies to.
            # @!attribute [rw] backup_schedule_id
            #   @return [::String]
            #     Required. The Id to use for the backup schedule. The `backup_schedule_id`
            #     appended to `parent` forms the full backup schedule name of the form
            #     `projects/<project>/instances/<instance>/databases/<database>/backupSchedules/<backup_schedule_id>`.
            # @!attribute [rw] backup_schedule
            #   @return [::Google::Cloud::Spanner::Admin::Database::V1::BackupSchedule]
            #     Required. The backup schedule to create.
            class CreateBackupScheduleRequest
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The request for
            # {::Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Client#get_backup_schedule GetBackupSchedule}.
            # @!attribute [rw] name
            #   @return [::String]
            #     Required. The name of the schedule to retrieve.
            #     Values are of the form
            #     `projects/<project>/instances/<instance>/databases/<database>/backupSchedules/<backup_schedule_id>`.
            class GetBackupScheduleRequest
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The request for
            # {::Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Client#delete_backup_schedule DeleteBackupSchedule}.
            # @!attribute [rw] name
            #   @return [::String]
            #     Required. The name of the schedule to delete.
            #     Values are of the form
            #     `projects/<project>/instances/<instance>/databases/<database>/backupSchedules/<backup_schedule_id>`.
            class DeleteBackupScheduleRequest
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The request for
            # {::Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Client#list_backup_schedules ListBackupSchedules}.
            # @!attribute [rw] parent
            #   @return [::String]
            #     Required. Database is the parent resource whose backup schedules should be
            #     listed. Values are of the form
            #     projects/<project>/instances/<instance>/databases/<database>
            # @!attribute [rw] page_size
            #   @return [::Integer]
            #     Optional. Number of backup schedules to be returned in the response. If 0
            #     or less, defaults to the server's maximum allowed page size.
            # @!attribute [rw] page_token
            #   @return [::String]
            #     Optional. If non-empty, `page_token` should contain a
            #     {::Google::Cloud::Spanner::Admin::Database::V1::ListBackupSchedulesResponse#next_page_token next_page_token}
            #     from a previous
            #     {::Google::Cloud::Spanner::Admin::Database::V1::ListBackupSchedulesResponse ListBackupSchedulesResponse}
            #     to the same `parent`.
            class ListBackupSchedulesRequest
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The response for
            # {::Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Client#list_backup_schedules ListBackupSchedules}.
            # @!attribute [rw] backup_schedules
            #   @return [::Array<::Google::Cloud::Spanner::Admin::Database::V1::BackupSchedule>]
            #     The list of backup schedules for a database.
            # @!attribute [rw] next_page_token
            #   @return [::String]
            #     `next_page_token` can be sent in a subsequent
            #     {::Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Client#list_backup_schedules ListBackupSchedules}
            #     call to fetch more of the schedules.
            class ListBackupSchedulesResponse
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The request for
            # {::Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Client#update_backup_schedule UpdateBackupScheduleRequest}.
            # @!attribute [rw] backup_schedule
            #   @return [::Google::Cloud::Spanner::Admin::Database::V1::BackupSchedule]
            #     Required. The backup schedule to update. `backup_schedule.name`, and the
            #     fields to be updated as specified by `update_mask` are required. Other
            #     fields are ignored.
            # @!attribute [rw] update_mask
            #   @return [::Google::Protobuf::FieldMask]
            #     Required. A mask specifying which fields in the BackupSchedule resource
            #     should be updated. This mask is relative to the BackupSchedule resource,
            #     not to the request message. The field mask must always be
            #     specified; this prevents any future fields from being erased
            #     accidentally.
            class UpdateBackupScheduleRequest
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end
      end
    end
  end
end
