# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/spanner/admin/database/v1/spanner_database_admin.proto for package 'Google.Cloud.Spanner.Admin.Database.V1'
# Original file comments:
# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/spanner/admin/database/v1/spanner_database_admin_pb'

module Google
  module Cloud
    module Spanner
      module Admin
        module Database
          module V1
            module DatabaseAdmin
              # Cloud Spanner Database Admin API
              #
              # The Cloud Spanner Database Admin API can be used to:
              #   * create, drop, and list databases
              #   * update the schema of pre-existing databases
              #   * create, delete, copy and list backups for a database
              #   * restore a database from an existing backup
              class Service

                include ::GRPC::GenericService

                self.marshal_class_method = :encode
                self.unmarshal_class_method = :decode
                self.service_name = 'google.spanner.admin.database.v1.DatabaseAdmin'

                # Lists Cloud Spanner databases.
                rpc :ListDatabases, ::Google::Cloud::Spanner::Admin::Database::V1::ListDatabasesRequest, ::Google::Cloud::Spanner::Admin::Database::V1::ListDatabasesResponse
                # Creates a new Cloud Spanner database and starts to prepare it for serving.
                # The returned [long-running operation][google.longrunning.Operation] will
                # have a name of the format `<database_name>/operations/<operation_id>` and
                # can be used to track preparation of the database. The
                # [metadata][google.longrunning.Operation.metadata] field type is
                # [CreateDatabaseMetadata][google.spanner.admin.database.v1.CreateDatabaseMetadata].
                # The [response][google.longrunning.Operation.response] field type is
                # [Database][google.spanner.admin.database.v1.Database], if successful.
                rpc :CreateDatabase, ::Google::Cloud::Spanner::Admin::Database::V1::CreateDatabaseRequest, ::Google::Longrunning::Operation
                # Gets the state of a Cloud Spanner database.
                rpc :GetDatabase, ::Google::Cloud::Spanner::Admin::Database::V1::GetDatabaseRequest, ::Google::Cloud::Spanner::Admin::Database::V1::Database
                # Updates a Cloud Spanner database. The returned
                # [long-running operation][google.longrunning.Operation] can be used to track
                # the progress of updating the database. If the named database does not
                # exist, returns `NOT_FOUND`.
                #
                # While the operation is pending:
                #
                #   * The database's
                #     [reconciling][google.spanner.admin.database.v1.Database.reconciling]
                #     field is set to true.
                #   * Cancelling the operation is best-effort. If the cancellation succeeds,
                #     the operation metadata's
                #     [cancel_time][google.spanner.admin.database.v1.UpdateDatabaseMetadata.cancel_time]
                #     is set, the updates are reverted, and the operation terminates with a
                #     `CANCELLED` status.
                #   * New UpdateDatabase requests will return a `FAILED_PRECONDITION` error
                #     until the pending operation is done (returns successfully or with
                #     error).
                #   * Reading the database via the API continues to give the pre-request
                #     values.
                #
                # Upon completion of the returned operation:
                #
                #   * The new values are in effect and readable via the API.
                #   * The database's
                #     [reconciling][google.spanner.admin.database.v1.Database.reconciling]
                #     field becomes false.
                #
                # The returned [long-running operation][google.longrunning.Operation] will
                # have a name of the format
                # `projects/<project>/instances/<instance>/databases/<database>/operations/<operation_id>`
                # and can be used to track the database modification. The
                # [metadata][google.longrunning.Operation.metadata] field type is
                # [UpdateDatabaseMetadata][google.spanner.admin.database.v1.UpdateDatabaseMetadata].
                # The [response][google.longrunning.Operation.response] field type is
                # [Database][google.spanner.admin.database.v1.Database], if successful.
                rpc :UpdateDatabase, ::Google::Cloud::Spanner::Admin::Database::V1::UpdateDatabaseRequest, ::Google::Longrunning::Operation
                # Updates the schema of a Cloud Spanner database by
                # creating/altering/dropping tables, columns, indexes, etc. The returned
                # [long-running operation][google.longrunning.Operation] will have a name of
                # the format `<database_name>/operations/<operation_id>` and can be used to
                # track execution of the schema change(s). The
                # [metadata][google.longrunning.Operation.metadata] field type is
                # [UpdateDatabaseDdlMetadata][google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata].
                # The operation has no response.
                rpc :UpdateDatabaseDdl, ::Google::Cloud::Spanner::Admin::Database::V1::UpdateDatabaseDdlRequest, ::Google::Longrunning::Operation
                # Drops (aka deletes) a Cloud Spanner database.
                # Completed backups for the database will be retained according to their
                # `expire_time`.
                # Note: Cloud Spanner might continue to accept requests for a few seconds
                # after the database has been deleted.
                rpc :DropDatabase, ::Google::Cloud::Spanner::Admin::Database::V1::DropDatabaseRequest, ::Google::Protobuf::Empty
                # Returns the schema of a Cloud Spanner database as a list of formatted
                # DDL statements. This method does not show pending schema updates, those may
                # be queried using the [Operations][google.longrunning.Operations] API.
                rpc :GetDatabaseDdl, ::Google::Cloud::Spanner::Admin::Database::V1::GetDatabaseDdlRequest, ::Google::Cloud::Spanner::Admin::Database::V1::GetDatabaseDdlResponse
                # Sets the access control policy on a database or backup resource.
                # Replaces any existing policy.
                #
                # Authorization requires `spanner.databases.setIamPolicy`
                # permission on [resource][google.iam.v1.SetIamPolicyRequest.resource].
                # For backups, authorization requires `spanner.backups.setIamPolicy`
                # permission on [resource][google.iam.v1.SetIamPolicyRequest.resource].
                rpc :SetIamPolicy, ::Google::Iam::V1::SetIamPolicyRequest, ::Google::Iam::V1::Policy
                # Gets the access control policy for a database or backup resource.
                # Returns an empty policy if a database or backup exists but does not have a
                # policy set.
                #
                # Authorization requires `spanner.databases.getIamPolicy` permission on
                # [resource][google.iam.v1.GetIamPolicyRequest.resource].
                # For backups, authorization requires `spanner.backups.getIamPolicy`
                # permission on [resource][google.iam.v1.GetIamPolicyRequest.resource].
                rpc :GetIamPolicy, ::Google::Iam::V1::GetIamPolicyRequest, ::Google::Iam::V1::Policy
                # Returns permissions that the caller has on the specified database or backup
                # resource.
                #
                # Attempting this RPC on a non-existent Cloud Spanner database will
                # result in a NOT_FOUND error if the user has
                # `spanner.databases.list` permission on the containing Cloud
                # Spanner instance. Otherwise returns an empty set of permissions.
                # Calling this method on a backup that does not exist will
                # result in a NOT_FOUND error if the user has
                # `spanner.backups.list` permission on the containing instance.
                rpc :TestIamPermissions, ::Google::Iam::V1::TestIamPermissionsRequest, ::Google::Iam::V1::TestIamPermissionsResponse
                # Starts creating a new Cloud Spanner Backup.
                # The returned backup [long-running operation][google.longrunning.Operation]
                # will have a name of the format
                # `projects/<project>/instances/<instance>/backups/<backup>/operations/<operation_id>`
                # and can be used to track creation of the backup. The
                # [metadata][google.longrunning.Operation.metadata] field type is
                # [CreateBackupMetadata][google.spanner.admin.database.v1.CreateBackupMetadata].
                # The [response][google.longrunning.Operation.response] field type is
                # [Backup][google.spanner.admin.database.v1.Backup], if successful.
                # Cancelling the returned operation will stop the creation and delete the
                # backup. There can be only one pending backup creation per database. Backup
                # creation of different databases can run concurrently.
                rpc :CreateBackup, ::Google::Cloud::Spanner::Admin::Database::V1::CreateBackupRequest, ::Google::Longrunning::Operation
                # Starts copying a Cloud Spanner Backup.
                # The returned backup [long-running operation][google.longrunning.Operation]
                # will have a name of the format
                # `projects/<project>/instances/<instance>/backups/<backup>/operations/<operation_id>`
                # and can be used to track copying of the backup. The operation is associated
                # with the destination backup.
                # The [metadata][google.longrunning.Operation.metadata] field type is
                # [CopyBackupMetadata][google.spanner.admin.database.v1.CopyBackupMetadata].
                # The [response][google.longrunning.Operation.response] field type is
                # [Backup][google.spanner.admin.database.v1.Backup], if successful.
                # Cancelling the returned operation will stop the copying and delete the
                # destination backup. Concurrent CopyBackup requests can run on the same
                # source backup.
                rpc :CopyBackup, ::Google::Cloud::Spanner::Admin::Database::V1::CopyBackupRequest, ::Google::Longrunning::Operation
                # Gets metadata on a pending or completed
                # [Backup][google.spanner.admin.database.v1.Backup].
                rpc :GetBackup, ::Google::Cloud::Spanner::Admin::Database::V1::GetBackupRequest, ::Google::Cloud::Spanner::Admin::Database::V1::Backup
                # Updates a pending or completed
                # [Backup][google.spanner.admin.database.v1.Backup].
                rpc :UpdateBackup, ::Google::Cloud::Spanner::Admin::Database::V1::UpdateBackupRequest, ::Google::Cloud::Spanner::Admin::Database::V1::Backup
                # Deletes a pending or completed
                # [Backup][google.spanner.admin.database.v1.Backup].
                rpc :DeleteBackup, ::Google::Cloud::Spanner::Admin::Database::V1::DeleteBackupRequest, ::Google::Protobuf::Empty
                # Lists completed and pending backups.
                # Backups returned are ordered by `create_time` in descending order,
                # starting from the most recent `create_time`.
                rpc :ListBackups, ::Google::Cloud::Spanner::Admin::Database::V1::ListBackupsRequest, ::Google::Cloud::Spanner::Admin::Database::V1::ListBackupsResponse
                # Create a new database by restoring from a completed backup. The new
                # database must be in the same project and in an instance with the same
                # instance configuration as the instance containing
                # the backup. The returned database [long-running
                # operation][google.longrunning.Operation] has a name of the format
                # `projects/<project>/instances/<instance>/databases/<database>/operations/<operation_id>`,
                # and can be used to track the progress of the operation, and to cancel it.
                # The [metadata][google.longrunning.Operation.metadata] field type is
                # [RestoreDatabaseMetadata][google.spanner.admin.database.v1.RestoreDatabaseMetadata].
                # The [response][google.longrunning.Operation.response] type
                # is [Database][google.spanner.admin.database.v1.Database], if
                # successful. Cancelling the returned operation will stop the restore and
                # delete the database.
                # There can be only one database being restored into an instance at a time.
                # Once the restore operation completes, a new restore operation can be
                # initiated, without waiting for the optimize operation associated with the
                # first restore to complete.
                rpc :RestoreDatabase, ::Google::Cloud::Spanner::Admin::Database::V1::RestoreDatabaseRequest, ::Google::Longrunning::Operation
                # Lists database [longrunning-operations][google.longrunning.Operation].
                # A database operation has a name of the form
                # `projects/<project>/instances/<instance>/databases/<database>/operations/<operation>`.
                # The long-running operation
                # [metadata][google.longrunning.Operation.metadata] field type
                # `metadata.type_url` describes the type of the metadata. Operations returned
                # include those that have completed/failed/canceled within the last 7 days,
                # and pending operations.
                rpc :ListDatabaseOperations, ::Google::Cloud::Spanner::Admin::Database::V1::ListDatabaseOperationsRequest, ::Google::Cloud::Spanner::Admin::Database::V1::ListDatabaseOperationsResponse
                # Lists the backup [long-running operations][google.longrunning.Operation] in
                # the given instance. A backup operation has a name of the form
                # `projects/<project>/instances/<instance>/backups/<backup>/operations/<operation>`.
                # The long-running operation
                # [metadata][google.longrunning.Operation.metadata] field type
                # `metadata.type_url` describes the type of the metadata. Operations returned
                # include those that have completed/failed/canceled within the last 7 days,
                # and pending operations. Operations returned are ordered by
                # `operation.metadata.value.progress.start_time` in descending order starting
                # from the most recently started operation.
                rpc :ListBackupOperations, ::Google::Cloud::Spanner::Admin::Database::V1::ListBackupOperationsRequest, ::Google::Cloud::Spanner::Admin::Database::V1::ListBackupOperationsResponse
                # Lists Cloud Spanner database roles.
                rpc :ListDatabaseRoles, ::Google::Cloud::Spanner::Admin::Database::V1::ListDatabaseRolesRequest, ::Google::Cloud::Spanner::Admin::Database::V1::ListDatabaseRolesResponse
                # Adds split points to specified tables, indexes of a database.
                rpc :AddSplitPoints, ::Google::Cloud::Spanner::Admin::Database::V1::AddSplitPointsRequest, ::Google::Cloud::Spanner::Admin::Database::V1::AddSplitPointsResponse
                # Creates a new backup schedule.
                rpc :CreateBackupSchedule, ::Google::Cloud::Spanner::Admin::Database::V1::CreateBackupScheduleRequest, ::Google::Cloud::Spanner::Admin::Database::V1::BackupSchedule
                # Gets backup schedule for the input schedule name.
                rpc :GetBackupSchedule, ::Google::Cloud::Spanner::Admin::Database::V1::GetBackupScheduleRequest, ::Google::Cloud::Spanner::Admin::Database::V1::BackupSchedule
                # Updates a backup schedule.
                rpc :UpdateBackupSchedule, ::Google::Cloud::Spanner::Admin::Database::V1::UpdateBackupScheduleRequest, ::Google::Cloud::Spanner::Admin::Database::V1::BackupSchedule
                # Deletes a backup schedule.
                rpc :DeleteBackupSchedule, ::Google::Cloud::Spanner::Admin::Database::V1::DeleteBackupScheduleRequest, ::Google::Protobuf::Empty
                # Lists all the backup schedules for the database.
                rpc :ListBackupSchedules, ::Google::Cloud::Spanner::Admin::Database::V1::ListBackupSchedulesRequest, ::Google::Cloud::Spanner::Admin::Database::V1::ListBackupSchedulesResponse
                # This is an internal API called by Spanner Graph jobs. You should never need
                # to call this API directly.
                rpc :InternalUpdateGraphOperation, ::Google::Cloud::Spanner::Admin::Database::V1::InternalUpdateGraphOperationRequest, ::Google::Cloud::Spanner::Admin::Database::V1::InternalUpdateGraphOperationResponse
              end

              Stub = Service.rpc_stub_class
            end
          end
        end
      end
    end
  end
end
