# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/spanner/admin/database/v1/spanner_database_admin_pb"

module Google
  module Cloud
    module Spanner
      module Admin
        module Database
          module V1
            module DatabaseAdmin
              module Rest
                ##
                # REST service stub for the DatabaseAdmin service.
                # Service stub contains baseline method implementations
                # including transcoding, making the REST call, and deserialing the response.
                #
                class ServiceStub
                  # @private
                  def initialize endpoint:, endpoint_template:, universe_domain:, credentials:, logger:
                    # These require statements are intentionally placed here to initialize
                    # the REST modules only when it's required.
                    require "gapic/rest"

                    @client_stub = ::Gapic::Rest::ClientStub.new endpoint: endpoint,
                                                                 endpoint_template: endpoint_template,
                                                                 universe_domain: universe_domain,
                                                                 credentials: credentials,
                                                                 numeric_enums: true,
                                                                 service_name: self.class,
                                                                 raise_faraday_errors: false,
                                                                 logger: logger
                  end

                  ##
                  # The effective universe domain
                  #
                  # @return [String]
                  #
                  def universe_domain
                    @client_stub.universe_domain
                  end

                  ##
                  # The effective endpoint
                  #
                  # @return [String]
                  #
                  def endpoint
                    @client_stub.endpoint
                  end

                  ##
                  # The logger used for request/response debug logging.
                  #
                  # @return [Logger]
                  #
                  def logger stub: false
                    stub ? @client_stub.stub_logger : @client_stub.logger
                  end

                  ##
                  # Baseline implementation for the list_databases REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::ListDatabasesRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Spanner::Admin::Database::V1::ListDatabasesResponse]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Spanner::Admin::Database::V1::ListDatabasesResponse]
                  #   A result object deserialized from the server's reply
                  def list_databases request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_list_databases_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "list_databases",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Spanner::Admin::Database::V1::ListDatabasesResponse.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the create_database REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::CreateDatabaseRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Longrunning::Operation]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Longrunning::Operation]
                  #   A result object deserialized from the server's reply
                  def create_database request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_create_database_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "create_database",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Longrunning::Operation.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the get_database REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::GetDatabaseRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Spanner::Admin::Database::V1::Database]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Spanner::Admin::Database::V1::Database]
                  #   A result object deserialized from the server's reply
                  def get_database request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_get_database_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "get_database",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Spanner::Admin::Database::V1::Database.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the update_database REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::UpdateDatabaseRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Longrunning::Operation]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Longrunning::Operation]
                  #   A result object deserialized from the server's reply
                  def update_database request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_update_database_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "update_database",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Longrunning::Operation.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the update_database_ddl REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::UpdateDatabaseDdlRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Longrunning::Operation]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Longrunning::Operation]
                  #   A result object deserialized from the server's reply
                  def update_database_ddl request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_update_database_ddl_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "update_database_ddl",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Longrunning::Operation.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the drop_database REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::DropDatabaseRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Protobuf::Empty]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Protobuf::Empty]
                  #   A result object deserialized from the server's reply
                  def drop_database request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_drop_database_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "drop_database",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Protobuf::Empty.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the get_database_ddl REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::GetDatabaseDdlRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Spanner::Admin::Database::V1::GetDatabaseDdlResponse]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Spanner::Admin::Database::V1::GetDatabaseDdlResponse]
                  #   A result object deserialized from the server's reply
                  def get_database_ddl request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_get_database_ddl_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "get_database_ddl",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Spanner::Admin::Database::V1::GetDatabaseDdlResponse.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the set_iam_policy REST call
                  #
                  # @param request_pb [::Google::Iam::V1::SetIamPolicyRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Iam::V1::Policy]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Iam::V1::Policy]
                  #   A result object deserialized from the server's reply
                  def set_iam_policy request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_set_iam_policy_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "set_iam_policy",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Iam::V1::Policy.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the get_iam_policy REST call
                  #
                  # @param request_pb [::Google::Iam::V1::GetIamPolicyRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Iam::V1::Policy]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Iam::V1::Policy]
                  #   A result object deserialized from the server's reply
                  def get_iam_policy request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_get_iam_policy_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "get_iam_policy",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Iam::V1::Policy.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the test_iam_permissions REST call
                  #
                  # @param request_pb [::Google::Iam::V1::TestIamPermissionsRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Iam::V1::TestIamPermissionsResponse]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Iam::V1::TestIamPermissionsResponse]
                  #   A result object deserialized from the server's reply
                  def test_iam_permissions request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_test_iam_permissions_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "test_iam_permissions",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Iam::V1::TestIamPermissionsResponse.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the create_backup REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::CreateBackupRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Longrunning::Operation]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Longrunning::Operation]
                  #   A result object deserialized from the server's reply
                  def create_backup request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_create_backup_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "create_backup",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Longrunning::Operation.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the copy_backup REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::CopyBackupRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Longrunning::Operation]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Longrunning::Operation]
                  #   A result object deserialized from the server's reply
                  def copy_backup request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_copy_backup_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "copy_backup",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Longrunning::Operation.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the get_backup REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::GetBackupRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Spanner::Admin::Database::V1::Backup]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Spanner::Admin::Database::V1::Backup]
                  #   A result object deserialized from the server's reply
                  def get_backup request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_get_backup_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "get_backup",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Spanner::Admin::Database::V1::Backup.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the update_backup REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::UpdateBackupRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Spanner::Admin::Database::V1::Backup]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Spanner::Admin::Database::V1::Backup]
                  #   A result object deserialized from the server's reply
                  def update_backup request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_update_backup_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "update_backup",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Spanner::Admin::Database::V1::Backup.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the delete_backup REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::DeleteBackupRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Protobuf::Empty]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Protobuf::Empty]
                  #   A result object deserialized from the server's reply
                  def delete_backup request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_delete_backup_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "delete_backup",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Protobuf::Empty.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the list_backups REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::ListBackupsRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Spanner::Admin::Database::V1::ListBackupsResponse]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Spanner::Admin::Database::V1::ListBackupsResponse]
                  #   A result object deserialized from the server's reply
                  def list_backups request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_list_backups_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "list_backups",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Spanner::Admin::Database::V1::ListBackupsResponse.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the restore_database REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::RestoreDatabaseRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Longrunning::Operation]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Longrunning::Operation]
                  #   A result object deserialized from the server's reply
                  def restore_database request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_restore_database_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "restore_database",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Longrunning::Operation.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the list_database_operations REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::ListDatabaseOperationsRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Spanner::Admin::Database::V1::ListDatabaseOperationsResponse]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Spanner::Admin::Database::V1::ListDatabaseOperationsResponse]
                  #   A result object deserialized from the server's reply
                  def list_database_operations request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_list_database_operations_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "list_database_operations",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Spanner::Admin::Database::V1::ListDatabaseOperationsResponse.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the list_backup_operations REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::ListBackupOperationsRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Spanner::Admin::Database::V1::ListBackupOperationsResponse]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Spanner::Admin::Database::V1::ListBackupOperationsResponse]
                  #   A result object deserialized from the server's reply
                  def list_backup_operations request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_list_backup_operations_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "list_backup_operations",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Spanner::Admin::Database::V1::ListBackupOperationsResponse.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the list_database_roles REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::ListDatabaseRolesRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Spanner::Admin::Database::V1::ListDatabaseRolesResponse]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Spanner::Admin::Database::V1::ListDatabaseRolesResponse]
                  #   A result object deserialized from the server's reply
                  def list_database_roles request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_list_database_roles_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "list_database_roles",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Spanner::Admin::Database::V1::ListDatabaseRolesResponse.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the add_split_points REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::AddSplitPointsRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Spanner::Admin::Database::V1::AddSplitPointsResponse]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Spanner::Admin::Database::V1::AddSplitPointsResponse]
                  #   A result object deserialized from the server's reply
                  def add_split_points request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_add_split_points_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "add_split_points",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Spanner::Admin::Database::V1::AddSplitPointsResponse.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the create_backup_schedule REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::CreateBackupScheduleRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Spanner::Admin::Database::V1::BackupSchedule]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Spanner::Admin::Database::V1::BackupSchedule]
                  #   A result object deserialized from the server's reply
                  def create_backup_schedule request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_create_backup_schedule_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "create_backup_schedule",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Spanner::Admin::Database::V1::BackupSchedule.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the get_backup_schedule REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::GetBackupScheduleRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Spanner::Admin::Database::V1::BackupSchedule]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Spanner::Admin::Database::V1::BackupSchedule]
                  #   A result object deserialized from the server's reply
                  def get_backup_schedule request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_get_backup_schedule_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "get_backup_schedule",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Spanner::Admin::Database::V1::BackupSchedule.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the update_backup_schedule REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::UpdateBackupScheduleRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Spanner::Admin::Database::V1::BackupSchedule]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Spanner::Admin::Database::V1::BackupSchedule]
                  #   A result object deserialized from the server's reply
                  def update_backup_schedule request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_update_backup_schedule_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "update_backup_schedule",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Spanner::Admin::Database::V1::BackupSchedule.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the delete_backup_schedule REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::DeleteBackupScheduleRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Protobuf::Empty]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Protobuf::Empty]
                  #   A result object deserialized from the server's reply
                  def delete_backup_schedule request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_delete_backup_schedule_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "delete_backup_schedule",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Protobuf::Empty.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the list_backup_schedules REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::ListBackupSchedulesRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Spanner::Admin::Database::V1::ListBackupSchedulesResponse]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Spanner::Admin::Database::V1::ListBackupSchedulesResponse]
                  #   A result object deserialized from the server's reply
                  def list_backup_schedules request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_list_backup_schedules_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "list_backup_schedules",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Spanner::Admin::Database::V1::ListBackupSchedulesResponse.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the list_databases REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::ListDatabasesRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_list_databases_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :get,
                                                              uri_template: "/v1/{parent}/databases",
                                                              matches: [
                                                                ["parent", %r{^projects/[^/]+/instances/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the create_database REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::CreateDatabaseRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_create_database_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :post,
                                                              uri_template: "/v1/{parent}/databases",
                                                              body: "*",
                                                              matches: [
                                                                ["parent", %r{^projects/[^/]+/instances/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the get_database REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::GetDatabaseRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_get_database_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :get,
                                                              uri_template: "/v1/{name}",
                                                              matches: [
                                                                ["name", %r{^projects/[^/]+/instances/[^/]+/databases/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the update_database REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::UpdateDatabaseRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_update_database_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :patch,
                                                              uri_template: "/v1/{database.name}",
                                                              body: "database",
                                                              matches: [
                                                                ["database.name", %r{^projects/[^/]+/instances/[^/]+/databases/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the update_database_ddl REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::UpdateDatabaseDdlRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_update_database_ddl_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :patch,
                                                              uri_template: "/v1/{database}/ddl",
                                                              body: "*",
                                                              matches: [
                                                                ["database", %r{^projects/[^/]+/instances/[^/]+/databases/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the drop_database REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::DropDatabaseRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_drop_database_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :delete,
                                                              uri_template: "/v1/{database}",
                                                              matches: [
                                                                ["database", %r{^projects/[^/]+/instances/[^/]+/databases/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the get_database_ddl REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::GetDatabaseDdlRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_get_database_ddl_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :get,
                                                              uri_template: "/v1/{database}/ddl",
                                                              matches: [
                                                                ["database", %r{^projects/[^/]+/instances/[^/]+/databases/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the set_iam_policy REST call
                  #
                  # @param request_pb [::Google::Iam::V1::SetIamPolicyRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_set_iam_policy_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :post,
                                                              uri_template: "/v1/{resource}:setIamPolicy",
                                                              body: "*",
                                                              matches: [
                                                                ["resource", %r{^projects/[^/]+/instances/[^/]+/databases/[^/]+/?$}, false]
                                                              ]
                                                            )
                                                            .with_bindings(
                                                              uri_method: :post,
                                                              uri_template: "/v1/{resource}:setIamPolicy",
                                                              body: "*",
                                                              matches: [
                                                                ["resource", %r{^projects/[^/]+/instances/[^/]+/backups/[^/]+/?$}, false]
                                                              ]
                                                            )
                                                            .with_bindings(
                                                              uri_method: :post,
                                                              uri_template: "/v1/{resource}:setIamPolicy",
                                                              body: "*",
                                                              matches: [
                                                                ["resource", %r{^projects/[^/]+/instances/[^/]+/databases/[^/]+/backupSchedules/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the get_iam_policy REST call
                  #
                  # @param request_pb [::Google::Iam::V1::GetIamPolicyRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_get_iam_policy_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :post,
                                                              uri_template: "/v1/{resource}:getIamPolicy",
                                                              body: "*",
                                                              matches: [
                                                                ["resource", %r{^projects/[^/]+/instances/[^/]+/databases/[^/]+/?$}, false]
                                                              ]
                                                            )
                                                            .with_bindings(
                                                              uri_method: :post,
                                                              uri_template: "/v1/{resource}:getIamPolicy",
                                                              body: "*",
                                                              matches: [
                                                                ["resource", %r{^projects/[^/]+/instances/[^/]+/backups/[^/]+/?$}, false]
                                                              ]
                                                            )
                                                            .with_bindings(
                                                              uri_method: :post,
                                                              uri_template: "/v1/{resource}:getIamPolicy",
                                                              body: "*",
                                                              matches: [
                                                                ["resource", %r{^projects/[^/]+/instances/[^/]+/databases/[^/]+/backupSchedules/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the test_iam_permissions REST call
                  #
                  # @param request_pb [::Google::Iam::V1::TestIamPermissionsRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_test_iam_permissions_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :post,
                                                              uri_template: "/v1/{resource}:testIamPermissions",
                                                              body: "*",
                                                              matches: [
                                                                ["resource", %r{^projects/[^/]+/instances/[^/]+/databases/[^/]+/?$}, false]
                                                              ]
                                                            )
                                                            .with_bindings(
                                                              uri_method: :post,
                                                              uri_template: "/v1/{resource}:testIamPermissions",
                                                              body: "*",
                                                              matches: [
                                                                ["resource", %r{^projects/[^/]+/instances/[^/]+/backups/[^/]+/?$}, false]
                                                              ]
                                                            )
                                                            .with_bindings(
                                                              uri_method: :post,
                                                              uri_template: "/v1/{resource}:testIamPermissions",
                                                              body: "*",
                                                              matches: [
                                                                ["resource", %r{^projects/[^/]+/instances/[^/]+/databases/[^/]+/backupSchedules/[^/]+/?$}, false]
                                                              ]
                                                            )
                                                            .with_bindings(
                                                              uri_method: :post,
                                                              uri_template: "/v1/{resource}:testIamPermissions",
                                                              body: "*",
                                                              matches: [
                                                                ["resource", %r{^projects/[^/]+/instances/[^/]+/databases/[^/]+/databaseRoles/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the create_backup REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::CreateBackupRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_create_backup_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :post,
                                                              uri_template: "/v1/{parent}/backups",
                                                              body: "backup",
                                                              matches: [
                                                                ["parent", %r{^projects/[^/]+/instances/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the copy_backup REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::CopyBackupRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_copy_backup_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :post,
                                                              uri_template: "/v1/{parent}/backups:copy",
                                                              body: "*",
                                                              matches: [
                                                                ["parent", %r{^projects/[^/]+/instances/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the get_backup REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::GetBackupRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_get_backup_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :get,
                                                              uri_template: "/v1/{name}",
                                                              matches: [
                                                                ["name", %r{^projects/[^/]+/instances/[^/]+/backups/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the update_backup REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::UpdateBackupRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_update_backup_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :patch,
                                                              uri_template: "/v1/{backup.name}",
                                                              body: "backup",
                                                              matches: [
                                                                ["backup.name", %r{^projects/[^/]+/instances/[^/]+/backups/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the delete_backup REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::DeleteBackupRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_delete_backup_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :delete,
                                                              uri_template: "/v1/{name}",
                                                              matches: [
                                                                ["name", %r{^projects/[^/]+/instances/[^/]+/backups/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the list_backups REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::ListBackupsRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_list_backups_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :get,
                                                              uri_template: "/v1/{parent}/backups",
                                                              matches: [
                                                                ["parent", %r{^projects/[^/]+/instances/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the restore_database REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::RestoreDatabaseRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_restore_database_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :post,
                                                              uri_template: "/v1/{parent}/databases:restore",
                                                              body: "*",
                                                              matches: [
                                                                ["parent", %r{^projects/[^/]+/instances/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the list_database_operations REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::ListDatabaseOperationsRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_list_database_operations_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :get,
                                                              uri_template: "/v1/{parent}/databaseOperations",
                                                              matches: [
                                                                ["parent", %r{^projects/[^/]+/instances/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the list_backup_operations REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::ListBackupOperationsRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_list_backup_operations_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :get,
                                                              uri_template: "/v1/{parent}/backupOperations",
                                                              matches: [
                                                                ["parent", %r{^projects/[^/]+/instances/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the list_database_roles REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::ListDatabaseRolesRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_list_database_roles_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :get,
                                                              uri_template: "/v1/{parent}/databaseRoles",
                                                              matches: [
                                                                ["parent", %r{^projects/[^/]+/instances/[^/]+/databases/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the add_split_points REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::AddSplitPointsRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_add_split_points_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :post,
                                                              uri_template: "/v1/{database}:addSplitPoints",
                                                              body: "*",
                                                              matches: [
                                                                ["database", %r{^projects/[^/]+/instances/[^/]+/databases/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the create_backup_schedule REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::CreateBackupScheduleRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_create_backup_schedule_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :post,
                                                              uri_template: "/v1/{parent}/backupSchedules",
                                                              body: "backup_schedule",
                                                              matches: [
                                                                ["parent", %r{^projects/[^/]+/instances/[^/]+/databases/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the get_backup_schedule REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::GetBackupScheduleRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_get_backup_schedule_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :get,
                                                              uri_template: "/v1/{name}",
                                                              matches: [
                                                                ["name", %r{^projects/[^/]+/instances/[^/]+/databases/[^/]+/backupSchedules/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the update_backup_schedule REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::UpdateBackupScheduleRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_update_backup_schedule_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :patch,
                                                              uri_template: "/v1/{backup_schedule.name}",
                                                              body: "backup_schedule",
                                                              matches: [
                                                                ["backup_schedule.name", %r{^projects/[^/]+/instances/[^/]+/databases/[^/]+/backupSchedules/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the delete_backup_schedule REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::DeleteBackupScheduleRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_delete_backup_schedule_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :delete,
                                                              uri_template: "/v1/{name}",
                                                              matches: [
                                                                ["name", %r{^projects/[^/]+/instances/[^/]+/databases/[^/]+/backupSchedules/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the list_backup_schedules REST call
                  #
                  # @param request_pb [::Google::Cloud::Spanner::Admin::Database::V1::ListBackupSchedulesRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_list_backup_schedules_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :get,
                                                              uri_template: "/v1/{parent}/backupSchedules",
                                                              matches: [
                                                                ["parent", %r{^projects/[^/]+/instances/[^/]+/databases/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
