# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/spanner/admin/database/v1/spanner_database_admin_pb"
require "google/cloud/spanner/admin/database/v1/database_admin/rest/service_stub"

module Google
  module Cloud
    module Spanner
      module Admin
        module Database
          module V1
            module DatabaseAdmin
              module Rest
                ##
                # REST client for the DatabaseAdmin service.
                #
                # Cloud Spanner Database Admin API
                #
                # The Cloud Spanner Database Admin API can be used to:
                #   * create, drop, and list databases
                #   * update the schema of pre-existing databases
                #   * create, delete, copy and list backups for a database
                #   * restore a database from an existing backup
                #
                class Client
                  # @private
                  API_VERSION = ""

                  # @private
                  DEFAULT_ENDPOINT_TEMPLATE = "spanner.$UNIVERSE_DOMAIN$"

                  include Paths

                  # @private
                  attr_reader :database_admin_stub

                  ##
                  # Configure the DatabaseAdmin Client class.
                  #
                  # See {::Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Rest::Client::Configuration}
                  # for a description of the configuration fields.
                  #
                  # @example
                  #
                  #   # Modify the configuration for all DatabaseAdmin clients
                  #   ::Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Rest::Client.configure do |config|
                  #     config.timeout = 10.0
                  #   end
                  #
                  # @yield [config] Configure the Client client.
                  # @yieldparam config [Client::Configuration]
                  #
                  # @return [Client::Configuration]
                  #
                  def self.configure
                    @configure ||= begin
                      namespace = ["Google", "Cloud", "Spanner", "Admin", "Database", "V1"]
                      parent_config = while namespace.any?
                                        parent_name = namespace.join "::"
                                        parent_const = const_get parent_name
                                        break parent_const.configure if parent_const.respond_to? :configure
                                        namespace.pop
                                      end
                      default_config = Client::Configuration.new parent_config

                      default_config.rpcs.list_databases.timeout = 3600.0
                      default_config.rpcs.list_databases.retry_policy = {
                        initial_delay: 1.0, max_delay: 32.0, multiplier: 1.3, retry_codes: [14, 4]
                      }

                      default_config.rpcs.create_database.timeout = 3600.0

                      default_config.rpcs.get_database.timeout = 3600.0
                      default_config.rpcs.get_database.retry_policy = {
                        initial_delay: 1.0, max_delay: 32.0, multiplier: 1.3, retry_codes: [14, 4]
                      }

                      default_config.rpcs.update_database.timeout = 3600.0
                      default_config.rpcs.update_database.retry_policy = {
                        initial_delay: 1.0, max_delay: 32.0, multiplier: 1.3, retry_codes: [14, 4]
                      }

                      default_config.rpcs.update_database_ddl.timeout = 3600.0
                      default_config.rpcs.update_database_ddl.retry_policy = {
                        initial_delay: 1.0, max_delay: 32.0, multiplier: 1.3, retry_codes: [14, 4]
                      }

                      default_config.rpcs.drop_database.timeout = 3600.0
                      default_config.rpcs.drop_database.retry_policy = {
                        initial_delay: 1.0, max_delay: 32.0, multiplier: 1.3, retry_codes: [14, 4]
                      }

                      default_config.rpcs.get_database_ddl.timeout = 3600.0
                      default_config.rpcs.get_database_ddl.retry_policy = {
                        initial_delay: 1.0, max_delay: 32.0, multiplier: 1.3, retry_codes: [14, 4]
                      }

                      default_config.rpcs.set_iam_policy.timeout = 30.0

                      default_config.rpcs.get_iam_policy.timeout = 30.0
                      default_config.rpcs.get_iam_policy.retry_policy = {
                        initial_delay: 1.0, max_delay: 32.0, multiplier: 1.3, retry_codes: [14, 4]
                      }

                      default_config.rpcs.test_iam_permissions.timeout = 30.0

                      default_config.rpcs.create_backup.timeout = 3600.0

                      default_config.rpcs.copy_backup.timeout = 3600.0

                      default_config.rpcs.get_backup.timeout = 3600.0
                      default_config.rpcs.get_backup.retry_policy = {
                        initial_delay: 1.0, max_delay: 32.0, multiplier: 1.3, retry_codes: [14, 4]
                      }

                      default_config.rpcs.update_backup.timeout = 3600.0
                      default_config.rpcs.update_backup.retry_policy = {
                        initial_delay: 1.0, max_delay: 32.0, multiplier: 1.3, retry_codes: [14, 4]
                      }

                      default_config.rpcs.delete_backup.timeout = 3600.0
                      default_config.rpcs.delete_backup.retry_policy = {
                        initial_delay: 1.0, max_delay: 32.0, multiplier: 1.3, retry_codes: [14, 4]
                      }

                      default_config.rpcs.list_backups.timeout = 3600.0
                      default_config.rpcs.list_backups.retry_policy = {
                        initial_delay: 1.0, max_delay: 32.0, multiplier: 1.3, retry_codes: [14, 4]
                      }

                      default_config.rpcs.restore_database.timeout = 3600.0

                      default_config.rpcs.list_database_operations.timeout = 3600.0
                      default_config.rpcs.list_database_operations.retry_policy = {
                        initial_delay: 1.0, max_delay: 32.0, multiplier: 1.3, retry_codes: [14, 4]
                      }

                      default_config.rpcs.list_backup_operations.timeout = 3600.0
                      default_config.rpcs.list_backup_operations.retry_policy = {
                        initial_delay: 1.0, max_delay: 32.0, multiplier: 1.3, retry_codes: [14, 4]
                      }

                      default_config.rpcs.list_database_roles.timeout = 3600.0
                      default_config.rpcs.list_database_roles.retry_policy = {
                        initial_delay: 1.0, max_delay: 32.0, multiplier: 1.3, retry_codes: [14, 4]
                      }

                      default_config.rpcs.add_split_points.timeout = 3600.0
                      default_config.rpcs.add_split_points.retry_policy = {
                        initial_delay: 1.0, max_delay: 32.0, multiplier: 1.3, retry_codes: [14, 4]
                      }

                      default_config.rpcs.create_backup_schedule.timeout = 3600.0
                      default_config.rpcs.create_backup_schedule.retry_policy = {
                        initial_delay: 1.0, max_delay: 32.0, multiplier: 1.3, retry_codes: [14, 4]
                      }

                      default_config.rpcs.get_backup_schedule.timeout = 3600.0
                      default_config.rpcs.get_backup_schedule.retry_policy = {
                        initial_delay: 1.0, max_delay: 32.0, multiplier: 1.3, retry_codes: [14, 4]
                      }

                      default_config.rpcs.update_backup_schedule.timeout = 3600.0
                      default_config.rpcs.update_backup_schedule.retry_policy = {
                        initial_delay: 1.0, max_delay: 32.0, multiplier: 1.3, retry_codes: [14, 4]
                      }

                      default_config.rpcs.delete_backup_schedule.timeout = 3600.0
                      default_config.rpcs.delete_backup_schedule.retry_policy = {
                        initial_delay: 1.0, max_delay: 32.0, multiplier: 1.3, retry_codes: [14, 4]
                      }

                      default_config.rpcs.list_backup_schedules.timeout = 3600.0
                      default_config.rpcs.list_backup_schedules.retry_policy = {
                        initial_delay: 1.0, max_delay: 32.0, multiplier: 1.3, retry_codes: [14, 4]
                      }

                      default_config
                    end
                    yield @configure if block_given?
                    @configure
                  end

                  ##
                  # Configure the DatabaseAdmin Client instance.
                  #
                  # The configuration is set to the derived mode, meaning that values can be changed,
                  # but structural changes (adding new fields, etc.) are not allowed. Structural changes
                  # should be made on {Client.configure}.
                  #
                  # See {::Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Rest::Client::Configuration}
                  # for a description of the configuration fields.
                  #
                  # @yield [config] Configure the Client client.
                  # @yieldparam config [Client::Configuration]
                  #
                  # @return [Client::Configuration]
                  #
                  def configure
                    yield @config if block_given?
                    @config
                  end

                  ##
                  # The effective universe domain
                  #
                  # @return [String]
                  #
                  def universe_domain
                    @database_admin_stub.universe_domain
                  end

                  ##
                  # Create a new DatabaseAdmin REST client object.
                  #
                  # @example
                  #
                  #   # Create a client using the default configuration
                  #   client = ::Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Rest::Client.new
                  #
                  #   # Create a client using a custom configuration
                  #   client = ::Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Rest::Client.new do |config|
                  #     config.timeout = 10.0
                  #   end
                  #
                  # @yield [config] Configure the DatabaseAdmin client.
                  # @yieldparam config [Client::Configuration]
                  #
                  def initialize
                    # Create the configuration object
                    @config = Configuration.new Client.configure

                    # Yield the configuration if needed
                    yield @config if block_given?

                    # Create credentials
                    credentials = @config.credentials
                    # Use self-signed JWT if the endpoint is unchanged from default,
                    # but only if the default endpoint does not have a region prefix.
                    enable_self_signed_jwt = @config.endpoint.nil? ||
                                             (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                             !@config.endpoint.split(".").first.include?("-"))
                    credentials ||= Credentials.default scope: @config.scope,
                                                        enable_self_signed_jwt: enable_self_signed_jwt
                    if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                      credentials = Credentials.new credentials, scope: @config.scope
                    end

                    @quota_project_id = @config.quota_project
                    @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                    @operations_client = ::Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Rest::Operations.new do |config|
                      config.credentials = credentials
                      config.quota_project = @quota_project_id
                      config.endpoint = @config.endpoint
                      config.universe_domain = @config.universe_domain
                    end

                    @database_admin_stub = ::Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Rest::ServiceStub.new(
                      endpoint: @config.endpoint,
                      endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                      universe_domain: @config.universe_domain,
                      credentials: credentials,
                      logger: @config.logger
                    )

                    @database_admin_stub.logger(stub: true)&.info do |entry|
                      entry.set_system_name
                      entry.set_service
                      entry.message = "Created client for #{entry.service}"
                      entry.set_credentials_fields credentials
                      entry.set "customEndpoint", @config.endpoint if @config.endpoint
                      entry.set "defaultTimeout", @config.timeout if @config.timeout
                      entry.set "quotaProject", @quota_project_id if @quota_project_id
                    end
                  end

                  ##
                  # Get the associated client for long-running operations.
                  #
                  # @return [::Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Rest::Operations]
                  #
                  attr_reader :operations_client

                  ##
                  # The logger used for request/response debug logging.
                  #
                  # @return [Logger]
                  #
                  def logger
                    @database_admin_stub.logger
                  end

                  # Service calls

                  ##
                  # Lists Cloud Spanner databases.
                  #
                  # @overload list_databases(request, options = nil)
                  #   Pass arguments to `list_databases` via a request object, either of type
                  #   {::Google::Cloud::Spanner::Admin::Database::V1::ListDatabasesRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Spanner::Admin::Database::V1::ListDatabasesRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload list_databases(parent: nil, page_size: nil, page_token: nil)
                  #   Pass arguments to `list_databases` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param parent [::String]
                  #     Required. The instance whose databases should be listed.
                  #     Values are of the form `projects/<project>/instances/<instance>`.
                  #   @param page_size [::Integer]
                  #     Number of databases to be returned in the response. If 0 or less,
                  #     defaults to the server's maximum allowed page size.
                  #   @param page_token [::String]
                  #     If non-empty, `page_token` should contain a
                  #     {::Google::Cloud::Spanner::Admin::Database::V1::ListDatabasesResponse#next_page_token next_page_token}
                  #     from a previous
                  #     {::Google::Cloud::Spanner::Admin::Database::V1::ListDatabasesResponse ListDatabasesResponse}.
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Spanner::Admin::Database::V1::Database>]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Spanner::Admin::Database::V1::Database>]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/database/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Spanner::Admin::Database::V1::ListDatabasesRequest.new
                  #
                  #   # Call the list_databases method.
                  #   result = client.list_databases request
                  #
                  #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
                  #   # over elements, and API calls will be issued to fetch pages as needed.
                  #   result.each do |item|
                  #     # Each element is of type ::Google::Cloud::Spanner::Admin::Database::V1::Database.
                  #     p item
                  #   end
                  #
                  def list_databases request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::Admin::Database::V1::ListDatabasesRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.list_databases.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Database::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.list_databases.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.list_databases.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @database_admin_stub.list_databases request, options do |result, operation|
                      result = ::Gapic::Rest::PagedEnumerable.new @database_admin_stub, :list_databases, "databases", request, result, options
                      yield result, operation if block_given?
                      throw :response, result
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Creates a new Cloud Spanner database and starts to prepare it for serving.
                  # The returned {::Google::Longrunning::Operation long-running operation} will
                  # have a name of the format `<database_name>/operations/<operation_id>` and
                  # can be used to track preparation of the database. The
                  # {::Google::Longrunning::Operation#metadata metadata} field type is
                  # {::Google::Cloud::Spanner::Admin::Database::V1::CreateDatabaseMetadata CreateDatabaseMetadata}.
                  # The {::Google::Longrunning::Operation#response response} field type is
                  # {::Google::Cloud::Spanner::Admin::Database::V1::Database Database}, if successful.
                  #
                  # @overload create_database(request, options = nil)
                  #   Pass arguments to `create_database` via a request object, either of type
                  #   {::Google::Cloud::Spanner::Admin::Database::V1::CreateDatabaseRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Spanner::Admin::Database::V1::CreateDatabaseRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload create_database(parent: nil, create_statement: nil, extra_statements: nil, encryption_config: nil, database_dialect: nil, proto_descriptors: nil)
                  #   Pass arguments to `create_database` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param parent [::String]
                  #     Required. The name of the instance that will serve the new database.
                  #     Values are of the form `projects/<project>/instances/<instance>`.
                  #   @param create_statement [::String]
                  #     Required. A `CREATE DATABASE` statement, which specifies the ID of the
                  #     new database.  The database ID must conform to the regular expression
                  #     `[a-z][a-z0-9_\-]*[a-z0-9]` and be between 2 and 30 characters in length.
                  #     If the database ID is a reserved word or if it contains a hyphen, the
                  #     database ID must be enclosed in backticks (`` ` ``).
                  #   @param extra_statements [::Array<::String>]
                  #     Optional. A list of DDL statements to run inside the newly created
                  #     database. Statements can create tables, indexes, etc. These
                  #     statements execute atomically with the creation of the database:
                  #     if there is an error in any statement, the database is not created.
                  #   @param encryption_config [::Google::Cloud::Spanner::Admin::Database::V1::EncryptionConfig, ::Hash]
                  #     Optional. The encryption configuration for the database. If this field is
                  #     not specified, Cloud Spanner will encrypt/decrypt all data at rest using
                  #     Google default encryption.
                  #   @param database_dialect [::Google::Cloud::Spanner::Admin::Database::V1::DatabaseDialect]
                  #     Optional. The dialect of the Cloud Spanner Database.
                  #   @param proto_descriptors [::String]
                  #     Optional. Proto descriptors used by CREATE/ALTER PROTO BUNDLE statements in
                  #     'extra_statements' above.
                  #     Contains a protobuf-serialized
                  #     [google.protobuf.FileDescriptorSet](https://github.com/protocolbuffers/protobuf/blob/main/src/google/protobuf/descriptor.proto).
                  #     To generate it, [install](https://grpc.io/docs/protoc-installation/) and
                  #     run `protoc` with --include_imports and --descriptor_set_out. For example,
                  #     to generate for moon/shot/app.proto, run
                  #     ```
                  #     $protoc  --proto_path=/app_path --proto_path=/lib_path \
                  #              --include_imports \
                  #              --descriptor_set_out=descriptors.data \
                  #              moon/shot/app.proto
                  #     ```
                  #     For more details, see protobuffer [self
                  #     description](https://developers.google.com/protocol-buffers/docs/techniques#self-description).
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Gapic::Operation]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Gapic::Operation]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/database/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Spanner::Admin::Database::V1::CreateDatabaseRequest.new
                  #
                  #   # Call the create_database method.
                  #   result = client.create_database request
                  #
                  #   # The returned object is of type Gapic::Operation. You can use it to
                  #   # check the status of an operation, cancel it, or wait for results.
                  #   # Here is how to wait for a response.
                  #   result.wait_until_done! timeout: 60
                  #   if result.response?
                  #     p result.response
                  #   else
                  #     puts "No response received."
                  #   end
                  #
                  def create_database request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::Admin::Database::V1::CreateDatabaseRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.create_database.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Database::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.create_database.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.create_database.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @database_admin_stub.create_database request, options do |result, operation|
                      result = ::Gapic::Operation.new result, @operations_client, options: options
                      yield result, operation if block_given?
                      throw :response, result
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Gets the state of a Cloud Spanner database.
                  #
                  # @overload get_database(request, options = nil)
                  #   Pass arguments to `get_database` via a request object, either of type
                  #   {::Google::Cloud::Spanner::Admin::Database::V1::GetDatabaseRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Spanner::Admin::Database::V1::GetDatabaseRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload get_database(name: nil)
                  #   Pass arguments to `get_database` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param name [::String]
                  #     Required. The name of the requested database. Values are of the form
                  #     `projects/<project>/instances/<instance>/databases/<database>`.
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Spanner::Admin::Database::V1::Database]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Spanner::Admin::Database::V1::Database]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/database/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Spanner::Admin::Database::V1::GetDatabaseRequest.new
                  #
                  #   # Call the get_database method.
                  #   result = client.get_database request
                  #
                  #   # The returned object is of type Google::Cloud::Spanner::Admin::Database::V1::Database.
                  #   p result
                  #
                  def get_database request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::Admin::Database::V1::GetDatabaseRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.get_database.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Database::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.get_database.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.get_database.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @database_admin_stub.get_database request, options do |result, operation|
                      yield result, operation if block_given?
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Updates a Cloud Spanner database. The returned
                  # {::Google::Longrunning::Operation long-running operation} can be used to track
                  # the progress of updating the database. If the named database does not
                  # exist, returns `NOT_FOUND`.
                  #
                  # While the operation is pending:
                  #
                  #   * The database's
                  #     {::Google::Cloud::Spanner::Admin::Database::V1::Database#reconciling reconciling}
                  #     field is set to true.
                  #   * Cancelling the operation is best-effort. If the cancellation succeeds,
                  #     the operation metadata's
                  #     {::Google::Cloud::Spanner::Admin::Database::V1::UpdateDatabaseMetadata#cancel_time cancel_time}
                  #     is set, the updates are reverted, and the operation terminates with a
                  #     `CANCELLED` status.
                  #   * New UpdateDatabase requests will return a `FAILED_PRECONDITION` error
                  #     until the pending operation is done (returns successfully or with
                  #     error).
                  #   * Reading the database via the API continues to give the pre-request
                  #     values.
                  #
                  # Upon completion of the returned operation:
                  #
                  #   * The new values are in effect and readable via the API.
                  #   * The database's
                  #     {::Google::Cloud::Spanner::Admin::Database::V1::Database#reconciling reconciling}
                  #     field becomes false.
                  #
                  # The returned {::Google::Longrunning::Operation long-running operation} will
                  # have a name of the format
                  # `projects/<project>/instances/<instance>/databases/<database>/operations/<operation_id>`
                  # and can be used to track the database modification. The
                  # {::Google::Longrunning::Operation#metadata metadata} field type is
                  # {::Google::Cloud::Spanner::Admin::Database::V1::UpdateDatabaseMetadata UpdateDatabaseMetadata}.
                  # The {::Google::Longrunning::Operation#response response} field type is
                  # {::Google::Cloud::Spanner::Admin::Database::V1::Database Database}, if successful.
                  #
                  # @overload update_database(request, options = nil)
                  #   Pass arguments to `update_database` via a request object, either of type
                  #   {::Google::Cloud::Spanner::Admin::Database::V1::UpdateDatabaseRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Spanner::Admin::Database::V1::UpdateDatabaseRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload update_database(database: nil, update_mask: nil)
                  #   Pass arguments to `update_database` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param database [::Google::Cloud::Spanner::Admin::Database::V1::Database, ::Hash]
                  #     Required. The database to update.
                  #     The `name` field of the database is of the form
                  #     `projects/<project>/instances/<instance>/databases/<database>`.
                  #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
                  #     Required. The list of fields to update. Currently, only
                  #     `enable_drop_protection` field can be updated.
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Gapic::Operation]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Gapic::Operation]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/database/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Spanner::Admin::Database::V1::UpdateDatabaseRequest.new
                  #
                  #   # Call the update_database method.
                  #   result = client.update_database request
                  #
                  #   # The returned object is of type Gapic::Operation. You can use it to
                  #   # check the status of an operation, cancel it, or wait for results.
                  #   # Here is how to wait for a response.
                  #   result.wait_until_done! timeout: 60
                  #   if result.response?
                  #     p result.response
                  #   else
                  #     puts "No response received."
                  #   end
                  #
                  def update_database request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::Admin::Database::V1::UpdateDatabaseRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.update_database.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Database::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.update_database.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.update_database.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @database_admin_stub.update_database request, options do |result, operation|
                      result = ::Gapic::Operation.new result, @operations_client, options: options
                      yield result, operation if block_given?
                      throw :response, result
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Updates the schema of a Cloud Spanner database by
                  # creating/altering/dropping tables, columns, indexes, etc. The returned
                  # {::Google::Longrunning::Operation long-running operation} will have a name of
                  # the format `<database_name>/operations/<operation_id>` and can be used to
                  # track execution of the schema change(s). The
                  # {::Google::Longrunning::Operation#metadata metadata} field type is
                  # {::Google::Cloud::Spanner::Admin::Database::V1::UpdateDatabaseDdlMetadata UpdateDatabaseDdlMetadata}.
                  # The operation has no response.
                  #
                  # @overload update_database_ddl(request, options = nil)
                  #   Pass arguments to `update_database_ddl` via a request object, either of type
                  #   {::Google::Cloud::Spanner::Admin::Database::V1::UpdateDatabaseDdlRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Spanner::Admin::Database::V1::UpdateDatabaseDdlRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload update_database_ddl(database: nil, statements: nil, operation_id: nil, proto_descriptors: nil, throughput_mode: nil)
                  #   Pass arguments to `update_database_ddl` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param database [::String]
                  #     Required. The database to update.
                  #   @param statements [::Array<::String>]
                  #     Required. DDL statements to be applied to the database.
                  #   @param operation_id [::String]
                  #     If empty, the new update request is assigned an
                  #     automatically-generated operation ID. Otherwise, `operation_id`
                  #     is used to construct the name of the resulting
                  #     {::Google::Longrunning::Operation Operation}.
                  #
                  #     Specifying an explicit operation ID simplifies determining
                  #     whether the statements were executed in the event that the
                  #     {::Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Rest::Client#update_database_ddl UpdateDatabaseDdl}
                  #     call is replayed, or the return value is otherwise lost: the
                  #     {::Google::Cloud::Spanner::Admin::Database::V1::UpdateDatabaseDdlRequest#database database}
                  #     and `operation_id` fields can be combined to form the
                  #     {::Google::Longrunning::Operation#name name} of the resulting
                  #     {::Google::Longrunning::Operation longrunning.Operation}:
                  #     `<database>/operations/<operation_id>`.
                  #
                  #     `operation_id` should be unique within the database, and must be
                  #     a valid identifier: `[a-z][a-z0-9_]*`. Note that
                  #     automatically-generated operation IDs always begin with an
                  #     underscore. If the named operation already exists,
                  #     {::Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Rest::Client#update_database_ddl UpdateDatabaseDdl}
                  #     returns `ALREADY_EXISTS`.
                  #   @param proto_descriptors [::String]
                  #     Optional. Proto descriptors used by CREATE/ALTER PROTO BUNDLE statements.
                  #     Contains a protobuf-serialized
                  #     [google.protobuf.FileDescriptorSet](https://github.com/protocolbuffers/protobuf/blob/main/src/google/protobuf/descriptor.proto).
                  #     To generate it, [install](https://grpc.io/docs/protoc-installation/) and
                  #     run `protoc` with --include_imports and --descriptor_set_out. For example,
                  #     to generate for moon/shot/app.proto, run
                  #     ```
                  #     $protoc  --proto_path=/app_path --proto_path=/lib_path \
                  #              --include_imports \
                  #              --descriptor_set_out=descriptors.data \
                  #              moon/shot/app.proto
                  #     ```
                  #     For more details, see protobuffer [self
                  #     description](https://developers.google.com/protocol-buffers/docs/techniques#self-description).
                  #   @param throughput_mode [::Boolean]
                  #     Optional. This field is exposed to be used by the Spanner Migration Tool.
                  #     For more details, see
                  #     [SMT](https://github.com/GoogleCloudPlatform/spanner-migration-tool).
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Gapic::Operation]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Gapic::Operation]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/database/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Spanner::Admin::Database::V1::UpdateDatabaseDdlRequest.new
                  #
                  #   # Call the update_database_ddl method.
                  #   result = client.update_database_ddl request
                  #
                  #   # The returned object is of type Gapic::Operation. You can use it to
                  #   # check the status of an operation, cancel it, or wait for results.
                  #   # Here is how to wait for a response.
                  #   result.wait_until_done! timeout: 60
                  #   if result.response?
                  #     p result.response
                  #   else
                  #     puts "No response received."
                  #   end
                  #
                  def update_database_ddl request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::Admin::Database::V1::UpdateDatabaseDdlRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.update_database_ddl.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Database::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.update_database_ddl.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.update_database_ddl.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @database_admin_stub.update_database_ddl request, options do |result, operation|
                      result = ::Gapic::Operation.new result, @operations_client, options: options
                      yield result, operation if block_given?
                      throw :response, result
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Drops (aka deletes) a Cloud Spanner database.
                  # Completed backups for the database will be retained according to their
                  # `expire_time`.
                  # Note: Cloud Spanner might continue to accept requests for a few seconds
                  # after the database has been deleted.
                  #
                  # @overload drop_database(request, options = nil)
                  #   Pass arguments to `drop_database` via a request object, either of type
                  #   {::Google::Cloud::Spanner::Admin::Database::V1::DropDatabaseRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Spanner::Admin::Database::V1::DropDatabaseRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload drop_database(database: nil)
                  #   Pass arguments to `drop_database` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param database [::String]
                  #     Required. The database to be dropped.
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Protobuf::Empty]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Protobuf::Empty]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/database/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Spanner::Admin::Database::V1::DropDatabaseRequest.new
                  #
                  #   # Call the drop_database method.
                  #   result = client.drop_database request
                  #
                  #   # The returned object is of type Google::Protobuf::Empty.
                  #   p result
                  #
                  def drop_database request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::Admin::Database::V1::DropDatabaseRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.drop_database.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Database::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.drop_database.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.drop_database.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @database_admin_stub.drop_database request, options do |result, operation|
                      yield result, operation if block_given?
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Returns the schema of a Cloud Spanner database as a list of formatted
                  # DDL statements. This method does not show pending schema updates, those may
                  # be queried using the Operations API.
                  #
                  # @overload get_database_ddl(request, options = nil)
                  #   Pass arguments to `get_database_ddl` via a request object, either of type
                  #   {::Google::Cloud::Spanner::Admin::Database::V1::GetDatabaseDdlRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Spanner::Admin::Database::V1::GetDatabaseDdlRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload get_database_ddl(database: nil)
                  #   Pass arguments to `get_database_ddl` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param database [::String]
                  #     Required. The database whose schema we wish to get.
                  #     Values are of the form
                  #     `projects/<project>/instances/<instance>/databases/<database>`
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Spanner::Admin::Database::V1::GetDatabaseDdlResponse]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Spanner::Admin::Database::V1::GetDatabaseDdlResponse]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/database/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Spanner::Admin::Database::V1::GetDatabaseDdlRequest.new
                  #
                  #   # Call the get_database_ddl method.
                  #   result = client.get_database_ddl request
                  #
                  #   # The returned object is of type Google::Cloud::Spanner::Admin::Database::V1::GetDatabaseDdlResponse.
                  #   p result
                  #
                  def get_database_ddl request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::Admin::Database::V1::GetDatabaseDdlRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.get_database_ddl.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Database::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.get_database_ddl.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.get_database_ddl.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @database_admin_stub.get_database_ddl request, options do |result, operation|
                      yield result, operation if block_given?
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Sets the access control policy on a database or backup resource.
                  # Replaces any existing policy.
                  #
                  # Authorization requires `spanner.databases.setIamPolicy`
                  # permission on [resource][google.iam.v1.SetIamPolicyRequest.resource].
                  # For backups, authorization requires `spanner.backups.setIamPolicy`
                  # permission on [resource][google.iam.v1.SetIamPolicyRequest.resource].
                  #
                  # @overload set_iam_policy(request, options = nil)
                  #   Pass arguments to `set_iam_policy` via a request object, either of type
                  #   {::Google::Iam::V1::SetIamPolicyRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Iam::V1::SetIamPolicyRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload set_iam_policy(resource: nil, policy: nil, update_mask: nil)
                  #   Pass arguments to `set_iam_policy` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param resource [::String]
                  #     REQUIRED: The resource for which the policy is being specified.
                  #     See the operation documentation for the appropriate value for this field.
                  #   @param policy [::Google::Iam::V1::Policy, ::Hash]
                  #     REQUIRED: The complete policy to be applied to the `resource`. The size of
                  #     the policy is limited to a few 10s of KB. An empty policy is a
                  #     valid policy but certain Cloud Platform services (such as Projects)
                  #     might reject them.
                  #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
                  #     OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
                  #     the fields in the mask will be modified. If no mask is provided, the
                  #     following default mask is used:
                  #
                  #     `paths: "bindings, etag"`
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Iam::V1::Policy]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Iam::V1::Policy]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/database/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Iam::V1::SetIamPolicyRequest.new
                  #
                  #   # Call the set_iam_policy method.
                  #   result = client.set_iam_policy request
                  #
                  #   # The returned object is of type Google::Iam::V1::Policy.
                  #   p result
                  #
                  def set_iam_policy request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::SetIamPolicyRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.set_iam_policy.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Database::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.set_iam_policy.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.set_iam_policy.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @database_admin_stub.set_iam_policy request, options do |result, operation|
                      yield result, operation if block_given?
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Gets the access control policy for a database or backup resource.
                  # Returns an empty policy if a database or backup exists but does not have a
                  # policy set.
                  #
                  # Authorization requires `spanner.databases.getIamPolicy` permission on
                  # [resource][google.iam.v1.GetIamPolicyRequest.resource].
                  # For backups, authorization requires `spanner.backups.getIamPolicy`
                  # permission on [resource][google.iam.v1.GetIamPolicyRequest.resource].
                  #
                  # @overload get_iam_policy(request, options = nil)
                  #   Pass arguments to `get_iam_policy` via a request object, either of type
                  #   {::Google::Iam::V1::GetIamPolicyRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Iam::V1::GetIamPolicyRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload get_iam_policy(resource: nil, options: nil)
                  #   Pass arguments to `get_iam_policy` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param resource [::String]
                  #     REQUIRED: The resource for which the policy is being requested.
                  #     See the operation documentation for the appropriate value for this field.
                  #   @param options [::Google::Iam::V1::GetPolicyOptions, ::Hash]
                  #     OPTIONAL: A `GetPolicyOptions` object for specifying options to
                  #     `GetIamPolicy`.
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Iam::V1::Policy]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Iam::V1::Policy]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/database/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Iam::V1::GetIamPolicyRequest.new
                  #
                  #   # Call the get_iam_policy method.
                  #   result = client.get_iam_policy request
                  #
                  #   # The returned object is of type Google::Iam::V1::Policy.
                  #   p result
                  #
                  def get_iam_policy request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::GetIamPolicyRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.get_iam_policy.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Database::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.get_iam_policy.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.get_iam_policy.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @database_admin_stub.get_iam_policy request, options do |result, operation|
                      yield result, operation if block_given?
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Returns permissions that the caller has on the specified database or backup
                  # resource.
                  #
                  # Attempting this RPC on a non-existent Cloud Spanner database will
                  # result in a NOT_FOUND error if the user has
                  # `spanner.databases.list` permission on the containing Cloud
                  # Spanner instance. Otherwise returns an empty set of permissions.
                  # Calling this method on a backup that does not exist will
                  # result in a NOT_FOUND error if the user has
                  # `spanner.backups.list` permission on the containing instance.
                  #
                  # @overload test_iam_permissions(request, options = nil)
                  #   Pass arguments to `test_iam_permissions` via a request object, either of type
                  #   {::Google::Iam::V1::TestIamPermissionsRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Iam::V1::TestIamPermissionsRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload test_iam_permissions(resource: nil, permissions: nil)
                  #   Pass arguments to `test_iam_permissions` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param resource [::String]
                  #     REQUIRED: The resource for which the policy detail is being requested.
                  #     See the operation documentation for the appropriate value for this field.
                  #   @param permissions [::Array<::String>]
                  #     The set of permissions to check for the `resource`. Permissions with
                  #     wildcards (such as '*' or 'storage.*') are not allowed. For more
                  #     information see
                  #     [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Iam::V1::TestIamPermissionsResponse]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Iam::V1::TestIamPermissionsResponse]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/database/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Iam::V1::TestIamPermissionsRequest.new
                  #
                  #   # Call the test_iam_permissions method.
                  #   result = client.test_iam_permissions request
                  #
                  #   # The returned object is of type Google::Iam::V1::TestIamPermissionsResponse.
                  #   p result
                  #
                  def test_iam_permissions request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::TestIamPermissionsRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.test_iam_permissions.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Database::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.test_iam_permissions.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.test_iam_permissions.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @database_admin_stub.test_iam_permissions request, options do |result, operation|
                      yield result, operation if block_given?
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Starts creating a new Cloud Spanner Backup.
                  # The returned backup {::Google::Longrunning::Operation long-running operation}
                  # will have a name of the format
                  # `projects/<project>/instances/<instance>/backups/<backup>/operations/<operation_id>`
                  # and can be used to track creation of the backup. The
                  # {::Google::Longrunning::Operation#metadata metadata} field type is
                  # {::Google::Cloud::Spanner::Admin::Database::V1::CreateBackupMetadata CreateBackupMetadata}.
                  # The {::Google::Longrunning::Operation#response response} field type is
                  # {::Google::Cloud::Spanner::Admin::Database::V1::Backup Backup}, if successful.
                  # Cancelling the returned operation will stop the creation and delete the
                  # backup. There can be only one pending backup creation per database. Backup
                  # creation of different databases can run concurrently.
                  #
                  # @overload create_backup(request, options = nil)
                  #   Pass arguments to `create_backup` via a request object, either of type
                  #   {::Google::Cloud::Spanner::Admin::Database::V1::CreateBackupRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Spanner::Admin::Database::V1::CreateBackupRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload create_backup(parent: nil, backup_id: nil, backup: nil, encryption_config: nil)
                  #   Pass arguments to `create_backup` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param parent [::String]
                  #     Required. The name of the instance in which the backup will be
                  #     created. This must be the same instance that contains the database the
                  #     backup will be created from. The backup will be stored in the
                  #     location(s) specified in the instance configuration of this
                  #     instance. Values are of the form
                  #     `projects/<project>/instances/<instance>`.
                  #   @param backup_id [::String]
                  #     Required. The id of the backup to be created. The `backup_id` appended to
                  #     `parent` forms the full backup name of the form
                  #     `projects/<project>/instances/<instance>/backups/<backup_id>`.
                  #   @param backup [::Google::Cloud::Spanner::Admin::Database::V1::Backup, ::Hash]
                  #     Required. The backup to create.
                  #   @param encryption_config [::Google::Cloud::Spanner::Admin::Database::V1::CreateBackupEncryptionConfig, ::Hash]
                  #     Optional. The encryption configuration used to encrypt the backup. If this
                  #     field is not specified, the backup will use the same encryption
                  #     configuration as the database by default, namely
                  #     {::Google::Cloud::Spanner::Admin::Database::V1::CreateBackupEncryptionConfig#encryption_type encryption_type}
                  #     = `USE_DATABASE_ENCRYPTION`.
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Gapic::Operation]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Gapic::Operation]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/database/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Spanner::Admin::Database::V1::CreateBackupRequest.new
                  #
                  #   # Call the create_backup method.
                  #   result = client.create_backup request
                  #
                  #   # The returned object is of type Gapic::Operation. You can use it to
                  #   # check the status of an operation, cancel it, or wait for results.
                  #   # Here is how to wait for a response.
                  #   result.wait_until_done! timeout: 60
                  #   if result.response?
                  #     p result.response
                  #   else
                  #     puts "No response received."
                  #   end
                  #
                  def create_backup request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::Admin::Database::V1::CreateBackupRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.create_backup.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Database::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.create_backup.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.create_backup.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @database_admin_stub.create_backup request, options do |result, operation|
                      result = ::Gapic::Operation.new result, @operations_client, options: options
                      yield result, operation if block_given?
                      throw :response, result
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Starts copying a Cloud Spanner Backup.
                  # The returned backup {::Google::Longrunning::Operation long-running operation}
                  # will have a name of the format
                  # `projects/<project>/instances/<instance>/backups/<backup>/operations/<operation_id>`
                  # and can be used to track copying of the backup. The operation is associated
                  # with the destination backup.
                  # The {::Google::Longrunning::Operation#metadata metadata} field type is
                  # {::Google::Cloud::Spanner::Admin::Database::V1::CopyBackupMetadata CopyBackupMetadata}.
                  # The {::Google::Longrunning::Operation#response response} field type is
                  # {::Google::Cloud::Spanner::Admin::Database::V1::Backup Backup}, if successful.
                  # Cancelling the returned operation will stop the copying and delete the
                  # destination backup. Concurrent CopyBackup requests can run on the same
                  # source backup.
                  #
                  # @overload copy_backup(request, options = nil)
                  #   Pass arguments to `copy_backup` via a request object, either of type
                  #   {::Google::Cloud::Spanner::Admin::Database::V1::CopyBackupRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Spanner::Admin::Database::V1::CopyBackupRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload copy_backup(parent: nil, backup_id: nil, source_backup: nil, expire_time: nil, encryption_config: nil)
                  #   Pass arguments to `copy_backup` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param parent [::String]
                  #     Required. The name of the destination instance that will contain the backup
                  #     copy. Values are of the form: `projects/<project>/instances/<instance>`.
                  #   @param backup_id [::String]
                  #     Required. The id of the backup copy.
                  #     The `backup_id` appended to `parent` forms the full backup_uri of the form
                  #     `projects/<project>/instances/<instance>/backups/<backup>`.
                  #   @param source_backup [::String]
                  #     Required. The source backup to be copied.
                  #     The source backup needs to be in READY state for it to be copied.
                  #     Once CopyBackup is in progress, the source backup cannot be deleted or
                  #     cleaned up on expiration until CopyBackup is finished.
                  #     Values are of the form:
                  #     `projects/<project>/instances/<instance>/backups/<backup>`.
                  #   @param expire_time [::Google::Protobuf::Timestamp, ::Hash]
                  #     Required. The expiration time of the backup in microsecond granularity.
                  #     The expiration time must be at least 6 hours and at most 366 days
                  #     from the `create_time` of the source backup. Once the `expire_time` has
                  #     passed, the backup is eligible to be automatically deleted by Cloud Spanner
                  #     to free the resources used by the backup.
                  #   @param encryption_config [::Google::Cloud::Spanner::Admin::Database::V1::CopyBackupEncryptionConfig, ::Hash]
                  #     Optional. The encryption configuration used to encrypt the backup. If this
                  #     field is not specified, the backup will use the same encryption
                  #     configuration as the source backup by default, namely
                  #     {::Google::Cloud::Spanner::Admin::Database::V1::CopyBackupEncryptionConfig#encryption_type encryption_type}
                  #     = `USE_CONFIG_DEFAULT_OR_BACKUP_ENCRYPTION`.
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Gapic::Operation]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Gapic::Operation]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/database/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Spanner::Admin::Database::V1::CopyBackupRequest.new
                  #
                  #   # Call the copy_backup method.
                  #   result = client.copy_backup request
                  #
                  #   # The returned object is of type Gapic::Operation. You can use it to
                  #   # check the status of an operation, cancel it, or wait for results.
                  #   # Here is how to wait for a response.
                  #   result.wait_until_done! timeout: 60
                  #   if result.response?
                  #     p result.response
                  #   else
                  #     puts "No response received."
                  #   end
                  #
                  def copy_backup request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::Admin::Database::V1::CopyBackupRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.copy_backup.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Database::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.copy_backup.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.copy_backup.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @database_admin_stub.copy_backup request, options do |result, operation|
                      result = ::Gapic::Operation.new result, @operations_client, options: options
                      yield result, operation if block_given?
                      throw :response, result
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Gets metadata on a pending or completed
                  # {::Google::Cloud::Spanner::Admin::Database::V1::Backup Backup}.
                  #
                  # @overload get_backup(request, options = nil)
                  #   Pass arguments to `get_backup` via a request object, either of type
                  #   {::Google::Cloud::Spanner::Admin::Database::V1::GetBackupRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Spanner::Admin::Database::V1::GetBackupRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload get_backup(name: nil)
                  #   Pass arguments to `get_backup` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param name [::String]
                  #     Required. Name of the backup.
                  #     Values are of the form
                  #     `projects/<project>/instances/<instance>/backups/<backup>`.
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Spanner::Admin::Database::V1::Backup]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Spanner::Admin::Database::V1::Backup]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/database/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Spanner::Admin::Database::V1::GetBackupRequest.new
                  #
                  #   # Call the get_backup method.
                  #   result = client.get_backup request
                  #
                  #   # The returned object is of type Google::Cloud::Spanner::Admin::Database::V1::Backup.
                  #   p result
                  #
                  def get_backup request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::Admin::Database::V1::GetBackupRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.get_backup.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Database::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.get_backup.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.get_backup.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @database_admin_stub.get_backup request, options do |result, operation|
                      yield result, operation if block_given?
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Updates a pending or completed
                  # {::Google::Cloud::Spanner::Admin::Database::V1::Backup Backup}.
                  #
                  # @overload update_backup(request, options = nil)
                  #   Pass arguments to `update_backup` via a request object, either of type
                  #   {::Google::Cloud::Spanner::Admin::Database::V1::UpdateBackupRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Spanner::Admin::Database::V1::UpdateBackupRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload update_backup(backup: nil, update_mask: nil)
                  #   Pass arguments to `update_backup` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param backup [::Google::Cloud::Spanner::Admin::Database::V1::Backup, ::Hash]
                  #     Required. The backup to update. `backup.name`, and the fields to be updated
                  #     as specified by `update_mask` are required. Other fields are ignored.
                  #     Update is only supported for the following fields:
                  #      * `backup.expire_time`.
                  #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
                  #     Required. A mask specifying which fields (e.g. `expire_time`) in the
                  #     Backup resource should be updated. This mask is relative to the Backup
                  #     resource, not to the request message. The field mask must always be
                  #     specified; this prevents any future fields from being erased accidentally
                  #     by clients that do not know about them.
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Spanner::Admin::Database::V1::Backup]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Spanner::Admin::Database::V1::Backup]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/database/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Spanner::Admin::Database::V1::UpdateBackupRequest.new
                  #
                  #   # Call the update_backup method.
                  #   result = client.update_backup request
                  #
                  #   # The returned object is of type Google::Cloud::Spanner::Admin::Database::V1::Backup.
                  #   p result
                  #
                  def update_backup request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::Admin::Database::V1::UpdateBackupRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.update_backup.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Database::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.update_backup.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.update_backup.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @database_admin_stub.update_backup request, options do |result, operation|
                      yield result, operation if block_given?
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Deletes a pending or completed
                  # {::Google::Cloud::Spanner::Admin::Database::V1::Backup Backup}.
                  #
                  # @overload delete_backup(request, options = nil)
                  #   Pass arguments to `delete_backup` via a request object, either of type
                  #   {::Google::Cloud::Spanner::Admin::Database::V1::DeleteBackupRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Spanner::Admin::Database::V1::DeleteBackupRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload delete_backup(name: nil)
                  #   Pass arguments to `delete_backup` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param name [::String]
                  #     Required. Name of the backup to delete.
                  #     Values are of the form
                  #     `projects/<project>/instances/<instance>/backups/<backup>`.
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Protobuf::Empty]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Protobuf::Empty]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/database/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Spanner::Admin::Database::V1::DeleteBackupRequest.new
                  #
                  #   # Call the delete_backup method.
                  #   result = client.delete_backup request
                  #
                  #   # The returned object is of type Google::Protobuf::Empty.
                  #   p result
                  #
                  def delete_backup request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::Admin::Database::V1::DeleteBackupRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.delete_backup.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Database::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.delete_backup.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.delete_backup.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @database_admin_stub.delete_backup request, options do |result, operation|
                      yield result, operation if block_given?
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Lists completed and pending backups.
                  # Backups returned are ordered by `create_time` in descending order,
                  # starting from the most recent `create_time`.
                  #
                  # @overload list_backups(request, options = nil)
                  #   Pass arguments to `list_backups` via a request object, either of type
                  #   {::Google::Cloud::Spanner::Admin::Database::V1::ListBackupsRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Spanner::Admin::Database::V1::ListBackupsRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload list_backups(parent: nil, filter: nil, page_size: nil, page_token: nil)
                  #   Pass arguments to `list_backups` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param parent [::String]
                  #     Required. The instance to list backups from.  Values are of the
                  #     form `projects/<project>/instances/<instance>`.
                  #   @param filter [::String]
                  #     An expression that filters the list of returned backups.
                  #
                  #     A filter expression consists of a field name, a comparison operator, and a
                  #     value for filtering.
                  #     The value must be a string, a number, or a boolean. The comparison operator
                  #     must be one of: `<`, `>`, `<=`, `>=`, `!=`, `=`, or `:`.
                  #     Colon `:` is the contains operator. Filter rules are not case sensitive.
                  #
                  #     The following fields in the
                  #     {::Google::Cloud::Spanner::Admin::Database::V1::Backup Backup} are eligible for
                  #     filtering:
                  #
                  #       * `name`
                  #       * `database`
                  #       * `state`
                  #       * `create_time`  (and values are of the format YYYY-MM-DDTHH:MM:SSZ)
                  #       * `expire_time`  (and values are of the format YYYY-MM-DDTHH:MM:SSZ)
                  #       * `version_time` (and values are of the format YYYY-MM-DDTHH:MM:SSZ)
                  #       * `size_bytes`
                  #       * `backup_schedules`
                  #
                  #     You can combine multiple expressions by enclosing each expression in
                  #     parentheses. By default, expressions are combined with AND logic, but
                  #     you can specify AND, OR, and NOT logic explicitly.
                  #
                  #     Here are a few examples:
                  #
                  #       * `name:Howl` - The backup's name contains the string "howl".
                  #       * `database:prod`
                  #              - The database's name contains the string "prod".
                  #       * `state:CREATING` - The backup is pending creation.
                  #       * `state:READY` - The backup is fully created and ready for use.
                  #       * `(name:howl) AND (create_time < \"2018-03-28T14:50:00Z\")`
                  #              - The backup name contains the string "howl" and `create_time`
                  #                  of the backup is before 2018-03-28T14:50:00Z.
                  #       * `expire_time < \"2018-03-28T14:50:00Z\"`
                  #              - The backup `expire_time` is before 2018-03-28T14:50:00Z.
                  #       * `size_bytes > 10000000000` - The backup's size is greater than 10GB
                  #       * `backup_schedules:daily`
                  #              - The backup is created from a schedule with "daily" in its name.
                  #   @param page_size [::Integer]
                  #     Number of backups to be returned in the response. If 0 or
                  #     less, defaults to the server's maximum allowed page size.
                  #   @param page_token [::String]
                  #     If non-empty, `page_token` should contain a
                  #     {::Google::Cloud::Spanner::Admin::Database::V1::ListBackupsResponse#next_page_token next_page_token}
                  #     from a previous
                  #     {::Google::Cloud::Spanner::Admin::Database::V1::ListBackupsResponse ListBackupsResponse}
                  #     to the same `parent` and with the same `filter`.
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Spanner::Admin::Database::V1::Backup>]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Spanner::Admin::Database::V1::Backup>]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/database/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Spanner::Admin::Database::V1::ListBackupsRequest.new
                  #
                  #   # Call the list_backups method.
                  #   result = client.list_backups request
                  #
                  #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
                  #   # over elements, and API calls will be issued to fetch pages as needed.
                  #   result.each do |item|
                  #     # Each element is of type ::Google::Cloud::Spanner::Admin::Database::V1::Backup.
                  #     p item
                  #   end
                  #
                  def list_backups request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::Admin::Database::V1::ListBackupsRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.list_backups.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Database::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.list_backups.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.list_backups.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @database_admin_stub.list_backups request, options do |result, operation|
                      result = ::Gapic::Rest::PagedEnumerable.new @database_admin_stub, :list_backups, "backups", request, result, options
                      yield result, operation if block_given?
                      throw :response, result
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Create a new database by restoring from a completed backup. The new
                  # database must be in the same project and in an instance with the same
                  # instance configuration as the instance containing
                  # the backup. The returned database [long-running
                  # operation][google.longrunning.Operation] has a name of the format
                  # `projects/<project>/instances/<instance>/databases/<database>/operations/<operation_id>`,
                  # and can be used to track the progress of the operation, and to cancel it.
                  # The {::Google::Longrunning::Operation#metadata metadata} field type is
                  # {::Google::Cloud::Spanner::Admin::Database::V1::RestoreDatabaseMetadata RestoreDatabaseMetadata}.
                  # The {::Google::Longrunning::Operation#response response} type
                  # is {::Google::Cloud::Spanner::Admin::Database::V1::Database Database}, if
                  # successful. Cancelling the returned operation will stop the restore and
                  # delete the database.
                  # There can be only one database being restored into an instance at a time.
                  # Once the restore operation completes, a new restore operation can be
                  # initiated, without waiting for the optimize operation associated with the
                  # first restore to complete.
                  #
                  # @overload restore_database(request, options = nil)
                  #   Pass arguments to `restore_database` via a request object, either of type
                  #   {::Google::Cloud::Spanner::Admin::Database::V1::RestoreDatabaseRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Spanner::Admin::Database::V1::RestoreDatabaseRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload restore_database(parent: nil, database_id: nil, backup: nil, encryption_config: nil)
                  #   Pass arguments to `restore_database` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param parent [::String]
                  #     Required. The name of the instance in which to create the
                  #     restored database. This instance must be in the same project and
                  #     have the same instance configuration as the instance containing
                  #     the source backup. Values are of the form
                  #     `projects/<project>/instances/<instance>`.
                  #   @param database_id [::String]
                  #     Required. The id of the database to create and restore to. This
                  #     database must not already exist. The `database_id` appended to
                  #     `parent` forms the full database name of the form
                  #     `projects/<project>/instances/<instance>/databases/<database_id>`.
                  #   @param backup [::String]
                  #     Name of the backup from which to restore.  Values are of the form
                  #     `projects/<project>/instances/<instance>/backups/<backup>`.
                  #   @param encryption_config [::Google::Cloud::Spanner::Admin::Database::V1::RestoreDatabaseEncryptionConfig, ::Hash]
                  #     Optional. An encryption configuration describing the encryption type and
                  #     key resources in Cloud KMS used to encrypt/decrypt the database to restore
                  #     to. If this field is not specified, the restored database will use the same
                  #     encryption configuration as the backup by default, namely
                  #     {::Google::Cloud::Spanner::Admin::Database::V1::RestoreDatabaseEncryptionConfig#encryption_type encryption_type}
                  #     = `USE_CONFIG_DEFAULT_OR_BACKUP_ENCRYPTION`.
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Gapic::Operation]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Gapic::Operation]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/database/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Spanner::Admin::Database::V1::RestoreDatabaseRequest.new
                  #
                  #   # Call the restore_database method.
                  #   result = client.restore_database request
                  #
                  #   # The returned object is of type Gapic::Operation. You can use it to
                  #   # check the status of an operation, cancel it, or wait for results.
                  #   # Here is how to wait for a response.
                  #   result.wait_until_done! timeout: 60
                  #   if result.response?
                  #     p result.response
                  #   else
                  #     puts "No response received."
                  #   end
                  #
                  def restore_database request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::Admin::Database::V1::RestoreDatabaseRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.restore_database.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Database::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.restore_database.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.restore_database.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @database_admin_stub.restore_database request, options do |result, operation|
                      result = ::Gapic::Operation.new result, @operations_client, options: options
                      yield result, operation if block_given?
                      throw :response, result
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Lists database {::Google::Longrunning::Operation longrunning-operations}.
                  # A database operation has a name of the form
                  # `projects/<project>/instances/<instance>/databases/<database>/operations/<operation>`.
                  # The long-running operation
                  # {::Google::Longrunning::Operation#metadata metadata} field type
                  # `metadata.type_url` describes the type of the metadata. Operations returned
                  # include those that have completed/failed/canceled within the last 7 days,
                  # and pending operations.
                  #
                  # @overload list_database_operations(request, options = nil)
                  #   Pass arguments to `list_database_operations` via a request object, either of type
                  #   {::Google::Cloud::Spanner::Admin::Database::V1::ListDatabaseOperationsRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Spanner::Admin::Database::V1::ListDatabaseOperationsRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload list_database_operations(parent: nil, filter: nil, page_size: nil, page_token: nil)
                  #   Pass arguments to `list_database_operations` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param parent [::String]
                  #     Required. The instance of the database operations.
                  #     Values are of the form `projects/<project>/instances/<instance>`.
                  #   @param filter [::String]
                  #     An expression that filters the list of returned operations.
                  #
                  #     A filter expression consists of a field name, a
                  #     comparison operator, and a value for filtering.
                  #     The value must be a string, a number, or a boolean. The comparison operator
                  #     must be one of: `<`, `>`, `<=`, `>=`, `!=`, `=`, or `:`.
                  #     Colon `:` is the contains operator. Filter rules are not case sensitive.
                  #
                  #     The following fields in the {::Google::Longrunning::Operation Operation}
                  #     are eligible for filtering:
                  #
                  #       * `name` - The name of the long-running operation
                  #       * `done` - False if the operation is in progress, else true.
                  #       * `metadata.@type` - the type of metadata. For example, the type string
                  #          for
                  #          {::Google::Cloud::Spanner::Admin::Database::V1::RestoreDatabaseMetadata RestoreDatabaseMetadata}
                  #          is
                  #          `type.googleapis.com/google.spanner.admin.database.v1.RestoreDatabaseMetadata`.
                  #       * `metadata.<field_name>` - any field in metadata.value.
                  #          `metadata.@type` must be specified first, if filtering on metadata
                  #          fields.
                  #       * `error` - Error associated with the long-running operation.
                  #       * `response.@type` - the type of response.
                  #       * `response.<field_name>` - any field in response.value.
                  #
                  #     You can combine multiple expressions by enclosing each expression in
                  #     parentheses. By default, expressions are combined with AND logic. However,
                  #     you can specify AND, OR, and NOT logic explicitly.
                  #
                  #     Here are a few examples:
                  #
                  #       * `done:true` - The operation is complete.
                  #       * `(metadata.@type=type.googleapis.com/google.spanner.admin.database.v1.RestoreDatabaseMetadata) AND` \
                  #         `(metadata.source_type:BACKUP) AND` \
                  #         `(metadata.backup_info.backup:backup_howl) AND` \
                  #         `(metadata.name:restored_howl) AND` \
                  #         `(metadata.progress.start_time < \"2018-03-28T14:50:00Z\") AND` \
                  #         `(error:*)` - Return operations where:
                  #         * The operation's metadata type is
                  #         {::Google::Cloud::Spanner::Admin::Database::V1::RestoreDatabaseMetadata RestoreDatabaseMetadata}.
                  #         * The database is restored from a backup.
                  #         * The backup name contains "backup_howl".
                  #         * The restored database's name contains "restored_howl".
                  #         * The operation started before 2018-03-28T14:50:00Z.
                  #         * The operation resulted in an error.
                  #   @param page_size [::Integer]
                  #     Number of operations to be returned in the response. If 0 or
                  #     less, defaults to the server's maximum allowed page size.
                  #   @param page_token [::String]
                  #     If non-empty, `page_token` should contain a
                  #     {::Google::Cloud::Spanner::Admin::Database::V1::ListDatabaseOperationsResponse#next_page_token next_page_token}
                  #     from a previous
                  #     {::Google::Cloud::Spanner::Admin::Database::V1::ListDatabaseOperationsResponse ListDatabaseOperationsResponse}
                  #     to the same `parent` and with the same `filter`.
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Gapic::Operation]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Gapic::Operation]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/database/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Spanner::Admin::Database::V1::ListDatabaseOperationsRequest.new
                  #
                  #   # Call the list_database_operations method.
                  #   result = client.list_database_operations request
                  #
                  #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
                  #   # over elements, and API calls will be issued to fetch pages as needed.
                  #   result.each do |item|
                  #     # Each element is of type ::Google::Longrunning::Operation.
                  #     p item
                  #   end
                  #
                  def list_database_operations request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::Admin::Database::V1::ListDatabaseOperationsRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.list_database_operations.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Database::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.list_database_operations.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.list_database_operations.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @database_admin_stub.list_database_operations request, options do |result, operation|
                      result = ::Gapic::Rest::PagedEnumerable.new @database_admin_stub, :list_database_operations, "operations", request, result, options
                      yield result, operation if block_given?
                      throw :response, result
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Lists the backup {::Google::Longrunning::Operation long-running operations} in
                  # the given instance. A backup operation has a name of the form
                  # `projects/<project>/instances/<instance>/backups/<backup>/operations/<operation>`.
                  # The long-running operation
                  # {::Google::Longrunning::Operation#metadata metadata} field type
                  # `metadata.type_url` describes the type of the metadata. Operations returned
                  # include those that have completed/failed/canceled within the last 7 days,
                  # and pending operations. Operations returned are ordered by
                  # `operation.metadata.value.progress.start_time` in descending order starting
                  # from the most recently started operation.
                  #
                  # @overload list_backup_operations(request, options = nil)
                  #   Pass arguments to `list_backup_operations` via a request object, either of type
                  #   {::Google::Cloud::Spanner::Admin::Database::V1::ListBackupOperationsRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Spanner::Admin::Database::V1::ListBackupOperationsRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload list_backup_operations(parent: nil, filter: nil, page_size: nil, page_token: nil)
                  #   Pass arguments to `list_backup_operations` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param parent [::String]
                  #     Required. The instance of the backup operations. Values are of
                  #     the form `projects/<project>/instances/<instance>`.
                  #   @param filter [::String]
                  #     An expression that filters the list of returned backup operations.
                  #
                  #     A filter expression consists of a field name, a
                  #     comparison operator, and a value for filtering.
                  #     The value must be a string, a number, or a boolean. The comparison operator
                  #     must be one of: `<`, `>`, `<=`, `>=`, `!=`, `=`, or `:`.
                  #     Colon `:` is the contains operator. Filter rules are not case sensitive.
                  #
                  #     The following fields in the {::Google::Longrunning::Operation operation}
                  #     are eligible for filtering:
                  #
                  #       * `name` - The name of the long-running operation
                  #       * `done` - False if the operation is in progress, else true.
                  #       * `metadata.@type` - the type of metadata. For example, the type string
                  #          for
                  #          {::Google::Cloud::Spanner::Admin::Database::V1::CreateBackupMetadata CreateBackupMetadata}
                  #          is
                  #          `type.googleapis.com/google.spanner.admin.database.v1.CreateBackupMetadata`.
                  #       * `metadata.<field_name>` - any field in metadata.value.
                  #          `metadata.@type` must be specified first if filtering on metadata
                  #          fields.
                  #       * `error` - Error associated with the long-running operation.
                  #       * `response.@type` - the type of response.
                  #       * `response.<field_name>` - any field in response.value.
                  #
                  #     You can combine multiple expressions by enclosing each expression in
                  #     parentheses. By default, expressions are combined with AND logic, but
                  #     you can specify AND, OR, and NOT logic explicitly.
                  #
                  #     Here are a few examples:
                  #
                  #       * `done:true` - The operation is complete.
                  #       * `(metadata.@type=type.googleapis.com/google.spanner.admin.database.v1.CreateBackupMetadata) AND` \
                  #          `metadata.database:prod` - Returns operations where:
                  #          * The operation's metadata type is
                  #          {::Google::Cloud::Spanner::Admin::Database::V1::CreateBackupMetadata CreateBackupMetadata}.
                  #          * The source database name of backup contains the string "prod".
                  #       * `(metadata.@type=type.googleapis.com/google.spanner.admin.database.v1.CreateBackupMetadata) AND` \
                  #         `(metadata.name:howl) AND` \
                  #         `(metadata.progress.start_time < \"2018-03-28T14:50:00Z\") AND` \
                  #         `(error:*)` - Returns operations where:
                  #         * The operation's metadata type is
                  #         {::Google::Cloud::Spanner::Admin::Database::V1::CreateBackupMetadata CreateBackupMetadata}.
                  #         * The backup name contains the string "howl".
                  #         * The operation started before 2018-03-28T14:50:00Z.
                  #         * The operation resulted in an error.
                  #       * `(metadata.@type=type.googleapis.com/google.spanner.admin.database.v1.CopyBackupMetadata) AND` \
                  #         `(metadata.source_backup:test) AND` \
                  #         `(metadata.progress.start_time < \"2022-01-18T14:50:00Z\") AND` \
                  #         `(error:*)` - Returns operations where:
                  #         * The operation's metadata type is
                  #         {::Google::Cloud::Spanner::Admin::Database::V1::CopyBackupMetadata CopyBackupMetadata}.
                  #         * The source backup name contains the string "test".
                  #         * The operation started before 2022-01-18T14:50:00Z.
                  #         * The operation resulted in an error.
                  #       * `((metadata.@type=type.googleapis.com/google.spanner.admin.database.v1.CreateBackupMetadata) AND` \
                  #         `(metadata.database:test_db)) OR` \
                  #         `((metadata.@type=type.googleapis.com/google.spanner.admin.database.v1.CopyBackupMetadata)
                  #         AND` \
                  #         `(metadata.source_backup:test_bkp)) AND` \
                  #         `(error:*)` - Returns operations where:
                  #         * The operation's metadata matches either of criteria:
                  #           * The operation's metadata type is
                  #           {::Google::Cloud::Spanner::Admin::Database::V1::CreateBackupMetadata CreateBackupMetadata}
                  #           AND the source database name of the backup contains the string
                  #           "test_db"
                  #           * The operation's metadata type is
                  #           {::Google::Cloud::Spanner::Admin::Database::V1::CopyBackupMetadata CopyBackupMetadata}
                  #           AND the source backup name contains the string "test_bkp"
                  #         * The operation resulted in an error.
                  #   @param page_size [::Integer]
                  #     Number of operations to be returned in the response. If 0 or
                  #     less, defaults to the server's maximum allowed page size.
                  #   @param page_token [::String]
                  #     If non-empty, `page_token` should contain a
                  #     {::Google::Cloud::Spanner::Admin::Database::V1::ListBackupOperationsResponse#next_page_token next_page_token}
                  #     from a previous
                  #     {::Google::Cloud::Spanner::Admin::Database::V1::ListBackupOperationsResponse ListBackupOperationsResponse}
                  #     to the same `parent` and with the same `filter`.
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Gapic::Operation]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Gapic::Operation]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/database/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Spanner::Admin::Database::V1::ListBackupOperationsRequest.new
                  #
                  #   # Call the list_backup_operations method.
                  #   result = client.list_backup_operations request
                  #
                  #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
                  #   # over elements, and API calls will be issued to fetch pages as needed.
                  #   result.each do |item|
                  #     # Each element is of type ::Google::Longrunning::Operation.
                  #     p item
                  #   end
                  #
                  def list_backup_operations request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::Admin::Database::V1::ListBackupOperationsRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.list_backup_operations.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Database::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.list_backup_operations.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.list_backup_operations.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @database_admin_stub.list_backup_operations request, options do |result, operation|
                      result = ::Gapic::Rest::PagedEnumerable.new @database_admin_stub, :list_backup_operations, "operations", request, result, options
                      yield result, operation if block_given?
                      throw :response, result
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Lists Cloud Spanner database roles.
                  #
                  # @overload list_database_roles(request, options = nil)
                  #   Pass arguments to `list_database_roles` via a request object, either of type
                  #   {::Google::Cloud::Spanner::Admin::Database::V1::ListDatabaseRolesRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Spanner::Admin::Database::V1::ListDatabaseRolesRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload list_database_roles(parent: nil, page_size: nil, page_token: nil)
                  #   Pass arguments to `list_database_roles` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param parent [::String]
                  #     Required. The database whose roles should be listed.
                  #     Values are of the form
                  #     `projects/<project>/instances/<instance>/databases/<database>`.
                  #   @param page_size [::Integer]
                  #     Number of database roles to be returned in the response. If 0 or less,
                  #     defaults to the server's maximum allowed page size.
                  #   @param page_token [::String]
                  #     If non-empty, `page_token` should contain a
                  #     {::Google::Cloud::Spanner::Admin::Database::V1::ListDatabaseRolesResponse#next_page_token next_page_token}
                  #     from a previous
                  #     {::Google::Cloud::Spanner::Admin::Database::V1::ListDatabaseRolesResponse ListDatabaseRolesResponse}.
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Spanner::Admin::Database::V1::DatabaseRole>]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Spanner::Admin::Database::V1::DatabaseRole>]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/database/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Spanner::Admin::Database::V1::ListDatabaseRolesRequest.new
                  #
                  #   # Call the list_database_roles method.
                  #   result = client.list_database_roles request
                  #
                  #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
                  #   # over elements, and API calls will be issued to fetch pages as needed.
                  #   result.each do |item|
                  #     # Each element is of type ::Google::Cloud::Spanner::Admin::Database::V1::DatabaseRole.
                  #     p item
                  #   end
                  #
                  def list_database_roles request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::Admin::Database::V1::ListDatabaseRolesRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.list_database_roles.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Database::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.list_database_roles.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.list_database_roles.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @database_admin_stub.list_database_roles request, options do |result, operation|
                      result = ::Gapic::Rest::PagedEnumerable.new @database_admin_stub, :list_database_roles, "database_roles", request, result, options
                      yield result, operation if block_given?
                      throw :response, result
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Adds split points to specified tables, indexes of a database.
                  #
                  # @overload add_split_points(request, options = nil)
                  #   Pass arguments to `add_split_points` via a request object, either of type
                  #   {::Google::Cloud::Spanner::Admin::Database::V1::AddSplitPointsRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Spanner::Admin::Database::V1::AddSplitPointsRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload add_split_points(database: nil, split_points: nil, initiator: nil)
                  #   Pass arguments to `add_split_points` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param database [::String]
                  #     Required. The database on whose tables/indexes split points are to be
                  #     added. Values are of the form
                  #     `projects/<project>/instances/<instance>/databases/<database>`.
                  #   @param split_points [::Array<::Google::Cloud::Spanner::Admin::Database::V1::SplitPoints, ::Hash>]
                  #     Required. The split points to add.
                  #   @param initiator [::String]
                  #     Optional. A user-supplied tag associated with the split points.
                  #     For example, "intital_data_load", "special_event_1".
                  #     Defaults to "CloudAddSplitPointsAPI" if not specified.
                  #     The length of the tag must not exceed 50 characters,else will be trimmed.
                  #     Only valid UTF8 characters are allowed.
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Spanner::Admin::Database::V1::AddSplitPointsResponse]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Spanner::Admin::Database::V1::AddSplitPointsResponse]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/database/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Spanner::Admin::Database::V1::AddSplitPointsRequest.new
                  #
                  #   # Call the add_split_points method.
                  #   result = client.add_split_points request
                  #
                  #   # The returned object is of type Google::Cloud::Spanner::Admin::Database::V1::AddSplitPointsResponse.
                  #   p result
                  #
                  def add_split_points request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::Admin::Database::V1::AddSplitPointsRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.add_split_points.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Database::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.add_split_points.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.add_split_points.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @database_admin_stub.add_split_points request, options do |result, operation|
                      yield result, operation if block_given?
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Creates a new backup schedule.
                  #
                  # @overload create_backup_schedule(request, options = nil)
                  #   Pass arguments to `create_backup_schedule` via a request object, either of type
                  #   {::Google::Cloud::Spanner::Admin::Database::V1::CreateBackupScheduleRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Spanner::Admin::Database::V1::CreateBackupScheduleRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload create_backup_schedule(parent: nil, backup_schedule_id: nil, backup_schedule: nil)
                  #   Pass arguments to `create_backup_schedule` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param parent [::String]
                  #     Required. The name of the database that this backup schedule applies to.
                  #   @param backup_schedule_id [::String]
                  #     Required. The Id to use for the backup schedule. The `backup_schedule_id`
                  #     appended to `parent` forms the full backup schedule name of the form
                  #     `projects/<project>/instances/<instance>/databases/<database>/backupSchedules/<backup_schedule_id>`.
                  #   @param backup_schedule [::Google::Cloud::Spanner::Admin::Database::V1::BackupSchedule, ::Hash]
                  #     Required. The backup schedule to create.
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Spanner::Admin::Database::V1::BackupSchedule]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Spanner::Admin::Database::V1::BackupSchedule]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/database/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Spanner::Admin::Database::V1::CreateBackupScheduleRequest.new
                  #
                  #   # Call the create_backup_schedule method.
                  #   result = client.create_backup_schedule request
                  #
                  #   # The returned object is of type Google::Cloud::Spanner::Admin::Database::V1::BackupSchedule.
                  #   p result
                  #
                  def create_backup_schedule request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::Admin::Database::V1::CreateBackupScheduleRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.create_backup_schedule.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Database::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.create_backup_schedule.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.create_backup_schedule.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @database_admin_stub.create_backup_schedule request, options do |result, operation|
                      yield result, operation if block_given?
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Gets backup schedule for the input schedule name.
                  #
                  # @overload get_backup_schedule(request, options = nil)
                  #   Pass arguments to `get_backup_schedule` via a request object, either of type
                  #   {::Google::Cloud::Spanner::Admin::Database::V1::GetBackupScheduleRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Spanner::Admin::Database::V1::GetBackupScheduleRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload get_backup_schedule(name: nil)
                  #   Pass arguments to `get_backup_schedule` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param name [::String]
                  #     Required. The name of the schedule to retrieve.
                  #     Values are of the form
                  #     `projects/<project>/instances/<instance>/databases/<database>/backupSchedules/<backup_schedule_id>`.
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Spanner::Admin::Database::V1::BackupSchedule]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Spanner::Admin::Database::V1::BackupSchedule]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/database/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Spanner::Admin::Database::V1::GetBackupScheduleRequest.new
                  #
                  #   # Call the get_backup_schedule method.
                  #   result = client.get_backup_schedule request
                  #
                  #   # The returned object is of type Google::Cloud::Spanner::Admin::Database::V1::BackupSchedule.
                  #   p result
                  #
                  def get_backup_schedule request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::Admin::Database::V1::GetBackupScheduleRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.get_backup_schedule.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Database::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.get_backup_schedule.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.get_backup_schedule.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @database_admin_stub.get_backup_schedule request, options do |result, operation|
                      yield result, operation if block_given?
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Updates a backup schedule.
                  #
                  # @overload update_backup_schedule(request, options = nil)
                  #   Pass arguments to `update_backup_schedule` via a request object, either of type
                  #   {::Google::Cloud::Spanner::Admin::Database::V1::UpdateBackupScheduleRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Spanner::Admin::Database::V1::UpdateBackupScheduleRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload update_backup_schedule(backup_schedule: nil, update_mask: nil)
                  #   Pass arguments to `update_backup_schedule` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param backup_schedule [::Google::Cloud::Spanner::Admin::Database::V1::BackupSchedule, ::Hash]
                  #     Required. The backup schedule to update. `backup_schedule.name`, and the
                  #     fields to be updated as specified by `update_mask` are required. Other
                  #     fields are ignored.
                  #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
                  #     Required. A mask specifying which fields in the BackupSchedule resource
                  #     should be updated. This mask is relative to the BackupSchedule resource,
                  #     not to the request message. The field mask must always be
                  #     specified; this prevents any future fields from being erased
                  #     accidentally.
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Spanner::Admin::Database::V1::BackupSchedule]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Spanner::Admin::Database::V1::BackupSchedule]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/database/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Spanner::Admin::Database::V1::UpdateBackupScheduleRequest.new
                  #
                  #   # Call the update_backup_schedule method.
                  #   result = client.update_backup_schedule request
                  #
                  #   # The returned object is of type Google::Cloud::Spanner::Admin::Database::V1::BackupSchedule.
                  #   p result
                  #
                  def update_backup_schedule request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::Admin::Database::V1::UpdateBackupScheduleRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.update_backup_schedule.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Database::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.update_backup_schedule.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.update_backup_schedule.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @database_admin_stub.update_backup_schedule request, options do |result, operation|
                      yield result, operation if block_given?
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Deletes a backup schedule.
                  #
                  # @overload delete_backup_schedule(request, options = nil)
                  #   Pass arguments to `delete_backup_schedule` via a request object, either of type
                  #   {::Google::Cloud::Spanner::Admin::Database::V1::DeleteBackupScheduleRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Spanner::Admin::Database::V1::DeleteBackupScheduleRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload delete_backup_schedule(name: nil)
                  #   Pass arguments to `delete_backup_schedule` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param name [::String]
                  #     Required. The name of the schedule to delete.
                  #     Values are of the form
                  #     `projects/<project>/instances/<instance>/databases/<database>/backupSchedules/<backup_schedule_id>`.
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Protobuf::Empty]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Protobuf::Empty]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/database/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Spanner::Admin::Database::V1::DeleteBackupScheduleRequest.new
                  #
                  #   # Call the delete_backup_schedule method.
                  #   result = client.delete_backup_schedule request
                  #
                  #   # The returned object is of type Google::Protobuf::Empty.
                  #   p result
                  #
                  def delete_backup_schedule request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::Admin::Database::V1::DeleteBackupScheduleRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.delete_backup_schedule.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Database::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.delete_backup_schedule.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.delete_backup_schedule.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @database_admin_stub.delete_backup_schedule request, options do |result, operation|
                      yield result, operation if block_given?
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Lists all the backup schedules for the database.
                  #
                  # @overload list_backup_schedules(request, options = nil)
                  #   Pass arguments to `list_backup_schedules` via a request object, either of type
                  #   {::Google::Cloud::Spanner::Admin::Database::V1::ListBackupSchedulesRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Spanner::Admin::Database::V1::ListBackupSchedulesRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload list_backup_schedules(parent: nil, page_size: nil, page_token: nil)
                  #   Pass arguments to `list_backup_schedules` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param parent [::String]
                  #     Required. Database is the parent resource whose backup schedules should be
                  #     listed. Values are of the form
                  #     projects/<project>/instances/<instance>/databases/<database>
                  #   @param page_size [::Integer]
                  #     Optional. Number of backup schedules to be returned in the response. If 0
                  #     or less, defaults to the server's maximum allowed page size.
                  #   @param page_token [::String]
                  #     Optional. If non-empty, `page_token` should contain a
                  #     {::Google::Cloud::Spanner::Admin::Database::V1::ListBackupSchedulesResponse#next_page_token next_page_token}
                  #     from a previous
                  #     {::Google::Cloud::Spanner::Admin::Database::V1::ListBackupSchedulesResponse ListBackupSchedulesResponse}
                  #     to the same `parent`.
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Spanner::Admin::Database::V1::BackupSchedule>]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Spanner::Admin::Database::V1::BackupSchedule>]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/spanner/admin/database/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Spanner::Admin::Database::V1::ListBackupSchedulesRequest.new
                  #
                  #   # Call the list_backup_schedules method.
                  #   result = client.list_backup_schedules request
                  #
                  #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
                  #   # over elements, and API calls will be issued to fetch pages as needed.
                  #   result.each do |item|
                  #     # Each element is of type ::Google::Cloud::Spanner::Admin::Database::V1::BackupSchedule.
                  #     p item
                  #   end
                  #
                  def list_backup_schedules request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Spanner::Admin::Database::V1::ListBackupSchedulesRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.list_backup_schedules.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Spanner::Admin::Database::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.list_backup_schedules.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.list_backup_schedules.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @database_admin_stub.list_backup_schedules request, options do |result, operation|
                      result = ::Gapic::Rest::PagedEnumerable.new @database_admin_stub, :list_backup_schedules, "backup_schedules", request, result, options
                      yield result, operation if block_given?
                      throw :response, result
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Configuration class for the DatabaseAdmin REST API.
                  #
                  # This class represents the configuration for DatabaseAdmin REST,
                  # providing control over timeouts, retry behavior, logging, transport
                  # parameters, and other low-level controls. Certain parameters can also be
                  # applied individually to specific RPCs. See
                  # {::Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Rest::Client::Configuration::Rpcs}
                  # for a list of RPCs that can be configured independently.
                  #
                  # Configuration can be applied globally to all clients, or to a single client
                  # on construction.
                  #
                  # @example
                  #
                  #   # Modify the global config, setting the timeout for
                  #   # list_databases to 20 seconds,
                  #   # and all remaining timeouts to 10 seconds.
                  #   ::Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Rest::Client.configure do |config|
                  #     config.timeout = 10.0
                  #     config.rpcs.list_databases.timeout = 20.0
                  #   end
                  #
                  #   # Apply the above configuration only to a new client.
                  #   client = ::Google::Cloud::Spanner::Admin::Database::V1::DatabaseAdmin::Rest::Client.new do |config|
                  #     config.timeout = 10.0
                  #     config.rpcs.list_databases.timeout = 20.0
                  #   end
                  #
                  # @!attribute [rw] endpoint
                  #   A custom service endpoint, as a hostname or hostname:port. The default is
                  #   nil, indicating to use the default endpoint in the current universe domain.
                  #   @return [::String,nil]
                  # @!attribute [rw] credentials
                  #   Credentials to send with calls. You may provide any of the following types:
                  #    *  (`String`) The path to a service account key file in JSON format
                  #    *  (`Hash`) A service account key as a Hash
                  #    *  (`Google::Auth::Credentials`) A googleauth credentials object
                  #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
                  #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
                  #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
                  #    *  (`nil`) indicating no credentials
                  #
                  #   Warning: If you accept a credential configuration (JSON file or Hash) from an
                  #   external source for authentication to Google Cloud, you must validate it before
                  #   providing it to a Google API client library. Providing an unvalidated credential
                  #   configuration to Google APIs can compromise the security of your systems and data.
                  #   For more information, refer to [Validate credential configurations from external
                  #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
                  #   @return [::Object]
                  # @!attribute [rw] scope
                  #   The OAuth scopes
                  #   @return [::Array<::String>]
                  # @!attribute [rw] lib_name
                  #   The library name as recorded in instrumentation and logging
                  #   @return [::String]
                  # @!attribute [rw] lib_version
                  #   The library version as recorded in instrumentation and logging
                  #   @return [::String]
                  # @!attribute [rw] timeout
                  #   The call timeout in seconds.
                  #   @return [::Numeric]
                  # @!attribute [rw] metadata
                  #   Additional headers to be sent with the call.
                  #   @return [::Hash{::Symbol=>::String}]
                  # @!attribute [rw] retry_policy
                  #   The retry policy. The value is a hash with the following keys:
                  #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                  #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                  #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                  #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                  #       trigger a retry.
                  #   @return [::Hash]
                  # @!attribute [rw] quota_project
                  #   A separate project against which to charge quota.
                  #   @return [::String]
                  # @!attribute [rw] universe_domain
                  #   The universe domain within which to make requests. This determines the
                  #   default endpoint URL. The default value of nil uses the environment
                  #   universe (usually the default "googleapis.com" universe).
                  #   @return [::String,nil]
                  # @!attribute [rw] logger
                  #   A custom logger to use for request/response debug logging, or the value
                  #   `:default` (the default) to construct a default logger, or `nil` to
                  #   explicitly disable logging.
                  #   @return [::Logger,:default,nil]
                  #
                  class Configuration
                    extend ::Gapic::Config

                    # @private
                    # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                    DEFAULT_ENDPOINT = "spanner.googleapis.com"

                    config_attr :endpoint,      nil, ::String, nil
                    config_attr :credentials,   nil do |value|
                      allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                      allowed.any? { |klass| klass === value }
                    end
                    config_attr :scope,         nil, ::String, ::Array, nil
                    config_attr :lib_name,      nil, ::String, nil
                    config_attr :lib_version,   nil, ::String, nil
                    config_attr :timeout,       nil, ::Numeric, nil
                    config_attr :metadata,      nil, ::Hash, nil
                    config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                    config_attr :quota_project, nil, ::String, nil
                    config_attr :universe_domain, nil, ::String, nil
                    config_attr :logger, :default, ::Logger, nil, :default

                    # @private
                    def initialize parent_config = nil
                      @parent_config = parent_config unless parent_config.nil?

                      yield self if block_given?
                    end

                    ##
                    # Configurations for individual RPCs
                    # @return [Rpcs]
                    #
                    def rpcs
                      @rpcs ||= begin
                        parent_rpcs = nil
                        parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                        Rpcs.new parent_rpcs
                      end
                    end

                    ##
                    # Configuration RPC class for the DatabaseAdmin API.
                    #
                    # Includes fields providing the configuration for each RPC in this service.
                    # Each configuration object is of type `Gapic::Config::Method` and includes
                    # the following configuration fields:
                    #
                    #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                    #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                    #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                    #     include the following keys:
                    #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                    #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                    #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                    #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                    #         trigger a retry.
                    #
                    class Rpcs
                      ##
                      # RPC-specific configuration for `list_databases`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :list_databases
                      ##
                      # RPC-specific configuration for `create_database`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :create_database
                      ##
                      # RPC-specific configuration for `get_database`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :get_database
                      ##
                      # RPC-specific configuration for `update_database`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :update_database
                      ##
                      # RPC-specific configuration for `update_database_ddl`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :update_database_ddl
                      ##
                      # RPC-specific configuration for `drop_database`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :drop_database
                      ##
                      # RPC-specific configuration for `get_database_ddl`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :get_database_ddl
                      ##
                      # RPC-specific configuration for `set_iam_policy`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :set_iam_policy
                      ##
                      # RPC-specific configuration for `get_iam_policy`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :get_iam_policy
                      ##
                      # RPC-specific configuration for `test_iam_permissions`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :test_iam_permissions
                      ##
                      # RPC-specific configuration for `create_backup`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :create_backup
                      ##
                      # RPC-specific configuration for `copy_backup`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :copy_backup
                      ##
                      # RPC-specific configuration for `get_backup`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :get_backup
                      ##
                      # RPC-specific configuration for `update_backup`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :update_backup
                      ##
                      # RPC-specific configuration for `delete_backup`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :delete_backup
                      ##
                      # RPC-specific configuration for `list_backups`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :list_backups
                      ##
                      # RPC-specific configuration for `restore_database`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :restore_database
                      ##
                      # RPC-specific configuration for `list_database_operations`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :list_database_operations
                      ##
                      # RPC-specific configuration for `list_backup_operations`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :list_backup_operations
                      ##
                      # RPC-specific configuration for `list_database_roles`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :list_database_roles
                      ##
                      # RPC-specific configuration for `add_split_points`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :add_split_points
                      ##
                      # RPC-specific configuration for `create_backup_schedule`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :create_backup_schedule
                      ##
                      # RPC-specific configuration for `get_backup_schedule`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :get_backup_schedule
                      ##
                      # RPC-specific configuration for `update_backup_schedule`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :update_backup_schedule
                      ##
                      # RPC-specific configuration for `delete_backup_schedule`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :delete_backup_schedule
                      ##
                      # RPC-specific configuration for `list_backup_schedules`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :list_backup_schedules

                      # @private
                      def initialize parent_rpcs = nil
                        list_databases_config = parent_rpcs.list_databases if parent_rpcs.respond_to? :list_databases
                        @list_databases = ::Gapic::Config::Method.new list_databases_config
                        create_database_config = parent_rpcs.create_database if parent_rpcs.respond_to? :create_database
                        @create_database = ::Gapic::Config::Method.new create_database_config
                        get_database_config = parent_rpcs.get_database if parent_rpcs.respond_to? :get_database
                        @get_database = ::Gapic::Config::Method.new get_database_config
                        update_database_config = parent_rpcs.update_database if parent_rpcs.respond_to? :update_database
                        @update_database = ::Gapic::Config::Method.new update_database_config
                        update_database_ddl_config = parent_rpcs.update_database_ddl if parent_rpcs.respond_to? :update_database_ddl
                        @update_database_ddl = ::Gapic::Config::Method.new update_database_ddl_config
                        drop_database_config = parent_rpcs.drop_database if parent_rpcs.respond_to? :drop_database
                        @drop_database = ::Gapic::Config::Method.new drop_database_config
                        get_database_ddl_config = parent_rpcs.get_database_ddl if parent_rpcs.respond_to? :get_database_ddl
                        @get_database_ddl = ::Gapic::Config::Method.new get_database_ddl_config
                        set_iam_policy_config = parent_rpcs.set_iam_policy if parent_rpcs.respond_to? :set_iam_policy
                        @set_iam_policy = ::Gapic::Config::Method.new set_iam_policy_config
                        get_iam_policy_config = parent_rpcs.get_iam_policy if parent_rpcs.respond_to? :get_iam_policy
                        @get_iam_policy = ::Gapic::Config::Method.new get_iam_policy_config
                        test_iam_permissions_config = parent_rpcs.test_iam_permissions if parent_rpcs.respond_to? :test_iam_permissions
                        @test_iam_permissions = ::Gapic::Config::Method.new test_iam_permissions_config
                        create_backup_config = parent_rpcs.create_backup if parent_rpcs.respond_to? :create_backup
                        @create_backup = ::Gapic::Config::Method.new create_backup_config
                        copy_backup_config = parent_rpcs.copy_backup if parent_rpcs.respond_to? :copy_backup
                        @copy_backup = ::Gapic::Config::Method.new copy_backup_config
                        get_backup_config = parent_rpcs.get_backup if parent_rpcs.respond_to? :get_backup
                        @get_backup = ::Gapic::Config::Method.new get_backup_config
                        update_backup_config = parent_rpcs.update_backup if parent_rpcs.respond_to? :update_backup
                        @update_backup = ::Gapic::Config::Method.new update_backup_config
                        delete_backup_config = parent_rpcs.delete_backup if parent_rpcs.respond_to? :delete_backup
                        @delete_backup = ::Gapic::Config::Method.new delete_backup_config
                        list_backups_config = parent_rpcs.list_backups if parent_rpcs.respond_to? :list_backups
                        @list_backups = ::Gapic::Config::Method.new list_backups_config
                        restore_database_config = parent_rpcs.restore_database if parent_rpcs.respond_to? :restore_database
                        @restore_database = ::Gapic::Config::Method.new restore_database_config
                        list_database_operations_config = parent_rpcs.list_database_operations if parent_rpcs.respond_to? :list_database_operations
                        @list_database_operations = ::Gapic::Config::Method.new list_database_operations_config
                        list_backup_operations_config = parent_rpcs.list_backup_operations if parent_rpcs.respond_to? :list_backup_operations
                        @list_backup_operations = ::Gapic::Config::Method.new list_backup_operations_config
                        list_database_roles_config = parent_rpcs.list_database_roles if parent_rpcs.respond_to? :list_database_roles
                        @list_database_roles = ::Gapic::Config::Method.new list_database_roles_config
                        add_split_points_config = parent_rpcs.add_split_points if parent_rpcs.respond_to? :add_split_points
                        @add_split_points = ::Gapic::Config::Method.new add_split_points_config
                        create_backup_schedule_config = parent_rpcs.create_backup_schedule if parent_rpcs.respond_to? :create_backup_schedule
                        @create_backup_schedule = ::Gapic::Config::Method.new create_backup_schedule_config
                        get_backup_schedule_config = parent_rpcs.get_backup_schedule if parent_rpcs.respond_to? :get_backup_schedule
                        @get_backup_schedule = ::Gapic::Config::Method.new get_backup_schedule_config
                        update_backup_schedule_config = parent_rpcs.update_backup_schedule if parent_rpcs.respond_to? :update_backup_schedule
                        @update_backup_schedule = ::Gapic::Config::Method.new update_backup_schedule_config
                        delete_backup_schedule_config = parent_rpcs.delete_backup_schedule if parent_rpcs.respond_to? :delete_backup_schedule
                        @delete_backup_schedule = ::Gapic::Config::Method.new delete_backup_schedule_config
                        list_backup_schedules_config = parent_rpcs.list_backup_schedules if parent_rpcs.respond_to? :list_backup_schedules
                        @list_backup_schedules = ::Gapic::Config::Method.new list_backup_schedules_config

                        yield self if block_given?
                      end
                    end
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
