# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ServiceUsage
      module V1
        # Request message for the `EnableService` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the consumer and service to enable the service on.
        #
        #     The `EnableService` and `DisableService` methods currently only support
        #     projects.
        #
        #     Enabling a service requires that the service is public or is shared with
        #     the user enabling the service.
        #
        #     An example name would be:
        #     `projects/123/services/serviceusage.googleapis.com` where `123` is the
        #     project number.
        class EnableServiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for the `EnableService` method.
        # This response message is assigned to the `response` field of the returned
        # Operation when that operation is done.
        # @!attribute [rw] service
        #   @return [::Google::Cloud::ServiceUsage::V1::Service]
        #     The new state of the service after enabling.
        class EnableServiceResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the `DisableService` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the consumer and service to disable the service on.
        #
        #     The enable and disable methods currently only support projects.
        #
        #     An example name would be:
        #     `projects/123/services/serviceusage.googleapis.com` where `123` is the
        #     project number.
        # @!attribute [rw] disable_dependent_services
        #   @return [::Boolean]
        #     Indicates if services that are enabled and which depend on this service
        #     should also be disabled. If not set, an error will be generated if any
        #     enabled services depend on the service to be disabled. When set, the
        #     service, and any enabled services that depend on it, will be disabled
        #     together.
        # @!attribute [rw] check_if_service_has_usage
        #   @return [::Google::Cloud::ServiceUsage::V1::DisableServiceRequest::CheckIfServiceHasUsage]
        #     Defines the behavior for checking service usage when disabling a service.
        class DisableServiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Enum to determine if service usage should be checked when disabling a
          # service.
          module CheckIfServiceHasUsage
            # When unset, the default behavior is used, which is SKIP.
            CHECK_IF_SERVICE_HAS_USAGE_UNSPECIFIED = 0

            # If set, skip checking service usage when disabling a service.
            SKIP = 1

            # If set, service usage is checked when disabling the service. If a
            # service, or its dependents, has usage in the last 30 days, the request
            # returns a FAILED_PRECONDITION error.
            CHECK = 2
          end
        end

        # Response message for the `DisableService` method.
        # This response message is assigned to the `response` field of the returned
        # Operation when that operation is done.
        # @!attribute [rw] service
        #   @return [::Google::Cloud::ServiceUsage::V1::Service]
        #     The new state of the service after disabling.
        class DisableServiceResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the `GetService` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the consumer and service to get the `ConsumerState` for.
        #
        #     An example name would be:
        #     `projects/123/services/serviceusage.googleapis.com` where `123` is the
        #     project number.
        class GetServiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the `ListServices` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Parent to search for services on.
        #
        #     An example name would be:
        #     `projects/123` where `123` is the project number.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Requested size of the next page of data.
        #     Requested page size cannot exceed 200.
        #     If not set, the default page size is 50.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Token identifying which result to start with, which is returned by a
        #     previous list call.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Only list services that conform to the given filter.
        #     The allowed filter strings are `state:ENABLED` and `state:DISABLED`.
        class ListServicesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for the `ListServices` method.
        # @!attribute [rw] services
        #   @return [::Array<::Google::Cloud::ServiceUsage::V1::Service>]
        #     The available services for the requested project.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token that can be passed to `ListServices` to resume a paginated
        #     query.
        class ListServicesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the `BatchEnableServices` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Parent to enable services on.
        #
        #     An example name would be:
        #     `projects/123` where `123` is the project number.
        #
        #     The `BatchEnableServices` method currently only supports projects.
        # @!attribute [rw] service_ids
        #   @return [::Array<::String>]
        #     The identifiers of the services to enable on the project.
        #
        #     A valid identifier would be:
        #     serviceusage.googleapis.com
        #
        #     Enabling services requires that each service is public or is shared with
        #     the user enabling the service.
        #
        #     A single request can enable a maximum of 20 services at a time. If more
        #     than 20 services are specified, the request will fail, and no state changes
        #     will occur.
        class BatchEnableServicesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for the `BatchEnableServices` method.
        # This response message is assigned to the `response` field of the returned
        # Operation when that operation is done.
        # @!attribute [rw] services
        #   @return [::Array<::Google::Cloud::ServiceUsage::V1::Service>]
        #     The new state of the services after enabling.
        # @!attribute [rw] failures
        #   @return [::Array<::Google::Cloud::ServiceUsage::V1::BatchEnableServicesResponse::EnableFailure>]
        #     If allow_partial_success is true, and one or more services could not be
        #     enabled, this field contains the details about each failure.
        class BatchEnableServicesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Provides error messages for the failing services.
          # @!attribute [rw] service_id
          #   @return [::String]
          #     The service id of a service that could not be enabled.
          # @!attribute [rw] error_message
          #   @return [::String]
          #     An error message describing why the service could not be enabled.
          class EnableFailure
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request message for the `BatchGetServices` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Parent to retrieve services from.
        #     If this is set, the parent of all of the services specified in `names` must
        #     match this field. An example name would be: `projects/123` where `123` is
        #     the project number. The `BatchGetServices` method currently only supports
        #     projects.
        # @!attribute [rw] names
        #   @return [::Array<::String>]
        #     Names of the services to retrieve.
        #
        #     An example name would be:
        #     `projects/123/services/serviceusage.googleapis.com` where `123` is the
        #     project number.
        #     A single request can get a maximum of 30 services at a time.
        class BatchGetServicesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for the `BatchGetServices` method.
        # @!attribute [rw] services
        #   @return [::Array<::Google::Cloud::ServiceUsage::V1::Service>]
        #     The requested Service states.
        class BatchGetServicesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
