# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/api/serviceusage/v1/serviceusage_pb"

module Google
  module Cloud
    module ServiceUsage
      module V1
        module ServiceUsage
          ##
          # Client for the ServiceUsage service.
          #
          # Enables services that service consumers want to use on Google Cloud Platform,
          # lists the available or enabled services, or disables services that service
          # consumers no longer use.
          #
          # See [Service Usage API](https://cloud.google.com/service-usage/docs/overview)
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "serviceusage.$UNIVERSE_DOMAIN$"

            # @private
            attr_reader :service_usage_stub

            ##
            # Configure the ServiceUsage Client class.
            #
            # See {::Google::Cloud::ServiceUsage::V1::ServiceUsage::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all ServiceUsage clients
            #   ::Google::Cloud::ServiceUsage::V1::ServiceUsage::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "ServiceUsage", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.timeout = 60.0

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the ServiceUsage Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::ServiceUsage::V1::ServiceUsage::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @service_usage_stub.universe_domain
            end

            ##
            # Create a new ServiceUsage client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::ServiceUsage::V1::ServiceUsage::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::ServiceUsage::V1::ServiceUsage::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the ServiceUsage client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/api/serviceusage/v1/serviceusage_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @service_usage_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::ServiceUsage::V1::ServiceUsage::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @service_usage_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::ServiceUsage::V1::ServiceUsage::Operations]
            #
            attr_reader :operations_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @service_usage_stub.logger
            end

            # Service calls

            ##
            # Enable a service so that it can be used with a project.
            #
            # @overload enable_service(request, options = nil)
            #   Pass arguments to `enable_service` via a request object, either of type
            #   {::Google::Cloud::ServiceUsage::V1::EnableServiceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ServiceUsage::V1::EnableServiceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload enable_service(name: nil)
            #   Pass arguments to `enable_service` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Name of the consumer and service to enable the service on.
            #
            #     The `EnableService` and `DisableService` methods currently only support
            #     projects.
            #
            #     Enabling a service requires that the service is public or is shared with
            #     the user enabling the service.
            #
            #     An example name would be:
            #     `projects/123/services/serviceusage.googleapis.com` where `123` is the
            #     project number.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/service_usage/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ServiceUsage::V1::ServiceUsage::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ServiceUsage::V1::EnableServiceRequest.new
            #
            #   # Call the enable_service method.
            #   result = client.enable_service request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def enable_service request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ServiceUsage::V1::EnableServiceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.enable_service.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ServiceUsage::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.enable_service.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.enable_service.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @service_usage_stub.call_rpc :enable_service, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Disable a service so that it can no longer be used with a project.
            # This prevents unintended usage that may cause unexpected billing
            # charges or security leaks.
            #
            # It is not valid to call the disable method on a service that is not
            # currently enabled. Callers will receive a `FAILED_PRECONDITION` status if
            # the target service is not currently enabled.
            #
            # @overload disable_service(request, options = nil)
            #   Pass arguments to `disable_service` via a request object, either of type
            #   {::Google::Cloud::ServiceUsage::V1::DisableServiceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ServiceUsage::V1::DisableServiceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload disable_service(name: nil, disable_dependent_services: nil, check_if_service_has_usage: nil)
            #   Pass arguments to `disable_service` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Name of the consumer and service to disable the service on.
            #
            #     The enable and disable methods currently only support projects.
            #
            #     An example name would be:
            #     `projects/123/services/serviceusage.googleapis.com` where `123` is the
            #     project number.
            #   @param disable_dependent_services [::Boolean]
            #     Indicates if services that are enabled and which depend on this service
            #     should also be disabled. If not set, an error will be generated if any
            #     enabled services depend on the service to be disabled. When set, the
            #     service, and any enabled services that depend on it, will be disabled
            #     together.
            #   @param check_if_service_has_usage [::Google::Cloud::ServiceUsage::V1::DisableServiceRequest::CheckIfServiceHasUsage]
            #     Defines the behavior for checking service usage when disabling a service.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/service_usage/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ServiceUsage::V1::ServiceUsage::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ServiceUsage::V1::DisableServiceRequest.new
            #
            #   # Call the disable_service method.
            #   result = client.disable_service request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def disable_service request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ServiceUsage::V1::DisableServiceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.disable_service.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ServiceUsage::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.disable_service.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.disable_service.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @service_usage_stub.call_rpc :disable_service, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns the service configuration and enabled state for a given service.
            #
            # @overload get_service(request, options = nil)
            #   Pass arguments to `get_service` via a request object, either of type
            #   {::Google::Cloud::ServiceUsage::V1::GetServiceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ServiceUsage::V1::GetServiceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_service(name: nil)
            #   Pass arguments to `get_service` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Name of the consumer and service to get the `ConsumerState` for.
            #
            #     An example name would be:
            #     `projects/123/services/serviceusage.googleapis.com` where `123` is the
            #     project number.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::ServiceUsage::V1::Service]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::ServiceUsage::V1::Service]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/service_usage/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ServiceUsage::V1::ServiceUsage::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ServiceUsage::V1::GetServiceRequest.new
            #
            #   # Call the get_service method.
            #   result = client.get_service request
            #
            #   # The returned object is of type Google::Cloud::ServiceUsage::V1::Service.
            #   p result
            #
            def get_service request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ServiceUsage::V1::GetServiceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_service.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ServiceUsage::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_service.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_service.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @service_usage_stub.call_rpc :get_service, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # List all services available to the specified project, and the current
            # state of those services with respect to the project. The list includes
            # all public services, all services for which the calling user has the
            # `servicemanagement.services.bind` permission, and all services that have
            # already been enabled on the project. The list can be filtered to
            # only include services in a specific state, for example to only include
            # services enabled on the project.
            #
            # WARNING: If you need to query enabled services frequently or across
            # an organization, you should use
            # [Cloud Asset Inventory
            # API](https://cloud.google.com/asset-inventory/docs/apis), which provides
            # higher throughput and richer filtering capability.
            #
            # @overload list_services(request, options = nil)
            #   Pass arguments to `list_services` via a request object, either of type
            #   {::Google::Cloud::ServiceUsage::V1::ListServicesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ServiceUsage::V1::ListServicesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_services(parent: nil, page_size: nil, page_token: nil, filter: nil)
            #   Pass arguments to `list_services` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Parent to search for services on.
            #
            #     An example name would be:
            #     `projects/123` where `123` is the project number.
            #   @param page_size [::Integer]
            #     Requested size of the next page of data.
            #     Requested page size cannot exceed 200.
            #     If not set, the default page size is 50.
            #   @param page_token [::String]
            #     Token identifying which result to start with, which is returned by a
            #     previous list call.
            #   @param filter [::String]
            #     Only list services that conform to the given filter.
            #     The allowed filter strings are `state:ENABLED` and `state:DISABLED`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::ServiceUsage::V1::Service>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::ServiceUsage::V1::Service>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/service_usage/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ServiceUsage::V1::ServiceUsage::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ServiceUsage::V1::ListServicesRequest.new
            #
            #   # Call the list_services method.
            #   result = client.list_services request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::ServiceUsage::V1::Service.
            #     p item
            #   end
            #
            def list_services request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ServiceUsage::V1::ListServicesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_services.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ServiceUsage::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_services.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_services.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @service_usage_stub.call_rpc :list_services, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @service_usage_stub, :list_services, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Enable multiple services on a project. The operation is atomic: if enabling
            # any service fails, then the entire batch fails, and no state changes occur.
            # To enable a single service, use the `EnableService` method instead.
            #
            # @overload batch_enable_services(request, options = nil)
            #   Pass arguments to `batch_enable_services` via a request object, either of type
            #   {::Google::Cloud::ServiceUsage::V1::BatchEnableServicesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ServiceUsage::V1::BatchEnableServicesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload batch_enable_services(parent: nil, service_ids: nil)
            #   Pass arguments to `batch_enable_services` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Parent to enable services on.
            #
            #     An example name would be:
            #     `projects/123` where `123` is the project number.
            #
            #     The `BatchEnableServices` method currently only supports projects.
            #   @param service_ids [::Array<::String>]
            #     The identifiers of the services to enable on the project.
            #
            #     A valid identifier would be:
            #     serviceusage.googleapis.com
            #
            #     Enabling services requires that each service is public or is shared with
            #     the user enabling the service.
            #
            #     A single request can enable a maximum of 20 services at a time. If more
            #     than 20 services are specified, the request will fail, and no state changes
            #     will occur.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/service_usage/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ServiceUsage::V1::ServiceUsage::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ServiceUsage::V1::BatchEnableServicesRequest.new
            #
            #   # Call the batch_enable_services method.
            #   result = client.batch_enable_services request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def batch_enable_services request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ServiceUsage::V1::BatchEnableServicesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.batch_enable_services.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ServiceUsage::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.batch_enable_services.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.batch_enable_services.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @service_usage_stub.call_rpc :batch_enable_services, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns the service configurations and enabled states for a given list of
            # services.
            #
            # @overload batch_get_services(request, options = nil)
            #   Pass arguments to `batch_get_services` via a request object, either of type
            #   {::Google::Cloud::ServiceUsage::V1::BatchGetServicesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ServiceUsage::V1::BatchGetServicesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload batch_get_services(parent: nil, names: nil)
            #   Pass arguments to `batch_get_services` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Parent to retrieve services from.
            #     If this is set, the parent of all of the services specified in `names` must
            #     match this field. An example name would be: `projects/123` where `123` is
            #     the project number. The `BatchGetServices` method currently only supports
            #     projects.
            #   @param names [::Array<::String>]
            #     Names of the services to retrieve.
            #
            #     An example name would be:
            #     `projects/123/services/serviceusage.googleapis.com` where `123` is the
            #     project number.
            #     A single request can get a maximum of 30 services at a time.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::ServiceUsage::V1::BatchGetServicesResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::ServiceUsage::V1::BatchGetServicesResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/service_usage/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ServiceUsage::V1::ServiceUsage::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ServiceUsage::V1::BatchGetServicesRequest.new
            #
            #   # Call the batch_get_services method.
            #   result = client.batch_get_services request
            #
            #   # The returned object is of type Google::Cloud::ServiceUsage::V1::BatchGetServicesResponse.
            #   p result
            #
            def batch_get_services request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ServiceUsage::V1::BatchGetServicesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.batch_get_services.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ServiceUsage::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.batch_get_services.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.batch_get_services.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @service_usage_stub.call_rpc :batch_get_services, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the ServiceUsage API.
            #
            # This class represents the configuration for ServiceUsage,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::ServiceUsage::V1::ServiceUsage::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # enable_service to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::ServiceUsage::V1::ServiceUsage::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.enable_service.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::ServiceUsage::V1::ServiceUsage::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.enable_service.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::ServiceUsage::V1::ServiceUsage::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "serviceusage.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the ServiceUsage API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `enable_service`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :enable_service
                ##
                # RPC-specific configuration for `disable_service`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :disable_service
                ##
                # RPC-specific configuration for `get_service`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_service
                ##
                # RPC-specific configuration for `list_services`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_services
                ##
                # RPC-specific configuration for `batch_enable_services`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :batch_enable_services
                ##
                # RPC-specific configuration for `batch_get_services`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :batch_get_services

                # @private
                def initialize parent_rpcs = nil
                  enable_service_config = parent_rpcs.enable_service if parent_rpcs.respond_to? :enable_service
                  @enable_service = ::Gapic::Config::Method.new enable_service_config
                  disable_service_config = parent_rpcs.disable_service if parent_rpcs.respond_to? :disable_service
                  @disable_service = ::Gapic::Config::Method.new disable_service_config
                  get_service_config = parent_rpcs.get_service if parent_rpcs.respond_to? :get_service
                  @get_service = ::Gapic::Config::Method.new get_service_config
                  list_services_config = parent_rpcs.list_services if parent_rpcs.respond_to? :list_services
                  @list_services = ::Gapic::Config::Method.new list_services_config
                  batch_enable_services_config = parent_rpcs.batch_enable_services if parent_rpcs.respond_to? :batch_enable_services
                  @batch_enable_services = ::Gapic::Config::Method.new batch_enable_services_config
                  batch_get_services_config = parent_rpcs.batch_get_services if parent_rpcs.respond_to? :batch_get_services
                  @batch_get_services = ::Gapic::Config::Method.new batch_get_services_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
