# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/api/serviceusage/v1/serviceusage.proto for package 'Google.Cloud.ServiceUsage.V1'
# Original file comments:
# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/api/serviceusage/v1/serviceusage_pb'

module Google
  module Cloud
    module ServiceUsage
      module V1
        module ServiceUsage
          # Enables services that service consumers want to use on Google Cloud Platform,
          # lists the available or enabled services, or disables services that service
          # consumers no longer use.
          #
          # See [Service Usage API](https://cloud.google.com/service-usage/docs/overview)
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.api.serviceusage.v1.ServiceUsage'

            # Enable a service so that it can be used with a project.
            rpc :EnableService, ::Google::Cloud::ServiceUsage::V1::EnableServiceRequest, ::Google::Longrunning::Operation
            # Disable a service so that it can no longer be used with a project.
            # This prevents unintended usage that may cause unexpected billing
            # charges or security leaks.
            #
            # It is not valid to call the disable method on a service that is not
            # currently enabled. Callers will receive a `FAILED_PRECONDITION` status if
            # the target service is not currently enabled.
            rpc :DisableService, ::Google::Cloud::ServiceUsage::V1::DisableServiceRequest, ::Google::Longrunning::Operation
            # Returns the service configuration and enabled state for a given service.
            rpc :GetService, ::Google::Cloud::ServiceUsage::V1::GetServiceRequest, ::Google::Cloud::ServiceUsage::V1::Service
            # List all services available to the specified project, and the current
            # state of those services with respect to the project. The list includes
            # all public services, all services for which the calling user has the
            # `servicemanagement.services.bind` permission, and all services that have
            # already been enabled on the project. The list can be filtered to
            # only include services in a specific state, for example to only include
            # services enabled on the project.
            #
            # WARNING: If you need to query enabled services frequently or across
            # an organization, you should use
            # [Cloud Asset Inventory
            # API](https://cloud.google.com/asset-inventory/docs/apis), which provides
            # higher throughput and richer filtering capability.
            rpc :ListServices, ::Google::Cloud::ServiceUsage::V1::ListServicesRequest, ::Google::Cloud::ServiceUsage::V1::ListServicesResponse
            # Enable multiple services on a project. The operation is atomic: if enabling
            # any service fails, then the entire batch fails, and no state changes occur.
            # To enable a single service, use the `EnableService` method instead.
            rpc :BatchEnableServices, ::Google::Cloud::ServiceUsage::V1::BatchEnableServicesRequest, ::Google::Longrunning::Operation
            # Returns the service configurations and enabled states for a given list of
            # services.
            rpc :BatchGetServices, ::Google::Cloud::ServiceUsage::V1::BatchGetServicesRequest, ::Google::Cloud::ServiceUsage::V1::BatchGetServicesResponse
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
