# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Api
    # Logging configuration of the service.
    #
    # The following example shows how to configure logs to be sent to the
    # producer and consumer projects. In the example, the `activity_history`
    # log is sent to both the producer and consumer projects, whereas the
    # `purchase_history` log is only sent to the producer project.
    #
    #     monitored_resources:
    #     - type: library.googleapis.com/branch
    #       labels:
    #       - key: /city
    #         description: The city where the library branch is located in.
    #       - key: /name
    #         description: The name of the branch.
    #     logs:
    #     - name: activity_history
    #       labels:
    #       - key: /customer_id
    #     - name: purchase_history
    #     logging:
    #       producer_destinations:
    #       - monitored_resource: library.googleapis.com/branch
    #         logs:
    #         - activity_history
    #         - purchase_history
    #       consumer_destinations:
    #       - monitored_resource: library.googleapis.com/branch
    #         logs:
    #         - activity_history
    # @!attribute [rw] producer_destinations
    #   @return [::Array<::Google::Api::Logging::LoggingDestination>]
    #     Logging configurations for sending logs to the producer project.
    #     There can be multiple producer destinations, each one must have a
    #     different monitored resource type. A log can be used in at most
    #     one producer destination.
    # @!attribute [rw] consumer_destinations
    #   @return [::Array<::Google::Api::Logging::LoggingDestination>]
    #     Logging configurations for sending logs to the consumer project.
    #     There can be multiple consumer destinations, each one must have a
    #     different monitored resource type. A log can be used in at most
    #     one consumer destination.
    class Logging
      include ::Google::Protobuf::MessageExts
      extend ::Google::Protobuf::MessageExts::ClassMethods

      # Configuration of a specific logging destination (the producer project
      # or the consumer project).
      # @!attribute [rw] monitored_resource
      #   @return [::String]
      #     The monitored resource type. The type must be defined in the
      #     {::Google::Api::Service#monitored_resources Service.monitored_resources}
      #     section.
      # @!attribute [rw] logs
      #   @return [::Array<::String>]
      #     Names of the logs to be sent to this destination. Each name must
      #     be defined in the {::Google::Api::Service#logs Service.logs} section. If the
      #     log name is not a domain scoped name, it will be automatically prefixed
      #     with the service name followed by "/".
      class LoggingDestination
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods
      end
    end
  end
end
