# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Api
    # Output generated from semantically comparing two versions of a service
    # configuration.
    #
    # Includes detailed information about a field that have changed with
    # applicable advice about potential consequences for the change, such as
    # backwards-incompatibility.
    # @!attribute [rw] element
    #   @return [::String]
    #     Object hierarchy path to the change, with levels separated by a '.'
    #     character. For repeated fields, an applicable unique identifier field is
    #     used for the index (usually selector, name, or id). For maps, the term
    #     'key' is used. If the field has no unique identifier, the numeric index
    #     is used.
    #     Examples:
    #     - visibility.rules[selector=="google.LibraryService.ListBooks"].restriction
    #     - quota.metric_rules[selector=="google"].metric_costs[key=="reads"].value
    #     - logging.producer_destinations[0]
    # @!attribute [rw] old_value
    #   @return [::String]
    #     Value of the changed object in the old Service configuration,
    #     in JSON format. This field will not be populated if ChangeType == ADDED.
    # @!attribute [rw] new_value
    #   @return [::String]
    #     Value of the changed object in the new Service configuration,
    #     in JSON format. This field will not be populated if ChangeType == REMOVED.
    # @!attribute [rw] change_type
    #   @return [::Google::Api::ChangeType]
    #     The type for this change, either ADDED, REMOVED, or MODIFIED.
    # @!attribute [rw] advices
    #   @return [::Array<::Google::Api::Advice>]
    #     Collection of advice provided for this change, useful for determining the
    #     possible impact of this change.
    class ConfigChange
      include ::Google::Protobuf::MessageExts
      extend ::Google::Protobuf::MessageExts::ClassMethods
    end

    # Generated advice about this change, used for providing more
    # information about how a change will affect the existing service.
    # @!attribute [rw] description
    #   @return [::String]
    #     Useful description for why this advice was applied and what actions should
    #     be taken to mitigate any implied risks.
    class Advice
      include ::Google::Protobuf::MessageExts
      extend ::Google::Protobuf::MessageExts::ClassMethods
    end

    # Classifies set of possible modifications to an object in the service
    # configuration.
    module ChangeType
      # No value was provided.
      CHANGE_TYPE_UNSPECIFIED = 0

      # The changed object exists in the 'new' service configuration, but not
      # in the 'old' service configuration.
      ADDED = 1

      # The changed object exists in the 'old' service configuration, but not
      # in the 'new' service configuration.
      REMOVED = 2

      # The changed object exists in both service configurations, but its value
      # is different.
      MODIFIED = 3
    end
  end
end
