# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/api/servicemanagement/v1/servicemanager_pb"
require "google/cloud/service_management/v1/service_manager/rest/service_stub"
require "google/iam/v1/rest"

module Google
  module Cloud
    module ServiceManagement
      module V1
        module ServiceManager
          module Rest
            ##
            # REST client for the ServiceManager service.
            #
            # [Google Service Management
            # API](https://cloud.google.com/service-infrastructure/docs/overview)
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "servicemanagement.$UNIVERSE_DOMAIN$"

              # @private
              attr_reader :service_manager_stub

              ##
              # Configure the ServiceManager Client class.
              #
              # See {::Google::Cloud::ServiceManagement::V1::ServiceManager::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all ServiceManager clients
              #   ::Google::Cloud::ServiceManagement::V1::ServiceManager::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "ServiceManagement", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 10.0

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the ServiceManager Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::ServiceManagement::V1::ServiceManager::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @service_manager_stub.universe_domain
              end

              ##
              # Create a new ServiceManager REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::ServiceManagement::V1::ServiceManager::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::ServiceManagement::V1::ServiceManager::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the ServiceManager client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::ServiceManagement::V1::ServiceManager::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @service_manager_stub = ::Google::Cloud::ServiceManagement::V1::ServiceManager::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @service_manager_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @iam_policy_client = Google::Iam::V1::IAMPolicy::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @service_manager_stub.endpoint
                  config.universe_domain = @service_manager_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @service_manager_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::ServiceManagement::V1::ServiceManager::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the IAMPolicy.
              #
              # @return [Google::Iam::V1::IAMPolicy::Rest::Client]
              #
              attr_reader :iam_policy_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @service_manager_stub.logger
              end

              # Service calls

              ##
              # Lists managed services.
              #
              # Returns all public services. For authenticated users, also returns all
              # services the calling user has "servicemanagement.services.get" permission
              # for.
              #
              # @overload list_services(request, options = nil)
              #   Pass arguments to `list_services` via a request object, either of type
              #   {::Google::Cloud::ServiceManagement::V1::ListServicesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ServiceManagement::V1::ListServicesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_services(producer_project_id: nil, page_size: nil, page_token: nil, consumer_id: nil)
              #   Pass arguments to `list_services` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param producer_project_id [::String]
              #     Include services produced by the specified project.
              #   @param page_size [::Integer]
              #     The max number of items to include in the response list. Page size is 50
              #     if not specified. Maximum value is 500.
              #   @param page_token [::String]
              #     Token identifying which result to start with; returned by a previous list
              #     call.
              #   @param consumer_id [::String]
              #     Include services consumed by the specified consumer.
              #
              #     The Google Service Management implementation accepts the following
              #     forms:
              #     - project:<project_id>
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ServiceManagement::V1::ManagedService>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ServiceManagement::V1::ManagedService>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/service_management/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ServiceManagement::V1::ServiceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ServiceManagement::V1::ListServicesRequest.new
              #
              #   # Call the list_services method.
              #   result = client.list_services request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::ServiceManagement::V1::ManagedService.
              #     p item
              #   end
              #
              def list_services request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ServiceManagement::V1::ListServicesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_services.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ServiceManagement::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_services.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_services.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @service_manager_stub.list_services request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @service_manager_stub, :list_services, "services", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a managed service. Authentication is required unless the service is
              # public.
              #
              # @overload get_service(request, options = nil)
              #   Pass arguments to `get_service` via a request object, either of type
              #   {::Google::Cloud::ServiceManagement::V1::GetServiceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ServiceManagement::V1::GetServiceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_service(service_name: nil)
              #   Pass arguments to `get_service` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param service_name [::String]
              #     Required. The name of the service.  See the `ServiceManager` overview for
              #     naming requirements.  For example: `example.googleapis.com`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ServiceManagement::V1::ManagedService]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ServiceManagement::V1::ManagedService]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/service_management/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ServiceManagement::V1::ServiceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ServiceManagement::V1::GetServiceRequest.new
              #
              #   # Call the get_service method.
              #   result = client.get_service request
              #
              #   # The returned object is of type Google::Cloud::ServiceManagement::V1::ManagedService.
              #   p result
              #
              def get_service request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ServiceManagement::V1::GetServiceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_service.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ServiceManagement::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_service.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_service.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @service_manager_stub.get_service request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new managed service.
              #
              # A managed service is immutable, and is subject to mandatory 30-day
              # data retention. You cannot move a service or recreate it within 30 days
              # after deletion.
              #
              # One producer project can own no more than 500 services. For security and
              # reliability purposes, a production service should be hosted in a
              # dedicated producer project.
              #
              # Operation<response: ManagedService>
              #
              # @overload create_service(request, options = nil)
              #   Pass arguments to `create_service` via a request object, either of type
              #   {::Google::Cloud::ServiceManagement::V1::CreateServiceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ServiceManagement::V1::CreateServiceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_service(service: nil)
              #   Pass arguments to `create_service` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param service [::Google::Cloud::ServiceManagement::V1::ManagedService, ::Hash]
              #     Required. Initial values for the service resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/service_management/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ServiceManagement::V1::ServiceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ServiceManagement::V1::CreateServiceRequest.new
              #
              #   # Call the create_service method.
              #   result = client.create_service request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_service request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ServiceManagement::V1::CreateServiceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_service.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ServiceManagement::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_service.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_service.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @service_manager_stub.create_service request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a managed service. This method will change the service to the
              # `Soft-Delete` state for 30 days. Within this period, service producers may
              # call
              # {::Google::Cloud::ServiceManagement::V1::ServiceManager::Rest::Client#undelete_service UndeleteService}
              # to restore the service. After 30 days, the service will be permanently
              # deleted.
              #
              # Operation<response: google.protobuf.Empty>
              #
              # @overload delete_service(request, options = nil)
              #   Pass arguments to `delete_service` via a request object, either of type
              #   {::Google::Cloud::ServiceManagement::V1::DeleteServiceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ServiceManagement::V1::DeleteServiceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_service(service_name: nil)
              #   Pass arguments to `delete_service` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param service_name [::String]
              #     Required. The name of the service.  See the
              #     [overview](https://cloud.google.com/service-management/overview) for naming
              #     requirements.  For example: `example.googleapis.com`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/service_management/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ServiceManagement::V1::ServiceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ServiceManagement::V1::DeleteServiceRequest.new
              #
              #   # Call the delete_service method.
              #   result = client.delete_service request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_service request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ServiceManagement::V1::DeleteServiceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_service.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ServiceManagement::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_service.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_service.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @service_manager_stub.delete_service request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Revives a previously deleted managed service. The method restores the
              # service using the configuration at the time the service was deleted.
              # The target service must exist and must have been deleted within the
              # last 30 days.
              #
              # Operation<response: UndeleteServiceResponse>
              #
              # @overload undelete_service(request, options = nil)
              #   Pass arguments to `undelete_service` via a request object, either of type
              #   {::Google::Cloud::ServiceManagement::V1::UndeleteServiceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ServiceManagement::V1::UndeleteServiceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload undelete_service(service_name: nil)
              #   Pass arguments to `undelete_service` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param service_name [::String]
              #     Required. The name of the service. See the
              #     [overview](https://cloud.google.com/service-management/overview) for naming
              #     requirements. For example: `example.googleapis.com`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/service_management/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ServiceManagement::V1::ServiceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ServiceManagement::V1::UndeleteServiceRequest.new
              #
              #   # Call the undelete_service method.
              #   result = client.undelete_service request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def undelete_service request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ServiceManagement::V1::UndeleteServiceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.undelete_service.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ServiceManagement::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.undelete_service.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.undelete_service.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @service_manager_stub.undelete_service request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists the history of the service configuration for a managed service,
              # from the newest to the oldest.
              #
              # @overload list_service_configs(request, options = nil)
              #   Pass arguments to `list_service_configs` via a request object, either of type
              #   {::Google::Cloud::ServiceManagement::V1::ListServiceConfigsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ServiceManagement::V1::ListServiceConfigsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_service_configs(service_name: nil, page_token: nil, page_size: nil)
              #   Pass arguments to `list_service_configs` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param service_name [::String]
              #     Required. The name of the service.  See the
              #     [overview](https://cloud.google.com/service-management/overview) for naming
              #     requirements.  For example: `example.googleapis.com`.
              #   @param page_token [::String]
              #     The token of the page to retrieve.
              #   @param page_size [::Integer]
              #     The max number of items to include in the response list. Page size is 50
              #     if not specified. Maximum value is 100.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Api::Service>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Api::Service>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/service_management/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ServiceManagement::V1::ServiceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ServiceManagement::V1::ListServiceConfigsRequest.new
              #
              #   # Call the list_service_configs method.
              #   result = client.list_service_configs request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Api::Service.
              #     p item
              #   end
              #
              def list_service_configs request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ServiceManagement::V1::ListServiceConfigsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_service_configs.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ServiceManagement::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_service_configs.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_service_configs.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @service_manager_stub.list_service_configs request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @service_manager_stub, :list_service_configs, "service_configs", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a service configuration (version) for a managed service.
              #
              # @overload get_service_config(request, options = nil)
              #   Pass arguments to `get_service_config` via a request object, either of type
              #   {::Google::Cloud::ServiceManagement::V1::GetServiceConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ServiceManagement::V1::GetServiceConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_service_config(service_name: nil, config_id: nil, view: nil)
              #   Pass arguments to `get_service_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param service_name [::String]
              #     Required. The name of the service.  See the
              #     [overview](https://cloud.google.com/service-management/overview) for naming
              #     requirements.  For example: `example.googleapis.com`.
              #   @param config_id [::String]
              #     Required. The id of the service configuration resource.
              #
              #     This field must be specified for the server to return all fields, including
              #     `SourceInfo`.
              #   @param view [::Google::Cloud::ServiceManagement::V1::GetServiceConfigRequest::ConfigView]
              #     Specifies which parts of the Service Config should be returned in the
              #     response.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Api::Service]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Api::Service]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/service_management/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ServiceManagement::V1::ServiceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ServiceManagement::V1::GetServiceConfigRequest.new
              #
              #   # Call the get_service_config method.
              #   result = client.get_service_config request
              #
              #   # The returned object is of type Google::Api::Service.
              #   p result
              #
              def get_service_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ServiceManagement::V1::GetServiceConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_service_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ServiceManagement::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_service_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_service_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @service_manager_stub.get_service_config request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new service configuration (version) for a managed service.
              # This method only stores the service configuration. To roll out the service
              # configuration to backend systems please call
              # {::Google::Cloud::ServiceManagement::V1::ServiceManager::Rest::Client#create_service_rollout CreateServiceRollout}.
              #
              # Only the 100 most recent service configurations and ones referenced by
              # existing rollouts are kept for each service. The rest will be deleted
              # eventually.
              #
              # @overload create_service_config(request, options = nil)
              #   Pass arguments to `create_service_config` via a request object, either of type
              #   {::Google::Cloud::ServiceManagement::V1::CreateServiceConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ServiceManagement::V1::CreateServiceConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_service_config(service_name: nil, service_config: nil)
              #   Pass arguments to `create_service_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param service_name [::String]
              #     Required. The name of the service.  See the
              #     [overview](https://cloud.google.com/service-management/overview) for naming
              #     requirements.  For example: `example.googleapis.com`.
              #   @param service_config [::Google::Api::Service, ::Hash]
              #     Required. The service configuration resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Api::Service]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Api::Service]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/service_management/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ServiceManagement::V1::ServiceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ServiceManagement::V1::CreateServiceConfigRequest.new
              #
              #   # Call the create_service_config method.
              #   result = client.create_service_config request
              #
              #   # The returned object is of type Google::Api::Service.
              #   p result
              #
              def create_service_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ServiceManagement::V1::CreateServiceConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_service_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ServiceManagement::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_service_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_service_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @service_manager_stub.create_service_config request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new service configuration (version) for a managed service based
              # on
              # user-supplied configuration source files (for example: OpenAPI
              # Specification). This method stores the source configurations as well as the
              # generated service configuration. To rollout the service configuration to
              # other services,
              # please call
              # {::Google::Cloud::ServiceManagement::V1::ServiceManager::Rest::Client#create_service_rollout CreateServiceRollout}.
              #
              # Only the 100 most recent configuration sources and ones referenced by
              # existing service configurtions are kept for each service. The rest will be
              # deleted eventually.
              #
              # Operation<response: SubmitConfigSourceResponse>
              #
              # @overload submit_config_source(request, options = nil)
              #   Pass arguments to `submit_config_source` via a request object, either of type
              #   {::Google::Cloud::ServiceManagement::V1::SubmitConfigSourceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ServiceManagement::V1::SubmitConfigSourceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload submit_config_source(service_name: nil, config_source: nil, validate_only: nil)
              #   Pass arguments to `submit_config_source` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param service_name [::String]
              #     Required. The name of the service.  See the
              #     [overview](https://cloud.google.com/service-management/overview) for naming
              #     requirements.  For example: `example.googleapis.com`.
              #   @param config_source [::Google::Cloud::ServiceManagement::V1::ConfigSource, ::Hash]
              #     Required. The source configuration for the service.
              #   @param validate_only [::Boolean]
              #     Optional. If set, this will result in the generation of a
              #     `google.api.Service` configuration based on the `ConfigSource` provided,
              #     but the generated config and the sources will NOT be persisted.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/service_management/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ServiceManagement::V1::ServiceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ServiceManagement::V1::SubmitConfigSourceRequest.new
              #
              #   # Call the submit_config_source method.
              #   result = client.submit_config_source request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def submit_config_source request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ServiceManagement::V1::SubmitConfigSourceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.submit_config_source.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ServiceManagement::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.submit_config_source.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.submit_config_source.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @service_manager_stub.submit_config_source request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists the history of the service configuration rollouts for a managed
              # service, from the newest to the oldest.
              #
              # @overload list_service_rollouts(request, options = nil)
              #   Pass arguments to `list_service_rollouts` via a request object, either of type
              #   {::Google::Cloud::ServiceManagement::V1::ListServiceRolloutsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ServiceManagement::V1::ListServiceRolloutsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_service_rollouts(service_name: nil, page_token: nil, page_size: nil, filter: nil)
              #   Pass arguments to `list_service_rollouts` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param service_name [::String]
              #     Required. The name of the service.  See the
              #     [overview](https://cloud.google.com/service-management/overview) for naming
              #     requirements.  For example: `example.googleapis.com`.
              #   @param page_token [::String]
              #     The token of the page to retrieve.
              #   @param page_size [::Integer]
              #     The max number of items to include in the response list. Page size is 50
              #     if not specified. Maximum value is 100.
              #   @param filter [::String]
              #     Required. Use `filter` to return subset of rollouts.
              #     The following filters are supported:
              #
              #      -- By [status]
              #      [google.api.servicemanagement.v1.Rollout.RolloutStatus]. For example,
              #      `filter='status=SUCCESS'`
              #
              #      -- By [strategy]
              #      [google.api.servicemanagement.v1.Rollout.strategy]. For example,
              #      `filter='strategy=TrafficPercentStrategy'`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ServiceManagement::V1::Rollout>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ServiceManagement::V1::Rollout>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/service_management/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ServiceManagement::V1::ServiceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ServiceManagement::V1::ListServiceRolloutsRequest.new
              #
              #   # Call the list_service_rollouts method.
              #   result = client.list_service_rollouts request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::ServiceManagement::V1::Rollout.
              #     p item
              #   end
              #
              def list_service_rollouts request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ServiceManagement::V1::ListServiceRolloutsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_service_rollouts.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ServiceManagement::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_service_rollouts.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_service_rollouts.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @service_manager_stub.list_service_rollouts request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @service_manager_stub, :list_service_rollouts, "rollouts", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a service configuration
              # {::Google::Cloud::ServiceManagement::V1::Rollout rollout}.
              #
              # @overload get_service_rollout(request, options = nil)
              #   Pass arguments to `get_service_rollout` via a request object, either of type
              #   {::Google::Cloud::ServiceManagement::V1::GetServiceRolloutRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ServiceManagement::V1::GetServiceRolloutRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_service_rollout(service_name: nil, rollout_id: nil)
              #   Pass arguments to `get_service_rollout` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param service_name [::String]
              #     Required. The name of the service.  See the
              #     [overview](https://cloud.google.com/service-management/overview) for naming
              #     requirements.  For example: `example.googleapis.com`.
              #   @param rollout_id [::String]
              #     Required. The id of the rollout resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ServiceManagement::V1::Rollout]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ServiceManagement::V1::Rollout]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/service_management/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ServiceManagement::V1::ServiceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ServiceManagement::V1::GetServiceRolloutRequest.new
              #
              #   # Call the get_service_rollout method.
              #   result = client.get_service_rollout request
              #
              #   # The returned object is of type Google::Cloud::ServiceManagement::V1::Rollout.
              #   p result
              #
              def get_service_rollout request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ServiceManagement::V1::GetServiceRolloutRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_service_rollout.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ServiceManagement::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_service_rollout.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_service_rollout.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @service_manager_stub.get_service_rollout request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new service configuration rollout. Based on rollout, the
              # Google Service Management will roll out the service configurations to
              # different backend services. For example, the logging configuration will be
              # pushed to Google Cloud Logging.
              #
              # Please note that any previous pending and running Rollouts and associated
              # Operations will be automatically cancelled so that the latest Rollout will
              # not be blocked by previous Rollouts.
              #
              # Only the 100 most recent (in any state) and the last 10 successful (if not
              # already part of the set of 100 most recent) rollouts are kept for each
              # service. The rest will be deleted eventually.
              #
              # Operation<response: Rollout>
              #
              # @overload create_service_rollout(request, options = nil)
              #   Pass arguments to `create_service_rollout` via a request object, either of type
              #   {::Google::Cloud::ServiceManagement::V1::CreateServiceRolloutRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ServiceManagement::V1::CreateServiceRolloutRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_service_rollout(service_name: nil, rollout: nil)
              #   Pass arguments to `create_service_rollout` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param service_name [::String]
              #     Required. The name of the service.  See the
              #     [overview](https://cloud.google.com/service-management/overview) for naming
              #     requirements.  For example: `example.googleapis.com`.
              #   @param rollout [::Google::Cloud::ServiceManagement::V1::Rollout, ::Hash]
              #     Required. The rollout resource. The `service_name` field is output only.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/service_management/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ServiceManagement::V1::ServiceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ServiceManagement::V1::CreateServiceRolloutRequest.new
              #
              #   # Call the create_service_rollout method.
              #   result = client.create_service_rollout request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_service_rollout request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ServiceManagement::V1::CreateServiceRolloutRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_service_rollout.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ServiceManagement::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_service_rollout.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_service_rollout.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @service_manager_stub.create_service_rollout request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Generates and returns a report (errors, warnings and changes from
              # existing configurations) associated with
              # GenerateConfigReportRequest.new_value
              #
              # If GenerateConfigReportRequest.old_value is specified,
              # GenerateConfigReportRequest will contain a single ChangeReport based on the
              # comparison between GenerateConfigReportRequest.new_value and
              # GenerateConfigReportRequest.old_value.
              # If GenerateConfigReportRequest.old_value is not specified, this method
              # will compare GenerateConfigReportRequest.new_value with the last pushed
              # service configuration.
              #
              # @overload generate_config_report(request, options = nil)
              #   Pass arguments to `generate_config_report` via a request object, either of type
              #   {::Google::Cloud::ServiceManagement::V1::GenerateConfigReportRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ServiceManagement::V1::GenerateConfigReportRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload generate_config_report(new_config: nil, old_config: nil)
              #   Pass arguments to `generate_config_report` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param new_config [::Google::Protobuf::Any, ::Hash]
              #     Required. Service configuration for which we want to generate the report.
              #     For this version of API, the supported types are
              #     {::Google::Cloud::ServiceManagement::V1::ConfigRef google.api.servicemanagement.v1.ConfigRef},
              #     {::Google::Cloud::ServiceManagement::V1::ConfigSource google.api.servicemanagement.v1.ConfigSource},
              #     and {::Google::Api::Service google.api.Service}
              #   @param old_config [::Google::Protobuf::Any, ::Hash]
              #     Optional. Service configuration against which the comparison will be done.
              #     For this version of API, the supported types are
              #     {::Google::Cloud::ServiceManagement::V1::ConfigRef google.api.servicemanagement.v1.ConfigRef},
              #     {::Google::Cloud::ServiceManagement::V1::ConfigSource google.api.servicemanagement.v1.ConfigSource},
              #     and {::Google::Api::Service google.api.Service}
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ServiceManagement::V1::GenerateConfigReportResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ServiceManagement::V1::GenerateConfigReportResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/service_management/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ServiceManagement::V1::ServiceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ServiceManagement::V1::GenerateConfigReportRequest.new
              #
              #   # Call the generate_config_report method.
              #   result = client.generate_config_report request
              #
              #   # The returned object is of type Google::Cloud::ServiceManagement::V1::GenerateConfigReportResponse.
              #   p result
              #
              def generate_config_report request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ServiceManagement::V1::GenerateConfigReportRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.generate_config_report.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ServiceManagement::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.generate_config_report.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.generate_config_report.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @service_manager_stub.generate_config_report request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the ServiceManager REST API.
              #
              # This class represents the configuration for ServiceManager REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::ServiceManagement::V1::ServiceManager::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # list_services to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::ServiceManagement::V1::ServiceManager::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_services.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::ServiceManagement::V1::ServiceManager::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_services.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "servicemanagement.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the ServiceManager API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `list_services`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_services
                  ##
                  # RPC-specific configuration for `get_service`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_service
                  ##
                  # RPC-specific configuration for `create_service`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_service
                  ##
                  # RPC-specific configuration for `delete_service`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_service
                  ##
                  # RPC-specific configuration for `undelete_service`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :undelete_service
                  ##
                  # RPC-specific configuration for `list_service_configs`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_service_configs
                  ##
                  # RPC-specific configuration for `get_service_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_service_config
                  ##
                  # RPC-specific configuration for `create_service_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_service_config
                  ##
                  # RPC-specific configuration for `submit_config_source`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :submit_config_source
                  ##
                  # RPC-specific configuration for `list_service_rollouts`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_service_rollouts
                  ##
                  # RPC-specific configuration for `get_service_rollout`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_service_rollout
                  ##
                  # RPC-specific configuration for `create_service_rollout`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_service_rollout
                  ##
                  # RPC-specific configuration for `generate_config_report`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :generate_config_report

                  # @private
                  def initialize parent_rpcs = nil
                    list_services_config = parent_rpcs.list_services if parent_rpcs.respond_to? :list_services
                    @list_services = ::Gapic::Config::Method.new list_services_config
                    get_service_config = parent_rpcs.get_service if parent_rpcs.respond_to? :get_service
                    @get_service = ::Gapic::Config::Method.new get_service_config
                    create_service_config = parent_rpcs.create_service if parent_rpcs.respond_to? :create_service
                    @create_service = ::Gapic::Config::Method.new create_service_config
                    delete_service_config = parent_rpcs.delete_service if parent_rpcs.respond_to? :delete_service
                    @delete_service = ::Gapic::Config::Method.new delete_service_config
                    undelete_service_config = parent_rpcs.undelete_service if parent_rpcs.respond_to? :undelete_service
                    @undelete_service = ::Gapic::Config::Method.new undelete_service_config
                    list_service_configs_config = parent_rpcs.list_service_configs if parent_rpcs.respond_to? :list_service_configs
                    @list_service_configs = ::Gapic::Config::Method.new list_service_configs_config
                    get_service_config_config = parent_rpcs.get_service_config if parent_rpcs.respond_to? :get_service_config
                    @get_service_config = ::Gapic::Config::Method.new get_service_config_config
                    create_service_config_config = parent_rpcs.create_service_config if parent_rpcs.respond_to? :create_service_config
                    @create_service_config = ::Gapic::Config::Method.new create_service_config_config
                    submit_config_source_config = parent_rpcs.submit_config_source if parent_rpcs.respond_to? :submit_config_source
                    @submit_config_source = ::Gapic::Config::Method.new submit_config_source_config
                    list_service_rollouts_config = parent_rpcs.list_service_rollouts if parent_rpcs.respond_to? :list_service_rollouts
                    @list_service_rollouts = ::Gapic::Config::Method.new list_service_rollouts_config
                    get_service_rollout_config = parent_rpcs.get_service_rollout if parent_rpcs.respond_to? :get_service_rollout
                    @get_service_rollout = ::Gapic::Config::Method.new get_service_rollout_config
                    create_service_rollout_config = parent_rpcs.create_service_rollout if parent_rpcs.respond_to? :create_service_rollout
                    @create_service_rollout = ::Gapic::Config::Method.new create_service_rollout_config
                    generate_config_report_config = parent_rpcs.generate_config_report if parent_rpcs.respond_to? :generate_config_report
                    @generate_config_report = ::Gapic::Config::Method.new generate_config_report_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
