# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/servicehealth/v1/event_service_pb"
require "google/cloud/service_health/v1/service_health"

class ::Google::Cloud::ServiceHealth::V1::ServiceHealth::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_events
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ServiceHealth::V1::ListEventsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    view = :EVENT_VIEW_UNSPECIFIED

    list_events_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_events, name
      assert_kind_of ::Google::Cloud::ServiceHealth::V1::ListEventsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal :EVENT_VIEW_UNSPECIFIED, request["view"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_events_client_stub do
      # Create client
      client = ::Google::Cloud::ServiceHealth::V1::ServiceHealth::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_events({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, view: view }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_events parent: parent, page_size: page_size, page_token: page_token, filter: filter, view: view do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_events ::Google::Cloud::ServiceHealth::V1::ListEventsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, view: view) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_events({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, view: view }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_events(::Google::Cloud::ServiceHealth::V1::ListEventsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, view: view), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_events_client_stub.call_rpc_count
    end
  end

  def test_get_event
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ServiceHealth::V1::Event.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_event_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_event, name
      assert_kind_of ::Google::Cloud::ServiceHealth::V1::GetEventRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_event_client_stub do
      # Create client
      client = ::Google::Cloud::ServiceHealth::V1::ServiceHealth::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_event({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_event name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_event ::Google::Cloud::ServiceHealth::V1::GetEventRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_event({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_event(::Google::Cloud::ServiceHealth::V1::GetEventRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_event_client_stub.call_rpc_count
    end
  end

  def test_list_organization_events
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ServiceHealth::V1::ListOrganizationEventsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    view = :ORGANIZATION_EVENT_VIEW_UNSPECIFIED

    list_organization_events_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_organization_events, name
      assert_kind_of ::Google::Cloud::ServiceHealth::V1::ListOrganizationEventsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal :ORGANIZATION_EVENT_VIEW_UNSPECIFIED, request["view"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_organization_events_client_stub do
      # Create client
      client = ::Google::Cloud::ServiceHealth::V1::ServiceHealth::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_organization_events({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, view: view }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_organization_events parent: parent, page_size: page_size, page_token: page_token, filter: filter, view: view do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_organization_events ::Google::Cloud::ServiceHealth::V1::ListOrganizationEventsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, view: view) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_organization_events({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, view: view }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_organization_events(::Google::Cloud::ServiceHealth::V1::ListOrganizationEventsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, view: view), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_organization_events_client_stub.call_rpc_count
    end
  end

  def test_get_organization_event
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ServiceHealth::V1::OrganizationEvent.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_organization_event_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_organization_event, name
      assert_kind_of ::Google::Cloud::ServiceHealth::V1::GetOrganizationEventRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_organization_event_client_stub do
      # Create client
      client = ::Google::Cloud::ServiceHealth::V1::ServiceHealth::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_organization_event({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_organization_event name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_organization_event ::Google::Cloud::ServiceHealth::V1::GetOrganizationEventRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_organization_event({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_organization_event(::Google::Cloud::ServiceHealth::V1::GetOrganizationEventRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_organization_event_client_stub.call_rpc_count
    end
  end

  def test_list_organization_impacts
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ServiceHealth::V1::ListOrganizationImpactsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_organization_impacts_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_organization_impacts, name
      assert_kind_of ::Google::Cloud::ServiceHealth::V1::ListOrganizationImpactsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_organization_impacts_client_stub do
      # Create client
      client = ::Google::Cloud::ServiceHealth::V1::ServiceHealth::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_organization_impacts({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_organization_impacts parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_organization_impacts ::Google::Cloud::ServiceHealth::V1::ListOrganizationImpactsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_organization_impacts({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_organization_impacts(::Google::Cloud::ServiceHealth::V1::ListOrganizationImpactsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_organization_impacts_client_stub.call_rpc_count
    end
  end

  def test_get_organization_impact
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ServiceHealth::V1::OrganizationImpact.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_organization_impact_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_organization_impact, name
      assert_kind_of ::Google::Cloud::ServiceHealth::V1::GetOrganizationImpactRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_organization_impact_client_stub do
      # Create client
      client = ::Google::Cloud::ServiceHealth::V1::ServiceHealth::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_organization_impact({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_organization_impact name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_organization_impact ::Google::Cloud::ServiceHealth::V1::GetOrganizationImpactRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_organization_impact({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_organization_impact(::Google::Cloud::ServiceHealth::V1::GetOrganizationImpactRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_organization_impact_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::ServiceHealth::V1::ServiceHealth::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::ServiceHealth::V1::ServiceHealth::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::ServiceHealth::V1::ServiceHealth::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::ServiceHealth::V1::ServiceHealth::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
