# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ServiceHealth
      module V1
        # Represents service health events that may affect Google Cloud products.
        # Event resource is a read-only view and does not allow any modifications. All
        # fields are output only.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Identifier. Name of the event. Unique name of the event in
        #     this scope including project and location using the form
        #     `projects/{project_id}/locations/{location}/events/{event_id}`.
        # @!attribute [r] title
        #   @return [::String]
        #     Output only. Brief description for the event.
        # @!attribute [r] description
        #   @return [::String]
        #     Output only. Free-form, human-readable description.
        # @!attribute [r] category
        #   @return [::Google::Cloud::ServiceHealth::V1::Event::EventCategory]
        #     Output only. The category of the event.
        # @!attribute [r] detailed_category
        #   @return [::Google::Cloud::ServiceHealth::V1::Event::DetailedCategory]
        #     Output only. The detailed category of the event.
        # @!attribute [r] state
        #   @return [::Google::Cloud::ServiceHealth::V1::Event::State]
        #     Output only. The current state of the event.
        # @!attribute [r] detailed_state
        #   @return [::Google::Cloud::ServiceHealth::V1::Event::DetailedState]
        #     Output only. The current detailed state of the incident.
        # @!attribute [rw] event_impacts
        #   @return [::Array<::Google::Cloud::ServiceHealth::V1::EventImpact>]
        #     Google Cloud products and locations impacted by the event.
        # @!attribute [r] relevance
        #   @return [::Google::Cloud::ServiceHealth::V1::Event::Relevance]
        #     Output only. Communicates why a given event is deemed relevant in the
        #     context of a given project.
        # @!attribute [r] updates
        #   @return [::Array<::Google::Cloud::ServiceHealth::V1::EventUpdate>]
        #     Output only. Event updates are correspondence from Google.
        # @!attribute [r] parent_event
        #   @return [::String]
        #     Output only. When `detailed_state`=`MERGED`, `parent_event` contains the
        #     name of the parent event. All further updates will be published to the
        #     parent event.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the event was last modified.
        # @!attribute [r] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The start time of the event, if applicable.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The end time of the event, if applicable.
        # @!attribute [r] next_update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the next update can be expected.
        class Event
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The category of the event. This enum lists all possible categories of
          # event.
          module EventCategory
            # Unspecified category.
            EVENT_CATEGORY_UNSPECIFIED = 0

            # Event category for service outage or degradation.
            INCIDENT = 2
          end

          # The detailed category of an event. Contains all possible states for all
          # event categories.
          module DetailedCategory
            # Unspecified detailed category.
            DETAILED_CATEGORY_UNSPECIFIED = 0

            # Indicates an event with category INCIDENT has a confirmed impact to at
            # least one Google Cloud product.
            CONFIRMED_INCIDENT = 1

            # Indicates an event with category INCIDENT is under investigation to
            # determine if it has a confirmed impact on any Google Cloud products.
            EMERGING_INCIDENT = 2
          end

          # The state of the event. This enum lists all possible states of event.
          module State
            # Unspecified state.
            STATE_UNSPECIFIED = 0

            # Event is actively affecting a Google Cloud product and will continue to
            # receive updates.
            ACTIVE = 1

            # Event is no longer affecting the Google Cloud product or has been merged
            # with another event.
            CLOSED = 2
          end

          # The detailed state of the incident. This enum lists all possible detailed
          # states of an incident.
          module DetailedState
            # Unspecified detail state.
            DETAILED_STATE_UNSPECIFIED = 0

            # Google engineers are actively investigating the event to determine the
            # impact.
            EMERGING = 1

            # The incident is confirmed and impacting at least one Google Cloud
            # product. Ongoing status updates will be provided until it is resolved.
            CONFIRMED = 2

            # The incident is no longer affecting any Google Cloud product, and there
            # will be no further updates.
            RESOLVED = 3

            # The incident was merged into a parent incident. All further updates will
            # be published to the parent only. The `parent_event` field contains the
            # name of the parent.
            MERGED = 4

            # The incident was automatically closed because of the following reasons:
            #
            #  * The impact of the incident could not be confirmed.
            #  * The incident was intermittent or resolved itself.
            #
            #  The incident does not have a resolution because no action or
            #  investigation happened. If it is intermittent, the incident may reopen.
            AUTO_CLOSED = 9

            # Upon investigation, Google engineers concluded that the incident is not
            # affecting a Google Cloud product. This state can change if the incident
            # is reviewed again.
            FALSE_POSITIVE = 10
          end

          # Communicates why a given incident is deemed relevant in the context of a
          # given project. This enum lists all possible detailed states of relevance.
          module Relevance
            # Unspecified relevance.
            RELEVANCE_UNSPECIFIED = 0

            # The relevance of the incident to the project is unknown.
            UNKNOWN = 2

            # The incident does not impact the project.
            NOT_IMPACTED = 6

            # The incident is associated with a Google Cloud product your project uses,
            # but the incident may not be impacting your project. For example, the
            # incident may be impacting a Google Cloud product that your project uses,
            # but in a location that your project does not use.
            PARTIALLY_RELATED = 7

            # The incident has a direct connection with your project and impacts a
            # Google Cloud product in a location your project uses.
            RELATED = 8

            # The incident is verified to be impacting your project.
            IMPACTED = 9
          end
        end

        # Represents service health events that may affect Google Cloud products used
        # across the organization. It is a read-only view and does not allow any
        # modifications.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Identifier. Name of the event. Unique name of the event in
        #     this scope including organization ID and location using the form
        #     `organizations/{organization_id}/locations/{location}/organizationEvents/{event_id}`.
        #
        #     `organization_id` - see [Getting your organization resource
        #     ID](https://cloud.google.com/resource-manager/docs/creating-managing-organization#retrieving_your_organization_id).<br>
        #     `location` - The location to get the service health events from.<br>
        #     `event_id` - Organization event ID to retrieve.
        # @!attribute [r] title
        #   @return [::String]
        #     Output only. Brief description for the event.
        # @!attribute [r] description
        #   @return [::String]
        #     Output only. Free-form, human-readable description.
        # @!attribute [r] category
        #   @return [::Google::Cloud::ServiceHealth::V1::OrganizationEvent::EventCategory]
        #     Output only. The category of the event.
        # @!attribute [r] detailed_category
        #   @return [::Google::Cloud::ServiceHealth::V1::OrganizationEvent::DetailedCategory]
        #     Output only. The detailed category of the event.
        # @!attribute [r] state
        #   @return [::Google::Cloud::ServiceHealth::V1::OrganizationEvent::State]
        #     Output only. The current state of the event.
        # @!attribute [r] detailed_state
        #   @return [::Google::Cloud::ServiceHealth::V1::OrganizationEvent::DetailedState]
        #     Output only. The current detailed state of the incident.
        # @!attribute [r] event_impacts
        #   @return [::Array<::Google::Cloud::ServiceHealth::V1::EventImpact>]
        #     Output only. Represents the Google Cloud products and locations impacted by
        #     the event.
        # @!attribute [r] updates
        #   @return [::Array<::Google::Cloud::ServiceHealth::V1::EventUpdate>]
        #     Output only. Incident-only field. Event updates are correspondence from
        #     Google.
        # @!attribute [r] parent_event
        #   @return [::String]
        #     Output only. When `detailed_state`=`MERGED`, `parent_event` contains the
        #     name of the parent event. All further updates will be published to the
        #     parent event.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the update was posted.
        # @!attribute [r] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The start time of the event, if applicable.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The end time of the event, if applicable.
        # @!attribute [r] next_update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Incident-only field. The time when the next update can be
        #     expected.
        class OrganizationEvent
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The category of the event. This enum lists all possible categories of
          # event.
          module EventCategory
            # Unspecified category.
            EVENT_CATEGORY_UNSPECIFIED = 0

            # Event category for service outage or degradation.
            INCIDENT = 2
          end

          # The detailed category of an event. Contains all possible states for all
          # event categories.
          module DetailedCategory
            # Unspecified detailed category.
            DETAILED_CATEGORY_UNSPECIFIED = 0

            # Indicates an event with category INCIDENT has a confirmed impact to at
            # least one Google Cloud product.
            CONFIRMED_INCIDENT = 1

            # Indicates an event with category INCIDENT is under investigation to
            # determine if it has a confirmed impact on any Google Cloud products.
            EMERGING_INCIDENT = 2
          end

          # The state of the organization event. This enum lists all possible states of
          # event.
          module State
            # Unspecified state.
            STATE_UNSPECIFIED = 0

            # Event is actively affecting a Google Cloud product and will continue to
            # receive updates.
            ACTIVE = 1

            # Event is no longer affecting the Google Cloud product or has been merged
            # with another event.
            CLOSED = 2
          end

          # The detailed state of the incident. This enum lists all possible detailed
          # states of an incident.
          module DetailedState
            # Unspecified detail state.
            DETAILED_STATE_UNSPECIFIED = 0

            # Google engineers are actively investigating the incident to determine the
            # impact.
            EMERGING = 1

            # The incident is confirmed and impacting at least one Google Cloud
            # product. Ongoing status updates will be provided until it is resolved.
            CONFIRMED = 2

            # The incident is no longer affecting any Google Cloud product, and there
            # will be no further updates.
            RESOLVED = 3

            # The incident was merged into a parent event. All further updates will be
            # published to the parent only. The `parent_event` contains the name of the
            # parent.
            MERGED = 4

            # The incident was automatically closed because of the following reasons:
            #
            #  * The impact of the incident could not be confirmed.
            #  * The incident was intermittent or resolved itself.
            #
            #  The incident does not have a resolution because no action or
            #  investigation happened. If it is intermittent, the incident may reopen.
            AUTO_CLOSED = 9

            # Upon investigation, Google engineers concluded that the incident is not
            # affecting a Google Cloud product. This state can change if the incident
            # is reviewed again.
            FALSE_POSITIVE = 10
          end
        end

        # Records an update made to the event.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the update was posted.
        # @!attribute [r] title
        #   @return [::String]
        #     Output only. Brief title for the event.
        # @!attribute [r] description
        #   @return [::String]
        #     Output only. Free-form, human-readable description.
        # @!attribute [r] symptom
        #   @return [::String]
        #     Output only. Symptoms of the event, if available.
        # @!attribute [r] workaround
        #   @return [::String]
        #     Output only. Workaround steps to remediate the event impact, if available.
        class EventUpdate
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the locations impacted by the event.
        # @!attribute [rw] location_name
        #   @return [::String]
        #     Location impacted by the event. Example: `"us-central1"`
        class Location
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the Google Cloud product impacted by the event.
        # @!attribute [rw] product_name
        #   @return [::String]
        #     Google Cloud product impacted by the event. Example: `"Google Cloud SQL"`
        # @!attribute [rw] id
        #   @return [::String]
        #     Unique identifier for the product.
        class Product
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the Google Cloud products and locations impacted by the event.
        # @!attribute [rw] product
        #   @return [::Google::Cloud::ServiceHealth::V1::Product]
        #     Google Cloud product impacted by the event.
        # @!attribute [rw] location
        #   @return [::Google::Cloud::ServiceHealth::V1::Location]
        #     Location impacted by the event.
        class EventImpact
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents impact to assets at organizational level. It is a read-only view
        # and does not allow any modifications.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Identifier. Unique name of the organization impact in this
        #     scope including organization and location using the form
        #     `organizations/{organization_id}/locations/{location}/organizationImpacts/{organization_impact_id}`.
        #
        #     `organization_id` - ID (number) of the organization that contains the
        #     event. To get your `organization_id`, see
        #     [Getting your organization resource
        #     ID](https://cloud.google.com/resource-manager/docs/creating-managing-organization#retrieving_your_organization_id).<br>
        #     `organization_impact_id` - ID of the [OrganizationImpact
        #     resource](/service-health/docs/reference/rest/v1beta/organizations.locations.organizationImpacts#OrganizationImpact).
        # @!attribute [r] events
        #   @return [::Array<::String>]
        #     Output only. A list of event names impacting the asset.
        # @!attribute [r] asset
        #   @return [::Google::Cloud::ServiceHealth::V1::Asset]
        #     Output only. Google Cloud asset possibly impacted by the specified events.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the affected project was last modified.
        class OrganizationImpact
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the asset impacted by the events.
        # @!attribute [r] asset_name
        #   @return [::String]
        #     Output only. Full name of the resource as defined in
        #     [Resource
        #     Names](https://cloud.google.com/apis/design/resource_names#full_resource_name).
        # @!attribute [r] asset_type
        #   @return [::String]
        #     Output only. Type of the asset. Example:
        #     `"cloudresourcemanager.googleapis.com/Project"`
        class Asset
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Requests list of events.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value using the form
        #     `projects/{project_id}/locations/{location}/events`.
        #
        #     `project_id` - ID of the project for which to list service health
        #     events.
        #     `location` - The location to get the service health events from.
        #     To retrieve service health events of category = INCIDENT, use `location` =
        #     `global`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of events that should be returned.  Acceptable
        #     values are 1 to 100, inclusive. (The default value is 10.) If more results
        #     are available, the service returns a next_page_token that you can use to
        #     get the next page of results in subsequent list requests. The service may
        #     return fewer events than the requested page_size.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        #     Provide Page token returned by a previous `ListEvents` call to retrieve the
        #     next page of results. When paginating, all other parameters provided to
        #     `ListEvents` must match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. A filter expression that filters resources listed in the
        #     response. The expression takes the following forms: <br>
        #     *   field=value for `category` and `state`<br>
        #     *   field &lt;, >, &lt;=, or >= value for `update_time` <br>
        #     Examples: `category=INCIDENT`, `update_time>="2000-01-01T11:30:00-04:00"`,
        #     `event_impacts.product.product_name:"Eventarc"`
        #     <br>
        #
        #     Multiple filter queries are separated by spaces. Example:
        #     `category=INCIDENT state=ACTIVE`.
        #
        #     By default, each expression is an AND expression. However, you can include
        #     AND and OR expressions explicitly.
        #
        #     Filter is supported for the following fields: `category`, `state`,
        #     `update_time`, `event_impacts.product.product_name`
        # @!attribute [rw] view
        #   @return [::Google::Cloud::ServiceHealth::V1::EventView]
        #     Optional. Event fields to include in response.
        class ListEventsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response to request for listing events.
        # @!attribute [r] events
        #   @return [::Array<::Google::Cloud::ServiceHealth::V1::Event>]
        #     Output only. List of events.
        # @!attribute [r] next_page_token
        #   @return [::String]
        #     Output only. The continuation token, used to page through large result
        #     sets. Provide this value in a subsequent request as page_token to retrieve
        #     the next page.
        #
        #     If this field is not present, there are no subsequent results.
        # @!attribute [r] unreachable
        #   @return [::Array<::String>]
        #     Output only. Locations that could not be reached.
        class ListEventsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Gets information about a specific event.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Unique name of the event in this scope including project
        #     and location using the form
        #     `projects/{project_id}/locations/{location}/events/{event_id}`.
        #
        #     `project_id` - Project ID of the project that contains the event. <br>
        #     `location` - The location to get the service health events from. <br>
        #     `event_id` - Event ID to retrieve.
        class GetEventRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Requests list of events that affect an organization.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value using the form
        #     `organizations/{organization_id}/locations/{location}/organizationEvents`.
        #
        #     `organization_id` - ID (number) of the project that contains the event. To
        #     get your `organization_id`, see
        #     [Getting your organization resource
        #     ID](https://cloud.google.com/resource-manager/docs/creating-managing-organization#retrieving_your_organization_id).<br>
        #     `location` - The location to get the service health events from. To
        #     retrieve service health events of category = INCIDENT, use `location` =
        #     `global`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of events that should be returned.  Acceptable
        #     values are `1` to `100`, inclusive. (The default value is `10`.) If more
        #     results are available, the service returns a `next_page_token` that you can
        #     use to get the next page of results in subsequent list requests. The
        #     service may return fewer events than the requested `page_size`.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        #
        #     Provide Page token returned by a previous `ListOrganizationEvents` call to
        #     retrieve the next page of results.
        #
        #     When paginating, all other parameters provided to
        #     `ListOrganizationEvents` must match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. A filter expression that filters resources listed in the
        #     response. The expression takes the following forms:
        #
        #     *   field=value for `category` and `state`
        #     *   field &lt;, >, &lt;=, or >= value for `update_time`
        #
        #     Examples: `category=INCIDENT`, `update_time>="2000-01-01T11:30:00-04:00"`
        #
        #     Multiple filter queries are space-separated. Example:
        #     `category=INCIDENT state=ACTIVE`.
        #
        #     By default, each expression is an AND expression. However, you can include
        #     AND and OR expressions explicitly.
        #
        #     Filter is supported for the following fields: `category`, `state`,
        #     `update_time`
        # @!attribute [rw] view
        #   @return [::Google::Cloud::ServiceHealth::V1::OrganizationEventView]
        #     Optional. OrganizationEvent fields to include in response.
        class ListOrganizationEventsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response to request for listing organization events.
        # @!attribute [r] organization_events
        #   @return [::Array<::Google::Cloud::ServiceHealth::V1::OrganizationEvent>]
        #     Output only. List of organization events affecting an organization.
        # @!attribute [r] next_page_token
        #   @return [::String]
        #     Output only. The continuation token, used to page through large result
        #     sets. Provide this value in a subsequent request as `page_token` to
        #     retrieve the next page.
        #
        #     If this field is not present, there are no subsequent results.
        # @!attribute [r] unreachable
        #   @return [::Array<::String>]
        #     Output only. Locations that could not be reached.
        class ListOrganizationEventsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Gets information about a specific event affecting an organization.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Unique name of the event in this scope including organization and
        #     event ID using the form
        #     `organizations/{organization_id}/locations/locations/global/organizationEvents/{event_id}`.
        #
        #     `organization_id` - ID (number) of the project that contains the event. To
        #     get your `organization_id`, see
        #     [Getting your organization resource
        #     ID](https://cloud.google.com/resource-manager/docs/creating-managing-organization#retrieving_your_organization_id).<br>
        #     `event_id` - Organization event ID to retrieve.
        class GetOrganizationEventRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Requests list of projects under an organization affected by an event.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value using the form
        #     `organizations/{organization_id}/locations/{location}/organizationImpacts`.
        #
        #     `organization_id` - ID (number) of the project that contains the event. To
        #     get your `organization_id`, see
        #     [Getting your organization resource
        #     ID](https://cloud.google.com/resource-manager/docs/creating-managing-organization#retrieving_your_organization_id).
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of events that should be returned. Acceptable
        #     values are `1` to `100`, inclusive. The default value is `10`.
        #
        #      If more results are available, the service returns a
        #     `next_page_token` that can be used to get the next page of results in
        #     subsequent list requests. The service may return fewer
        #     [impacts](/service-health/docs/reference/rest/v1beta/organizations.locations.organizationImpacts#OrganizationImpact)
        #     than the requested `page_size`.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        #
        #     Provide `page_token` returned by a previous `ListOrganizationImpacts` call
        #     to retrieve the next page of results.
        #
        #     When paginating, all other parameters provided to `ListOrganizationImpacts`
        #     must match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. A filter expression that filters resources listed in the
        #     response. The expression is in the form of `field:value` for checking if a
        #     repeated field contains a value.
        #
        #     Example:
        #     `events:organizations%2F{organization_id}%2Flocations%2Fglobal%2ForganizationEvents%2Fevent-id`
        #
        #     To get your `{organization_id}`, see
        #     [Getting your organization resource
        #     ID](https://cloud.google.com/resource-manager/docs/creating-managing-organization#retrieving_your_organization_id).
        #
        #     Multiple filter queries are separated by spaces.
        #
        #     By default, each expression is an AND expression. However, you can include
        #     AND and OR expressions explicitly.
        #     Filter is supported for the following fields: `events`.
        class ListOrganizationImpactsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response to request for listing projects under an organization affected by an
        # event.
        # @!attribute [r] organization_impacts
        #   @return [::Array<::Google::Cloud::ServiceHealth::V1::OrganizationImpact>]
        #     Output only. List of
        #     [impacts](/service-health/docs/reference/rest/v1beta/organizations.locations.organizationImpacts#OrganizationImpact)
        #     for an organization affected by service health events.
        # @!attribute [r] next_page_token
        #   @return [::String]
        #     Output only. The continuation token, used to page through large result
        #     sets. Provide this value in a subsequent request as `page_token` to
        #     retrieve the next page.
        #
        #     If this field is not present, there are no subsequent results.
        # @!attribute [r] unreachable
        #   @return [::Array<::String>]
        #     Output only. Locations that could not be reached.
        class ListOrganizationImpactsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Gets information about an event that affects a project under an organization.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource using the form
        #     `organizations/{organization_id}/locations/global/organizationImpacts/{organization_impact_id}`.
        #
        #     `organization_id` - ID (number) of the organization that contains the
        #     event. To get your `organization_id`, see
        #     [Getting your organization resource
        #     ID](https://cloud.google.com/resource-manager/docs/creating-managing-organization#retrieving_your_organization_id).<br>
        #     `organization_impact_id` - ID of the [OrganizationImpact
        #     resource](/service-health/docs/reference/rest/v1beta/organizations.locations.organizationImpacts#OrganizationImpact).
        class GetOrganizationImpactRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The event fields to include in ListEvents API response. This enum lists all
        # possible event views.
        module EventView
          # Unspecified event view. Default to `EVENT_VIEW_BASIC`.
          EVENT_VIEW_UNSPECIFIED = 0

          # Includes all fields except `updates`. This view is the default for
          # ListEvents API.
          EVENT_VIEW_BASIC = 1

          # Includes all event fields.
          EVENT_VIEW_FULL = 2
        end

        # The organization event fields to include in ListOrganizationEvents API
        # response. This enum lists all possible organization event views.
        module OrganizationEventView
          # Unspecified event view. Default to `ORGANIZATION_EVENT_VIEW_BASIC`.
          ORGANIZATION_EVENT_VIEW_UNSPECIFIED = 0

          # Includes all organization event fields except `updates`. This view is the
          # default for ListOrganizationEvents API.
          ORGANIZATION_EVENT_VIEW_BASIC = 1

          # Includes all organization event fields.
          ORGANIZATION_EVENT_VIEW_FULL = 2
        end
      end
    end
  end
end
