# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/servicehealth/v1/event_service_pb"
require "google/cloud/service_health/v1/service_health/rest/service_stub"
require "google/cloud/location/rest"

module Google
  module Cloud
    module ServiceHealth
      module V1
        module ServiceHealth
          module Rest
            ##
            # REST client for the ServiceHealth service.
            #
            # Request service health events relevant to your Google Cloud project.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "servicehealth.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :service_health_stub

              ##
              # Configure the ServiceHealth Client class.
              #
              # See {::Google::Cloud::ServiceHealth::V1::ServiceHealth::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all ServiceHealth clients
              #   ::Google::Cloud::ServiceHealth::V1::ServiceHealth::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "ServiceHealth", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.list_events.timeout = 60.0
                  default_config.rpcs.list_events.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_event.timeout = 60.0
                  default_config.rpcs.get_event.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.list_organization_events.timeout = 60.0
                  default_config.rpcs.list_organization_events.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_organization_event.timeout = 60.0
                  default_config.rpcs.get_organization_event.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.list_organization_impacts.timeout = 60.0
                  default_config.rpcs.list_organization_impacts.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_organization_impact.timeout = 60.0
                  default_config.rpcs.get_organization_impact.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the ServiceHealth Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::ServiceHealth::V1::ServiceHealth::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @service_health_stub.universe_domain
              end

              ##
              # Create a new ServiceHealth REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::ServiceHealth::V1::ServiceHealth::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::ServiceHealth::V1::ServiceHealth::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the ServiceHealth client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @service_health_stub = ::Google::Cloud::ServiceHealth::V1::ServiceHealth::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @service_health_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @service_health_stub.endpoint
                  config.universe_domain = @service_health_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @service_health_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @service_health_stub.logger
              end

              # Service calls

              ##
              # Lists events under a given project and location.
              #
              # @overload list_events(request, options = nil)
              #   Pass arguments to `list_events` via a request object, either of type
              #   {::Google::Cloud::ServiceHealth::V1::ListEventsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ServiceHealth::V1::ListEventsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_events(parent: nil, page_size: nil, page_token: nil, filter: nil, view: nil)
              #   Pass arguments to `list_events` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value using the form
              #     `projects/{project_id}/locations/{location}/events`.
              #
              #     `project_id` - ID of the project for which to list service health
              #     events.
              #     `location` - The location to get the service health events from.
              #     To retrieve service health events of category = INCIDENT, use `location` =
              #     `global`.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of events that should be returned.  Acceptable
              #     values are 1 to 100, inclusive. (The default value is 10.) If more results
              #     are available, the service returns a next_page_token that you can use to
              #     get the next page of results in subsequent list requests. The service may
              #     return fewer events than the requested page_size.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results the server should return.
              #     Provide Page token returned by a previous `ListEvents` call to retrieve the
              #     next page of results. When paginating, all other parameters provided to
              #     `ListEvents` must match the call that provided the page token.
              #   @param filter [::String]
              #     Optional. A filter expression that filters resources listed in the
              #     response. The expression takes the following forms: <br>
              #     *   field=value for `category` and `state`<br>
              #     *   field &lt;, >, &lt;=, or >= value for `update_time` <br>
              #     Examples: `category=INCIDENT`, `update_time>="2000-01-01T11:30:00-04:00"`,
              #     `event_impacts.product.product_name:"Eventarc"`
              #     <br>
              #
              #     Multiple filter queries are separated by spaces. Example:
              #     `category=INCIDENT state=ACTIVE`.
              #
              #     By default, each expression is an AND expression. However, you can include
              #     AND and OR expressions explicitly.
              #
              #     Filter is supported for the following fields: `category`, `state`,
              #     `update_time`, `event_impacts.product.product_name`
              #   @param view [::Google::Cloud::ServiceHealth::V1::EventView]
              #     Optional. Event fields to include in response.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ServiceHealth::V1::Event>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ServiceHealth::V1::Event>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/service_health/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ServiceHealth::V1::ServiceHealth::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ServiceHealth::V1::ListEventsRequest.new
              #
              #   # Call the list_events method.
              #   result = client.list_events request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::ServiceHealth::V1::Event.
              #     p item
              #   end
              #
              def list_events request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ServiceHealth::V1::ListEventsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_events.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ServiceHealth::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_events.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_events.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @service_health_stub.list_events request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @service_health_stub, :list_events, "events", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Retrieves a resource containing information about an event.
              #
              # @overload get_event(request, options = nil)
              #   Pass arguments to `get_event` via a request object, either of type
              #   {::Google::Cloud::ServiceHealth::V1::GetEventRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ServiceHealth::V1::GetEventRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_event(name: nil)
              #   Pass arguments to `get_event` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Unique name of the event in this scope including project
              #     and location using the form
              #     `projects/{project_id}/locations/{location}/events/{event_id}`.
              #
              #     `project_id` - Project ID of the project that contains the event. <br>
              #     `location` - The location to get the service health events from. <br>
              #     `event_id` - Event ID to retrieve.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ServiceHealth::V1::Event]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ServiceHealth::V1::Event]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/service_health/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ServiceHealth::V1::ServiceHealth::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ServiceHealth::V1::GetEventRequest.new
              #
              #   # Call the get_event method.
              #   result = client.get_event request
              #
              #   # The returned object is of type Google::Cloud::ServiceHealth::V1::Event.
              #   p result
              #
              def get_event request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ServiceHealth::V1::GetEventRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_event.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ServiceHealth::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_event.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_event.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @service_health_stub.get_event request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists organization events under a given organization and location.
              #
              # @overload list_organization_events(request, options = nil)
              #   Pass arguments to `list_organization_events` via a request object, either of type
              #   {::Google::Cloud::ServiceHealth::V1::ListOrganizationEventsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ServiceHealth::V1::ListOrganizationEventsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_organization_events(parent: nil, page_size: nil, page_token: nil, filter: nil, view: nil)
              #   Pass arguments to `list_organization_events` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value using the form
              #     `organizations/{organization_id}/locations/{location}/organizationEvents`.
              #
              #     `organization_id` - ID (number) of the project that contains the event. To
              #     get your `organization_id`, see
              #     [Getting your organization resource
              #     ID](https://cloud.google.com/resource-manager/docs/creating-managing-organization#retrieving_your_organization_id).<br>
              #     `location` - The location to get the service health events from. To
              #     retrieve service health events of category = INCIDENT, use `location` =
              #     `global`.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of events that should be returned.  Acceptable
              #     values are `1` to `100`, inclusive. (The default value is `10`.) If more
              #     results are available, the service returns a `next_page_token` that you can
              #     use to get the next page of results in subsequent list requests. The
              #     service may return fewer events than the requested `page_size`.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results the server should return.
              #
              #     Provide Page token returned by a previous `ListOrganizationEvents` call to
              #     retrieve the next page of results.
              #
              #     When paginating, all other parameters provided to
              #     `ListOrganizationEvents` must match the call that provided the page token.
              #   @param filter [::String]
              #     Optional. A filter expression that filters resources listed in the
              #     response. The expression takes the following forms:
              #
              #     *   field=value for `category` and `state`
              #     *   field &lt;, >, &lt;=, or >= value for `update_time`
              #
              #     Examples: `category=INCIDENT`, `update_time>="2000-01-01T11:30:00-04:00"`
              #
              #     Multiple filter queries are space-separated. Example:
              #     `category=INCIDENT state=ACTIVE`.
              #
              #     By default, each expression is an AND expression. However, you can include
              #     AND and OR expressions explicitly.
              #
              #     Filter is supported for the following fields: `category`, `state`,
              #     `update_time`
              #   @param view [::Google::Cloud::ServiceHealth::V1::OrganizationEventView]
              #     Optional. OrganizationEvent fields to include in response.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ServiceHealth::V1::OrganizationEvent>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ServiceHealth::V1::OrganizationEvent>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/service_health/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ServiceHealth::V1::ServiceHealth::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ServiceHealth::V1::ListOrganizationEventsRequest.new
              #
              #   # Call the list_organization_events method.
              #   result = client.list_organization_events request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::ServiceHealth::V1::OrganizationEvent.
              #     p item
              #   end
              #
              def list_organization_events request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ServiceHealth::V1::ListOrganizationEventsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_organization_events.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ServiceHealth::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_organization_events.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_organization_events.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @service_health_stub.list_organization_events request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @service_health_stub, :list_organization_events, "organization_events", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Retrieves a resource containing information about an event affecting an
              # organization .
              #
              # @overload get_organization_event(request, options = nil)
              #   Pass arguments to `get_organization_event` via a request object, either of type
              #   {::Google::Cloud::ServiceHealth::V1::GetOrganizationEventRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ServiceHealth::V1::GetOrganizationEventRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_organization_event(name: nil)
              #   Pass arguments to `get_organization_event` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Unique name of the event in this scope including organization and
              #     event ID using the form
              #     `organizations/{organization_id}/locations/locations/global/organizationEvents/{event_id}`.
              #
              #     `organization_id` - ID (number) of the project that contains the event. To
              #     get your `organization_id`, see
              #     [Getting your organization resource
              #     ID](https://cloud.google.com/resource-manager/docs/creating-managing-organization#retrieving_your_organization_id).<br>
              #     `event_id` - Organization event ID to retrieve.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ServiceHealth::V1::OrganizationEvent]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ServiceHealth::V1::OrganizationEvent]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/service_health/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ServiceHealth::V1::ServiceHealth::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ServiceHealth::V1::GetOrganizationEventRequest.new
              #
              #   # Call the get_organization_event method.
              #   result = client.get_organization_event request
              #
              #   # The returned object is of type Google::Cloud::ServiceHealth::V1::OrganizationEvent.
              #   p result
              #
              def get_organization_event request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ServiceHealth::V1::GetOrganizationEventRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_organization_event.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ServiceHealth::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_organization_event.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_organization_event.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @service_health_stub.get_organization_event request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists assets impacted by organization events under a given organization and
              # location.
              #
              # @overload list_organization_impacts(request, options = nil)
              #   Pass arguments to `list_organization_impacts` via a request object, either of type
              #   {::Google::Cloud::ServiceHealth::V1::ListOrganizationImpactsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ServiceHealth::V1::ListOrganizationImpactsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_organization_impacts(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_organization_impacts` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value using the form
              #     `organizations/{organization_id}/locations/{location}/organizationImpacts`.
              #
              #     `organization_id` - ID (number) of the project that contains the event. To
              #     get your `organization_id`, see
              #     [Getting your organization resource
              #     ID](https://cloud.google.com/resource-manager/docs/creating-managing-organization#retrieving_your_organization_id).
              #   @param page_size [::Integer]
              #     Optional. The maximum number of events that should be returned. Acceptable
              #     values are `1` to `100`, inclusive. The default value is `10`.
              #
              #      If more results are available, the service returns a
              #     `next_page_token` that can be used to get the next page of results in
              #     subsequent list requests. The service may return fewer
              #     [impacts](/service-health/docs/reference/rest/v1beta/organizations.locations.organizationImpacts#OrganizationImpact)
              #     than the requested `page_size`.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results the server should return.
              #
              #     Provide `page_token` returned by a previous `ListOrganizationImpacts` call
              #     to retrieve the next page of results.
              #
              #     When paginating, all other parameters provided to `ListOrganizationImpacts`
              #     must match the call that provided the page token.
              #   @param filter [::String]
              #     Optional. A filter expression that filters resources listed in the
              #     response. The expression is in the form of `field:value` for checking if a
              #     repeated field contains a value.
              #
              #     Example:
              #     `events:organizations%2F{organization_id}%2Flocations%2Fglobal%2ForganizationEvents%2Fevent-id`
              #
              #     To get your `{organization_id}`, see
              #     [Getting your organization resource
              #     ID](https://cloud.google.com/resource-manager/docs/creating-managing-organization#retrieving_your_organization_id).
              #
              #     Multiple filter queries are separated by spaces.
              #
              #     By default, each expression is an AND expression. However, you can include
              #     AND and OR expressions explicitly.
              #     Filter is supported for the following fields: `events`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ServiceHealth::V1::OrganizationImpact>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ServiceHealth::V1::OrganizationImpact>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/service_health/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ServiceHealth::V1::ServiceHealth::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ServiceHealth::V1::ListOrganizationImpactsRequest.new
              #
              #   # Call the list_organization_impacts method.
              #   result = client.list_organization_impacts request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::ServiceHealth::V1::OrganizationImpact.
              #     p item
              #   end
              #
              def list_organization_impacts request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ServiceHealth::V1::ListOrganizationImpactsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_organization_impacts.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ServiceHealth::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_organization_impacts.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_organization_impacts.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @service_health_stub.list_organization_impacts request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @service_health_stub, :list_organization_impacts, "organization_impacts", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Retrieves a resource containing information about impact to an asset under
              # an organization affected by a service health event.
              #
              # @overload get_organization_impact(request, options = nil)
              #   Pass arguments to `get_organization_impact` via a request object, either of type
              #   {::Google::Cloud::ServiceHealth::V1::GetOrganizationImpactRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ServiceHealth::V1::GetOrganizationImpactRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_organization_impact(name: nil)
              #   Pass arguments to `get_organization_impact` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource using the form
              #     `organizations/{organization_id}/locations/global/organizationImpacts/{organization_impact_id}`.
              #
              #     `organization_id` - ID (number) of the organization that contains the
              #     event. To get your `organization_id`, see
              #     [Getting your organization resource
              #     ID](https://cloud.google.com/resource-manager/docs/creating-managing-organization#retrieving_your_organization_id).<br>
              #     `organization_impact_id` - ID of the [OrganizationImpact
              #     resource](/service-health/docs/reference/rest/v1beta/organizations.locations.organizationImpacts#OrganizationImpact).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ServiceHealth::V1::OrganizationImpact]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ServiceHealth::V1::OrganizationImpact]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/service_health/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ServiceHealth::V1::ServiceHealth::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ServiceHealth::V1::GetOrganizationImpactRequest.new
              #
              #   # Call the get_organization_impact method.
              #   result = client.get_organization_impact request
              #
              #   # The returned object is of type Google::Cloud::ServiceHealth::V1::OrganizationImpact.
              #   p result
              #
              def get_organization_impact request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ServiceHealth::V1::GetOrganizationImpactRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_organization_impact.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ServiceHealth::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_organization_impact.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_organization_impact.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @service_health_stub.get_organization_impact request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the ServiceHealth REST API.
              #
              # This class represents the configuration for ServiceHealth REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::ServiceHealth::V1::ServiceHealth::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # list_events to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::ServiceHealth::V1::ServiceHealth::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_events.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::ServiceHealth::V1::ServiceHealth::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_events.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "servicehealth.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the ServiceHealth API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `list_events`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_events
                  ##
                  # RPC-specific configuration for `get_event`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_event
                  ##
                  # RPC-specific configuration for `list_organization_events`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_organization_events
                  ##
                  # RPC-specific configuration for `get_organization_event`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_organization_event
                  ##
                  # RPC-specific configuration for `list_organization_impacts`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_organization_impacts
                  ##
                  # RPC-specific configuration for `get_organization_impact`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_organization_impact

                  # @private
                  def initialize parent_rpcs = nil
                    list_events_config = parent_rpcs.list_events if parent_rpcs.respond_to? :list_events
                    @list_events = ::Gapic::Config::Method.new list_events_config
                    get_event_config = parent_rpcs.get_event if parent_rpcs.respond_to? :get_event
                    @get_event = ::Gapic::Config::Method.new get_event_config
                    list_organization_events_config = parent_rpcs.list_organization_events if parent_rpcs.respond_to? :list_organization_events
                    @list_organization_events = ::Gapic::Config::Method.new list_organization_events_config
                    get_organization_event_config = parent_rpcs.get_organization_event if parent_rpcs.respond_to? :get_organization_event
                    @get_organization_event = ::Gapic::Config::Method.new get_organization_event_config
                    list_organization_impacts_config = parent_rpcs.list_organization_impacts if parent_rpcs.respond_to? :list_organization_impacts
                    @list_organization_impacts = ::Gapic::Config::Method.new list_organization_impacts_config
                    get_organization_impact_config = parent_rpcs.get_organization_impact if parent_rpcs.respond_to? :get_organization_impact
                    @get_organization_impact = ::Gapic::Config::Method.new get_organization_impact_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
