# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ServiceHealth
      module V1
        module ServiceHealth
          # Path helper methods for the ServiceHealth API.
          module Paths
            ##
            # Create a fully-qualified Event resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/events/{event}`
            #
            # @param project [String]
            # @param location [String]
            # @param event [String]
            #
            # @return [::String]
            def event_path project:, location:, event:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/events/#{event}"
            end

            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified OrganizationEvent resource string.
            #
            # The resource will be in the following format:
            #
            # `organizations/{organization}/locations/{location}/organizationEvents/{event}`
            #
            # @param organization [String]
            # @param location [String]
            # @param event [String]
            #
            # @return [::String]
            def organization_event_path organization:, location:, event:
              raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "organizations/#{organization}/locations/#{location}/organizationEvents/#{event}"
            end

            ##
            # Create a fully-qualified OrganizationImpact resource string.
            #
            # The resource will be in the following format:
            #
            # `organizations/{organization}/locations/{location}/organizationImpacts/{organization_impact}`
            #
            # @param organization [String]
            # @param location [String]
            # @param organization_impact [String]
            #
            # @return [::String]
            def organization_impact_path organization:, location:, organization_impact:
              raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "organizations/#{organization}/locations/#{location}/organizationImpacts/#{organization_impact}"
            end

            ##
            # Create a fully-qualified OrganizationLocation resource string.
            #
            # The resource will be in the following format:
            #
            # `organizations/{organization}/locations/{location}`
            #
            # @param organization [String]
            # @param location [String]
            #
            # @return [::String]
            def organization_location_path organization:, location:
              raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"

              "organizations/#{organization}/locations/#{location}"
            end

            extend self
          end
        end
      end
    end
  end
end
