# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/servicedirectory/v1beta1/registration_service_pb"
require "google/cloud/service_directory/v1beta1/registration_service/rest/service_stub"
require "google/cloud/location/rest"

module Google
  module Cloud
    module ServiceDirectory
      module V1beta1
        module RegistrationService
          module Rest
            ##
            # REST client for the RegistrationService service.
            #
            # Service Directory API for registering services. It defines the following
            # resource model:
            #
            # - The API has a collection of
            # {::Google::Cloud::ServiceDirectory::V1beta1::Namespace Namespace}
            # resources, named `projects/*/locations/*/namespaces/*`.
            #
            # - Each Namespace has a collection of
            # {::Google::Cloud::ServiceDirectory::V1beta1::Service Service} resources, named
            # `projects/*/locations/*/namespaces/*/services/*`.
            #
            # - Each Service has a collection of
            # {::Google::Cloud::ServiceDirectory::V1beta1::Endpoint Endpoint}
            # resources, named
            # `projects/*/locations/*/namespaces/*/services/*/endpoints/*`.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "servicedirectory.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :registration_service_stub

              ##
              # Configure the RegistrationService Client class.
              #
              # See {::Google::Cloud::ServiceDirectory::V1beta1::RegistrationService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all RegistrationService clients
              #   ::Google::Cloud::ServiceDirectory::V1beta1::RegistrationService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "ServiceDirectory", "V1beta1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 15.0
                  default_config.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 2]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the RegistrationService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::ServiceDirectory::V1beta1::RegistrationService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @registration_service_stub.universe_domain
              end

              ##
              # Create a new RegistrationService REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::ServiceDirectory::V1beta1::RegistrationService::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::ServiceDirectory::V1beta1::RegistrationService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the RegistrationService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @registration_service_stub = ::Google::Cloud::ServiceDirectory::V1beta1::RegistrationService::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @registration_service_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @registration_service_stub.endpoint
                  config.universe_domain = @registration_service_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @registration_service_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @registration_service_stub.logger
              end

              # Service calls

              ##
              # Creates a namespace, and returns the new namespace.
              #
              # @overload create_namespace(request, options = nil)
              #   Pass arguments to `create_namespace` via a request object, either of type
              #   {::Google::Cloud::ServiceDirectory::V1beta1::CreateNamespaceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ServiceDirectory::V1beta1::CreateNamespaceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_namespace(parent: nil, namespace_id: nil, namespace: nil)
              #   Pass arguments to `create_namespace` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the project and location the namespace
              #     will be created in.
              #   @param namespace_id [::String]
              #     Required. The Resource ID must be 1-63 characters long, and comply with
              #     <a href="https://www.ietf.org/rfc/rfc1035.txt" target="_blank">RFC1035</a>.
              #     Specifically, the name must be 1-63 characters long and match the regular
              #     expression `[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?` which means the first
              #     character must be a lowercase letter, and all following characters must
              #     be a dash, lowercase letter, or digit, except the last character, which
              #     cannot be a dash.
              #   @param namespace [::Google::Cloud::ServiceDirectory::V1beta1::Namespace, ::Hash]
              #     Required. A namespace with initial fields set.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ServiceDirectory::V1beta1::Namespace]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ServiceDirectory::V1beta1::Namespace]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/service_directory/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ServiceDirectory::V1beta1::RegistrationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ServiceDirectory::V1beta1::CreateNamespaceRequest.new
              #
              #   # Call the create_namespace method.
              #   result = client.create_namespace request
              #
              #   # The returned object is of type Google::Cloud::ServiceDirectory::V1beta1::Namespace.
              #   p result
              #
              def create_namespace request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ServiceDirectory::V1beta1::CreateNamespaceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_namespace.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ServiceDirectory::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_namespace.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_namespace.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registration_service_stub.create_namespace request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all namespaces.
              #
              # @overload list_namespaces(request, options = nil)
              #   Pass arguments to `list_namespaces` via a request object, either of type
              #   {::Google::Cloud::ServiceDirectory::V1beta1::ListNamespacesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ServiceDirectory::V1beta1::ListNamespacesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_namespaces(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_namespaces` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the project and location whose namespaces
              #     you'd like to list.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of items to return. The default value is 100.
              #   @param page_token [::String]
              #     Optional. The next_page_token value returned from a previous List request,
              #     if any.
              #   @param filter [::String]
              #     Optional. The filter to list results by.
              #
              #     General `filter` string syntax:
              #     `<field> <operator> <value> (<logical connector>)`
              #
              #     *   `<field>` can be `name`, `labels.<key>` for map field, or
              #     `attributes.<field>` for attributes field
              #     *   `<operator>` can be `<`, `>`, `<=`, `>=`, `!=`, `=`, `:`. Of which `:`
              #         means `HAS`, and is roughly the same as `=`
              #     *   `<value>` must be the same data type as field
              #     *   `<logical connector>` can be `AND`, `OR`, `NOT`
              #
              #     Examples of valid filters:
              #
              #     *   `labels.owner` returns namespaces that have a label with the key
              #         `owner`, this is the same as `labels:owner`
              #     *   `labels.owner=sd` returns namespaces that have key/value `owner=sd`
              #     *   `name>projects/my-project/locations/us-east1/namespaces/namespace-c`
              #         returns namespaces that have name that is alphabetically later than the
              #         string, so "namespace-e" is returned but "namespace-a" is not
              #     *   `labels.owner!=sd AND labels.foo=bar` returns namespaces that have
              #         `owner` in label key but value is not `sd` AND have key/value `foo=bar`
              #     *   `doesnotexist.foo=bar` returns an empty list. Note that namespace
              #         doesn't have a field called "doesnotexist". Since the filter does not
              #         match any namespaces, it returns no results
              #     *   `attributes.managed_registration=true` returns namespaces that are
              #         managed by a GCP product or service
              #
              #     For more information about filtering, see
              #     [API Filtering](https://aip.dev/160).
              #   @param order_by [::String]
              #     Optional. The order to list results by.
              #
              #     General `order_by` string syntax: `<field> (<asc|desc>) (,)`
              #
              #     *   `<field>` allows value: `name`
              #     *   `<asc|desc>` ascending or descending order by `<field>`. If this is
              #         left blank, `asc` is used
              #
              #     Note that an empty `order_by` string results in default order, which is
              #     order by `name` in ascending order.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ServiceDirectory::V1beta1::Namespace>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ServiceDirectory::V1beta1::Namespace>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/service_directory/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ServiceDirectory::V1beta1::RegistrationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ServiceDirectory::V1beta1::ListNamespacesRequest.new
              #
              #   # Call the list_namespaces method.
              #   result = client.list_namespaces request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::ServiceDirectory::V1beta1::Namespace.
              #     p item
              #   end
              #
              def list_namespaces request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ServiceDirectory::V1beta1::ListNamespacesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_namespaces.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ServiceDirectory::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_namespaces.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_namespaces.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registration_service_stub.list_namespaces request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @registration_service_stub, :list_namespaces, "namespaces", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a namespace.
              #
              # @overload get_namespace(request, options = nil)
              #   Pass arguments to `get_namespace` via a request object, either of type
              #   {::Google::Cloud::ServiceDirectory::V1beta1::GetNamespaceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ServiceDirectory::V1beta1::GetNamespaceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_namespace(name: nil)
              #   Pass arguments to `get_namespace` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the namespace to retrieve.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ServiceDirectory::V1beta1::Namespace]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ServiceDirectory::V1beta1::Namespace]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/service_directory/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ServiceDirectory::V1beta1::RegistrationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ServiceDirectory::V1beta1::GetNamespaceRequest.new
              #
              #   # Call the get_namespace method.
              #   result = client.get_namespace request
              #
              #   # The returned object is of type Google::Cloud::ServiceDirectory::V1beta1::Namespace.
              #   p result
              #
              def get_namespace request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ServiceDirectory::V1beta1::GetNamespaceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_namespace.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ServiceDirectory::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_namespace.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_namespace.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registration_service_stub.get_namespace request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a namespace.
              #
              # @overload update_namespace(request, options = nil)
              #   Pass arguments to `update_namespace` via a request object, either of type
              #   {::Google::Cloud::ServiceDirectory::V1beta1::UpdateNamespaceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ServiceDirectory::V1beta1::UpdateNamespaceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_namespace(namespace: nil, update_mask: nil)
              #   Pass arguments to `update_namespace` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param namespace [::Google::Cloud::ServiceDirectory::V1beta1::Namespace, ::Hash]
              #     Required. The updated namespace.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. List of fields to be updated in this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ServiceDirectory::V1beta1::Namespace]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ServiceDirectory::V1beta1::Namespace]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/service_directory/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ServiceDirectory::V1beta1::RegistrationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ServiceDirectory::V1beta1::UpdateNamespaceRequest.new
              #
              #   # Call the update_namespace method.
              #   result = client.update_namespace request
              #
              #   # The returned object is of type Google::Cloud::ServiceDirectory::V1beta1::Namespace.
              #   p result
              #
              def update_namespace request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ServiceDirectory::V1beta1::UpdateNamespaceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_namespace.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ServiceDirectory::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_namespace.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_namespace.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registration_service_stub.update_namespace request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a namespace. This also deletes all services and endpoints in
              # the namespace.
              #
              # @overload delete_namespace(request, options = nil)
              #   Pass arguments to `delete_namespace` via a request object, either of type
              #   {::Google::Cloud::ServiceDirectory::V1beta1::DeleteNamespaceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ServiceDirectory::V1beta1::DeleteNamespaceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_namespace(name: nil)
              #   Pass arguments to `delete_namespace` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the namespace to delete.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/service_directory/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ServiceDirectory::V1beta1::RegistrationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ServiceDirectory::V1beta1::DeleteNamespaceRequest.new
              #
              #   # Call the delete_namespace method.
              #   result = client.delete_namespace request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_namespace request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ServiceDirectory::V1beta1::DeleteNamespaceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_namespace.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ServiceDirectory::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_namespace.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_namespace.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registration_service_stub.delete_namespace request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a service, and returns the new service.
              #
              # @overload create_service(request, options = nil)
              #   Pass arguments to `create_service` via a request object, either of type
              #   {::Google::Cloud::ServiceDirectory::V1beta1::CreateServiceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ServiceDirectory::V1beta1::CreateServiceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_service(parent: nil, service_id: nil, service: nil)
              #   Pass arguments to `create_service` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the namespace this service will belong to.
              #   @param service_id [::String]
              #     Required. The Resource ID must be 1-63 characters long, and comply with
              #     <a href="https://www.ietf.org/rfc/rfc1035.txt" target="_blank">RFC1035</a>.
              #     Specifically, the name must be 1-63 characters long and match the regular
              #     expression `[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?` which means the first
              #     character must be a lowercase letter, and all following characters must
              #     be a dash, lowercase letter, or digit, except the last character, which
              #     cannot be a dash.
              #   @param service [::Google::Cloud::ServiceDirectory::V1beta1::Service, ::Hash]
              #     Required. A service  with initial fields set.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ServiceDirectory::V1beta1::Service]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ServiceDirectory::V1beta1::Service]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/service_directory/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ServiceDirectory::V1beta1::RegistrationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ServiceDirectory::V1beta1::CreateServiceRequest.new
              #
              #   # Call the create_service method.
              #   result = client.create_service request
              #
              #   # The returned object is of type Google::Cloud::ServiceDirectory::V1beta1::Service.
              #   p result
              #
              def create_service request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ServiceDirectory::V1beta1::CreateServiceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_service.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ServiceDirectory::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_service.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_service.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registration_service_stub.create_service request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all services belonging to a namespace.
              #
              # @overload list_services(request, options = nil)
              #   Pass arguments to `list_services` via a request object, either of type
              #   {::Google::Cloud::ServiceDirectory::V1beta1::ListServicesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ServiceDirectory::V1beta1::ListServicesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_services(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_services` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the namespace whose services you'd
              #     like to list.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of items to return. The default value is 100.
              #   @param page_token [::String]
              #     Optional. The next_page_token value returned from a previous List request,
              #     if any.
              #   @param filter [::String]
              #     Optional. The filter to list results by.
              #
              #     General `filter` string syntax:
              #     `<field> <operator> <value> (<logical connector>)`
              #
              #     *   `<field>` can be `name` or `metadata.<key>` for map field
              #     *   `<operator>` can be `<`, `>`, `<=`, `>=`, `!=`, `=`, `:`. Of which `:`
              #         means `HAS`, and is roughly the same as `=`
              #     *   `<value>` must be the same data type as field
              #     *   `<logical connector>` can be `AND`, `OR`, `NOT`
              #
              #     Examples of valid filters:
              #
              #     *   `metadata.owner` returns services that have a metadata with the key
              #         `owner`, this is the same as `metadata:owner`
              #     *   `metadata.protocol=gRPC` returns services that have key/value
              #         `protocol=gRPC`
              #     *
              #     `name>projects/my-project/locations/us-east1/namespaces/my-namespace/services/service-c`
              #         returns services that have name that is alphabetically later than the
              #         string, so "service-e" is returned but "service-a" is not
              #     *   `metadata.owner!=sd AND metadata.foo=bar` returns services that have
              #         `owner` in metadata key but value is not `sd` AND have key/value
              #         `foo=bar`
              #     *   `doesnotexist.foo=bar` returns an empty list. Note that service
              #         doesn't have a field called "doesnotexist". Since the filter does not
              #         match any services, it returns no results
              #     *   `attributes.managed_registration=true` returns services that are
              #     managed
              #         by a GCP product or service
              #
              #     For more information about filtering, see
              #     [API Filtering](https://aip.dev/160).
              #   @param order_by [::String]
              #     Optional. The order to list results by.
              #
              #     General `order_by` string syntax: `<field> (<asc|desc>) (,)`
              #
              #     *   `<field>` allows value: `name`
              #     *   `<asc|desc>` ascending or descending order by `<field>`. If this is
              #         left blank, `asc` is used
              #
              #     Note that an empty `order_by` string results in default order, which is
              #     order by `name` in ascending order.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ServiceDirectory::V1beta1::Service>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ServiceDirectory::V1beta1::Service>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/service_directory/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ServiceDirectory::V1beta1::RegistrationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ServiceDirectory::V1beta1::ListServicesRequest.new
              #
              #   # Call the list_services method.
              #   result = client.list_services request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::ServiceDirectory::V1beta1::Service.
              #     p item
              #   end
              #
              def list_services request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ServiceDirectory::V1beta1::ListServicesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_services.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ServiceDirectory::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_services.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_services.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registration_service_stub.list_services request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @registration_service_stub, :list_services, "services", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a service.
              #
              # @overload get_service(request, options = nil)
              #   Pass arguments to `get_service` via a request object, either of type
              #   {::Google::Cloud::ServiceDirectory::V1beta1::GetServiceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ServiceDirectory::V1beta1::GetServiceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_service(name: nil)
              #   Pass arguments to `get_service` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the service to get.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ServiceDirectory::V1beta1::Service]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ServiceDirectory::V1beta1::Service]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/service_directory/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ServiceDirectory::V1beta1::RegistrationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ServiceDirectory::V1beta1::GetServiceRequest.new
              #
              #   # Call the get_service method.
              #   result = client.get_service request
              #
              #   # The returned object is of type Google::Cloud::ServiceDirectory::V1beta1::Service.
              #   p result
              #
              def get_service request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ServiceDirectory::V1beta1::GetServiceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_service.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ServiceDirectory::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_service.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_service.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registration_service_stub.get_service request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a service.
              #
              # @overload update_service(request, options = nil)
              #   Pass arguments to `update_service` via a request object, either of type
              #   {::Google::Cloud::ServiceDirectory::V1beta1::UpdateServiceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ServiceDirectory::V1beta1::UpdateServiceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_service(service: nil, update_mask: nil)
              #   Pass arguments to `update_service` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param service [::Google::Cloud::ServiceDirectory::V1beta1::Service, ::Hash]
              #     Required. The updated service.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. List of fields to be updated in this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ServiceDirectory::V1beta1::Service]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ServiceDirectory::V1beta1::Service]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/service_directory/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ServiceDirectory::V1beta1::RegistrationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ServiceDirectory::V1beta1::UpdateServiceRequest.new
              #
              #   # Call the update_service method.
              #   result = client.update_service request
              #
              #   # The returned object is of type Google::Cloud::ServiceDirectory::V1beta1::Service.
              #   p result
              #
              def update_service request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ServiceDirectory::V1beta1::UpdateServiceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_service.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ServiceDirectory::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_service.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_service.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registration_service_stub.update_service request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a service. This also deletes all endpoints associated with
              # the service.
              #
              # @overload delete_service(request, options = nil)
              #   Pass arguments to `delete_service` via a request object, either of type
              #   {::Google::Cloud::ServiceDirectory::V1beta1::DeleteServiceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ServiceDirectory::V1beta1::DeleteServiceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_service(name: nil)
              #   Pass arguments to `delete_service` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the service to delete.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/service_directory/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ServiceDirectory::V1beta1::RegistrationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ServiceDirectory::V1beta1::DeleteServiceRequest.new
              #
              #   # Call the delete_service method.
              #   result = client.delete_service request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_service request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ServiceDirectory::V1beta1::DeleteServiceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_service.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ServiceDirectory::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_service.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_service.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registration_service_stub.delete_service request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates an endpoint, and returns the new endpoint.
              #
              # @overload create_endpoint(request, options = nil)
              #   Pass arguments to `create_endpoint` via a request object, either of type
              #   {::Google::Cloud::ServiceDirectory::V1beta1::CreateEndpointRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ServiceDirectory::V1beta1::CreateEndpointRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_endpoint(parent: nil, endpoint_id: nil, endpoint: nil)
              #   Pass arguments to `create_endpoint` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the service that this endpoint provides.
              #   @param endpoint_id [::String]
              #     Required. The Resource ID must be 1-63 characters long, and comply with
              #     <a href="https://www.ietf.org/rfc/rfc1035.txt" target="_blank">RFC1035</a>.
              #     Specifically, the name must be 1-63 characters long and match the regular
              #     expression `[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?` which means the first
              #     character must be a lowercase letter, and all following characters must
              #     be a dash, lowercase letter, or digit, except the last character, which
              #     cannot be a dash.
              #   @param endpoint [::Google::Cloud::ServiceDirectory::V1beta1::Endpoint, ::Hash]
              #     Required. A endpoint with initial fields set.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ServiceDirectory::V1beta1::Endpoint]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ServiceDirectory::V1beta1::Endpoint]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/service_directory/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ServiceDirectory::V1beta1::RegistrationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ServiceDirectory::V1beta1::CreateEndpointRequest.new
              #
              #   # Call the create_endpoint method.
              #   result = client.create_endpoint request
              #
              #   # The returned object is of type Google::Cloud::ServiceDirectory::V1beta1::Endpoint.
              #   p result
              #
              def create_endpoint request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ServiceDirectory::V1beta1::CreateEndpointRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_endpoint.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ServiceDirectory::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_endpoint.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_endpoint.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registration_service_stub.create_endpoint request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all endpoints.
              #
              # @overload list_endpoints(request, options = nil)
              #   Pass arguments to `list_endpoints` via a request object, either of type
              #   {::Google::Cloud::ServiceDirectory::V1beta1::ListEndpointsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ServiceDirectory::V1beta1::ListEndpointsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_endpoints(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_endpoints` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the service whose endpoints you'd like to
              #     list.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of items to return. The default value is 100.
              #   @param page_token [::String]
              #     Optional. The next_page_token value returned from a previous List request,
              #     if any.
              #   @param filter [::String]
              #     Optional. The filter to list results by.
              #
              #     General `filter` string syntax:
              #     `<field> <operator> <value> (<logical connector>)`
              #
              #     *   `<field>` can be `name`, `address`, `port`, `metadata.<key>` for map
              #         field, or `attributes.<field>` for attributes field
              #     *   `<operator>` can be `<`, `>`, `<=`, `>=`, `!=`, `=`, `:`. Of which `:`
              #         means `HAS`, and is roughly the same as `=`
              #     *   `<value>` must be the same data type as field
              #     *   `<logical connector>` can be `AND`, `OR`, `NOT`
              #
              #     Examples of valid filters:
              #
              #     *   `metadata.owner` returns endpoints that have a metadata with the key
              #         `owner`, this is the same as `metadata:owner`
              #     *   `metadata.protocol=gRPC` returns endpoints that have key/value
              #         `protocol=gRPC`
              #     *   `address=192.108.1.105` returns endpoints that have this address
              #     *   `port>8080` returns endpoints that have port number larger than 8080
              #     *
              #     `name>projects/my-project/locations/us-east1/namespaces/my-namespace/services/my-service/endpoints/endpoint-c`
              #         returns endpoints that have name that is alphabetically later than the
              #         string, so "endpoint-e" is returned but "endpoint-a" is not
              #     *   `metadata.owner!=sd AND metadata.foo=bar` returns endpoints that have
              #         `owner` in metadata key but value is not `sd` AND have key/value
              #          `foo=bar`
              #     *   `doesnotexist.foo=bar` returns an empty list. Note that endpoint
              #         doesn't have a field called "doesnotexist". Since the filter does not
              #         match any endpoints, it returns no results
              #     *   `attributes.kubernetes_resource_type=KUBERNETES_RESOURCE_TYPE_CLUSTER_
              #         IP` returns endpoints with the corresponding kubernetes_resource_type
              #
              #     For more information about filtering, see
              #     [API Filtering](https://aip.dev/160).
              #   @param order_by [::String]
              #     Optional. The order to list results by.
              #
              #     General `order_by` string syntax: `<field> (<asc|desc>) (,)`
              #
              #     *   `<field>` allows values: `name`, `address`, `port`
              #     *   `<asc|desc>` ascending or descending order by `<field>`. If this is
              #         left blank, `asc` is used
              #
              #     Note that an empty `order_by` string results in default order, which is
              #     order by `name` in ascending order.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ServiceDirectory::V1beta1::Endpoint>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ServiceDirectory::V1beta1::Endpoint>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/service_directory/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ServiceDirectory::V1beta1::RegistrationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ServiceDirectory::V1beta1::ListEndpointsRequest.new
              #
              #   # Call the list_endpoints method.
              #   result = client.list_endpoints request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::ServiceDirectory::V1beta1::Endpoint.
              #     p item
              #   end
              #
              def list_endpoints request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ServiceDirectory::V1beta1::ListEndpointsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_endpoints.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ServiceDirectory::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_endpoints.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_endpoints.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registration_service_stub.list_endpoints request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @registration_service_stub, :list_endpoints, "endpoints", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets an endpoint.
              #
              # @overload get_endpoint(request, options = nil)
              #   Pass arguments to `get_endpoint` via a request object, either of type
              #   {::Google::Cloud::ServiceDirectory::V1beta1::GetEndpointRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ServiceDirectory::V1beta1::GetEndpointRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_endpoint(name: nil)
              #   Pass arguments to `get_endpoint` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the endpoint to get.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ServiceDirectory::V1beta1::Endpoint]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ServiceDirectory::V1beta1::Endpoint]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/service_directory/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ServiceDirectory::V1beta1::RegistrationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ServiceDirectory::V1beta1::GetEndpointRequest.new
              #
              #   # Call the get_endpoint method.
              #   result = client.get_endpoint request
              #
              #   # The returned object is of type Google::Cloud::ServiceDirectory::V1beta1::Endpoint.
              #   p result
              #
              def get_endpoint request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ServiceDirectory::V1beta1::GetEndpointRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_endpoint.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ServiceDirectory::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_endpoint.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_endpoint.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registration_service_stub.get_endpoint request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates an endpoint.
              #
              # @overload update_endpoint(request, options = nil)
              #   Pass arguments to `update_endpoint` via a request object, either of type
              #   {::Google::Cloud::ServiceDirectory::V1beta1::UpdateEndpointRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ServiceDirectory::V1beta1::UpdateEndpointRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_endpoint(endpoint: nil, update_mask: nil)
              #   Pass arguments to `update_endpoint` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param endpoint [::Google::Cloud::ServiceDirectory::V1beta1::Endpoint, ::Hash]
              #     Required. The updated endpoint.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. List of fields to be updated in this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ServiceDirectory::V1beta1::Endpoint]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ServiceDirectory::V1beta1::Endpoint]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/service_directory/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ServiceDirectory::V1beta1::RegistrationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ServiceDirectory::V1beta1::UpdateEndpointRequest.new
              #
              #   # Call the update_endpoint method.
              #   result = client.update_endpoint request
              #
              #   # The returned object is of type Google::Cloud::ServiceDirectory::V1beta1::Endpoint.
              #   p result
              #
              def update_endpoint request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ServiceDirectory::V1beta1::UpdateEndpointRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_endpoint.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ServiceDirectory::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_endpoint.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_endpoint.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registration_service_stub.update_endpoint request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes an endpoint.
              #
              # @overload delete_endpoint(request, options = nil)
              #   Pass arguments to `delete_endpoint` via a request object, either of type
              #   {::Google::Cloud::ServiceDirectory::V1beta1::DeleteEndpointRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ServiceDirectory::V1beta1::DeleteEndpointRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_endpoint(name: nil)
              #   Pass arguments to `delete_endpoint` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the endpoint to delete.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/service_directory/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ServiceDirectory::V1beta1::RegistrationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ServiceDirectory::V1beta1::DeleteEndpointRequest.new
              #
              #   # Call the delete_endpoint method.
              #   result = client.delete_endpoint request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_endpoint request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ServiceDirectory::V1beta1::DeleteEndpointRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_endpoint.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ServiceDirectory::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_endpoint.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_endpoint.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registration_service_stub.delete_endpoint request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the IAM Policy for a resource
              #
              # @overload get_iam_policy(request, options = nil)
              #   Pass arguments to `get_iam_policy` via a request object, either of type
              #   {::Google::Iam::V1::GetIamPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::GetIamPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_iam_policy(resource: nil, options: nil)
              #   Pass arguments to `get_iam_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy is being requested.
              #     See the operation documentation for the appropriate value for this field.
              #   @param options [::Google::Iam::V1::GetPolicyOptions, ::Hash]
              #     OPTIONAL: A `GetPolicyOptions` object for specifying options to
              #     `GetIamPolicy`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Iam::V1::Policy]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Iam::V1::Policy]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/service_directory/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ServiceDirectory::V1beta1::RegistrationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::GetIamPolicyRequest.new
              #
              #   # Call the get_iam_policy method.
              #   result = client.get_iam_policy request
              #
              #   # The returned object is of type Google::Iam::V1::Policy.
              #   p result
              #
              def get_iam_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::GetIamPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_iam_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ServiceDirectory::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_iam_policy.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_iam_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registration_service_stub.get_iam_policy request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Sets the IAM Policy for a resource
              #
              # @overload set_iam_policy(request, options = nil)
              #   Pass arguments to `set_iam_policy` via a request object, either of type
              #   {::Google::Iam::V1::SetIamPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::SetIamPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload set_iam_policy(resource: nil, policy: nil, update_mask: nil)
              #   Pass arguments to `set_iam_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy is being specified.
              #     See the operation documentation for the appropriate value for this field.
              #   @param policy [::Google::Iam::V1::Policy, ::Hash]
              #     REQUIRED: The complete policy to be applied to the `resource`. The size of
              #     the policy is limited to a few 10s of KB. An empty policy is a
              #     valid policy but certain Cloud Platform services (such as Projects)
              #     might reject them.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
              #     the fields in the mask will be modified. If no mask is provided, the
              #     following default mask is used:
              #
              #     `paths: "bindings, etag"`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Iam::V1::Policy]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Iam::V1::Policy]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/service_directory/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ServiceDirectory::V1beta1::RegistrationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::SetIamPolicyRequest.new
              #
              #   # Call the set_iam_policy method.
              #   result = client.set_iam_policy request
              #
              #   # The returned object is of type Google::Iam::V1::Policy.
              #   p result
              #
              def set_iam_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::SetIamPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.set_iam_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ServiceDirectory::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.set_iam_policy.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.set_iam_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registration_service_stub.set_iam_policy request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Tests IAM permissions for a resource (namespace, service  or
              # service workload only).
              #
              # @overload test_iam_permissions(request, options = nil)
              #   Pass arguments to `test_iam_permissions` via a request object, either of type
              #   {::Google::Iam::V1::TestIamPermissionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::TestIamPermissionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload test_iam_permissions(resource: nil, permissions: nil)
              #   Pass arguments to `test_iam_permissions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy detail is being requested.
              #     See the operation documentation for the appropriate value for this field.
              #   @param permissions [::Array<::String>]
              #     The set of permissions to check for the `resource`. Permissions with
              #     wildcards (such as '*' or 'storage.*') are not allowed. For more
              #     information see
              #     [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Iam::V1::TestIamPermissionsResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Iam::V1::TestIamPermissionsResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/service_directory/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ServiceDirectory::V1beta1::RegistrationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::TestIamPermissionsRequest.new
              #
              #   # Call the test_iam_permissions method.
              #   result = client.test_iam_permissions request
              #
              #   # The returned object is of type Google::Iam::V1::TestIamPermissionsResponse.
              #   p result
              #
              def test_iam_permissions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::TestIamPermissionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.test_iam_permissions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ServiceDirectory::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.test_iam_permissions.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.test_iam_permissions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registration_service_stub.test_iam_permissions request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the RegistrationService REST API.
              #
              # This class represents the configuration for RegistrationService REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::ServiceDirectory::V1beta1::RegistrationService::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # create_namespace to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::ServiceDirectory::V1beta1::RegistrationService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_namespace.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::ServiceDirectory::V1beta1::RegistrationService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_namespace.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "servicedirectory.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the RegistrationService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `create_namespace`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_namespace
                  ##
                  # RPC-specific configuration for `list_namespaces`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_namespaces
                  ##
                  # RPC-specific configuration for `get_namespace`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_namespace
                  ##
                  # RPC-specific configuration for `update_namespace`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_namespace
                  ##
                  # RPC-specific configuration for `delete_namespace`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_namespace
                  ##
                  # RPC-specific configuration for `create_service`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_service
                  ##
                  # RPC-specific configuration for `list_services`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_services
                  ##
                  # RPC-specific configuration for `get_service`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_service
                  ##
                  # RPC-specific configuration for `update_service`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_service
                  ##
                  # RPC-specific configuration for `delete_service`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_service
                  ##
                  # RPC-specific configuration for `create_endpoint`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_endpoint
                  ##
                  # RPC-specific configuration for `list_endpoints`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_endpoints
                  ##
                  # RPC-specific configuration for `get_endpoint`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_endpoint
                  ##
                  # RPC-specific configuration for `update_endpoint`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_endpoint
                  ##
                  # RPC-specific configuration for `delete_endpoint`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_endpoint
                  ##
                  # RPC-specific configuration for `get_iam_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_iam_policy
                  ##
                  # RPC-specific configuration for `set_iam_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :set_iam_policy
                  ##
                  # RPC-specific configuration for `test_iam_permissions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :test_iam_permissions

                  # @private
                  def initialize parent_rpcs = nil
                    create_namespace_config = parent_rpcs.create_namespace if parent_rpcs.respond_to? :create_namespace
                    @create_namespace = ::Gapic::Config::Method.new create_namespace_config
                    list_namespaces_config = parent_rpcs.list_namespaces if parent_rpcs.respond_to? :list_namespaces
                    @list_namespaces = ::Gapic::Config::Method.new list_namespaces_config
                    get_namespace_config = parent_rpcs.get_namespace if parent_rpcs.respond_to? :get_namespace
                    @get_namespace = ::Gapic::Config::Method.new get_namespace_config
                    update_namespace_config = parent_rpcs.update_namespace if parent_rpcs.respond_to? :update_namespace
                    @update_namespace = ::Gapic::Config::Method.new update_namespace_config
                    delete_namespace_config = parent_rpcs.delete_namespace if parent_rpcs.respond_to? :delete_namespace
                    @delete_namespace = ::Gapic::Config::Method.new delete_namespace_config
                    create_service_config = parent_rpcs.create_service if parent_rpcs.respond_to? :create_service
                    @create_service = ::Gapic::Config::Method.new create_service_config
                    list_services_config = parent_rpcs.list_services if parent_rpcs.respond_to? :list_services
                    @list_services = ::Gapic::Config::Method.new list_services_config
                    get_service_config = parent_rpcs.get_service if parent_rpcs.respond_to? :get_service
                    @get_service = ::Gapic::Config::Method.new get_service_config
                    update_service_config = parent_rpcs.update_service if parent_rpcs.respond_to? :update_service
                    @update_service = ::Gapic::Config::Method.new update_service_config
                    delete_service_config = parent_rpcs.delete_service if parent_rpcs.respond_to? :delete_service
                    @delete_service = ::Gapic::Config::Method.new delete_service_config
                    create_endpoint_config = parent_rpcs.create_endpoint if parent_rpcs.respond_to? :create_endpoint
                    @create_endpoint = ::Gapic::Config::Method.new create_endpoint_config
                    list_endpoints_config = parent_rpcs.list_endpoints if parent_rpcs.respond_to? :list_endpoints
                    @list_endpoints = ::Gapic::Config::Method.new list_endpoints_config
                    get_endpoint_config = parent_rpcs.get_endpoint if parent_rpcs.respond_to? :get_endpoint
                    @get_endpoint = ::Gapic::Config::Method.new get_endpoint_config
                    update_endpoint_config = parent_rpcs.update_endpoint if parent_rpcs.respond_to? :update_endpoint
                    @update_endpoint = ::Gapic::Config::Method.new update_endpoint_config
                    delete_endpoint_config = parent_rpcs.delete_endpoint if parent_rpcs.respond_to? :delete_endpoint
                    @delete_endpoint = ::Gapic::Config::Method.new delete_endpoint_config
                    get_iam_policy_config = parent_rpcs.get_iam_policy if parent_rpcs.respond_to? :get_iam_policy
                    @get_iam_policy = ::Gapic::Config::Method.new get_iam_policy_config
                    set_iam_policy_config = parent_rpcs.set_iam_policy if parent_rpcs.respond_to? :set_iam_policy
                    @set_iam_policy = ::Gapic::Config::Method.new set_iam_policy_config
                    test_iam_permissions_config = parent_rpcs.test_iam_permissions if parent_rpcs.respond_to? :test_iam_permissions
                    @test_iam_permissions = ::Gapic::Config::Method.new test_iam_permissions_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
