# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ServiceDirectory
      module V1
        # An individual service. A service contains a name and optional metadata.
        # A service must exist before
        # {::Google::Cloud::ServiceDirectory::V1::Endpoint endpoints} can be
        # added to it.
        # @!attribute [rw] name
        #   @return [::String]
        #     Immutable. The resource name for the service in the format
        #     `projects/*/locations/*/namespaces/*/services/*`.
        # @!attribute [rw] annotations
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Annotations for the service. This data can be consumed by service
        #     clients.
        #
        #     Restrictions:
        #
        #     *   The entire annotations dictionary may contain up to 2000 characters,
        #         spread accoss all key-value pairs. Annotations that go beyond this
        #         limit are rejected
        #     *   Valid annotation keys have two segments: an optional prefix and name,
        #         separated by a slash (/). The name segment is required and must be 63
        #         characters or less, beginning and ending with an alphanumeric character
        #         ([a-z0-9A-Z]) with dashes (-), underscores (_), dots (.), and
        #         alphanumerics between. The prefix is optional. If specified, the prefix
        #         must be a DNS subdomain: a series of DNS labels separated by dots (.),
        #         not longer than 253 characters in total, followed by a slash (/).
        #         Annotations that fails to meet these requirements are rejected
        #
        #     Note: This field is equivalent to the `metadata` field in the v1beta1 API.
        #     They have the same syntax and read/write to the same location in Service
        #     Directory.
        # @!attribute [r] endpoints
        #   @return [::Array<::Google::Cloud::ServiceDirectory::V1::Endpoint>]
        #     Output only. Endpoints associated with this service. Returned on
        #     {::Google::Cloud::ServiceDirectory::V1::LookupService::Client#resolve_service LookupService.ResolveService}.
        #     Control plane clients should use
        #     {::Google::Cloud::ServiceDirectory::V1::RegistrationService::Client#list_endpoints RegistrationService.ListEndpoints}.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. The globally unique identifier of the service in the UUID4
        #     format.
        class Service
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AnnotationsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
