# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ServiceDirectory
      module V1
        # A container for {::Google::Cloud::ServiceDirectory::V1::Service services}.
        # Namespaces allow administrators to group services together and define
        # permissions for a collection of services.
        # @!attribute [rw] name
        #   @return [::String]
        #     Immutable. The resource name for the namespace in the format
        #     `projects/*/locations/*/namespaces/*`.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Resource labels associated with this namespace.
        #     No more than 64 user labels can be associated with a given resource. Label
        #     keys and values can be no longer than 63 characters.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. The globally unique identifier of the namespace in the UUID4
        #     format.
        class Namespace
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
