# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ServiceControl
      module V1
        # Request message for the Check method.
        # @!attribute [rw] service_name
        #   @return [::String]
        #     The service name as specified in its service configuration. For example,
        #     `"pubsub.googleapis.com"`.
        #
        #     See
        #     [google.api.Service](https://cloud.google.com/service-management/reference/rpc/google.api#google.api.Service)
        #     for the definition of a service name.
        # @!attribute [rw] operation
        #   @return [::Google::Cloud::ServiceControl::V1::Operation]
        #     The operation to be checked.
        # @!attribute [rw] service_config_id
        #   @return [::String]
        #     Specifies which version of service configuration should be used to process
        #     the request.
        #
        #     If unspecified or no matching version can be found, the
        #     latest one will be used.
        class CheckRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for the Check method.
        # @!attribute [rw] operation_id
        #   @return [::String]
        #     The same operation_id value used in the
        #     {::Google::Cloud::ServiceControl::V1::CheckRequest CheckRequest}. Used for logging
        #     and diagnostics purposes.
        # @!attribute [rw] check_errors
        #   @return [::Array<::Google::Cloud::ServiceControl::V1::CheckError>]
        #     Indicate the decision of the check.
        #
        #     If no check errors are present, the service should process the operation.
        #     Otherwise the service should use the list of errors to determine the
        #     appropriate action.
        # @!attribute [rw] service_config_id
        #   @return [::String]
        #     The actual config id used to process the request.
        # @!attribute [rw] service_rollout_id
        #   @return [::String]
        #     The current service rollout id used to process the request.
        # @!attribute [rw] check_info
        #   @return [::Google::Cloud::ServiceControl::V1::CheckResponse::CheckInfo]
        #     Feedback data returned from the server during processing a Check request.
        class CheckResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Contains additional information about the check operation.
          # @!attribute [rw] unused_arguments
          #   @return [::Array<::String>]
          #     A list of fields and label keys that are ignored by the server.
          #     The client doesn't need to send them for following requests to improve
          #     performance and allow better aggregation.
          # @!attribute [rw] consumer_info
          #   @return [::Google::Cloud::ServiceControl::V1::CheckResponse::ConsumerInfo]
          #     Consumer info of this check.
          # @!attribute [rw] api_key_uid
          #   @return [::String]
          #     The unique id of the api key in the format of "apikey:<UID>".
          #     This field will be populated when the consumer passed to Service Control
          #     is an API key and all the API key related validations are successful.
          class CheckInfo
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # `ConsumerInfo` provides information about the consumer.
          # @!attribute [rw] project_number
          #   @return [::Integer]
          #     The Google cloud project number, e.g. 1234567890. A value of 0 indicates
          #     no project number is found.
          #
          #     NOTE: This field is deprecated after we support flexible consumer
          #     id. New code should not depend on this field anymore.
          # @!attribute [rw] type
          #   @return [::Google::Cloud::ServiceControl::V1::CheckResponse::ConsumerInfo::ConsumerType]
          #     The type of the consumer which should have been defined in
          #     [Google Resource Manager](https://cloud.google.com/resource-manager/).
          # @!attribute [rw] consumer_number
          #   @return [::Integer]
          #     The consumer identity number, can be Google cloud project number, folder
          #     number or organization number e.g. 1234567890. A value of 0 indicates no
          #     consumer number is found.
          class ConsumerInfo
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The type of the consumer as defined in
            # [Google Resource Manager](https://cloud.google.com/resource-manager/).
            module ConsumerType
              # This is never used.
              CONSUMER_TYPE_UNSPECIFIED = 0

              # The consumer is a Google Cloud Project.
              PROJECT = 1

              # The consumer is a Google Cloud Folder.
              FOLDER = 2

              # The consumer is a Google Cloud Organization.
              ORGANIZATION = 3

              # Service-specific resource container which is defined by the service
              # producer to offer their users the ability to manage service control
              # functionalities at a finer level of granularity than the PROJECT.
              SERVICE_SPECIFIC = 4
            end
          end
        end

        # Request message for the Report method.
        # @!attribute [rw] service_name
        #   @return [::String]
        #     The service name as specified in its service configuration. For example,
        #     `"pubsub.googleapis.com"`.
        #
        #     See
        #     [google.api.Service](https://cloud.google.com/service-management/reference/rpc/google.api#google.api.Service)
        #     for the definition of a service name.
        # @!attribute [rw] operations
        #   @return [::Array<::Google::Cloud::ServiceControl::V1::Operation>]
        #     Operations to be reported.
        #
        #     Typically the service should report one operation per request.
        #     Putting multiple operations into a single request is allowed, but should
        #     be used only when multiple operations are natually available at the time
        #     of the report.
        #
        #     There is no limit on the number of operations in the same ReportRequest,
        #     however the ReportRequest size should be no larger than 1MB. See
        #     {::Google::Cloud::ServiceControl::V1::ReportResponse#report_errors ReportResponse.report_errors}
        #     for partial failure behavior.
        # @!attribute [rw] service_config_id
        #   @return [::String]
        #     Specifies which version of service config should be used to process the
        #     request.
        #
        #     If unspecified or no matching version can be found, the
        #     latest one will be used.
        class ReportRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for the Report method.
        # @!attribute [rw] report_errors
        #   @return [::Array<::Google::Cloud::ServiceControl::V1::ReportResponse::ReportError>]
        #     Partial failures, one for each `Operation` in the request that failed
        #     processing. There are three possible combinations of the RPC status:
        #
        #     1. The combination of a successful RPC status and an empty `report_errors`
        #        list indicates a complete success where all `Operations` in the
        #        request are processed successfully.
        #     2. The combination of a successful RPC status and a non-empty
        #        `report_errors` list indicates a partial success where some
        #        `Operations` in the request succeeded. Each
        #        `Operation` that failed processing has a corresponding item
        #        in this list.
        #     3. A failed RPC status indicates a general non-deterministic failure.
        #        When this happens, it's impossible to know which of the
        #        'Operations' in the request succeeded or failed.
        # @!attribute [rw] service_config_id
        #   @return [::String]
        #     The actual config id used to process the request.
        # @!attribute [rw] service_rollout_id
        #   @return [::String]
        #     The current service rollout id used to process the request.
        class ReportResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Represents the processing error of one
          # {::Google::Cloud::ServiceControl::V1::Operation Operation} in the request.
          # @!attribute [rw] operation_id
          #   @return [::String]
          #     The
          #     {::Google::Cloud::ServiceControl::V1::Operation#operation_id Operation.operation_id}
          #     value from the request.
          # @!attribute [rw] status
          #   @return [::Google::Rpc::Status]
          #     Details of the error when processing the
          #     {::Google::Cloud::ServiceControl::V1::Operation Operation}.
          class ReportError
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
