# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ServiceControl
      module V1
        # Represents a single metric value.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     The labels describing the metric value.
        #     See comments on {::Google::Cloud::ServiceControl::V1::Operation#labels google.api.servicecontrol.v1.Operation.labels} for
        #     the overriding relationship.
        #     Note that this map must not contain monitored resource labels.
        # @!attribute [rw] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The start of the time period over which this metric value's measurement
        #     applies. The time period has different semantics for different metric
        #     types (cumulative, delta, and gauge). See the metric definition
        #     documentation in the service configuration for details. If not specified,
        #     {::Google::Cloud::ServiceControl::V1::Operation#start_time google.api.servicecontrol.v1.Operation.start_time} will be used.
        # @!attribute [rw] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The end of the time period over which this metric value's measurement
        #     applies.  If not specified,
        #     {::Google::Cloud::ServiceControl::V1::Operation#end_time google.api.servicecontrol.v1.Operation.end_time} will be used.
        # @!attribute [rw] bool_value
        #   @return [::Boolean]
        #     A boolean value.
        #
        #     Note: The following fields are mutually exclusive: `bool_value`, `int64_value`, `double_value`, `string_value`, `distribution_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] int64_value
        #   @return [::Integer]
        #     A signed 64-bit integer value.
        #
        #     Note: The following fields are mutually exclusive: `int64_value`, `bool_value`, `double_value`, `string_value`, `distribution_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] double_value
        #   @return [::Float]
        #     A double precision floating point value.
        #
        #     Note: The following fields are mutually exclusive: `double_value`, `bool_value`, `int64_value`, `string_value`, `distribution_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] string_value
        #   @return [::String]
        #     A text string value.
        #
        #     Note: The following fields are mutually exclusive: `string_value`, `bool_value`, `int64_value`, `double_value`, `distribution_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] distribution_value
        #   @return [::Google::Cloud::ServiceControl::V1::Distribution]
        #     A distribution value.
        #
        #     Note: The following fields are mutually exclusive: `distribution_value`, `bool_value`, `int64_value`, `double_value`, `string_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class MetricValue
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Represents a set of metric values in the same metric.
        # Each metric value in the set should have a unique combination of start time,
        # end time, and label values.
        # @!attribute [rw] metric_name
        #   @return [::String]
        #     The metric name defined in the service configuration.
        # @!attribute [rw] metric_values
        #   @return [::Array<::Google::Cloud::ServiceControl::V1::MetricValue>]
        #     The values in this metric.
        class MetricValueSet
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
