# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/api/servicecontrol/v1/service_controller_pb"
require "google/cloud/service_control/v1/service_controller/rest/service_stub"

module Google
  module Cloud
    module ServiceControl
      module V1
        module ServiceController
          module Rest
            ##
            # REST client for the ServiceController service.
            #
            # [Google Service Control API](/service-control/overview)
            #
            # Lets clients check and report operations against a [managed
            # service](https://cloud.google.com/service-management/reference/rpc/google.api/servicemanagement.v1#google.api.servicemanagement.v1.ManagedService).
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "servicecontrol.$UNIVERSE_DOMAIN$"

              # @private
              attr_reader :service_controller_stub

              ##
              # Configure the ServiceController Client class.
              #
              # See {::Google::Cloud::ServiceControl::V1::ServiceController::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all ServiceController clients
              #   ::Google::Cloud::ServiceControl::V1::ServiceController::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "ServiceControl", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.check.timeout = 5.0
                  default_config.rpcs.check.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.report.timeout = 16.0

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the ServiceController Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::ServiceControl::V1::ServiceController::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @service_controller_stub.universe_domain
              end

              ##
              # Create a new ServiceController REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::ServiceControl::V1::ServiceController::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::ServiceControl::V1::ServiceController::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the ServiceController client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @service_controller_stub = ::Google::Cloud::ServiceControl::V1::ServiceController::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @service_controller_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @service_controller_stub.logger
              end

              # Service calls

              ##
              # Checks whether an operation on a service should be allowed to proceed
              # based on the configuration of the service and related policies. It must be
              # called before the operation is executed.
              #
              # If feasible, the client should cache the check results and reuse them for
              # 60 seconds. In case of any server errors, the client should rely on the
              # cached results for much longer time to avoid outage.
              # WARNING: There is general 60s delay for the configuration and policy
              # propagation, therefore callers MUST NOT depend on the `Check` method having
              # the latest policy information.
              #
              # NOTE: the {::Google::Cloud::ServiceControl::V1::CheckRequest CheckRequest} has
              # the size limit (wire-format byte size) of 1MB.
              #
              # This method requires the `servicemanagement.services.check` permission
              # on the specified service. For more information, see
              # [Cloud IAM](https://cloud.google.com/iam).
              #
              # @overload check(request, options = nil)
              #   Pass arguments to `check` via a request object, either of type
              #   {::Google::Cloud::ServiceControl::V1::CheckRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ServiceControl::V1::CheckRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload check(service_name: nil, operation: nil, service_config_id: nil)
              #   Pass arguments to `check` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param service_name [::String]
              #     The service name as specified in its service configuration. For example,
              #     `"pubsub.googleapis.com"`.
              #
              #     See
              #     [google.api.Service](https://cloud.google.com/service-management/reference/rpc/google.api#google.api.Service)
              #     for the definition of a service name.
              #   @param operation [::Google::Cloud::ServiceControl::V1::Operation, ::Hash]
              #     The operation to be checked.
              #   @param service_config_id [::String]
              #     Specifies which version of service configuration should be used to process
              #     the request.
              #
              #     If unspecified or no matching version can be found, the
              #     latest one will be used.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ServiceControl::V1::CheckResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ServiceControl::V1::CheckResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/service_control/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ServiceControl::V1::ServiceController::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ServiceControl::V1::CheckRequest.new
              #
              #   # Call the check method.
              #   result = client.check request
              #
              #   # The returned object is of type Google::Cloud::ServiceControl::V1::CheckResponse.
              #   p result
              #
              def check request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ServiceControl::V1::CheckRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.check.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ServiceControl::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.check.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.check.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @service_controller_stub.check request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Reports operation results to Google Service Control, such as logs and
              # metrics. It should be called after an operation is completed.
              #
              # If feasible, the client should aggregate reporting data for up to 5
              # seconds to reduce API traffic. Limiting aggregation to 5 seconds is to
              # reduce data loss during client crashes. Clients should carefully choose
              # the aggregation time window to avoid data loss risk more than 0.01%
              # for business and compliance reasons.
              #
              # NOTE: the {::Google::Cloud::ServiceControl::V1::ReportRequest ReportRequest} has
              # the size limit (wire-format byte size) of 1MB.
              #
              # This method requires the `servicemanagement.services.report` permission
              # on the specified service. For more information, see
              # [Google Cloud IAM](https://cloud.google.com/iam).
              #
              # @overload report(request, options = nil)
              #   Pass arguments to `report` via a request object, either of type
              #   {::Google::Cloud::ServiceControl::V1::ReportRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ServiceControl::V1::ReportRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload report(service_name: nil, operations: nil, service_config_id: nil)
              #   Pass arguments to `report` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param service_name [::String]
              #     The service name as specified in its service configuration. For example,
              #     `"pubsub.googleapis.com"`.
              #
              #     See
              #     [google.api.Service](https://cloud.google.com/service-management/reference/rpc/google.api#google.api.Service)
              #     for the definition of a service name.
              #   @param operations [::Array<::Google::Cloud::ServiceControl::V1::Operation, ::Hash>]
              #     Operations to be reported.
              #
              #     Typically the service should report one operation per request.
              #     Putting multiple operations into a single request is allowed, but should
              #     be used only when multiple operations are natually available at the time
              #     of the report.
              #
              #     There is no limit on the number of operations in the same ReportRequest,
              #     however the ReportRequest size should be no larger than 1MB. See
              #     {::Google::Cloud::ServiceControl::V1::ReportResponse#report_errors ReportResponse.report_errors}
              #     for partial failure behavior.
              #   @param service_config_id [::String]
              #     Specifies which version of service config should be used to process the
              #     request.
              #
              #     If unspecified or no matching version can be found, the
              #     latest one will be used.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ServiceControl::V1::ReportResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ServiceControl::V1::ReportResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/service_control/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ServiceControl::V1::ServiceController::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ServiceControl::V1::ReportRequest.new
              #
              #   # Call the report method.
              #   result = client.report request
              #
              #   # The returned object is of type Google::Cloud::ServiceControl::V1::ReportResponse.
              #   p result
              #
              def report request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ServiceControl::V1::ReportRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.report.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ServiceControl::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.report.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.report.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @service_controller_stub.report request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the ServiceController REST API.
              #
              # This class represents the configuration for ServiceController REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::ServiceControl::V1::ServiceController::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # check to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::ServiceControl::V1::ServiceController::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.check.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::ServiceControl::V1::ServiceController::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.check.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "servicecontrol.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the ServiceController API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `check`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :check
                  ##
                  # RPC-specific configuration for `report`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :report

                  # @private
                  def initialize parent_rpcs = nil
                    check_config = parent_rpcs.check if parent_rpcs.respond_to? :check
                    @check = ::Gapic::Config::Method.new check_config
                    report_config = parent_rpcs.report if parent_rpcs.respond_to? :report
                    @report = ::Gapic::Config::Method.new report_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
