# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/common"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/service_control/v1/version"

require "google/cloud/service_control/v1/service_controller/credentials"
require "google/cloud/service_control/v1/service_controller/client"
require "google/cloud/service_control/v1/service_controller/rest"

module Google
  module Cloud
    module ServiceControl
      module V1
        ##
        # [Google Service Control API](/service-control/overview)
        #
        # Lets clients check and report operations against a [managed
        # service](https://cloud.google.com/service-management/reference/rpc/google.api/servicemanagement.v1#google.api.servicemanagement.v1.ManagedService).
        #
        # @example Load this service and instantiate a gRPC client
        #
        #     require "google/cloud/service_control/v1/service_controller"
        #     client = ::Google::Cloud::ServiceControl::V1::ServiceController::Client.new
        #
        # @example Load this service and instantiate a REST client
        #
        #     require "google/cloud/service_control/v1/service_controller/rest"
        #     client = ::Google::Cloud::ServiceControl::V1::ServiceController::Rest::Client.new
        #
        module ServiceController
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "service_controller", "helpers.rb"
require "google/cloud/service_control/v1/service_controller/helpers" if ::File.file? helper_path
