# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/api/servicecontrol/v1/quota_controller.proto for package 'Google.Cloud.ServiceControl.V1'
# Original file comments:
# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/api/servicecontrol/v1/quota_controller_pb'

module Google
  module Cloud
    module ServiceControl
      module V1
        module QuotaController
          # [Google Quota Control API](/service-control/overview)
          #
          # Allows clients to allocate and release quota against a [managed
          # service](https://cloud.google.com/service-management/reference/rpc/google.api/servicemanagement.v1#google.api.servicemanagement.v1.ManagedService).
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.api.servicecontrol.v1.QuotaController'

            # Attempts to allocate quota for the specified consumer. It should be called
            # before the operation is executed.
            #
            # This method requires the `servicemanagement.services.quota`
            # permission on the specified service. For more information, see
            # [Cloud IAM](https://cloud.google.com/iam).
            #
            # **NOTE:** The client **must** fail-open on server errors `INTERNAL`,
            # `UNKNOWN`, `DEADLINE_EXCEEDED`, and `UNAVAILABLE`. To ensure system
            # reliability, the server may inject these errors to prohibit any hard
            # dependency on the quota functionality.
            rpc :AllocateQuota, ::Google::Cloud::ServiceControl::V1::AllocateQuotaRequest, ::Google::Cloud::ServiceControl::V1::AllocateQuotaResponse
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
