# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/securitycentermanagement/v1/security_center_management_pb"
require "google/cloud/security_center_management/v1/security_center_management"

class ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_effective_security_health_analytics_custom_modules
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenterManagement::V1::ListEffectiveSecurityHealthAnalyticsCustomModulesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_effective_security_health_analytics_custom_modules_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_effective_security_health_analytics_custom_modules, name
      assert_kind_of ::Google::Cloud::SecurityCenterManagement::V1::ListEffectiveSecurityHealthAnalyticsCustomModulesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_effective_security_health_analytics_custom_modules_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_effective_security_health_analytics_custom_modules({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_effective_security_health_analytics_custom_modules parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_effective_security_health_analytics_custom_modules ::Google::Cloud::SecurityCenterManagement::V1::ListEffectiveSecurityHealthAnalyticsCustomModulesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_effective_security_health_analytics_custom_modules({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_effective_security_health_analytics_custom_modules(::Google::Cloud::SecurityCenterManagement::V1::ListEffectiveSecurityHealthAnalyticsCustomModulesRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_effective_security_health_analytics_custom_modules_client_stub.call_rpc_count
    end
  end

  def test_get_effective_security_health_analytics_custom_module
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenterManagement::V1::EffectiveSecurityHealthAnalyticsCustomModule.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_effective_security_health_analytics_custom_module_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_effective_security_health_analytics_custom_module, name
      assert_kind_of ::Google::Cloud::SecurityCenterManagement::V1::GetEffectiveSecurityHealthAnalyticsCustomModuleRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_effective_security_health_analytics_custom_module_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_effective_security_health_analytics_custom_module({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_effective_security_health_analytics_custom_module name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_effective_security_health_analytics_custom_module ::Google::Cloud::SecurityCenterManagement::V1::GetEffectiveSecurityHealthAnalyticsCustomModuleRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_effective_security_health_analytics_custom_module({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_effective_security_health_analytics_custom_module(::Google::Cloud::SecurityCenterManagement::V1::GetEffectiveSecurityHealthAnalyticsCustomModuleRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_effective_security_health_analytics_custom_module_client_stub.call_rpc_count
    end
  end

  def test_list_security_health_analytics_custom_modules
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenterManagement::V1::ListSecurityHealthAnalyticsCustomModulesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_security_health_analytics_custom_modules_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_security_health_analytics_custom_modules, name
      assert_kind_of ::Google::Cloud::SecurityCenterManagement::V1::ListSecurityHealthAnalyticsCustomModulesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_security_health_analytics_custom_modules_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_security_health_analytics_custom_modules({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_security_health_analytics_custom_modules parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_security_health_analytics_custom_modules ::Google::Cloud::SecurityCenterManagement::V1::ListSecurityHealthAnalyticsCustomModulesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_security_health_analytics_custom_modules({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_security_health_analytics_custom_modules(::Google::Cloud::SecurityCenterManagement::V1::ListSecurityHealthAnalyticsCustomModulesRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_security_health_analytics_custom_modules_client_stub.call_rpc_count
    end
  end

  def test_list_descendant_security_health_analytics_custom_modules
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenterManagement::V1::ListDescendantSecurityHealthAnalyticsCustomModulesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_descendant_security_health_analytics_custom_modules_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_descendant_security_health_analytics_custom_modules, name
      assert_kind_of ::Google::Cloud::SecurityCenterManagement::V1::ListDescendantSecurityHealthAnalyticsCustomModulesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_descendant_security_health_analytics_custom_modules_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_descendant_security_health_analytics_custom_modules({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_descendant_security_health_analytics_custom_modules parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_descendant_security_health_analytics_custom_modules ::Google::Cloud::SecurityCenterManagement::V1::ListDescendantSecurityHealthAnalyticsCustomModulesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_descendant_security_health_analytics_custom_modules({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_descendant_security_health_analytics_custom_modules(::Google::Cloud::SecurityCenterManagement::V1::ListDescendantSecurityHealthAnalyticsCustomModulesRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_descendant_security_health_analytics_custom_modules_client_stub.call_rpc_count
    end
  end

  def test_get_security_health_analytics_custom_module
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenterManagement::V1::SecurityHealthAnalyticsCustomModule.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_security_health_analytics_custom_module_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_security_health_analytics_custom_module, name
      assert_kind_of ::Google::Cloud::SecurityCenterManagement::V1::GetSecurityHealthAnalyticsCustomModuleRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_security_health_analytics_custom_module_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_security_health_analytics_custom_module({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_security_health_analytics_custom_module name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_security_health_analytics_custom_module ::Google::Cloud::SecurityCenterManagement::V1::GetSecurityHealthAnalyticsCustomModuleRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_security_health_analytics_custom_module({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_security_health_analytics_custom_module(::Google::Cloud::SecurityCenterManagement::V1::GetSecurityHealthAnalyticsCustomModuleRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_security_health_analytics_custom_module_client_stub.call_rpc_count
    end
  end

  def test_create_security_health_analytics_custom_module
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenterManagement::V1::SecurityHealthAnalyticsCustomModule.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    security_health_analytics_custom_module = {}
    validate_only = true

    create_security_health_analytics_custom_module_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_security_health_analytics_custom_module, name
      assert_kind_of ::Google::Cloud::SecurityCenterManagement::V1::CreateSecurityHealthAnalyticsCustomModuleRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecurityCenterManagement::V1::SecurityHealthAnalyticsCustomModule), request["security_health_analytics_custom_module"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_security_health_analytics_custom_module_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_security_health_analytics_custom_module({ parent: parent, security_health_analytics_custom_module: security_health_analytics_custom_module, validate_only: validate_only }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_security_health_analytics_custom_module parent: parent, security_health_analytics_custom_module: security_health_analytics_custom_module, validate_only: validate_only do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_security_health_analytics_custom_module ::Google::Cloud::SecurityCenterManagement::V1::CreateSecurityHealthAnalyticsCustomModuleRequest.new(parent: parent, security_health_analytics_custom_module: security_health_analytics_custom_module, validate_only: validate_only) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_security_health_analytics_custom_module({ parent: parent, security_health_analytics_custom_module: security_health_analytics_custom_module, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_security_health_analytics_custom_module(::Google::Cloud::SecurityCenterManagement::V1::CreateSecurityHealthAnalyticsCustomModuleRequest.new(parent: parent, security_health_analytics_custom_module: security_health_analytics_custom_module, validate_only: validate_only), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_security_health_analytics_custom_module_client_stub.call_rpc_count
    end
  end

  def test_update_security_health_analytics_custom_module
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenterManagement::V1::SecurityHealthAnalyticsCustomModule.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    security_health_analytics_custom_module = {}
    validate_only = true

    update_security_health_analytics_custom_module_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_security_health_analytics_custom_module, name
      assert_kind_of ::Google::Cloud::SecurityCenterManagement::V1::UpdateSecurityHealthAnalyticsCustomModuleRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecurityCenterManagement::V1::SecurityHealthAnalyticsCustomModule), request["security_health_analytics_custom_module"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_security_health_analytics_custom_module_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_security_health_analytics_custom_module({ update_mask: update_mask, security_health_analytics_custom_module: security_health_analytics_custom_module, validate_only: validate_only }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_security_health_analytics_custom_module update_mask: update_mask, security_health_analytics_custom_module: security_health_analytics_custom_module, validate_only: validate_only do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_security_health_analytics_custom_module ::Google::Cloud::SecurityCenterManagement::V1::UpdateSecurityHealthAnalyticsCustomModuleRequest.new(update_mask: update_mask, security_health_analytics_custom_module: security_health_analytics_custom_module, validate_only: validate_only) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_security_health_analytics_custom_module({ update_mask: update_mask, security_health_analytics_custom_module: security_health_analytics_custom_module, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_security_health_analytics_custom_module(::Google::Cloud::SecurityCenterManagement::V1::UpdateSecurityHealthAnalyticsCustomModuleRequest.new(update_mask: update_mask, security_health_analytics_custom_module: security_health_analytics_custom_module, validate_only: validate_only), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_security_health_analytics_custom_module_client_stub.call_rpc_count
    end
  end

  def test_delete_security_health_analytics_custom_module
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    validate_only = true

    delete_security_health_analytics_custom_module_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_security_health_analytics_custom_module, name
      assert_kind_of ::Google::Cloud::SecurityCenterManagement::V1::DeleteSecurityHealthAnalyticsCustomModuleRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_security_health_analytics_custom_module_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_security_health_analytics_custom_module({ name: name, validate_only: validate_only }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_security_health_analytics_custom_module name: name, validate_only: validate_only do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_security_health_analytics_custom_module ::Google::Cloud::SecurityCenterManagement::V1::DeleteSecurityHealthAnalyticsCustomModuleRequest.new(name: name, validate_only: validate_only) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_security_health_analytics_custom_module({ name: name, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_security_health_analytics_custom_module(::Google::Cloud::SecurityCenterManagement::V1::DeleteSecurityHealthAnalyticsCustomModuleRequest.new(name: name, validate_only: validate_only), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_security_health_analytics_custom_module_client_stub.call_rpc_count
    end
  end

  def test_simulate_security_health_analytics_custom_module
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenterManagement::V1::SimulateSecurityHealthAnalyticsCustomModuleResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    custom_config = {}
    resource = {}

    simulate_security_health_analytics_custom_module_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :simulate_security_health_analytics_custom_module, name
      assert_kind_of ::Google::Cloud::SecurityCenterManagement::V1::SimulateSecurityHealthAnalyticsCustomModuleRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecurityCenterManagement::V1::CustomConfig), request["custom_config"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecurityCenterManagement::V1::SimulateSecurityHealthAnalyticsCustomModuleRequest::SimulatedResource), request["resource"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, simulate_security_health_analytics_custom_module_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.simulate_security_health_analytics_custom_module({ parent: parent, custom_config: custom_config, resource: resource }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.simulate_security_health_analytics_custom_module parent: parent, custom_config: custom_config, resource: resource do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.simulate_security_health_analytics_custom_module ::Google::Cloud::SecurityCenterManagement::V1::SimulateSecurityHealthAnalyticsCustomModuleRequest.new(parent: parent, custom_config: custom_config, resource: resource) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.simulate_security_health_analytics_custom_module({ parent: parent, custom_config: custom_config, resource: resource }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.simulate_security_health_analytics_custom_module(::Google::Cloud::SecurityCenterManagement::V1::SimulateSecurityHealthAnalyticsCustomModuleRequest.new(parent: parent, custom_config: custom_config, resource: resource), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, simulate_security_health_analytics_custom_module_client_stub.call_rpc_count
    end
  end

  def test_list_effective_event_threat_detection_custom_modules
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenterManagement::V1::ListEffectiveEventThreatDetectionCustomModulesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_effective_event_threat_detection_custom_modules_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_effective_event_threat_detection_custom_modules, name
      assert_kind_of ::Google::Cloud::SecurityCenterManagement::V1::ListEffectiveEventThreatDetectionCustomModulesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_effective_event_threat_detection_custom_modules_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_effective_event_threat_detection_custom_modules({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_effective_event_threat_detection_custom_modules parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_effective_event_threat_detection_custom_modules ::Google::Cloud::SecurityCenterManagement::V1::ListEffectiveEventThreatDetectionCustomModulesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_effective_event_threat_detection_custom_modules({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_effective_event_threat_detection_custom_modules(::Google::Cloud::SecurityCenterManagement::V1::ListEffectiveEventThreatDetectionCustomModulesRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_effective_event_threat_detection_custom_modules_client_stub.call_rpc_count
    end
  end

  def test_get_effective_event_threat_detection_custom_module
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenterManagement::V1::EffectiveEventThreatDetectionCustomModule.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_effective_event_threat_detection_custom_module_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_effective_event_threat_detection_custom_module, name
      assert_kind_of ::Google::Cloud::SecurityCenterManagement::V1::GetEffectiveEventThreatDetectionCustomModuleRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_effective_event_threat_detection_custom_module_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_effective_event_threat_detection_custom_module({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_effective_event_threat_detection_custom_module name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_effective_event_threat_detection_custom_module ::Google::Cloud::SecurityCenterManagement::V1::GetEffectiveEventThreatDetectionCustomModuleRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_effective_event_threat_detection_custom_module({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_effective_event_threat_detection_custom_module(::Google::Cloud::SecurityCenterManagement::V1::GetEffectiveEventThreatDetectionCustomModuleRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_effective_event_threat_detection_custom_module_client_stub.call_rpc_count
    end
  end

  def test_list_event_threat_detection_custom_modules
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenterManagement::V1::ListEventThreatDetectionCustomModulesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_event_threat_detection_custom_modules_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_event_threat_detection_custom_modules, name
      assert_kind_of ::Google::Cloud::SecurityCenterManagement::V1::ListEventThreatDetectionCustomModulesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_event_threat_detection_custom_modules_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_event_threat_detection_custom_modules({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_event_threat_detection_custom_modules parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_event_threat_detection_custom_modules ::Google::Cloud::SecurityCenterManagement::V1::ListEventThreatDetectionCustomModulesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_event_threat_detection_custom_modules({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_event_threat_detection_custom_modules(::Google::Cloud::SecurityCenterManagement::V1::ListEventThreatDetectionCustomModulesRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_event_threat_detection_custom_modules_client_stub.call_rpc_count
    end
  end

  def test_list_descendant_event_threat_detection_custom_modules
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenterManagement::V1::ListDescendantEventThreatDetectionCustomModulesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_descendant_event_threat_detection_custom_modules_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_descendant_event_threat_detection_custom_modules, name
      assert_kind_of ::Google::Cloud::SecurityCenterManagement::V1::ListDescendantEventThreatDetectionCustomModulesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_descendant_event_threat_detection_custom_modules_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_descendant_event_threat_detection_custom_modules({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_descendant_event_threat_detection_custom_modules parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_descendant_event_threat_detection_custom_modules ::Google::Cloud::SecurityCenterManagement::V1::ListDescendantEventThreatDetectionCustomModulesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_descendant_event_threat_detection_custom_modules({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_descendant_event_threat_detection_custom_modules(::Google::Cloud::SecurityCenterManagement::V1::ListDescendantEventThreatDetectionCustomModulesRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_descendant_event_threat_detection_custom_modules_client_stub.call_rpc_count
    end
  end

  def test_get_event_threat_detection_custom_module
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenterManagement::V1::EventThreatDetectionCustomModule.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_event_threat_detection_custom_module_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_event_threat_detection_custom_module, name
      assert_kind_of ::Google::Cloud::SecurityCenterManagement::V1::GetEventThreatDetectionCustomModuleRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_event_threat_detection_custom_module_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_event_threat_detection_custom_module({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_event_threat_detection_custom_module name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_event_threat_detection_custom_module ::Google::Cloud::SecurityCenterManagement::V1::GetEventThreatDetectionCustomModuleRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_event_threat_detection_custom_module({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_event_threat_detection_custom_module(::Google::Cloud::SecurityCenterManagement::V1::GetEventThreatDetectionCustomModuleRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_event_threat_detection_custom_module_client_stub.call_rpc_count
    end
  end

  def test_create_event_threat_detection_custom_module
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenterManagement::V1::EventThreatDetectionCustomModule.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    event_threat_detection_custom_module = {}
    validate_only = true

    create_event_threat_detection_custom_module_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_event_threat_detection_custom_module, name
      assert_kind_of ::Google::Cloud::SecurityCenterManagement::V1::CreateEventThreatDetectionCustomModuleRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecurityCenterManagement::V1::EventThreatDetectionCustomModule), request["event_threat_detection_custom_module"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_event_threat_detection_custom_module_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_event_threat_detection_custom_module({ parent: parent, event_threat_detection_custom_module: event_threat_detection_custom_module, validate_only: validate_only }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_event_threat_detection_custom_module parent: parent, event_threat_detection_custom_module: event_threat_detection_custom_module, validate_only: validate_only do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_event_threat_detection_custom_module ::Google::Cloud::SecurityCenterManagement::V1::CreateEventThreatDetectionCustomModuleRequest.new(parent: parent, event_threat_detection_custom_module: event_threat_detection_custom_module, validate_only: validate_only) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_event_threat_detection_custom_module({ parent: parent, event_threat_detection_custom_module: event_threat_detection_custom_module, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_event_threat_detection_custom_module(::Google::Cloud::SecurityCenterManagement::V1::CreateEventThreatDetectionCustomModuleRequest.new(parent: parent, event_threat_detection_custom_module: event_threat_detection_custom_module, validate_only: validate_only), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_event_threat_detection_custom_module_client_stub.call_rpc_count
    end
  end

  def test_update_event_threat_detection_custom_module
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenterManagement::V1::EventThreatDetectionCustomModule.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    event_threat_detection_custom_module = {}
    validate_only = true

    update_event_threat_detection_custom_module_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_event_threat_detection_custom_module, name
      assert_kind_of ::Google::Cloud::SecurityCenterManagement::V1::UpdateEventThreatDetectionCustomModuleRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecurityCenterManagement::V1::EventThreatDetectionCustomModule), request["event_threat_detection_custom_module"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_event_threat_detection_custom_module_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_event_threat_detection_custom_module({ update_mask: update_mask, event_threat_detection_custom_module: event_threat_detection_custom_module, validate_only: validate_only }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_event_threat_detection_custom_module update_mask: update_mask, event_threat_detection_custom_module: event_threat_detection_custom_module, validate_only: validate_only do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_event_threat_detection_custom_module ::Google::Cloud::SecurityCenterManagement::V1::UpdateEventThreatDetectionCustomModuleRequest.new(update_mask: update_mask, event_threat_detection_custom_module: event_threat_detection_custom_module, validate_only: validate_only) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_event_threat_detection_custom_module({ update_mask: update_mask, event_threat_detection_custom_module: event_threat_detection_custom_module, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_event_threat_detection_custom_module(::Google::Cloud::SecurityCenterManagement::V1::UpdateEventThreatDetectionCustomModuleRequest.new(update_mask: update_mask, event_threat_detection_custom_module: event_threat_detection_custom_module, validate_only: validate_only), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_event_threat_detection_custom_module_client_stub.call_rpc_count
    end
  end

  def test_delete_event_threat_detection_custom_module
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    validate_only = true

    delete_event_threat_detection_custom_module_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_event_threat_detection_custom_module, name
      assert_kind_of ::Google::Cloud::SecurityCenterManagement::V1::DeleteEventThreatDetectionCustomModuleRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_event_threat_detection_custom_module_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_event_threat_detection_custom_module({ name: name, validate_only: validate_only }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_event_threat_detection_custom_module name: name, validate_only: validate_only do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_event_threat_detection_custom_module ::Google::Cloud::SecurityCenterManagement::V1::DeleteEventThreatDetectionCustomModuleRequest.new(name: name, validate_only: validate_only) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_event_threat_detection_custom_module({ name: name, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_event_threat_detection_custom_module(::Google::Cloud::SecurityCenterManagement::V1::DeleteEventThreatDetectionCustomModuleRequest.new(name: name, validate_only: validate_only), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_event_threat_detection_custom_module_client_stub.call_rpc_count
    end
  end

  def test_validate_event_threat_detection_custom_module
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenterManagement::V1::ValidateEventThreatDetectionCustomModuleResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    raw_text = "hello world"
    type = "hello world"

    validate_event_threat_detection_custom_module_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :validate_event_threat_detection_custom_module, name
      assert_kind_of ::Google::Cloud::SecurityCenterManagement::V1::ValidateEventThreatDetectionCustomModuleRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["raw_text"]
      assert_equal "hello world", request["type"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, validate_event_threat_detection_custom_module_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.validate_event_threat_detection_custom_module({ parent: parent, raw_text: raw_text, type: type }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.validate_event_threat_detection_custom_module parent: parent, raw_text: raw_text, type: type do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.validate_event_threat_detection_custom_module ::Google::Cloud::SecurityCenterManagement::V1::ValidateEventThreatDetectionCustomModuleRequest.new(parent: parent, raw_text: raw_text, type: type) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.validate_event_threat_detection_custom_module({ parent: parent, raw_text: raw_text, type: type }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.validate_event_threat_detection_custom_module(::Google::Cloud::SecurityCenterManagement::V1::ValidateEventThreatDetectionCustomModuleRequest.new(parent: parent, raw_text: raw_text, type: type), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, validate_event_threat_detection_custom_module_client_stub.call_rpc_count
    end
  end

  def test_get_security_center_service
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterService.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    show_eligible_modules_only = true

    get_security_center_service_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_security_center_service, name
      assert_kind_of ::Google::Cloud::SecurityCenterManagement::V1::GetSecurityCenterServiceRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["show_eligible_modules_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_security_center_service_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_security_center_service({ name: name, show_eligible_modules_only: show_eligible_modules_only }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_security_center_service name: name, show_eligible_modules_only: show_eligible_modules_only do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_security_center_service ::Google::Cloud::SecurityCenterManagement::V1::GetSecurityCenterServiceRequest.new(name: name, show_eligible_modules_only: show_eligible_modules_only) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_security_center_service({ name: name, show_eligible_modules_only: show_eligible_modules_only }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_security_center_service(::Google::Cloud::SecurityCenterManagement::V1::GetSecurityCenterServiceRequest.new(name: name, show_eligible_modules_only: show_eligible_modules_only), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_security_center_service_client_stub.call_rpc_count
    end
  end

  def test_list_security_center_services
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenterManagement::V1::ListSecurityCenterServicesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    show_eligible_modules_only = true

    list_security_center_services_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_security_center_services, name
      assert_kind_of ::Google::Cloud::SecurityCenterManagement::V1::ListSecurityCenterServicesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal true, request["show_eligible_modules_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_security_center_services_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_security_center_services({ parent: parent, page_size: page_size, page_token: page_token, show_eligible_modules_only: show_eligible_modules_only }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_security_center_services parent: parent, page_size: page_size, page_token: page_token, show_eligible_modules_only: show_eligible_modules_only do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_security_center_services ::Google::Cloud::SecurityCenterManagement::V1::ListSecurityCenterServicesRequest.new(parent: parent, page_size: page_size, page_token: page_token, show_eligible_modules_only: show_eligible_modules_only) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_security_center_services({ parent: parent, page_size: page_size, page_token: page_token, show_eligible_modules_only: show_eligible_modules_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_security_center_services(::Google::Cloud::SecurityCenterManagement::V1::ListSecurityCenterServicesRequest.new(parent: parent, page_size: page_size, page_token: page_token, show_eligible_modules_only: show_eligible_modules_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_security_center_services_client_stub.call_rpc_count
    end
  end

  def test_update_security_center_service
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterService.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    security_center_service = {}
    update_mask = {}
    validate_only = true

    update_security_center_service_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_security_center_service, name
      assert_kind_of ::Google::Cloud::SecurityCenterManagement::V1::UpdateSecurityCenterServiceRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterService), request["security_center_service"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_security_center_service_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_security_center_service({ security_center_service: security_center_service, update_mask: update_mask, validate_only: validate_only }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_security_center_service security_center_service: security_center_service, update_mask: update_mask, validate_only: validate_only do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_security_center_service ::Google::Cloud::SecurityCenterManagement::V1::UpdateSecurityCenterServiceRequest.new(security_center_service: security_center_service, update_mask: update_mask, validate_only: validate_only) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_security_center_service({ security_center_service: security_center_service, update_mask: update_mask, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_security_center_service(::Google::Cloud::SecurityCenterManagement::V1::UpdateSecurityCenterServiceRequest.new(security_center_service: security_center_service, update_mask: update_mask, validate_only: validate_only), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_security_center_service_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
