# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/securitycentermanagement/v1/security_center_management_pb"
require "google/cloud/security_center_management/v1/security_center_management/rest"


class ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_effective_security_health_analytics_custom_modules
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenterManagement::V1::ListEffectiveSecurityHealthAnalyticsCustomModulesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_effective_security_health_analytics_custom_modules_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::ServiceStub.stub :transcode_list_effective_security_health_analytics_custom_modules_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_effective_security_health_analytics_custom_modules_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_effective_security_health_analytics_custom_modules({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_effective_security_health_analytics_custom_modules parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_effective_security_health_analytics_custom_modules ::Google::Cloud::SecurityCenterManagement::V1::ListEffectiveSecurityHealthAnalyticsCustomModulesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_effective_security_health_analytics_custom_modules({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_effective_security_health_analytics_custom_modules(::Google::Cloud::SecurityCenterManagement::V1::ListEffectiveSecurityHealthAnalyticsCustomModulesRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_effective_security_health_analytics_custom_modules_client_stub.call_count
      end
    end
  end

  def test_get_effective_security_health_analytics_custom_module
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenterManagement::V1::EffectiveSecurityHealthAnalyticsCustomModule.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_effective_security_health_analytics_custom_module_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::ServiceStub.stub :transcode_get_effective_security_health_analytics_custom_module_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_effective_security_health_analytics_custom_module_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_effective_security_health_analytics_custom_module({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_effective_security_health_analytics_custom_module name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_effective_security_health_analytics_custom_module ::Google::Cloud::SecurityCenterManagement::V1::GetEffectiveSecurityHealthAnalyticsCustomModuleRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_effective_security_health_analytics_custom_module({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_effective_security_health_analytics_custom_module(::Google::Cloud::SecurityCenterManagement::V1::GetEffectiveSecurityHealthAnalyticsCustomModuleRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_effective_security_health_analytics_custom_module_client_stub.call_count
      end
    end
  end

  def test_list_security_health_analytics_custom_modules
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenterManagement::V1::ListSecurityHealthAnalyticsCustomModulesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_security_health_analytics_custom_modules_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::ServiceStub.stub :transcode_list_security_health_analytics_custom_modules_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_security_health_analytics_custom_modules_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_security_health_analytics_custom_modules({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_security_health_analytics_custom_modules parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_security_health_analytics_custom_modules ::Google::Cloud::SecurityCenterManagement::V1::ListSecurityHealthAnalyticsCustomModulesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_security_health_analytics_custom_modules({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_security_health_analytics_custom_modules(::Google::Cloud::SecurityCenterManagement::V1::ListSecurityHealthAnalyticsCustomModulesRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_security_health_analytics_custom_modules_client_stub.call_count
      end
    end
  end

  def test_list_descendant_security_health_analytics_custom_modules
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenterManagement::V1::ListDescendantSecurityHealthAnalyticsCustomModulesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_descendant_security_health_analytics_custom_modules_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::ServiceStub.stub :transcode_list_descendant_security_health_analytics_custom_modules_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_descendant_security_health_analytics_custom_modules_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_descendant_security_health_analytics_custom_modules({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_descendant_security_health_analytics_custom_modules parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_descendant_security_health_analytics_custom_modules ::Google::Cloud::SecurityCenterManagement::V1::ListDescendantSecurityHealthAnalyticsCustomModulesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_descendant_security_health_analytics_custom_modules({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_descendant_security_health_analytics_custom_modules(::Google::Cloud::SecurityCenterManagement::V1::ListDescendantSecurityHealthAnalyticsCustomModulesRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_descendant_security_health_analytics_custom_modules_client_stub.call_count
      end
    end
  end

  def test_get_security_health_analytics_custom_module
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenterManagement::V1::SecurityHealthAnalyticsCustomModule.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_security_health_analytics_custom_module_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::ServiceStub.stub :transcode_get_security_health_analytics_custom_module_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_security_health_analytics_custom_module_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_security_health_analytics_custom_module({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_security_health_analytics_custom_module name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_security_health_analytics_custom_module ::Google::Cloud::SecurityCenterManagement::V1::GetSecurityHealthAnalyticsCustomModuleRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_security_health_analytics_custom_module({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_security_health_analytics_custom_module(::Google::Cloud::SecurityCenterManagement::V1::GetSecurityHealthAnalyticsCustomModuleRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_security_health_analytics_custom_module_client_stub.call_count
      end
    end
  end

  def test_create_security_health_analytics_custom_module
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenterManagement::V1::SecurityHealthAnalyticsCustomModule.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    security_health_analytics_custom_module = {}
    validate_only = true

    create_security_health_analytics_custom_module_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::ServiceStub.stub :transcode_create_security_health_analytics_custom_module_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_security_health_analytics_custom_module_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_security_health_analytics_custom_module({ parent: parent, security_health_analytics_custom_module: security_health_analytics_custom_module, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_security_health_analytics_custom_module parent: parent, security_health_analytics_custom_module: security_health_analytics_custom_module, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_security_health_analytics_custom_module ::Google::Cloud::SecurityCenterManagement::V1::CreateSecurityHealthAnalyticsCustomModuleRequest.new(parent: parent, security_health_analytics_custom_module: security_health_analytics_custom_module, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_security_health_analytics_custom_module({ parent: parent, security_health_analytics_custom_module: security_health_analytics_custom_module, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_security_health_analytics_custom_module(::Google::Cloud::SecurityCenterManagement::V1::CreateSecurityHealthAnalyticsCustomModuleRequest.new(parent: parent, security_health_analytics_custom_module: security_health_analytics_custom_module, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_security_health_analytics_custom_module_client_stub.call_count
      end
    end
  end

  def test_update_security_health_analytics_custom_module
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenterManagement::V1::SecurityHealthAnalyticsCustomModule.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    security_health_analytics_custom_module = {}
    validate_only = true

    update_security_health_analytics_custom_module_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::ServiceStub.stub :transcode_update_security_health_analytics_custom_module_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_security_health_analytics_custom_module_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_security_health_analytics_custom_module({ update_mask: update_mask, security_health_analytics_custom_module: security_health_analytics_custom_module, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_security_health_analytics_custom_module update_mask: update_mask, security_health_analytics_custom_module: security_health_analytics_custom_module, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_security_health_analytics_custom_module ::Google::Cloud::SecurityCenterManagement::V1::UpdateSecurityHealthAnalyticsCustomModuleRequest.new(update_mask: update_mask, security_health_analytics_custom_module: security_health_analytics_custom_module, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_security_health_analytics_custom_module({ update_mask: update_mask, security_health_analytics_custom_module: security_health_analytics_custom_module, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_security_health_analytics_custom_module(::Google::Cloud::SecurityCenterManagement::V1::UpdateSecurityHealthAnalyticsCustomModuleRequest.new(update_mask: update_mask, security_health_analytics_custom_module: security_health_analytics_custom_module, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_security_health_analytics_custom_module_client_stub.call_count
      end
    end
  end

  def test_delete_security_health_analytics_custom_module
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    validate_only = true

    delete_security_health_analytics_custom_module_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::ServiceStub.stub :transcode_delete_security_health_analytics_custom_module_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_security_health_analytics_custom_module_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_security_health_analytics_custom_module({ name: name, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_security_health_analytics_custom_module name: name, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_security_health_analytics_custom_module ::Google::Cloud::SecurityCenterManagement::V1::DeleteSecurityHealthAnalyticsCustomModuleRequest.new(name: name, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_security_health_analytics_custom_module({ name: name, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_security_health_analytics_custom_module(::Google::Cloud::SecurityCenterManagement::V1::DeleteSecurityHealthAnalyticsCustomModuleRequest.new(name: name, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_security_health_analytics_custom_module_client_stub.call_count
      end
    end
  end

  def test_simulate_security_health_analytics_custom_module
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenterManagement::V1::SimulateSecurityHealthAnalyticsCustomModuleResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    custom_config = {}
    resource = {}

    simulate_security_health_analytics_custom_module_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::ServiceStub.stub :transcode_simulate_security_health_analytics_custom_module_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, simulate_security_health_analytics_custom_module_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.simulate_security_health_analytics_custom_module({ parent: parent, custom_config: custom_config, resource: resource }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.simulate_security_health_analytics_custom_module parent: parent, custom_config: custom_config, resource: resource do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.simulate_security_health_analytics_custom_module ::Google::Cloud::SecurityCenterManagement::V1::SimulateSecurityHealthAnalyticsCustomModuleRequest.new(parent: parent, custom_config: custom_config, resource: resource) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.simulate_security_health_analytics_custom_module({ parent: parent, custom_config: custom_config, resource: resource }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.simulate_security_health_analytics_custom_module(::Google::Cloud::SecurityCenterManagement::V1::SimulateSecurityHealthAnalyticsCustomModuleRequest.new(parent: parent, custom_config: custom_config, resource: resource), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, simulate_security_health_analytics_custom_module_client_stub.call_count
      end
    end
  end

  def test_list_effective_event_threat_detection_custom_modules
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenterManagement::V1::ListEffectiveEventThreatDetectionCustomModulesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_effective_event_threat_detection_custom_modules_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::ServiceStub.stub :transcode_list_effective_event_threat_detection_custom_modules_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_effective_event_threat_detection_custom_modules_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_effective_event_threat_detection_custom_modules({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_effective_event_threat_detection_custom_modules parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_effective_event_threat_detection_custom_modules ::Google::Cloud::SecurityCenterManagement::V1::ListEffectiveEventThreatDetectionCustomModulesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_effective_event_threat_detection_custom_modules({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_effective_event_threat_detection_custom_modules(::Google::Cloud::SecurityCenterManagement::V1::ListEffectiveEventThreatDetectionCustomModulesRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_effective_event_threat_detection_custom_modules_client_stub.call_count
      end
    end
  end

  def test_get_effective_event_threat_detection_custom_module
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenterManagement::V1::EffectiveEventThreatDetectionCustomModule.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_effective_event_threat_detection_custom_module_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::ServiceStub.stub :transcode_get_effective_event_threat_detection_custom_module_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_effective_event_threat_detection_custom_module_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_effective_event_threat_detection_custom_module({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_effective_event_threat_detection_custom_module name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_effective_event_threat_detection_custom_module ::Google::Cloud::SecurityCenterManagement::V1::GetEffectiveEventThreatDetectionCustomModuleRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_effective_event_threat_detection_custom_module({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_effective_event_threat_detection_custom_module(::Google::Cloud::SecurityCenterManagement::V1::GetEffectiveEventThreatDetectionCustomModuleRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_effective_event_threat_detection_custom_module_client_stub.call_count
      end
    end
  end

  def test_list_event_threat_detection_custom_modules
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenterManagement::V1::ListEventThreatDetectionCustomModulesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_event_threat_detection_custom_modules_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::ServiceStub.stub :transcode_list_event_threat_detection_custom_modules_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_event_threat_detection_custom_modules_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_event_threat_detection_custom_modules({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_event_threat_detection_custom_modules parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_event_threat_detection_custom_modules ::Google::Cloud::SecurityCenterManagement::V1::ListEventThreatDetectionCustomModulesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_event_threat_detection_custom_modules({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_event_threat_detection_custom_modules(::Google::Cloud::SecurityCenterManagement::V1::ListEventThreatDetectionCustomModulesRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_event_threat_detection_custom_modules_client_stub.call_count
      end
    end
  end

  def test_list_descendant_event_threat_detection_custom_modules
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenterManagement::V1::ListDescendantEventThreatDetectionCustomModulesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_descendant_event_threat_detection_custom_modules_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::ServiceStub.stub :transcode_list_descendant_event_threat_detection_custom_modules_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_descendant_event_threat_detection_custom_modules_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_descendant_event_threat_detection_custom_modules({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_descendant_event_threat_detection_custom_modules parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_descendant_event_threat_detection_custom_modules ::Google::Cloud::SecurityCenterManagement::V1::ListDescendantEventThreatDetectionCustomModulesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_descendant_event_threat_detection_custom_modules({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_descendant_event_threat_detection_custom_modules(::Google::Cloud::SecurityCenterManagement::V1::ListDescendantEventThreatDetectionCustomModulesRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_descendant_event_threat_detection_custom_modules_client_stub.call_count
      end
    end
  end

  def test_get_event_threat_detection_custom_module
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenterManagement::V1::EventThreatDetectionCustomModule.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_event_threat_detection_custom_module_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::ServiceStub.stub :transcode_get_event_threat_detection_custom_module_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_event_threat_detection_custom_module_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_event_threat_detection_custom_module({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_event_threat_detection_custom_module name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_event_threat_detection_custom_module ::Google::Cloud::SecurityCenterManagement::V1::GetEventThreatDetectionCustomModuleRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_event_threat_detection_custom_module({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_event_threat_detection_custom_module(::Google::Cloud::SecurityCenterManagement::V1::GetEventThreatDetectionCustomModuleRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_event_threat_detection_custom_module_client_stub.call_count
      end
    end
  end

  def test_create_event_threat_detection_custom_module
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenterManagement::V1::EventThreatDetectionCustomModule.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    event_threat_detection_custom_module = {}
    validate_only = true

    create_event_threat_detection_custom_module_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::ServiceStub.stub :transcode_create_event_threat_detection_custom_module_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_event_threat_detection_custom_module_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_event_threat_detection_custom_module({ parent: parent, event_threat_detection_custom_module: event_threat_detection_custom_module, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_event_threat_detection_custom_module parent: parent, event_threat_detection_custom_module: event_threat_detection_custom_module, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_event_threat_detection_custom_module ::Google::Cloud::SecurityCenterManagement::V1::CreateEventThreatDetectionCustomModuleRequest.new(parent: parent, event_threat_detection_custom_module: event_threat_detection_custom_module, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_event_threat_detection_custom_module({ parent: parent, event_threat_detection_custom_module: event_threat_detection_custom_module, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_event_threat_detection_custom_module(::Google::Cloud::SecurityCenterManagement::V1::CreateEventThreatDetectionCustomModuleRequest.new(parent: parent, event_threat_detection_custom_module: event_threat_detection_custom_module, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_event_threat_detection_custom_module_client_stub.call_count
      end
    end
  end

  def test_update_event_threat_detection_custom_module
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenterManagement::V1::EventThreatDetectionCustomModule.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    event_threat_detection_custom_module = {}
    validate_only = true

    update_event_threat_detection_custom_module_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::ServiceStub.stub :transcode_update_event_threat_detection_custom_module_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_event_threat_detection_custom_module_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_event_threat_detection_custom_module({ update_mask: update_mask, event_threat_detection_custom_module: event_threat_detection_custom_module, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_event_threat_detection_custom_module update_mask: update_mask, event_threat_detection_custom_module: event_threat_detection_custom_module, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_event_threat_detection_custom_module ::Google::Cloud::SecurityCenterManagement::V1::UpdateEventThreatDetectionCustomModuleRequest.new(update_mask: update_mask, event_threat_detection_custom_module: event_threat_detection_custom_module, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_event_threat_detection_custom_module({ update_mask: update_mask, event_threat_detection_custom_module: event_threat_detection_custom_module, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_event_threat_detection_custom_module(::Google::Cloud::SecurityCenterManagement::V1::UpdateEventThreatDetectionCustomModuleRequest.new(update_mask: update_mask, event_threat_detection_custom_module: event_threat_detection_custom_module, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_event_threat_detection_custom_module_client_stub.call_count
      end
    end
  end

  def test_delete_event_threat_detection_custom_module
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    validate_only = true

    delete_event_threat_detection_custom_module_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::ServiceStub.stub :transcode_delete_event_threat_detection_custom_module_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_event_threat_detection_custom_module_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_event_threat_detection_custom_module({ name: name, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_event_threat_detection_custom_module name: name, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_event_threat_detection_custom_module ::Google::Cloud::SecurityCenterManagement::V1::DeleteEventThreatDetectionCustomModuleRequest.new(name: name, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_event_threat_detection_custom_module({ name: name, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_event_threat_detection_custom_module(::Google::Cloud::SecurityCenterManagement::V1::DeleteEventThreatDetectionCustomModuleRequest.new(name: name, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_event_threat_detection_custom_module_client_stub.call_count
      end
    end
  end

  def test_validate_event_threat_detection_custom_module
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenterManagement::V1::ValidateEventThreatDetectionCustomModuleResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    raw_text = "hello world"
    type = "hello world"

    validate_event_threat_detection_custom_module_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::ServiceStub.stub :transcode_validate_event_threat_detection_custom_module_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, validate_event_threat_detection_custom_module_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.validate_event_threat_detection_custom_module({ parent: parent, raw_text: raw_text, type: type }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.validate_event_threat_detection_custom_module parent: parent, raw_text: raw_text, type: type do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.validate_event_threat_detection_custom_module ::Google::Cloud::SecurityCenterManagement::V1::ValidateEventThreatDetectionCustomModuleRequest.new(parent: parent, raw_text: raw_text, type: type) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.validate_event_threat_detection_custom_module({ parent: parent, raw_text: raw_text, type: type }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.validate_event_threat_detection_custom_module(::Google::Cloud::SecurityCenterManagement::V1::ValidateEventThreatDetectionCustomModuleRequest.new(parent: parent, raw_text: raw_text, type: type), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, validate_event_threat_detection_custom_module_client_stub.call_count
      end
    end
  end

  def test_get_security_center_service
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterService.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    show_eligible_modules_only = true

    get_security_center_service_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::ServiceStub.stub :transcode_get_security_center_service_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_security_center_service_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_security_center_service({ name: name, show_eligible_modules_only: show_eligible_modules_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_security_center_service name: name, show_eligible_modules_only: show_eligible_modules_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_security_center_service ::Google::Cloud::SecurityCenterManagement::V1::GetSecurityCenterServiceRequest.new(name: name, show_eligible_modules_only: show_eligible_modules_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_security_center_service({ name: name, show_eligible_modules_only: show_eligible_modules_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_security_center_service(::Google::Cloud::SecurityCenterManagement::V1::GetSecurityCenterServiceRequest.new(name: name, show_eligible_modules_only: show_eligible_modules_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_security_center_service_client_stub.call_count
      end
    end
  end

  def test_list_security_center_services
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenterManagement::V1::ListSecurityCenterServicesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    show_eligible_modules_only = true

    list_security_center_services_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::ServiceStub.stub :transcode_list_security_center_services_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_security_center_services_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_security_center_services({ parent: parent, page_size: page_size, page_token: page_token, show_eligible_modules_only: show_eligible_modules_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_security_center_services parent: parent, page_size: page_size, page_token: page_token, show_eligible_modules_only: show_eligible_modules_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_security_center_services ::Google::Cloud::SecurityCenterManagement::V1::ListSecurityCenterServicesRequest.new(parent: parent, page_size: page_size, page_token: page_token, show_eligible_modules_only: show_eligible_modules_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_security_center_services({ parent: parent, page_size: page_size, page_token: page_token, show_eligible_modules_only: show_eligible_modules_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_security_center_services(::Google::Cloud::SecurityCenterManagement::V1::ListSecurityCenterServicesRequest.new(parent: parent, page_size: page_size, page_token: page_token, show_eligible_modules_only: show_eligible_modules_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_security_center_services_client_stub.call_count
      end
    end
  end

  def test_update_security_center_service
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterService.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    security_center_service = {}
    update_mask = {}
    validate_only = true

    update_security_center_service_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::ServiceStub.stub :transcode_update_security_center_service_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_security_center_service_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_security_center_service({ security_center_service: security_center_service, update_mask: update_mask, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_security_center_service security_center_service: security_center_service, update_mask: update_mask, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_security_center_service ::Google::Cloud::SecurityCenterManagement::V1::UpdateSecurityCenterServiceRequest.new(security_center_service: security_center_service, update_mask: update_mask, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_security_center_service({ security_center_service: security_center_service, update_mask: update_mask, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_security_center_service(::Google::Cloud::SecurityCenterManagement::V1::UpdateSecurityCenterServiceRequest.new(security_center_service: security_center_service, update_mask: update_mask, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_security_center_service_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Rest::Client::Configuration, config
  end
end
