# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/security_center_management/v1/security_center_management"

class ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::ClientPathsTest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end
  
    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_effective_event_threat_detection_custom_module_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.effective_event_threat_detection_custom_module_path organization: "value0", location: "value1", effective_event_threat_detection_custom_module: "value2"
      assert_equal "organizations/value0/locations/value1/effectiveEventThreatDetectionCustomModules/value2", path

      path = client.effective_event_threat_detection_custom_module_path project: "value0", location: "value1", effective_event_threat_detection_custom_module: "value2"
      assert_equal "projects/value0/locations/value1/effectiveEventThreatDetectionCustomModules/value2", path

      path = client.effective_event_threat_detection_custom_module_path folder: "value0", location: "value1", effective_event_threat_detection_custom_module: "value2"
      assert_equal "folders/value0/locations/value1/effectiveEventThreatDetectionCustomModules/value2", path
    end
  end

  def test_effective_security_health_analytics_custom_module_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.effective_security_health_analytics_custom_module_path organization: "value0", location: "value1", effective_security_health_analytics_custom_module: "value2"
      assert_equal "organizations/value0/locations/value1/effectiveSecurityHealthAnalyticsCustomModules/value2", path

      path = client.effective_security_health_analytics_custom_module_path project: "value0", location: "value1", effective_security_health_analytics_custom_module: "value2"
      assert_equal "projects/value0/locations/value1/effectiveSecurityHealthAnalyticsCustomModules/value2", path

      path = client.effective_security_health_analytics_custom_module_path folder: "value0", location: "value1", effective_security_health_analytics_custom_module: "value2"
      assert_equal "folders/value0/locations/value1/effectiveSecurityHealthAnalyticsCustomModules/value2", path
    end
  end

  def test_event_threat_detection_custom_module_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.event_threat_detection_custom_module_path organization: "value0", location: "value1", event_threat_detection_custom_module: "value2"
      assert_equal "organizations/value0/locations/value1/eventThreatDetectionCustomModules/value2", path

      path = client.event_threat_detection_custom_module_path project: "value0", location: "value1", event_threat_detection_custom_module: "value2"
      assert_equal "projects/value0/locations/value1/eventThreatDetectionCustomModules/value2", path

      path = client.event_threat_detection_custom_module_path folder: "value0", location: "value1", event_threat_detection_custom_module: "value2"
      assert_equal "folders/value0/locations/value1/eventThreatDetectionCustomModules/value2", path
    end
  end

  def test_folder_location_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.folder_location_path folder: "value0", location: "value1"
      assert_equal "folders/value0/locations/value1", path
    end
  end

  def test_location_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.location_path project: "value0", location: "value1"
      assert_equal "projects/value0/locations/value1", path
    end
  end

  def test_organization_location_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.organization_location_path organization: "value0", location: "value1"
      assert_equal "organizations/value0/locations/value1", path
    end
  end

  def test_security_center_service_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.security_center_service_path project: "value0", location: "value1", service: "value2"
      assert_equal "projects/value0/locations/value1/securityCenterServices/value2", path

      path = client.security_center_service_path folder: "value0", location: "value1", service: "value2"
      assert_equal "folders/value0/locations/value1/securityCenterServices/value2", path

      path = client.security_center_service_path organization: "value0", location: "value1", service: "value2"
      assert_equal "organizations/value0/locations/value1/securityCenterServices/value2", path
    end
  end

  def test_security_health_analytics_custom_module_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.security_health_analytics_custom_module_path organization: "value0", location: "value1", security_health_analytics_custom_module: "value2"
      assert_equal "organizations/value0/locations/value1/securityHealthAnalyticsCustomModules/value2", path

      path = client.security_health_analytics_custom_module_path project: "value0", location: "value1", security_health_analytics_custom_module: "value2"
      assert_equal "projects/value0/locations/value1/securityHealthAnalyticsCustomModules/value2", path

      path = client.security_health_analytics_custom_module_path folder: "value0", location: "value1", security_health_analytics_custom_module: "value2"
      assert_equal "folders/value0/locations/value1/securityHealthAnalyticsCustomModules/value2", path
    end
  end
end
