# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module SecurityCenterManagement
      module V1
        # Represents a particular Security Command Center service. This includes
        # settings information such as top-level enablement in addition to individual
        # module settings. Service settings can be configured at the organization,
        # folder, or project level. Service settings at the organization or folder
        # level are inherited by those in descendant folders and projects.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the service, in one of the following formats:
        #
        #     * `organizations/{organization}/locations/{location}/securityCenterServices/{service}`
        #     * `folders/{folder}/locations/{location}/securityCenterServices/{service}`
        #     * `projects/{project}/locations/{location}/securityCenterServices/{service}`
        #
        #     The following values are valid for `{service}`:
        #
        #     * `container-threat-detection`
        #     * `event-threat-detection`
        #     * `security-health-analytics`
        #     * `vm-threat-detection`
        #     * `web-security-scanner`
        # @!attribute [rw] intended_enablement_state
        #   @return [::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterService::EnablementState]
        #     Optional. The intended enablement state for the service at its level of the
        #     resource hierarchy. A `DISABLED` state will override all module enablement
        #     states to `DISABLED`.
        # @!attribute [r] effective_enablement_state
        #   @return [::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterService::EnablementState]
        #     Output only. The effective enablement state for the service at its level of
        #     the resource hierarchy. If the intended state is set to `INHERITED`, the
        #     effective state will be inherited from the enablement state of an ancestor.
        #     This state may differ from the intended enablement state due to billing
        #     eligibility or onboarding status.
        # @!attribute [rw] modules
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterService::ModuleSettings}]
        #     Optional. The module configurations, including the enablement state for the
        #     service's modules. The absence of a module in the map implies that its
        #     configuration is inherited from its parents.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the service was last updated. This could be due to an
        #     explicit user update or due to a side effect of another system change, such
        #     as billing subscription expiry.
        # @!attribute [rw] service_config
        #   @return [::Google::Protobuf::Struct]
        #     Optional. Additional service-specific configuration. Not all services will
        #     utilize this field.
        class SecurityCenterService
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The settings for individual modules.
          # @!attribute [rw] intended_enablement_state
          #   @return [::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterService::EnablementState]
          #     Optional. The intended enablement state for the module at its level of
          #     the resource hierarchy.
          # @!attribute [r] effective_enablement_state
          #   @return [::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterService::EnablementState]
          #     Output only. The effective enablement state for the module at its level
          #     of the resource hierarchy. If the intended state is set to `INHERITED`,
          #     the effective state will be inherited from the enablement state of an
          #     ancestor. This state may differ from the intended enablement state due to
          #     billing eligibility or onboarding status.
          class ModuleSettings
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterService::ModuleSettings]
          class ModulesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Represents the possible enablement states for a service or module.
          module EnablementState
            # Default value. This value is unused.
            ENABLEMENT_STATE_UNSPECIFIED = 0

            # State is inherited from the parent resource. Valid as an intended
            # enablement state, but not as an effective enablement state.
            INHERITED = 1

            # State is enabled.
            ENABLED = 2

            # State is disabled.
            DISABLED = 3

            # Security Command Center is configured to ingest findings from this
            # service, but not to enable this service. This state indicates that
            # Security Command Center is misconfigured. You can't set this state
            # yourself.
            INGEST_ONLY = 4
          end
        end

        # The representation of a Security Health Analytics custom module at a
        # specified level of the resource hierarchy: organization, folder, or project.
        # If a custom module is inherited from an ancestor organization or folder, then
        # the enablement state is set to the value that is effective in the parent, not
        # to `INHERITED`. For example, if the module is enabled in an organization or
        # folder, then the effective enablement state for the module is `ENABLED` in
        # all descendant folders or projects.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The full resource name of the custom module, in one of the
        #     following formats:
        #
        #     * `organizations/organization/{location}/effectiveSecurityHealthAnalyticsCustomModules/{custom_module}`
        #     * `folders/folder/{location}/effectiveSecurityHealthAnalyticsCustomModules/{custom_module}`
        #     * `projects/project/{location}/effectiveSecurityHealthAnalyticsCustomModules/{custom_module}`
        # @!attribute [r] custom_config
        #   @return [::Google::Cloud::SecurityCenterManagement::V1::CustomConfig]
        #     Output only. The user-specified configuration for the module.
        # @!attribute [r] enablement_state
        #   @return [::Google::Cloud::SecurityCenterManagement::V1::EffectiveSecurityHealthAnalyticsCustomModule::EnablementState]
        #     Output only. The effective enablement state for the module at the given
        #     level of the hierarchy.
        # @!attribute [r] display_name
        #   @return [::String]
        #     Output only. The display name for the custom module. The name must be
        #     between 1 and 128 characters, start with a lowercase letter, and contain
        #     alphanumeric characters or underscores only.
        class EffectiveSecurityHealthAnalyticsCustomModule
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The enablement state of the module.
          module EnablementState
            # Default value. This value is unused.
            ENABLEMENT_STATE_UNSPECIFIED = 0

            # The module is enabled at the given level.
            ENABLED = 1

            # The module is disabled at the given level.
            DISABLED = 2
          end
        end

        # Request message for
        # {::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client#list_effective_security_health_analytics_custom_modules SecurityCenterManagement.ListEffectiveSecurityHealthAnalyticsCustomModules}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Name of parent to list effective custom modules, in one of the
        #     following formats:
        #
        #     * `organizations/{organization}/locations/{location}`
        #     * `folders/{folder}/locations/{location}`
        #     * `projects/{project}/locations/{location}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of results to return in a single response.
        #     Default is 10, minimum is 1, maximum is 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A pagination token returned from a previous request. Provide this
        #     token to retrieve the next page of results.
        #
        #     When paginating, the rest of the request must match the request that
        #     generated the page token.
        class ListEffectiveSecurityHealthAnalyticsCustomModulesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client#list_effective_security_health_analytics_custom_modules SecurityCenterManagement.ListEffectiveSecurityHealthAnalyticsCustomModules}.
        # @!attribute [rw] effective_security_health_analytics_custom_modules
        #   @return [::Array<::Google::Cloud::SecurityCenterManagement::V1::EffectiveSecurityHealthAnalyticsCustomModule>]
        #     The list of effective Security Health Analytics custom modules.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A pagination token. To retrieve the next page of results, call the method
        #     again with this token.
        class ListEffectiveSecurityHealthAnalyticsCustomModulesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client#get_effective_security_health_analytics_custom_module SecurityCenterManagement.GetEffectiveSecurityHealthAnalyticsCustomModule}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The full resource name of the custom module, specified in one of
        #     the following formats:
        #
        #     * `organizations/organization/{location}/effectiveSecurityHealthAnalyticsCustomModules/{custom_module}`
        #     * `folders/folder/{location}/effectiveSecurityHealthAnalyticsCustomModules/{custom_module}`
        #     * `projects/project/{location}/effectiveSecurityHealthAnalyticsCustomModules/{custom_module}`
        class GetEffectiveSecurityHealthAnalyticsCustomModuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents an instance of a Security Health Analytics custom module,
        # including its full module name, display name, enablement state, and last
        # updated time. You can create a custom module at the organization, folder, or
        # project level. Custom modules that you create at the organization or folder
        # level are inherited by the descendant folders and projects.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The full resource name of the custom module, in one of the
        #     following formats:
        #
        #     * `organizations/{organization}/locations/{location}/securityHealthAnalyticsCustomModules/{custom_module}`
        #     * `folders/{folder}/locations/{location}/securityHealthAnalyticsCustomModules/{custom_module}`
        #     * `projects/{project}/locations/{location}/securityHealthAnalyticsCustomModules/{custom_module}`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. The display name of the Security Health Analytics custom module.
        #     This display name becomes the finding category for all findings that are
        #     returned by this custom module. The display name must be between 1 and 128
        #     characters, start with a lowercase letter, and contain alphanumeric
        #     characters or underscores only.
        # @!attribute [rw] enablement_state
        #   @return [::Google::Cloud::SecurityCenterManagement::V1::SecurityHealthAnalyticsCustomModule::EnablementState]
        #     Optional. The enablement state of the custom module.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which the custom module was last updated.
        # @!attribute [r] last_editor
        #   @return [::String]
        #     Output only. The editor that last updated the custom module.
        # @!attribute [r] ancestor_module
        #   @return [::String]
        #     Output only. Specifies the organization or folder from which the custom
        #     module is inherited. If empty, indicates that the custom module was created
        #     in the organization, folder, or project in which you are viewing the custom
        #     module.
        # @!attribute [rw] custom_config
        #   @return [::Google::Cloud::SecurityCenterManagement::V1::CustomConfig]
        #     Optional. The user-specified custom configuration for the module.
        class SecurityHealthAnalyticsCustomModule
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Possible enablement states of a custom module.
          module EnablementState
            # Default value. This value is unused.
            ENABLEMENT_STATE_UNSPECIFIED = 0

            # The module is enabled at the given organization, folder, or project.
            ENABLED = 1

            # The module is disabled at the given organization, folder, or project.
            DISABLED = 2

            # State is inherited from an ancestor module. The module will either
            # be effectively `ENABLED` or `DISABLED` based on its closest non-inherited
            # ancestor module in the resource hierarchy. If you try to set a top-level
            # module (a module with no parent) to the `INHERITED` state, you receive an
            # `INVALID_ARGUMENT` error.
            INHERITED = 3
          end
        end

        # Defines the properties in a custom module configuration for Security
        # Health Analytics. Use the custom module configuration to create custom
        # detectors that generate custom findings for resources that you specify.
        # @!attribute [rw] predicate
        #   @return [::Google::Type::Expr]
        #     Optional. The Common Expression Language (CEL) expression to evaluate to
        #     produce findings. When the expression evaluates to `true` against a
        #     resource, a finding is generated.
        # @!attribute [rw] custom_output
        #   @return [::Google::Cloud::SecurityCenterManagement::V1::CustomConfig::CustomOutputSpec]
        #     Optional. Custom output properties.
        # @!attribute [rw] resource_selector
        #   @return [::Google::Cloud::SecurityCenterManagement::V1::CustomConfig::ResourceSelector]
        #     Optional. The Cloud Asset Inventory resource types that the custom module
        #     operates on. For information about resource types, see [Supported asset
        #     types](https://cloud.google.com/asset-inventory/docs/supported-asset-types).
        #     Each custom module can specify up to 5 resource types.
        # @!attribute [rw] severity
        #   @return [::Google::Cloud::SecurityCenterManagement::V1::CustomConfig::Severity]
        #     Optional. The severity to assign to findings generated by the module.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Text that describes the vulnerability or misconfiguration that
        #     the custom module detects. This explanation is returned with each finding
        #     instance to help investigators understand the detected issue. The text must
        #     be enclosed in quotation marks.
        # @!attribute [rw] recommendation
        #   @return [::String]
        #     Optional. An explanation of the recommended steps that security teams can
        #     take to resolve the detected issue. This explanation is returned with each
        #     finding generated by this module.
        class CustomConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A set of optional name-value pairs that define custom source properties to
          # return with each finding that is generated by the custom module. The custom
          # source properties that are defined here are included in the finding.
          # @!attribute [rw] properties
          #   @return [::Array<::Google::Cloud::SecurityCenterManagement::V1::CustomConfig::CustomOutputSpec::Property>]
          #     Optional. A list of custom output properties to add to the finding.
          class CustomOutputSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # An individual name-value pair that defines a custom source property.
            # @!attribute [rw] name
            #   @return [::String]
            #     Optional. Name of the property for the custom output.
            # @!attribute [rw] value_expression
            #   @return [::Google::Type::Expr]
            #     Optional. The CEL expression for the custom output. A resource property
            #     can be specified to return the value of the property or a text string
            #     enclosed in quotation marks.
            class Property
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Resource for selecting resource type.
          # @!attribute [rw] resource_types
          #   @return [::Array<::String>]
          #     Optional. The resource types to run the detector on.
          class ResourceSelector
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Defines the valid value options for the severity of a finding.
          module Severity
            # Default value. This value is unused.
            SEVERITY_UNSPECIFIED = 0

            # Critical severity.
            CRITICAL = 1

            # High severity.
            HIGH = 2

            # Medium severity.
            MEDIUM = 3

            # Low severity.
            LOW = 4
          end
        end

        # Request message for
        # {::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client#list_security_health_analytics_custom_modules SecurityCenterManagement.ListSecurityHealthAnalyticsCustomModules}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Name of the parent organization, folder, or project in which to
        #     list custom modules, in one of the following formats:
        #
        #     * `organizations/{organization}/locations/{location}`
        #     * `folders/{folder}/locations/{location}`
        #     * `projects/{project}/locations/{location}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of results to return in a single response.
        #     Default is 10, minimum is 1, maximum is 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A pagination token returned from a previous request. Provide this
        #     token to retrieve the next page of results.
        #
        #     When paginating, the rest of the request must match the request that
        #     generated the page token.
        class ListSecurityHealthAnalyticsCustomModulesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client#list_security_health_analytics_custom_modules SecurityCenterManagement.ListSecurityHealthAnalyticsCustomModules}.
        # @!attribute [rw] security_health_analytics_custom_modules
        #   @return [::Array<::Google::Cloud::SecurityCenterManagement::V1::SecurityHealthAnalyticsCustomModule>]
        #     The list of Security Health Analytics custom modules.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A pagination token. To retrieve the next page of results, call the method
        #     again with this token.
        class ListSecurityHealthAnalyticsCustomModulesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client#list_descendant_security_health_analytics_custom_modules SecurityCenterManagement.ListDescendantSecurityHealthAnalyticsCustomModules}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Name of the parent organization, folder, or project in which to
        #     list custom modules, in one of the following formats:
        #
        #     * `organizations/{organization}/locations/{location}`
        #     * `folders/{folder}/locations/{location}`
        #     * `projects/{project}/locations/{location}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of results to return in a single response.
        #     Default is 10, minimum is 1, maximum is 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A pagination token returned from a previous request. Provide this
        #     token to retrieve the next page of results.
        #
        #     When paginating, the rest of the request must match the request that
        #     generated the page token.
        class ListDescendantSecurityHealthAnalyticsCustomModulesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client#list_descendant_security_health_analytics_custom_modules SecurityCenterManagement.ListDescendantSecurityHealthAnalyticsCustomModules}.
        # @!attribute [rw] security_health_analytics_custom_modules
        #   @return [::Array<::Google::Cloud::SecurityCenterManagement::V1::SecurityHealthAnalyticsCustomModule>]
        #     The list of SecurityHealthAnalyticsCustomModules
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A pagination token. To retrieve the next page of results, call the method
        #     again with this token.
        class ListDescendantSecurityHealthAnalyticsCustomModulesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client#get_security_health_analytics_custom_module SecurityCenterManagement.GetSecurityHealthAnalyticsCustomModule}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource, in the format
        #     `projects/{project}/locations/{location}/securityHealthAnalyticsCustomModules/{custom_module}`.
        class GetSecurityHealthAnalyticsCustomModuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client#create_security_health_analytics_custom_module SecurityCenterManagement.CreateSecurityHealthAnalyticsCustomModule}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Name of the parent organization, folder, or project of the
        #     module, in one of the following formats:
        #
        #     * `organizations/{organization}/locations/{location}`
        #     * `folders/{folder}/locations/{location}`
        #     * `projects/{project}/locations/{location}`
        # @!attribute [rw] security_health_analytics_custom_module
        #   @return [::Google::Cloud::SecurityCenterManagement::V1::SecurityHealthAnalyticsCustomModule]
        #     Required. The resource being created.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. When set to `true`, the request will be validated (including IAM
        #     checks), but no module will be created. An `OK` response indicates that the
        #     request is valid, while an error response indicates that the request is
        #     invalid.
        #
        #     If the request is valid, a subsequent request to create the module could
        #     still fail for one of the following reasons:
        #
        #     *  The state of your cloud resources changed; for example, you lost a
        #        required IAM permission
        #     *  An error occurred during creation of the module
        #
        #     Defaults to `false`.
        class CreateSecurityHealthAnalyticsCustomModuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client#update_security_health_analytics_custom_module SecurityCenterManagement.UpdateSecurityHealthAnalyticsCustomModule}.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The fields to update. The following values are valid:
        #
        #     * `custom_config`
        #     * `enablement_state`
        #
        #     If you omit this field or set it to the wildcard value `*`, then all
        #     eligible fields are updated.
        # @!attribute [rw] security_health_analytics_custom_module
        #   @return [::Google::Cloud::SecurityCenterManagement::V1::SecurityHealthAnalyticsCustomModule]
        #     Required. The resource being updated.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. When set to `true`, the request will be validated (including IAM
        #     checks), but no module will be updated. An `OK` response indicates that the
        #     request is valid, while an error response indicates that the request is
        #     invalid.
        #
        #     If the request is valid, a subsequent request to update the module could
        #     still fail for one of the following reasons:
        #
        #     *  The state of your cloud resources changed; for example, you lost a
        #        required IAM permission
        #     *  An error occurred during creation of the module
        #
        #     Defaults to `false`.
        class UpdateSecurityHealthAnalyticsCustomModuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client#delete_security_health_analytics_custom_module SecurityCenterManagement.DeleteSecurityHealthAnalyticsCustomModule}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the SHA custom module, in one of the
        #     following formats:
        #
        #       * `organizations/{organization}/locations/{location}/securityHealthAnalyticsCustomModules/{custom_module}`
        #       * `folders/{folder}/locations/{location}/securityHealthAnalyticsCustomModules/{custom_module}`
        #       * `projects/{project}/locations/{location}/securityHealthAnalyticsCustomModules/{custom_module}`
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. When set to `true`, the request will be validated (including IAM
        #     checks), but no module will be deleted. An `OK` response indicates that the
        #     request is valid, while an error response indicates that the request is
        #     invalid.
        #
        #     If the request is valid, a subsequent request to delete the module could
        #     still fail for one of the following reasons:
        #
        #     *  The state of your cloud resources changed; for example, you lost a
        #        required IAM permission
        #     *  An error occurred during deletion of the module
        #
        #     Defaults to `false`.
        class DeleteSecurityHealthAnalyticsCustomModuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client#simulate_security_health_analytics_custom_module SecurityCenterManagement.SimulateSecurityHealthAnalyticsCustomModule}.
        # The maximum size of the request is 4 MiB.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The relative resource name of the organization, project, or
        #     folder. For more information about relative resource names, see [AIP-122:
        #     Resource names](https://google.aip.dev/122). Example:
        #     `organizations/{organization_id}`.
        # @!attribute [rw] custom_config
        #   @return [::Google::Cloud::SecurityCenterManagement::V1::CustomConfig]
        #     Required. The custom configuration that you need to test.
        # @!attribute [rw] resource
        #   @return [::Google::Cloud::SecurityCenterManagement::V1::SimulateSecurityHealthAnalyticsCustomModuleRequest::SimulatedResource]
        #     Required. Resource data to simulate custom module against.
        class SimulateSecurityHealthAnalyticsCustomModuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Manually constructed information about a resource.
          # @!attribute [rw] resource_type
          #   @return [::String]
          #     Required. The type of the resource. For example,
          #     `compute.googleapis.com/Disk`.
          # @!attribute [rw] resource_data
          #   @return [::Google::Protobuf::Struct]
          #     Optional. A representation of the Google Cloud resource. Should match the
          #     Google Cloud resource JSON format.
          #
          #     If the custom module evaluates only the IAM allow policy, then you can
          #     omit this field.
          # @!attribute [rw] iam_policy_data
          #   @return [::Google::Iam::V1::Policy]
          #     Optional. A representation of the IAM allow policy.
          #
          #     If the custom module evaluates only the resource data, then you can omit
          #     this field.
          class SimulatedResource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The minimum set of fields needed to represent a simulated finding from a
        # Security Health Analytics custom module.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The [relative resource name](https://google.aip.dev/122) of the
        #     finding, in one of the following formats:
        #
        #     * `organizations/{organization_id}/sources/{source_id}/findings/{finding_id}`
        #     * `folders/{folder_id}/sources/{source_id}/findings/{finding_id}`
        #     * `projects/{project_id}/sources/{source_id}/findings/{finding_id}`
        # @!attribute [rw] parent
        #   @return [::String]
        #     The [relative resource name](https://google.aip.dev/122) of the source the
        #     finding belongs to. For example,
        #     `organizations/{organization_id}/sources/{source_id}`. This field is
        #     immutable after creation time.
        # @!attribute [rw] resource_name
        #   @return [::String]
        #     For findings on Google Cloud resources, the
        #     [full resource name](https://google.aip.dev/122#full-resource-names) of the
        #     Google Cloud resource this finding is for. When the finding is for a
        #     non-Google Cloud resource, the value can be a customer or partner defined
        #     string. This field is immutable after creation time.
        # @!attribute [rw] category
        #   @return [::String]
        #     The additional taxonomy group within findings from a given source. For
        #     example, `XSS_FLASH_INJECTION`. This field is immutable after creation
        #     time.
        # @!attribute [r] state
        #   @return [::Google::Cloud::SecurityCenterManagement::V1::SimulatedFinding::State]
        #     Output only. The state of the finding.
        # @!attribute [rw] source_properties
        #   @return [::Google::Protobuf::Map{::String => ::Google::Protobuf::Value}]
        #     Source-specific properties. These properties are managed by the source
        #     that writes the finding. The key names must be between 1 and 255
        #     characters; they must start with a letter and contain alphanumeric
        #     characters or underscores only.
        # @!attribute [rw] event_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time the finding was first detected. If an existing finding is updated,
        #     then this is the time the update occurred. If the finding is later
        #     resolved, then this time reflects when the finding was resolved.
        #
        #     For example, if the finding represents an open firewall, this property
        #     captures the time the detector believes the firewall became open. The
        #     accuracy is determined by the detector.
        #
        #     The event time must not be set to a value greater than the current
        #     timestamp.
        # @!attribute [rw] severity
        #   @return [::Google::Cloud::SecurityCenterManagement::V1::SimulatedFinding::Severity]
        #     The severity of the finding. This field is managed by the source that
        #     writes the finding.
        # @!attribute [rw] finding_class
        #   @return [::Google::Cloud::SecurityCenterManagement::V1::SimulatedFinding::FindingClass]
        #     The class of the finding.
        class SimulatedFinding
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Protobuf::Value]
          class SourcePropertiesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The state of the finding.
          module State
            # Default value. This value is unused.
            STATE_UNSPECIFIED = 0

            # The finding requires attention and has not been addressed yet.
            ACTIVE = 1

            # The finding has been fixed, triaged as a non-issue, or otherwise
            # addressed and is no longer active.
            INACTIVE = 2
          end

          # The severity of the finding.
          module Severity
            # Default value. This value is unused.
            SEVERITY_UNSPECIFIED = 0

            # For vulnerabilities: A critical vulnerability is easily discoverable by
            # an external actor, exploitable, and results in the direct ability to
            # execute arbitrary code, exfiltrate data, and otherwise gain additional
            # access and privileges to cloud resources and workloads. Examples include
            # publicly accessible unprotected user data and public SSH access with weak
            # or no passwords.
            #
            # For threats: Indicates a threat that is able to access, modify, or delete
            # data or execute unauthorized code within existing resources.
            CRITICAL = 1

            # For vulnerabilities: A high-risk vulnerability can be easily discovered
            # and exploited in combination with other vulnerabilities in order to gain
            # direct access and the ability to execute arbitrary code, exfiltrate data,
            # and otherwise gain additional access and privileges to cloud resources
            # and workloads. An example is a database with weak or no passwords that is
            # only accessible internally. This database could easily be compromised by
            # an actor that had access to the internal network.
            #
            # For threats: Indicates a threat that is able to create new computational
            # resources in an environment but not able to access data or execute code
            # in existing resources.
            HIGH = 2

            # For vulnerabilities: A medium-risk vulnerability could be used by an
            # actor to gain access to resources or privileges that enable them to
            # eventually (through multiple steps or a complex exploit) gain access and
            # the ability to execute arbitrary code or exfiltrate data. An example is a
            # service account with access to more projects than it should have. If an
            # actor gains access to the service account, they could potentially use
            # that access to manipulate a project the service account was not intended
            # to.
            #
            # For threats: Indicates a threat that is able to cause operational impact
            # but may not access data or execute unauthorized code.
            MEDIUM = 3

            # For vulnerabilities: A low-risk vulnerability hampers a security
            # organization's ability to detect vulnerabilities or active threats in
            # their deployment, or prevents the root cause investigation of security
            # issues. An example is monitoring and logs being disabled for resource
            # configurations and access.
            #
            # For threats: Indicates a threat that has obtained minimal access to an
            # environment but is not able to access data, execute code, or create
            # resources.
            LOW = 4
          end

          # Represents what kind of finding it is.
          module FindingClass
            # Default value. This value is unused.
            FINDING_CLASS_UNSPECIFIED = 0

            # Describes unwanted or malicious activity.
            THREAT = 1

            # Describes a potential weakness in software that increases risk to
            # confidentiality, integrity, and availability.
            VULNERABILITY = 2

            # Describes a potential weakness in cloud resource or asset configuration
            # that increases risk.
            MISCONFIGURATION = 3

            # Describes a security observation that is for informational purposes.
            OBSERVATION = 4

            # Describes an error that prevents Security Command Center from working
            # correctly.
            SCC_ERROR = 5

            # Describes a potential security risk due to a change in the security
            # posture.
            POSTURE_VIOLATION = 6

            # Describes a combination of security issues that represent a more severe
            # security problem when taken together.
            TOXIC_COMBINATION = 7
          end
        end

        # Response message for
        # {::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client#simulate_security_health_analytics_custom_module SecurityCenterManagement.SimulateSecurityHealthAnalyticsCustomModule}.
        # @!attribute [rw] result
        #   @return [::Google::Cloud::SecurityCenterManagement::V1::SimulateSecurityHealthAnalyticsCustomModuleResponse::SimulatedResult]
        #     Result for test case in the corresponding request.
        class SimulateSecurityHealthAnalyticsCustomModuleResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Possible test result.
          # @!attribute [rw] finding
          #   @return [::Google::Cloud::SecurityCenterManagement::V1::SimulatedFinding]
          #     Finding that would be published for the test case if a violation is
          #     detected.
          #
          #     Note: The following fields are mutually exclusive: `finding`, `no_violation`, `error`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] no_violation
          #   @return [::Google::Protobuf::Empty]
          #     Indicates that the test case does not trigger any violation.
          #
          #     Note: The following fields are mutually exclusive: `no_violation`, `finding`, `error`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] error
          #   @return [::Google::Rpc::Status]
          #     Error encountered during the test.
          #
          #     Note: The following fields are mutually exclusive: `error`, `finding`, `no_violation`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class SimulatedResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The representation of an
        # {::Google::Cloud::SecurityCenterManagement::V1::EventThreatDetectionCustomModule EventThreatDetectionCustomModule}
        # at a given level, taking hierarchy into account and resolving various fields
        # accordingly. For example, if the module is enabled at the ancestor level,
        # then effective modules at all descendant levels will have their enablement
        # state set to `ENABLED`. Similarly, if `module.inherited` is set, then the
        # effective module's configuration will reflect the ancestor's configuration.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name of the Event Threat Detection custom module,
        #     in one of the following formats:
        #
        #     * `organizations/{organization}/locations/{location}/effectiveEventThreatDetectionCustomModules/{custom_module}`
        #     * `folders/{folder}/locations/{location}/effectiveEventThreatDetectionCustomModules/{custom_module}`
        #     * `projects/{project}/locations/{location}/effectiveEventThreatDetectionCustomModules/{custom_module}`
        # @!attribute [r] config
        #   @return [::Google::Protobuf::Struct]
        #     Output only. Configuration for the effective module.
        # @!attribute [r] enablement_state
        #   @return [::Google::Cloud::SecurityCenterManagement::V1::EffectiveEventThreatDetectionCustomModule::EnablementState]
        #     Output only. The effective state of enablement for the module at the given
        #     level of the hierarchy.
        # @!attribute [r] type
        #   @return [::String]
        #     Output only. Type for the module (for example, `CONFIGURABLE_BAD_IP`).
        # @!attribute [r] display_name
        #   @return [::String]
        #     Output only. The human-readable name of the module.
        # @!attribute [r] description
        #   @return [::String]
        #     Output only. A description of the module.
        class EffectiveEventThreatDetectionCustomModule
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The enablement state of the module.
          module EnablementState
            # Default value. This value is unused.
            ENABLEMENT_STATE_UNSPECIFIED = 0

            # The module is enabled at the given level.
            ENABLED = 1

            # The module is disabled at the given level.
            DISABLED = 2
          end
        end

        # Request message for
        # {::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client#list_effective_event_threat_detection_custom_modules SecurityCenterManagement.ListEffectiveEventThreatDetectionCustomModules}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Name of parent to list effective custom modules, in one of the
        #     following formats:
        #
        #     * `organizations/{organization}/locations/{location}`
        #     * `folders/{folder}/locations/{location}`
        #     * `projects/{project}/locations/{location}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of results to return in a single response.
        #     Default is 10, minimum is 1, maximum is 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A pagination token returned from a previous request. Provide this
        #     token to retrieve the next page of results.
        #
        #     When paginating, the rest of the request must match the request that
        #     generated the page token.
        class ListEffectiveEventThreatDetectionCustomModulesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client#list_effective_event_threat_detection_custom_modules SecurityCenterManagement.ListEffectiveEventThreatDetectionCustomModules}.
        # @!attribute [rw] effective_event_threat_detection_custom_modules
        #   @return [::Array<::Google::Cloud::SecurityCenterManagement::V1::EffectiveEventThreatDetectionCustomModule>]
        #     The list of effective Event Threat Detection custom modules.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A pagination token. To retrieve the next page of results, call the method
        #     again with this token.
        class ListEffectiveEventThreatDetectionCustomModulesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client#get_effective_event_threat_detection_custom_module SecurityCenterManagement.GetEffectiveEventThreatDetectionCustomModule}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the Event Threat Detection custom module, in
        #     one of the following formats:
        #
        #     * `organizations/{organization}/locations/{location}/effectiveEventThreatDetectionCustomModules/{custom_module}`
        #     * `folders/{folder}/locations/{location}/effectiveEventThreatDetectionCustomModules/{custom_module}`
        #     * `projects/{project}/locations/{location}/effectiveEventThreatDetectionCustomModules/{custom_module}`
        class GetEffectiveEventThreatDetectionCustomModuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A Security Command Center resource that contains the configuration and
        # enablement state of a custom module, which enables Event Threat Detection to
        # write certain findings to Security Command Center.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name of the Event Threat Detection custom module,
        #     in one of the following formats:
        #
        #     * `organizations/{organization}/locations/{location}/eventThreatDetectionCustomModules/{custom_module}`
        #     * `folders/{folder}/locations/{location}/eventThreatDetectionCustomModules/{custom_module}`
        #     * `projects/{project}/locations/{location}/eventThreatDetectionCustomModules/{custom_module}`
        # @!attribute [rw] config
        #   @return [::Google::Protobuf::Struct]
        #     Optional. Configuration for the module. For the resident module, its
        #     configuration value is defined at this level. For the inherited module, its
        #     configuration value is inherited from the ancestor module.
        # @!attribute [r] ancestor_module
        #   @return [::String]
        #     Output only. The closest ancestor module that this module inherits the
        #     enablement state from. If empty, indicates that the custom module was
        #     created in the requesting parent organization, folder, or project. The
        #     format is the same as the custom module's resource name.
        # @!attribute [rw] enablement_state
        #   @return [::Google::Cloud::SecurityCenterManagement::V1::EventThreatDetectionCustomModule::EnablementState]
        #     Optional. The state of enablement for the module at the given level of the
        #     hierarchy.
        # @!attribute [rw] type
        #   @return [::String]
        #     Optional. Type for the module. For example, `CONFIGURABLE_BAD_IP`.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. The human-readable name of the module.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. A description of the module.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the module was last updated.
        # @!attribute [r] last_editor
        #   @return [::String]
        #     Output only. The editor the module was last updated by.
        class EventThreatDetectionCustomModule
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The enablement state of the module.
          module EnablementState
            # Unspecified enablement state.
            ENABLEMENT_STATE_UNSPECIFIED = 0

            # The module is enabled at the given level.
            ENABLED = 1

            # The module is disabled at the given level.
            DISABLED = 2

            # State is inherited from an ancestor module. The module will either be
            # effectively `ENABLED` or `DISABLED` based on its closest non-inherited
            # ancestor module in the CRM hierarchy. If you try to set a top-level
            # module (a module with no parent) to the `INHERITED` state, you receive an
            # `INVALID_ARGUMENT` error.
            INHERITED = 3
          end
        end

        # Request message for
        # {::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client#list_event_threat_detection_custom_modules SecurityCenterManagement.ListEventThreatDetectionCustomModules}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Name of parent to list custom modules, in one of the following
        #     formats:
        #
        #     * `organizations/{organization}/locations/{location}`
        #     * `folders/{folder}/locations/{location}`
        #     * `projects/{project}/locations/{location}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of modules to return. The service may return
        #     fewer than this value. If unspecified, at most 10 modules will be returned.
        #     The maximum value is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A pagination token returned from a previous request. Provide this
        #     token to retrieve the next page of results.
        #
        #     When paginating, the rest of the request must match the request that
        #     generated the page token.
        class ListEventThreatDetectionCustomModulesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client#list_event_threat_detection_custom_modules SecurityCenterManagement.ListEventThreatDetectionCustomModules}.
        # @!attribute [rw] event_threat_detection_custom_modules
        #   @return [::Array<::Google::Cloud::SecurityCenterManagement::V1::EventThreatDetectionCustomModule>]
        #     The list of custom modules.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A pagination token. To retrieve the next page of results, call the method
        #     again with this token.
        class ListEventThreatDetectionCustomModulesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client#list_descendant_event_threat_detection_custom_modules SecurityCenterManagement.ListDescendantEventThreatDetectionCustomModules}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Name of parent to list custom modules, in one of the following
        #     formats:
        #
        #     * `organizations/{organization}/locations/{location}`
        #     * `folders/{folder}/locations/{location}`
        #     * `projects/{project}/locations/{location}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of modules to return. The service may return
        #     fewer than this value. If unspecified, at most 10 configs will be returned.
        #     The maximum value is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A pagination token returned from a previous request. Provide this
        #     token to retrieve the next page of results.
        #
        #     When paginating, the rest of the request must match the request that
        #     generated the page token.
        class ListDescendantEventThreatDetectionCustomModulesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client#list_descendant_event_threat_detection_custom_modules SecurityCenterManagement.ListDescendantEventThreatDetectionCustomModules}.
        # @!attribute [rw] event_threat_detection_custom_modules
        #   @return [::Array<::Google::Cloud::SecurityCenterManagement::V1::EventThreatDetectionCustomModule>]
        #     The list of custom modules.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A pagination token. To retrieve the next page of results, call the method
        #     again with this token.
        class ListDescendantEventThreatDetectionCustomModulesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client#get_event_threat_detection_custom_module SecurityCenterManagement.GetEventThreatDetectionCustomModule}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the Event Threat Detection custom module, in
        #     one of the following formats:
        #
        #     * `organizations/{organization}/locations/{location}/eventThreatDetectionCustomModules/{custom_module}`
        #     * `folders/{folder}/locations/{location}/eventThreatDetectionCustomModules/{custom_module}`
        #     * `projects/{project}/locations/{location}/eventThreatDetectionCustomModules/{custom_module}`
        class GetEventThreatDetectionCustomModuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client#create_event_threat_detection_custom_module SecurityCenterManagement.CreateEventThreatDetectionCustomModule}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Name of parent for the module, in one of the following formats:
        #
        #     * `organizations/{organization}/locations/{location}`
        #     * `folders/{folder}/locations/{location}`
        #     * `projects/{project}/locations/{location}`
        # @!attribute [rw] event_threat_detection_custom_module
        #   @return [::Google::Cloud::SecurityCenterManagement::V1::EventThreatDetectionCustomModule]
        #     Required. The module to create. The
        #     {::Google::Cloud::SecurityCenterManagement::V1::EventThreatDetectionCustomModule#name EventThreatDetectionCustomModule.name}
        #     field is ignored; Security Command Center generates the name.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. When set to `true`, the request will be validated (including IAM
        #     checks), but no module will be created. An `OK` response indicates that the
        #     request is valid, while an error response indicates that the request is
        #     invalid.
        #
        #     If the request is valid, a subsequent request to create the module could
        #     still fail for one of the following reasons:
        #
        #     *  The state of your cloud resources changed; for example, you lost a
        #        required IAM permission
        #     *  An error occurred during creation of the module
        #
        #     Defaults to `false`.
        class CreateEventThreatDetectionCustomModuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for updating a EventThreatDetectionCustomModule
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The fields to update. If omitted, then all fields are updated.
        # @!attribute [rw] event_threat_detection_custom_module
        #   @return [::Google::Cloud::SecurityCenterManagement::V1::EventThreatDetectionCustomModule]
        #     Required. The module being updated.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. When set to `true`, the request will be validated (including IAM
        #     checks), but no module will be updated. An `OK` response indicates that the
        #     request is valid, while an error response indicates that the request is
        #     invalid.
        #
        #     If the request is valid, a subsequent request to update the module could
        #     still fail for one of the following reasons:
        #
        #     *  The state of your cloud resources changed; for example, you lost a
        #        required IAM permission
        #     *  An error occurred during creation of the module
        #
        #     Defaults to `false`.
        class UpdateEventThreatDetectionCustomModuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client#delete_event_threat_detection_custom_module SecurityCenterManagement.DeleteEventThreatDetectionCustomModule}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the Event Threat Detection custom module, in
        #     one of the following formats:
        #
        #     * `organizations/{organization}/locations/{location}/eventThreatDetectionCustomModules/{custom_module}`
        #     * `folders/{folder}/locations/{location}/eventThreatDetectionCustomModules/{custom_module}`
        #     * `projects/{project}/locations/{location}/eventThreatDetectionCustomModules/{custom_module}`
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. When set to `true`, the request will be validated (including IAM
        #     checks), but no module will be deleted. An `OK` response indicates that the
        #     request is valid, while an error response indicates that the request is
        #     invalid.
        #
        #     If the request is valid, a subsequent request to delete the module could
        #     still fail for one of the following reasons:
        #
        #     *  The state of your cloud resources changed; for example, you lost a
        #        required IAM permission
        #     *  An error occurred during creation of the module
        #
        #     Defaults to `false`.
        class DeleteEventThreatDetectionCustomModuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client#validate_event_threat_detection_custom_module SecurityCenterManagement.ValidateEventThreatDetectionCustomModule}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Resource name of the parent to validate the custom modules under,
        #     in one of the following formats:
        #
        #     * `organizations/{organization}/locations/{location}`
        # @!attribute [rw] raw_text
        #   @return [::String]
        #     Required. The raw text of the module's contents. Used to generate error
        #     messages.
        # @!attribute [rw] type
        #   @return [::String]
        #     Required. The type of the module. For example, `CONFIGURABLE_BAD_IP`.
        class ValidateEventThreatDetectionCustomModuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client#validate_event_threat_detection_custom_module SecurityCenterManagement.ValidateEventThreatDetectionCustomModule}.
        # @!attribute [rw] errors
        #   @return [::Array<::Google::Cloud::SecurityCenterManagement::V1::ValidateEventThreatDetectionCustomModuleResponse::CustomModuleValidationError>]
        #     A list of errors returned by the validator. If the list is empty, there
        #     were no errors.
        class ValidateEventThreatDetectionCustomModuleResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # An error encountered while validating the uploaded configuration of an
          # Event Threat Detection custom module.
          # @!attribute [rw] description
          #   @return [::String]
          #     A human-readable description of the error.
          # @!attribute [rw] field_path
          #   @return [::String]
          #     The path, in [RFC 6901: JSON
          #     Pointer](https://datatracker.ietf.org/doc/html/rfc6901) format, to the
          #     field that failed validation. Omitted if no specific field is affected.
          # @!attribute [rw] start
          #   @return [::Google::Cloud::SecurityCenterManagement::V1::ValidateEventThreatDetectionCustomModuleResponse::Position]
          #     The initial position of the error in the uploaded text version of the
          #     module. Omitted if no specific position applies, or if the position could
          #     not be computed.
          # @!attribute [rw] end
          #   @return [::Google::Cloud::SecurityCenterManagement::V1::ValidateEventThreatDetectionCustomModuleResponse::Position]
          #     The end position of the error in the uploaded text version of the module.
          #     Omitted if no specific position applies, or if the position could not be
          #     computed.
          class CustomModuleValidationError
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A position in the uploaded text version of a module.
          # @!attribute [rw] line_number
          #   @return [::Integer]
          #     The line position in the text.
          # @!attribute [rw] column_number
          #   @return [::Integer]
          #     The column position in the line.
          class Position
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request message for
        # {::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client#get_security_center_service SecurityCenterManagement.GetSecurityCenterService}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The Security Command Center service to retrieve, in one of the
        #     following formats:
        #
        #     * organizations/\\{organization}/locations/\\{location}/securityCenterServices/\\{service}
        #     * folders/\\{folder}/locations/\\{location}/securityCenterServices/\\{service}
        #     * projects/\\{project}/locations/\\{location}/securityCenterServices/\\{service}
        #
        #     The following values are valid for `{service}`:
        #
        #     * `container-threat-detection`
        #     * `event-threat-detection`
        #     * `security-health-analytics`
        #     * `vm-threat-detection`
        #     * `web-security-scanner`
        # @!attribute [rw] show_eligible_modules_only
        #   @return [::Boolean]
        #     Set to `true` to show only modules that are in scope. By default, all
        #     modules are shown.
        class GetSecurityCenterServiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client#list_security_center_services SecurityCenterManagement.ListSecurityCenterServices}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the parent to list Security Command Center services,
        #     in one of the following formats:
        #
        #     * `organizations/{organization}/locations/{location}`
        #     * `folders/{folder}/locations/{location}`
        #     * `projects/{project}/locations/{location}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of results to return in a single response.
        #     Default is 10, minimum is 1, maximum is 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A pagination token returned from a previous request. Provide this
        #     token to retrieve the next page of results.
        #
        #     When paginating, the rest of the request must match the request that
        #     generated the page token.
        # @!attribute [rw] show_eligible_modules_only
        #   @return [::Boolean]
        #     Flag that, when set, is used to filter the module settings that are shown.
        #     The default setting is that all modules are shown.
        class ListSecurityCenterServicesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client#list_security_center_services SecurityCenterManagement.ListSecurityCenterServices}.
        # @!attribute [rw] security_center_services
        #   @return [::Array<::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterService>]
        #     The list of services.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A pagination token. To retrieve the next page of results, call the method
        #     again with this token.
        class ListSecurityCenterServicesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client#update_security_center_service SecurityCenterManagement.UpdateSecurityCenterService}.
        # @!attribute [rw] security_center_service
        #   @return [::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterService]
        #     Required. The updated service.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The fields to update. Accepts the following values:
        #
        #     * `intended_enablement_state`
        #     * `modules`
        #
        #     If omitted, then all eligible fields are updated.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. When set to `true`, the request will be validated (including IAM
        #     checks), but no service will be updated. An `OK` response indicates that
        #     the request is valid, while an error response indicates that the request is
        #     invalid.
        #
        #     If the request is valid, a subsequent request to update the service could
        #     still fail for one of the following reasons:
        #
        #     *  The state of your cloud resources changed; for example, you lost a
        #        required IAM permission
        #     *  An error occurred during update of the service
        #
        #     Defaults to `false`.
        class UpdateSecurityCenterServiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
