# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module SecurityCenterManagement
      module V1
        module SecurityCenterManagement
          # Path helper methods for the SecurityCenterManagement API.
          module Paths
            ##
            # Create a fully-qualified EffectiveEventThreatDetectionCustomModule resource string.
            #
            # @overload effective_event_threat_detection_custom_module_path(organization:, location:, effective_event_threat_detection_custom_module:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/locations/{location}/effectiveEventThreatDetectionCustomModules/{effective_event_threat_detection_custom_module}`
            #
            #   @param organization [String]
            #   @param location [String]
            #   @param effective_event_threat_detection_custom_module [String]
            #
            # @overload effective_event_threat_detection_custom_module_path(project:, location:, effective_event_threat_detection_custom_module:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/effectiveEventThreatDetectionCustomModules/{effective_event_threat_detection_custom_module}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param effective_event_threat_detection_custom_module [String]
            #
            # @overload effective_event_threat_detection_custom_module_path(folder:, location:, effective_event_threat_detection_custom_module:)
            #   The resource will be in the following format:
            #
            #   `folders/{folder}/locations/{location}/effectiveEventThreatDetectionCustomModules/{effective_event_threat_detection_custom_module}`
            #
            #   @param folder [String]
            #   @param location [String]
            #   @param effective_event_threat_detection_custom_module [String]
            #
            # @return [::String]
            def effective_event_threat_detection_custom_module_path **args
              resources = {
                "effective_event_threat_detection_custom_module:location:organization" => (proc do |organization:, location:, effective_event_threat_detection_custom_module:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "organizations/#{organization}/locations/#{location}/effectiveEventThreatDetectionCustomModules/#{effective_event_threat_detection_custom_module}"
                end),
                "effective_event_threat_detection_custom_module:location:project" => (proc do |project:, location:, effective_event_threat_detection_custom_module:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/effectiveEventThreatDetectionCustomModules/#{effective_event_threat_detection_custom_module}"
                end),
                "effective_event_threat_detection_custom_module:folder:location" => (proc do |folder:, location:, effective_event_threat_detection_custom_module:|
                  raise ::ArgumentError, "folder cannot contain /" if folder.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "folders/#{folder}/locations/#{location}/effectiveEventThreatDetectionCustomModules/#{effective_event_threat_detection_custom_module}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified EffectiveSecurityHealthAnalyticsCustomModule resource string.
            #
            # @overload effective_security_health_analytics_custom_module_path(organization:, location:, effective_security_health_analytics_custom_module:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/locations/{location}/effectiveSecurityHealthAnalyticsCustomModules/{effective_security_health_analytics_custom_module}`
            #
            #   @param organization [String]
            #   @param location [String]
            #   @param effective_security_health_analytics_custom_module [String]
            #
            # @overload effective_security_health_analytics_custom_module_path(project:, location:, effective_security_health_analytics_custom_module:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/effectiveSecurityHealthAnalyticsCustomModules/{effective_security_health_analytics_custom_module}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param effective_security_health_analytics_custom_module [String]
            #
            # @overload effective_security_health_analytics_custom_module_path(folder:, location:, effective_security_health_analytics_custom_module:)
            #   The resource will be in the following format:
            #
            #   `folders/{folder}/locations/{location}/effectiveSecurityHealthAnalyticsCustomModules/{effective_security_health_analytics_custom_module}`
            #
            #   @param folder [String]
            #   @param location [String]
            #   @param effective_security_health_analytics_custom_module [String]
            #
            # @return [::String]
            def effective_security_health_analytics_custom_module_path **args
              resources = {
                "effective_security_health_analytics_custom_module:location:organization" => (proc do |organization:, location:, effective_security_health_analytics_custom_module:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "organizations/#{organization}/locations/#{location}/effectiveSecurityHealthAnalyticsCustomModules/#{effective_security_health_analytics_custom_module}"
                end),
                "effective_security_health_analytics_custom_module:location:project" => (proc do |project:, location:, effective_security_health_analytics_custom_module:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/effectiveSecurityHealthAnalyticsCustomModules/#{effective_security_health_analytics_custom_module}"
                end),
                "effective_security_health_analytics_custom_module:folder:location" => (proc do |folder:, location:, effective_security_health_analytics_custom_module:|
                  raise ::ArgumentError, "folder cannot contain /" if folder.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "folders/#{folder}/locations/#{location}/effectiveSecurityHealthAnalyticsCustomModules/#{effective_security_health_analytics_custom_module}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified EventThreatDetectionCustomModule resource string.
            #
            # @overload event_threat_detection_custom_module_path(organization:, location:, event_threat_detection_custom_module:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/locations/{location}/eventThreatDetectionCustomModules/{event_threat_detection_custom_module}`
            #
            #   @param organization [String]
            #   @param location [String]
            #   @param event_threat_detection_custom_module [String]
            #
            # @overload event_threat_detection_custom_module_path(project:, location:, event_threat_detection_custom_module:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/eventThreatDetectionCustomModules/{event_threat_detection_custom_module}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param event_threat_detection_custom_module [String]
            #
            # @overload event_threat_detection_custom_module_path(folder:, location:, event_threat_detection_custom_module:)
            #   The resource will be in the following format:
            #
            #   `folders/{folder}/locations/{location}/eventThreatDetectionCustomModules/{event_threat_detection_custom_module}`
            #
            #   @param folder [String]
            #   @param location [String]
            #   @param event_threat_detection_custom_module [String]
            #
            # @return [::String]
            def event_threat_detection_custom_module_path **args
              resources = {
                "event_threat_detection_custom_module:location:organization" => (proc do |organization:, location:, event_threat_detection_custom_module:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "organizations/#{organization}/locations/#{location}/eventThreatDetectionCustomModules/#{event_threat_detection_custom_module}"
                end),
                "event_threat_detection_custom_module:location:project" => (proc do |project:, location:, event_threat_detection_custom_module:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/eventThreatDetectionCustomModules/#{event_threat_detection_custom_module}"
                end),
                "event_threat_detection_custom_module:folder:location" => (proc do |folder:, location:, event_threat_detection_custom_module:|
                  raise ::ArgumentError, "folder cannot contain /" if folder.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "folders/#{folder}/locations/#{location}/eventThreatDetectionCustomModules/#{event_threat_detection_custom_module}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified FolderLocation resource string.
            #
            # The resource will be in the following format:
            #
            # `folders/{folder}/locations/{location}`
            #
            # @param folder [String]
            # @param location [String]
            #
            # @return [::String]
            def folder_location_path folder:, location:
              raise ::ArgumentError, "folder cannot contain /" if folder.to_s.include? "/"

              "folders/#{folder}/locations/#{location}"
            end

            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified OrganizationLocation resource string.
            #
            # The resource will be in the following format:
            #
            # `organizations/{organization}/locations/{location}`
            #
            # @param organization [String]
            # @param location [String]
            #
            # @return [::String]
            def organization_location_path organization:, location:
              raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"

              "organizations/#{organization}/locations/#{location}"
            end

            ##
            # Create a fully-qualified SecurityCenterService resource string.
            #
            # @overload security_center_service_path(project:, location:, service:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/securityCenterServices/{service}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param service [String]
            #
            # @overload security_center_service_path(folder:, location:, service:)
            #   The resource will be in the following format:
            #
            #   `folders/{folder}/locations/{location}/securityCenterServices/{service}`
            #
            #   @param folder [String]
            #   @param location [String]
            #   @param service [String]
            #
            # @overload security_center_service_path(organization:, location:, service:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/locations/{location}/securityCenterServices/{service}`
            #
            #   @param organization [String]
            #   @param location [String]
            #   @param service [String]
            #
            # @return [::String]
            def security_center_service_path **args
              resources = {
                "location:project:service" => (proc do |project:, location:, service:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/securityCenterServices/#{service}"
                end),
                "folder:location:service" => (proc do |folder:, location:, service:|
                  raise ::ArgumentError, "folder cannot contain /" if folder.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "folders/#{folder}/locations/#{location}/securityCenterServices/#{service}"
                end),
                "location:organization:service" => (proc do |organization:, location:, service:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "organizations/#{organization}/locations/#{location}/securityCenterServices/#{service}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified SecurityHealthAnalyticsCustomModule resource string.
            #
            # @overload security_health_analytics_custom_module_path(organization:, location:, security_health_analytics_custom_module:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/locations/{location}/securityHealthAnalyticsCustomModules/{security_health_analytics_custom_module}`
            #
            #   @param organization [String]
            #   @param location [String]
            #   @param security_health_analytics_custom_module [String]
            #
            # @overload security_health_analytics_custom_module_path(project:, location:, security_health_analytics_custom_module:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/securityHealthAnalyticsCustomModules/{security_health_analytics_custom_module}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param security_health_analytics_custom_module [String]
            #
            # @overload security_health_analytics_custom_module_path(folder:, location:, security_health_analytics_custom_module:)
            #   The resource will be in the following format:
            #
            #   `folders/{folder}/locations/{location}/securityHealthAnalyticsCustomModules/{security_health_analytics_custom_module}`
            #
            #   @param folder [String]
            #   @param location [String]
            #   @param security_health_analytics_custom_module [String]
            #
            # @return [::String]
            def security_health_analytics_custom_module_path **args
              resources = {
                "location:organization:security_health_analytics_custom_module" => (proc do |organization:, location:, security_health_analytics_custom_module:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "organizations/#{organization}/locations/#{location}/securityHealthAnalyticsCustomModules/#{security_health_analytics_custom_module}"
                end),
                "location:project:security_health_analytics_custom_module" => (proc do |project:, location:, security_health_analytics_custom_module:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/securityHealthAnalyticsCustomModules/#{security_health_analytics_custom_module}"
                end),
                "folder:location:security_health_analytics_custom_module" => (proc do |folder:, location:, security_health_analytics_custom_module:|
                  raise ::ArgumentError, "folder cannot contain /" if folder.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "folders/#{folder}/locations/#{location}/securityHealthAnalyticsCustomModules/#{security_health_analytics_custom_module}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            extend self
          end
        end
      end
    end
  end
end
