# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/securitycentermanagement/v1/security_center_management_pb"
require "google/cloud/location"

module Google
  module Cloud
    module SecurityCenterManagement
      module V1
        module SecurityCenterManagement
          ##
          # Client for the SecurityCenterManagement service.
          #
          # Service describing handlers for resources
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "securitycentermanagement.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :security_center_management_stub

            ##
            # Configure the SecurityCenterManagement Client class.
            #
            # See {::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all SecurityCenterManagement clients
            #   ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "SecurityCenterManagement", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.list_effective_security_health_analytics_custom_modules.timeout = 60.0
                default_config.rpcs.list_effective_security_health_analytics_custom_modules.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.get_effective_security_health_analytics_custom_module.timeout = 60.0
                default_config.rpcs.get_effective_security_health_analytics_custom_module.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.list_security_health_analytics_custom_modules.timeout = 60.0
                default_config.rpcs.list_security_health_analytics_custom_modules.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.list_descendant_security_health_analytics_custom_modules.timeout = 60.0
                default_config.rpcs.list_descendant_security_health_analytics_custom_modules.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.get_security_health_analytics_custom_module.timeout = 60.0
                default_config.rpcs.get_security_health_analytics_custom_module.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.create_security_health_analytics_custom_module.timeout = 60.0

                default_config.rpcs.update_security_health_analytics_custom_module.timeout = 60.0

                default_config.rpcs.delete_security_health_analytics_custom_module.timeout = 60.0

                default_config.rpcs.simulate_security_health_analytics_custom_module.timeout = 60.0
                default_config.rpcs.simulate_security_health_analytics_custom_module.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.list_effective_event_threat_detection_custom_modules.timeout = 60.0
                default_config.rpcs.list_effective_event_threat_detection_custom_modules.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.get_effective_event_threat_detection_custom_module.timeout = 60.0
                default_config.rpcs.get_effective_event_threat_detection_custom_module.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.list_event_threat_detection_custom_modules.timeout = 60.0
                default_config.rpcs.list_event_threat_detection_custom_modules.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.list_descendant_event_threat_detection_custom_modules.timeout = 60.0
                default_config.rpcs.list_descendant_event_threat_detection_custom_modules.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.get_event_threat_detection_custom_module.timeout = 60.0
                default_config.rpcs.get_event_threat_detection_custom_module.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.create_event_threat_detection_custom_module.timeout = 60.0

                default_config.rpcs.update_event_threat_detection_custom_module.timeout = 60.0

                default_config.rpcs.delete_event_threat_detection_custom_module.timeout = 60.0

                default_config.rpcs.validate_event_threat_detection_custom_module.timeout = 60.0
                default_config.rpcs.validate_event_threat_detection_custom_module.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the SecurityCenterManagement Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @security_center_management_stub.universe_domain
            end

            ##
            # Create a new SecurityCenterManagement client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the SecurityCenterManagement client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/securitycentermanagement/v1/security_center_management_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @security_center_management_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @security_center_management_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @security_center_management_stub.endpoint
                config.universe_domain = @security_center_management_stub.universe_domain
                config.logger = @security_center_management_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @security_center_management_stub.logger
            end

            # Service calls

            ##
            # Returns a list of all
            # {::Google::Cloud::SecurityCenterManagement::V1::EffectiveSecurityHealthAnalyticsCustomModule EffectiveSecurityHealthAnalyticsCustomModule}
            # resources for the given parent. This includes resident modules defined at
            # the scope of the parent, and inherited modules, inherited from ancestor
            # organizations, folders, and projects (no descendants).
            #
            # @overload list_effective_security_health_analytics_custom_modules(request, options = nil)
            #   Pass arguments to `list_effective_security_health_analytics_custom_modules` via a request object, either of type
            #   {::Google::Cloud::SecurityCenterManagement::V1::ListEffectiveSecurityHealthAnalyticsCustomModulesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenterManagement::V1::ListEffectiveSecurityHealthAnalyticsCustomModulesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_effective_security_health_analytics_custom_modules(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_effective_security_health_analytics_custom_modules` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Name of parent to list effective custom modules, in one of the
            #     following formats:
            #
            #     * `organizations/{organization}/locations/{location}`
            #     * `folders/{folder}/locations/{location}`
            #     * `projects/{project}/locations/{location}`
            #   @param page_size [::Integer]
            #     Optional. The maximum number of results to return in a single response.
            #     Default is 10, minimum is 1, maximum is 1000.
            #   @param page_token [::String]
            #     Optional. A pagination token returned from a previous request. Provide this
            #     token to retrieve the next page of results.
            #
            #     When paginating, the rest of the request must match the request that
            #     generated the page token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenterManagement::V1::EffectiveSecurityHealthAnalyticsCustomModule>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenterManagement::V1::EffectiveSecurityHealthAnalyticsCustomModule>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center_management/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenterManagement::V1::ListEffectiveSecurityHealthAnalyticsCustomModulesRequest.new
            #
            #   # Call the list_effective_security_health_analytics_custom_modules method.
            #   result = client.list_effective_security_health_analytics_custom_modules request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::SecurityCenterManagement::V1::EffectiveSecurityHealthAnalyticsCustomModule.
            #     p item
            #   end
            #
            def list_effective_security_health_analytics_custom_modules request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenterManagement::V1::ListEffectiveSecurityHealthAnalyticsCustomModulesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_effective_security_health_analytics_custom_modules.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenterManagement::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_effective_security_health_analytics_custom_modules.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_effective_security_health_analytics_custom_modules.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_management_stub.call_rpc :list_effective_security_health_analytics_custom_modules, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @security_center_management_stub, :list_effective_security_health_analytics_custom_modules, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single
            # {::Google::Cloud::SecurityCenterManagement::V1::EffectiveSecurityHealthAnalyticsCustomModule EffectiveSecurityHealthAnalyticsCustomModule}.
            #
            # @overload get_effective_security_health_analytics_custom_module(request, options = nil)
            #   Pass arguments to `get_effective_security_health_analytics_custom_module` via a request object, either of type
            #   {::Google::Cloud::SecurityCenterManagement::V1::GetEffectiveSecurityHealthAnalyticsCustomModuleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenterManagement::V1::GetEffectiveSecurityHealthAnalyticsCustomModuleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_effective_security_health_analytics_custom_module(name: nil)
            #   Pass arguments to `get_effective_security_health_analytics_custom_module` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The full resource name of the custom module, specified in one of
            #     the following formats:
            #
            #     * `organizations/organization/{location}/effectiveSecurityHealthAnalyticsCustomModules/{custom_module}`
            #     * `folders/folder/{location}/effectiveSecurityHealthAnalyticsCustomModules/{custom_module}`
            #     * `projects/project/{location}/effectiveSecurityHealthAnalyticsCustomModules/{custom_module}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenterManagement::V1::EffectiveSecurityHealthAnalyticsCustomModule]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenterManagement::V1::EffectiveSecurityHealthAnalyticsCustomModule]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center_management/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenterManagement::V1::GetEffectiveSecurityHealthAnalyticsCustomModuleRequest.new
            #
            #   # Call the get_effective_security_health_analytics_custom_module method.
            #   result = client.get_effective_security_health_analytics_custom_module request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenterManagement::V1::EffectiveSecurityHealthAnalyticsCustomModule.
            #   p result
            #
            def get_effective_security_health_analytics_custom_module request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenterManagement::V1::GetEffectiveSecurityHealthAnalyticsCustomModuleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_effective_security_health_analytics_custom_module.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenterManagement::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_effective_security_health_analytics_custom_module.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_effective_security_health_analytics_custom_module.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_management_stub.call_rpc :get_effective_security_health_analytics_custom_module, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns a list of all
            # {::Google::Cloud::SecurityCenterManagement::V1::SecurityHealthAnalyticsCustomModule SecurityHealthAnalyticsCustomModule}
            # resources for the given parent. This includes resident modules defined at
            # the scope of the parent, and inherited modules, inherited from ancestor
            # organizations, folders, and projects (no descendants).
            #
            # @overload list_security_health_analytics_custom_modules(request, options = nil)
            #   Pass arguments to `list_security_health_analytics_custom_modules` via a request object, either of type
            #   {::Google::Cloud::SecurityCenterManagement::V1::ListSecurityHealthAnalyticsCustomModulesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenterManagement::V1::ListSecurityHealthAnalyticsCustomModulesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_security_health_analytics_custom_modules(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_security_health_analytics_custom_modules` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Name of the parent organization, folder, or project in which to
            #     list custom modules, in one of the following formats:
            #
            #     * `organizations/{organization}/locations/{location}`
            #     * `folders/{folder}/locations/{location}`
            #     * `projects/{project}/locations/{location}`
            #   @param page_size [::Integer]
            #     Optional. The maximum number of results to return in a single response.
            #     Default is 10, minimum is 1, maximum is 1000.
            #   @param page_token [::String]
            #     Optional. A pagination token returned from a previous request. Provide this
            #     token to retrieve the next page of results.
            #
            #     When paginating, the rest of the request must match the request that
            #     generated the page token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenterManagement::V1::SecurityHealthAnalyticsCustomModule>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenterManagement::V1::SecurityHealthAnalyticsCustomModule>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center_management/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenterManagement::V1::ListSecurityHealthAnalyticsCustomModulesRequest.new
            #
            #   # Call the list_security_health_analytics_custom_modules method.
            #   result = client.list_security_health_analytics_custom_modules request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::SecurityCenterManagement::V1::SecurityHealthAnalyticsCustomModule.
            #     p item
            #   end
            #
            def list_security_health_analytics_custom_modules request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenterManagement::V1::ListSecurityHealthAnalyticsCustomModulesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_security_health_analytics_custom_modules.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenterManagement::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_security_health_analytics_custom_modules.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_security_health_analytics_custom_modules.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_management_stub.call_rpc :list_security_health_analytics_custom_modules, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @security_center_management_stub, :list_security_health_analytics_custom_modules, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns a list of all resident
            # {::Google::Cloud::SecurityCenterManagement::V1::SecurityHealthAnalyticsCustomModule SecurityHealthAnalyticsCustomModule}
            # resources under the given organization, folder, or project and all of its
            # descendants.
            #
            # @overload list_descendant_security_health_analytics_custom_modules(request, options = nil)
            #   Pass arguments to `list_descendant_security_health_analytics_custom_modules` via a request object, either of type
            #   {::Google::Cloud::SecurityCenterManagement::V1::ListDescendantSecurityHealthAnalyticsCustomModulesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenterManagement::V1::ListDescendantSecurityHealthAnalyticsCustomModulesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_descendant_security_health_analytics_custom_modules(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_descendant_security_health_analytics_custom_modules` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Name of the parent organization, folder, or project in which to
            #     list custom modules, in one of the following formats:
            #
            #     * `organizations/{organization}/locations/{location}`
            #     * `folders/{folder}/locations/{location}`
            #     * `projects/{project}/locations/{location}`
            #   @param page_size [::Integer]
            #     Optional. The maximum number of results to return in a single response.
            #     Default is 10, minimum is 1, maximum is 1000.
            #   @param page_token [::String]
            #     Optional. A pagination token returned from a previous request. Provide this
            #     token to retrieve the next page of results.
            #
            #     When paginating, the rest of the request must match the request that
            #     generated the page token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenterManagement::V1::SecurityHealthAnalyticsCustomModule>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenterManagement::V1::SecurityHealthAnalyticsCustomModule>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center_management/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenterManagement::V1::ListDescendantSecurityHealthAnalyticsCustomModulesRequest.new
            #
            #   # Call the list_descendant_security_health_analytics_custom_modules method.
            #   result = client.list_descendant_security_health_analytics_custom_modules request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::SecurityCenterManagement::V1::SecurityHealthAnalyticsCustomModule.
            #     p item
            #   end
            #
            def list_descendant_security_health_analytics_custom_modules request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenterManagement::V1::ListDescendantSecurityHealthAnalyticsCustomModulesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_descendant_security_health_analytics_custom_modules.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenterManagement::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_descendant_security_health_analytics_custom_modules.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_descendant_security_health_analytics_custom_modules.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_management_stub.call_rpc :list_descendant_security_health_analytics_custom_modules, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @security_center_management_stub, :list_descendant_security_health_analytics_custom_modules, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieves a
            # {::Google::Cloud::SecurityCenterManagement::V1::SecurityHealthAnalyticsCustomModule SecurityHealthAnalyticsCustomModule}.
            #
            # @overload get_security_health_analytics_custom_module(request, options = nil)
            #   Pass arguments to `get_security_health_analytics_custom_module` via a request object, either of type
            #   {::Google::Cloud::SecurityCenterManagement::V1::GetSecurityHealthAnalyticsCustomModuleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenterManagement::V1::GetSecurityHealthAnalyticsCustomModuleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_security_health_analytics_custom_module(name: nil)
            #   Pass arguments to `get_security_health_analytics_custom_module` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the resource, in the format
            #     `projects/{project}/locations/{location}/securityHealthAnalyticsCustomModules/{custom_module}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenterManagement::V1::SecurityHealthAnalyticsCustomModule]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenterManagement::V1::SecurityHealthAnalyticsCustomModule]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center_management/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenterManagement::V1::GetSecurityHealthAnalyticsCustomModuleRequest.new
            #
            #   # Call the get_security_health_analytics_custom_module method.
            #   result = client.get_security_health_analytics_custom_module request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenterManagement::V1::SecurityHealthAnalyticsCustomModule.
            #   p result
            #
            def get_security_health_analytics_custom_module request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenterManagement::V1::GetSecurityHealthAnalyticsCustomModuleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_security_health_analytics_custom_module.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenterManagement::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_security_health_analytics_custom_module.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_security_health_analytics_custom_module.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_management_stub.call_rpc :get_security_health_analytics_custom_module, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a resident
            # {::Google::Cloud::SecurityCenterManagement::V1::SecurityHealthAnalyticsCustomModule SecurityHealthAnalyticsCustomModule}
            # at the scope of the given organization, folder, or project, and also
            # creates inherited `SecurityHealthAnalyticsCustomModule` resources for all
            # folders and projects that are descendants of the given parent. These
            # modules are enabled by default.
            #
            # @overload create_security_health_analytics_custom_module(request, options = nil)
            #   Pass arguments to `create_security_health_analytics_custom_module` via a request object, either of type
            #   {::Google::Cloud::SecurityCenterManagement::V1::CreateSecurityHealthAnalyticsCustomModuleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenterManagement::V1::CreateSecurityHealthAnalyticsCustomModuleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_security_health_analytics_custom_module(parent: nil, security_health_analytics_custom_module: nil, validate_only: nil)
            #   Pass arguments to `create_security_health_analytics_custom_module` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Name of the parent organization, folder, or project of the
            #     module, in one of the following formats:
            #
            #     * `organizations/{organization}/locations/{location}`
            #     * `folders/{folder}/locations/{location}`
            #     * `projects/{project}/locations/{location}`
            #   @param security_health_analytics_custom_module [::Google::Cloud::SecurityCenterManagement::V1::SecurityHealthAnalyticsCustomModule, ::Hash]
            #     Required. The resource being created.
            #   @param validate_only [::Boolean]
            #     Optional. When set to `true`, the request will be validated (including IAM
            #     checks), but no module will be created. An `OK` response indicates that the
            #     request is valid, while an error response indicates that the request is
            #     invalid.
            #
            #     If the request is valid, a subsequent request to create the module could
            #     still fail for one of the following reasons:
            #
            #     *  The state of your cloud resources changed; for example, you lost a
            #        required IAM permission
            #     *  An error occurred during creation of the module
            #
            #     Defaults to `false`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenterManagement::V1::SecurityHealthAnalyticsCustomModule]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenterManagement::V1::SecurityHealthAnalyticsCustomModule]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center_management/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenterManagement::V1::CreateSecurityHealthAnalyticsCustomModuleRequest.new
            #
            #   # Call the create_security_health_analytics_custom_module method.
            #   result = client.create_security_health_analytics_custom_module request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenterManagement::V1::SecurityHealthAnalyticsCustomModule.
            #   p result
            #
            def create_security_health_analytics_custom_module request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenterManagement::V1::CreateSecurityHealthAnalyticsCustomModuleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_security_health_analytics_custom_module.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenterManagement::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_security_health_analytics_custom_module.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_security_health_analytics_custom_module.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_management_stub.call_rpc :create_security_health_analytics_custom_module, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the
            # {::Google::Cloud::SecurityCenterManagement::V1::SecurityHealthAnalyticsCustomModule SecurityHealthAnalyticsCustomModule}
            # under the given name based on the given update mask. Updating the
            # enablement state is supported on both resident and inherited modules
            # (though resident modules cannot have an enablement state of "inherited").
            # Updating the display name and custom configuration of a module is supported
            # on resident modules only.
            #
            # @overload update_security_health_analytics_custom_module(request, options = nil)
            #   Pass arguments to `update_security_health_analytics_custom_module` via a request object, either of type
            #   {::Google::Cloud::SecurityCenterManagement::V1::UpdateSecurityHealthAnalyticsCustomModuleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenterManagement::V1::UpdateSecurityHealthAnalyticsCustomModuleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_security_health_analytics_custom_module(update_mask: nil, security_health_analytics_custom_module: nil, validate_only: nil)
            #   Pass arguments to `update_security_health_analytics_custom_module` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. The fields to update. The following values are valid:
            #
            #     * `custom_config`
            #     * `enablement_state`
            #
            #     If you omit this field or set it to the wildcard value `*`, then all
            #     eligible fields are updated.
            #   @param security_health_analytics_custom_module [::Google::Cloud::SecurityCenterManagement::V1::SecurityHealthAnalyticsCustomModule, ::Hash]
            #     Required. The resource being updated.
            #   @param validate_only [::Boolean]
            #     Optional. When set to `true`, the request will be validated (including IAM
            #     checks), but no module will be updated. An `OK` response indicates that the
            #     request is valid, while an error response indicates that the request is
            #     invalid.
            #
            #     If the request is valid, a subsequent request to update the module could
            #     still fail for one of the following reasons:
            #
            #     *  The state of your cloud resources changed; for example, you lost a
            #        required IAM permission
            #     *  An error occurred during creation of the module
            #
            #     Defaults to `false`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenterManagement::V1::SecurityHealthAnalyticsCustomModule]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenterManagement::V1::SecurityHealthAnalyticsCustomModule]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center_management/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenterManagement::V1::UpdateSecurityHealthAnalyticsCustomModuleRequest.new
            #
            #   # Call the update_security_health_analytics_custom_module method.
            #   result = client.update_security_health_analytics_custom_module request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenterManagement::V1::SecurityHealthAnalyticsCustomModule.
            #   p result
            #
            def update_security_health_analytics_custom_module request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenterManagement::V1::UpdateSecurityHealthAnalyticsCustomModuleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_security_health_analytics_custom_module.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenterManagement::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.security_health_analytics_custom_module&.name
                header_params["security_health_analytics_custom_module.name"] = request.security_health_analytics_custom_module.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_security_health_analytics_custom_module.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_security_health_analytics_custom_module.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_management_stub.call_rpc :update_security_health_analytics_custom_module, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes the specified
            # {::Google::Cloud::SecurityCenterManagement::V1::SecurityHealthAnalyticsCustomModule SecurityHealthAnalyticsCustomModule}
            # and all of its descendants in the resource hierarchy. This method is only
            # supported for resident custom modules.
            #
            # @overload delete_security_health_analytics_custom_module(request, options = nil)
            #   Pass arguments to `delete_security_health_analytics_custom_module` via a request object, either of type
            #   {::Google::Cloud::SecurityCenterManagement::V1::DeleteSecurityHealthAnalyticsCustomModuleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenterManagement::V1::DeleteSecurityHealthAnalyticsCustomModuleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_security_health_analytics_custom_module(name: nil, validate_only: nil)
            #   Pass arguments to `delete_security_health_analytics_custom_module` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the SHA custom module, in one of the
            #     following formats:
            #
            #       * `organizations/{organization}/locations/{location}/securityHealthAnalyticsCustomModules/{custom_module}`
            #       * `folders/{folder}/locations/{location}/securityHealthAnalyticsCustomModules/{custom_module}`
            #       * `projects/{project}/locations/{location}/securityHealthAnalyticsCustomModules/{custom_module}`
            #   @param validate_only [::Boolean]
            #     Optional. When set to `true`, the request will be validated (including IAM
            #     checks), but no module will be deleted. An `OK` response indicates that the
            #     request is valid, while an error response indicates that the request is
            #     invalid.
            #
            #     If the request is valid, a subsequent request to delete the module could
            #     still fail for one of the following reasons:
            #
            #     *  The state of your cloud resources changed; for example, you lost a
            #        required IAM permission
            #     *  An error occurred during deletion of the module
            #
            #     Defaults to `false`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center_management/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenterManagement::V1::DeleteSecurityHealthAnalyticsCustomModuleRequest.new
            #
            #   # Call the delete_security_health_analytics_custom_module method.
            #   result = client.delete_security_health_analytics_custom_module request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_security_health_analytics_custom_module request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenterManagement::V1::DeleteSecurityHealthAnalyticsCustomModuleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_security_health_analytics_custom_module.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenterManagement::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_security_health_analytics_custom_module.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_security_health_analytics_custom_module.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_management_stub.call_rpc :delete_security_health_analytics_custom_module, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Simulates the result of using a
            # {::Google::Cloud::SecurityCenterManagement::V1::SecurityHealthAnalyticsCustomModule SecurityHealthAnalyticsCustomModule}
            # to check a resource.
            #
            # @overload simulate_security_health_analytics_custom_module(request, options = nil)
            #   Pass arguments to `simulate_security_health_analytics_custom_module` via a request object, either of type
            #   {::Google::Cloud::SecurityCenterManagement::V1::SimulateSecurityHealthAnalyticsCustomModuleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenterManagement::V1::SimulateSecurityHealthAnalyticsCustomModuleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload simulate_security_health_analytics_custom_module(parent: nil, custom_config: nil, resource: nil)
            #   Pass arguments to `simulate_security_health_analytics_custom_module` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The relative resource name of the organization, project, or
            #     folder. For more information about relative resource names, see [AIP-122:
            #     Resource names](https://google.aip.dev/122). Example:
            #     `organizations/{organization_id}`.
            #   @param custom_config [::Google::Cloud::SecurityCenterManagement::V1::CustomConfig, ::Hash]
            #     Required. The custom configuration that you need to test.
            #   @param resource [::Google::Cloud::SecurityCenterManagement::V1::SimulateSecurityHealthAnalyticsCustomModuleRequest::SimulatedResource, ::Hash]
            #     Required. Resource data to simulate custom module against.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenterManagement::V1::SimulateSecurityHealthAnalyticsCustomModuleResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenterManagement::V1::SimulateSecurityHealthAnalyticsCustomModuleResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center_management/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenterManagement::V1::SimulateSecurityHealthAnalyticsCustomModuleRequest.new
            #
            #   # Call the simulate_security_health_analytics_custom_module method.
            #   result = client.simulate_security_health_analytics_custom_module request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenterManagement::V1::SimulateSecurityHealthAnalyticsCustomModuleResponse.
            #   p result
            #
            def simulate_security_health_analytics_custom_module request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenterManagement::V1::SimulateSecurityHealthAnalyticsCustomModuleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.simulate_security_health_analytics_custom_module.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenterManagement::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.simulate_security_health_analytics_custom_module.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.simulate_security_health_analytics_custom_module.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_management_stub.call_rpc :simulate_security_health_analytics_custom_module, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists all effective Event Threat Detection custom modules for the
            # given parent. This includes resident modules defined at the scope of the
            # parent along with modules inherited from its ancestors.
            #
            # @overload list_effective_event_threat_detection_custom_modules(request, options = nil)
            #   Pass arguments to `list_effective_event_threat_detection_custom_modules` via a request object, either of type
            #   {::Google::Cloud::SecurityCenterManagement::V1::ListEffectiveEventThreatDetectionCustomModulesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenterManagement::V1::ListEffectiveEventThreatDetectionCustomModulesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_effective_event_threat_detection_custom_modules(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_effective_event_threat_detection_custom_modules` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Name of parent to list effective custom modules, in one of the
            #     following formats:
            #
            #     * `organizations/{organization}/locations/{location}`
            #     * `folders/{folder}/locations/{location}`
            #     * `projects/{project}/locations/{location}`
            #   @param page_size [::Integer]
            #     Optional. The maximum number of results to return in a single response.
            #     Default is 10, minimum is 1, maximum is 1000.
            #   @param page_token [::String]
            #     Optional. A pagination token returned from a previous request. Provide this
            #     token to retrieve the next page of results.
            #
            #     When paginating, the rest of the request must match the request that
            #     generated the page token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenterManagement::V1::EffectiveEventThreatDetectionCustomModule>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenterManagement::V1::EffectiveEventThreatDetectionCustomModule>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center_management/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenterManagement::V1::ListEffectiveEventThreatDetectionCustomModulesRequest.new
            #
            #   # Call the list_effective_event_threat_detection_custom_modules method.
            #   result = client.list_effective_event_threat_detection_custom_modules request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::SecurityCenterManagement::V1::EffectiveEventThreatDetectionCustomModule.
            #     p item
            #   end
            #
            def list_effective_event_threat_detection_custom_modules request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenterManagement::V1::ListEffectiveEventThreatDetectionCustomModulesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_effective_event_threat_detection_custom_modules.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenterManagement::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_effective_event_threat_detection_custom_modules.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_effective_event_threat_detection_custom_modules.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_management_stub.call_rpc :list_effective_event_threat_detection_custom_modules, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @security_center_management_stub, :list_effective_event_threat_detection_custom_modules, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets the effective Event Threat Detection custom module at the given level.
            #
            # The difference between an
            # {::Google::Cloud::SecurityCenterManagement::V1::EffectiveEventThreatDetectionCustomModule EffectiveEventThreatDetectionCustomModule}
            # and an
            # {::Google::Cloud::SecurityCenterManagement::V1::EventThreatDetectionCustomModule EventThreatDetectionCustomModule}
            # is that the fields for an `EffectiveEventThreatDetectionCustomModule` are
            # computed from ancestors if needed. For example, the enablement state for an
            # `EventThreatDetectionCustomModule` can be `ENABLED`, `DISABLED`, or
            # `INHERITED`. In contrast, the enablement state for an
            # `EffectiveEventThreatDetectionCustomModule` is always computed as `ENABLED`
            # or `DISABLED`.
            #
            # @overload get_effective_event_threat_detection_custom_module(request, options = nil)
            #   Pass arguments to `get_effective_event_threat_detection_custom_module` via a request object, either of type
            #   {::Google::Cloud::SecurityCenterManagement::V1::GetEffectiveEventThreatDetectionCustomModuleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenterManagement::V1::GetEffectiveEventThreatDetectionCustomModuleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_effective_event_threat_detection_custom_module(name: nil)
            #   Pass arguments to `get_effective_event_threat_detection_custom_module` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the Event Threat Detection custom module, in
            #     one of the following formats:
            #
            #     * `organizations/{organization}/locations/{location}/effectiveEventThreatDetectionCustomModules/{custom_module}`
            #     * `folders/{folder}/locations/{location}/effectiveEventThreatDetectionCustomModules/{custom_module}`
            #     * `projects/{project}/locations/{location}/effectiveEventThreatDetectionCustomModules/{custom_module}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenterManagement::V1::EffectiveEventThreatDetectionCustomModule]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenterManagement::V1::EffectiveEventThreatDetectionCustomModule]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center_management/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenterManagement::V1::GetEffectiveEventThreatDetectionCustomModuleRequest.new
            #
            #   # Call the get_effective_event_threat_detection_custom_module method.
            #   result = client.get_effective_event_threat_detection_custom_module request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenterManagement::V1::EffectiveEventThreatDetectionCustomModule.
            #   p result
            #
            def get_effective_event_threat_detection_custom_module request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenterManagement::V1::GetEffectiveEventThreatDetectionCustomModuleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_effective_event_threat_detection_custom_module.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenterManagement::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_effective_event_threat_detection_custom_module.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_effective_event_threat_detection_custom_module.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_management_stub.call_rpc :get_effective_event_threat_detection_custom_module, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists all Event Threat Detection custom modules for the given organization,
            # folder, or project. This includes resident modules defined at the scope of
            # the parent along with modules inherited from ancestors.
            #
            # @overload list_event_threat_detection_custom_modules(request, options = nil)
            #   Pass arguments to `list_event_threat_detection_custom_modules` via a request object, either of type
            #   {::Google::Cloud::SecurityCenterManagement::V1::ListEventThreatDetectionCustomModulesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenterManagement::V1::ListEventThreatDetectionCustomModulesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_event_threat_detection_custom_modules(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_event_threat_detection_custom_modules` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Name of parent to list custom modules, in one of the following
            #     formats:
            #
            #     * `organizations/{organization}/locations/{location}`
            #     * `folders/{folder}/locations/{location}`
            #     * `projects/{project}/locations/{location}`
            #   @param page_size [::Integer]
            #     Optional. The maximum number of modules to return. The service may return
            #     fewer than this value. If unspecified, at most 10 modules will be returned.
            #     The maximum value is 1000; values above 1000 will be coerced to 1000.
            #   @param page_token [::String]
            #     Optional. A pagination token returned from a previous request. Provide this
            #     token to retrieve the next page of results.
            #
            #     When paginating, the rest of the request must match the request that
            #     generated the page token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenterManagement::V1::EventThreatDetectionCustomModule>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenterManagement::V1::EventThreatDetectionCustomModule>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center_management/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenterManagement::V1::ListEventThreatDetectionCustomModulesRequest.new
            #
            #   # Call the list_event_threat_detection_custom_modules method.
            #   result = client.list_event_threat_detection_custom_modules request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::SecurityCenterManagement::V1::EventThreatDetectionCustomModule.
            #     p item
            #   end
            #
            def list_event_threat_detection_custom_modules request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenterManagement::V1::ListEventThreatDetectionCustomModulesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_event_threat_detection_custom_modules.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenterManagement::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_event_threat_detection_custom_modules.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_event_threat_detection_custom_modules.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_management_stub.call_rpc :list_event_threat_detection_custom_modules, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @security_center_management_stub, :list_event_threat_detection_custom_modules, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists all resident Event Threat Detection custom modules for the given
            # organization, folder, or project and its descendants.
            #
            # @overload list_descendant_event_threat_detection_custom_modules(request, options = nil)
            #   Pass arguments to `list_descendant_event_threat_detection_custom_modules` via a request object, either of type
            #   {::Google::Cloud::SecurityCenterManagement::V1::ListDescendantEventThreatDetectionCustomModulesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenterManagement::V1::ListDescendantEventThreatDetectionCustomModulesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_descendant_event_threat_detection_custom_modules(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_descendant_event_threat_detection_custom_modules` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Name of parent to list custom modules, in one of the following
            #     formats:
            #
            #     * `organizations/{organization}/locations/{location}`
            #     * `folders/{folder}/locations/{location}`
            #     * `projects/{project}/locations/{location}`
            #   @param page_size [::Integer]
            #     Optional. The maximum number of modules to return. The service may return
            #     fewer than this value. If unspecified, at most 10 configs will be returned.
            #     The maximum value is 1000; values above 1000 will be coerced to 1000.
            #   @param page_token [::String]
            #     Optional. A pagination token returned from a previous request. Provide this
            #     token to retrieve the next page of results.
            #
            #     When paginating, the rest of the request must match the request that
            #     generated the page token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenterManagement::V1::EventThreatDetectionCustomModule>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenterManagement::V1::EventThreatDetectionCustomModule>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center_management/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenterManagement::V1::ListDescendantEventThreatDetectionCustomModulesRequest.new
            #
            #   # Call the list_descendant_event_threat_detection_custom_modules method.
            #   result = client.list_descendant_event_threat_detection_custom_modules request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::SecurityCenterManagement::V1::EventThreatDetectionCustomModule.
            #     p item
            #   end
            #
            def list_descendant_event_threat_detection_custom_modules request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenterManagement::V1::ListDescendantEventThreatDetectionCustomModulesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_descendant_event_threat_detection_custom_modules.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenterManagement::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_descendant_event_threat_detection_custom_modules.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_descendant_event_threat_detection_custom_modules.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_management_stub.call_rpc :list_descendant_event_threat_detection_custom_modules, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @security_center_management_stub, :list_descendant_event_threat_detection_custom_modules, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets an Event Threat Detection custom module.
            #
            # @overload get_event_threat_detection_custom_module(request, options = nil)
            #   Pass arguments to `get_event_threat_detection_custom_module` via a request object, either of type
            #   {::Google::Cloud::SecurityCenterManagement::V1::GetEventThreatDetectionCustomModuleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenterManagement::V1::GetEventThreatDetectionCustomModuleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_event_threat_detection_custom_module(name: nil)
            #   Pass arguments to `get_event_threat_detection_custom_module` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the Event Threat Detection custom module, in
            #     one of the following formats:
            #
            #     * `organizations/{organization}/locations/{location}/eventThreatDetectionCustomModules/{custom_module}`
            #     * `folders/{folder}/locations/{location}/eventThreatDetectionCustomModules/{custom_module}`
            #     * `projects/{project}/locations/{location}/eventThreatDetectionCustomModules/{custom_module}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenterManagement::V1::EventThreatDetectionCustomModule]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenterManagement::V1::EventThreatDetectionCustomModule]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center_management/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenterManagement::V1::GetEventThreatDetectionCustomModuleRequest.new
            #
            #   # Call the get_event_threat_detection_custom_module method.
            #   result = client.get_event_threat_detection_custom_module request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenterManagement::V1::EventThreatDetectionCustomModule.
            #   p result
            #
            def get_event_threat_detection_custom_module request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenterManagement::V1::GetEventThreatDetectionCustomModuleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_event_threat_detection_custom_module.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenterManagement::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_event_threat_detection_custom_module.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_event_threat_detection_custom_module.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_management_stub.call_rpc :get_event_threat_detection_custom_module, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a resident Event Threat Detection custom module at the scope of the
            # given organization, folder, or project, and creates inherited custom
            # modules for all descendants of the given parent. These modules are enabled
            # by default.
            #
            # @overload create_event_threat_detection_custom_module(request, options = nil)
            #   Pass arguments to `create_event_threat_detection_custom_module` via a request object, either of type
            #   {::Google::Cloud::SecurityCenterManagement::V1::CreateEventThreatDetectionCustomModuleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenterManagement::V1::CreateEventThreatDetectionCustomModuleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_event_threat_detection_custom_module(parent: nil, event_threat_detection_custom_module: nil, validate_only: nil)
            #   Pass arguments to `create_event_threat_detection_custom_module` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Name of parent for the module, in one of the following formats:
            #
            #     * `organizations/{organization}/locations/{location}`
            #     * `folders/{folder}/locations/{location}`
            #     * `projects/{project}/locations/{location}`
            #   @param event_threat_detection_custom_module [::Google::Cloud::SecurityCenterManagement::V1::EventThreatDetectionCustomModule, ::Hash]
            #     Required. The module to create. The
            #     {::Google::Cloud::SecurityCenterManagement::V1::EventThreatDetectionCustomModule#name EventThreatDetectionCustomModule.name}
            #     field is ignored; Security Command Center generates the name.
            #   @param validate_only [::Boolean]
            #     Optional. When set to `true`, the request will be validated (including IAM
            #     checks), but no module will be created. An `OK` response indicates that the
            #     request is valid, while an error response indicates that the request is
            #     invalid.
            #
            #     If the request is valid, a subsequent request to create the module could
            #     still fail for one of the following reasons:
            #
            #     *  The state of your cloud resources changed; for example, you lost a
            #        required IAM permission
            #     *  An error occurred during creation of the module
            #
            #     Defaults to `false`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenterManagement::V1::EventThreatDetectionCustomModule]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenterManagement::V1::EventThreatDetectionCustomModule]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center_management/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenterManagement::V1::CreateEventThreatDetectionCustomModuleRequest.new
            #
            #   # Call the create_event_threat_detection_custom_module method.
            #   result = client.create_event_threat_detection_custom_module request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenterManagement::V1::EventThreatDetectionCustomModule.
            #   p result
            #
            def create_event_threat_detection_custom_module request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenterManagement::V1::CreateEventThreatDetectionCustomModuleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_event_threat_detection_custom_module.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenterManagement::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_event_threat_detection_custom_module.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_event_threat_detection_custom_module.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_management_stub.call_rpc :create_event_threat_detection_custom_module, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the Event Threat Detection custom module with the given name based
            # on the given update mask. Updating the enablement state is supported for
            # both resident and inherited modules (though resident modules cannot have an
            # enablement state of "inherited"). Updating the display name or
            # configuration of a module is supported for resident modules only. The type
            # of a module cannot be changed.
            #
            # @overload update_event_threat_detection_custom_module(request, options = nil)
            #   Pass arguments to `update_event_threat_detection_custom_module` via a request object, either of type
            #   {::Google::Cloud::SecurityCenterManagement::V1::UpdateEventThreatDetectionCustomModuleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenterManagement::V1::UpdateEventThreatDetectionCustomModuleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_event_threat_detection_custom_module(update_mask: nil, event_threat_detection_custom_module: nil, validate_only: nil)
            #   Pass arguments to `update_event_threat_detection_custom_module` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. The fields to update. If omitted, then all fields are updated.
            #   @param event_threat_detection_custom_module [::Google::Cloud::SecurityCenterManagement::V1::EventThreatDetectionCustomModule, ::Hash]
            #     Required. The module being updated.
            #   @param validate_only [::Boolean]
            #     Optional. When set to `true`, the request will be validated (including IAM
            #     checks), but no module will be updated. An `OK` response indicates that the
            #     request is valid, while an error response indicates that the request is
            #     invalid.
            #
            #     If the request is valid, a subsequent request to update the module could
            #     still fail for one of the following reasons:
            #
            #     *  The state of your cloud resources changed; for example, you lost a
            #        required IAM permission
            #     *  An error occurred during creation of the module
            #
            #     Defaults to `false`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenterManagement::V1::EventThreatDetectionCustomModule]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenterManagement::V1::EventThreatDetectionCustomModule]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center_management/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenterManagement::V1::UpdateEventThreatDetectionCustomModuleRequest.new
            #
            #   # Call the update_event_threat_detection_custom_module method.
            #   result = client.update_event_threat_detection_custom_module request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenterManagement::V1::EventThreatDetectionCustomModule.
            #   p result
            #
            def update_event_threat_detection_custom_module request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenterManagement::V1::UpdateEventThreatDetectionCustomModuleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_event_threat_detection_custom_module.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenterManagement::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.event_threat_detection_custom_module&.name
                header_params["event_threat_detection_custom_module.name"] = request.event_threat_detection_custom_module.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_event_threat_detection_custom_module.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_event_threat_detection_custom_module.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_management_stub.call_rpc :update_event_threat_detection_custom_module, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes the specified Event Threat Detection custom module and all of its
            # descendants in the resource hierarchy. This method is only supported for
            # resident custom modules.
            #
            # @overload delete_event_threat_detection_custom_module(request, options = nil)
            #   Pass arguments to `delete_event_threat_detection_custom_module` via a request object, either of type
            #   {::Google::Cloud::SecurityCenterManagement::V1::DeleteEventThreatDetectionCustomModuleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenterManagement::V1::DeleteEventThreatDetectionCustomModuleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_event_threat_detection_custom_module(name: nil, validate_only: nil)
            #   Pass arguments to `delete_event_threat_detection_custom_module` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the Event Threat Detection custom module, in
            #     one of the following formats:
            #
            #     * `organizations/{organization}/locations/{location}/eventThreatDetectionCustomModules/{custom_module}`
            #     * `folders/{folder}/locations/{location}/eventThreatDetectionCustomModules/{custom_module}`
            #     * `projects/{project}/locations/{location}/eventThreatDetectionCustomModules/{custom_module}`
            #   @param validate_only [::Boolean]
            #     Optional. When set to `true`, the request will be validated (including IAM
            #     checks), but no module will be deleted. An `OK` response indicates that the
            #     request is valid, while an error response indicates that the request is
            #     invalid.
            #
            #     If the request is valid, a subsequent request to delete the module could
            #     still fail for one of the following reasons:
            #
            #     *  The state of your cloud resources changed; for example, you lost a
            #        required IAM permission
            #     *  An error occurred during creation of the module
            #
            #     Defaults to `false`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center_management/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenterManagement::V1::DeleteEventThreatDetectionCustomModuleRequest.new
            #
            #   # Call the delete_event_threat_detection_custom_module method.
            #   result = client.delete_event_threat_detection_custom_module request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_event_threat_detection_custom_module request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenterManagement::V1::DeleteEventThreatDetectionCustomModuleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_event_threat_detection_custom_module.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenterManagement::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_event_threat_detection_custom_module.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_event_threat_detection_custom_module.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_management_stub.call_rpc :delete_event_threat_detection_custom_module, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Validates the given Event Threat Detection custom module.
            #
            # @overload validate_event_threat_detection_custom_module(request, options = nil)
            #   Pass arguments to `validate_event_threat_detection_custom_module` via a request object, either of type
            #   {::Google::Cloud::SecurityCenterManagement::V1::ValidateEventThreatDetectionCustomModuleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenterManagement::V1::ValidateEventThreatDetectionCustomModuleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload validate_event_threat_detection_custom_module(parent: nil, raw_text: nil, type: nil)
            #   Pass arguments to `validate_event_threat_detection_custom_module` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Resource name of the parent to validate the custom modules under,
            #     in one of the following formats:
            #
            #     * `organizations/{organization}/locations/{location}`
            #   @param raw_text [::String]
            #     Required. The raw text of the module's contents. Used to generate error
            #     messages.
            #   @param type [::String]
            #     Required. The type of the module. For example, `CONFIGURABLE_BAD_IP`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenterManagement::V1::ValidateEventThreatDetectionCustomModuleResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenterManagement::V1::ValidateEventThreatDetectionCustomModuleResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center_management/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenterManagement::V1::ValidateEventThreatDetectionCustomModuleRequest.new
            #
            #   # Call the validate_event_threat_detection_custom_module method.
            #   result = client.validate_event_threat_detection_custom_module request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenterManagement::V1::ValidateEventThreatDetectionCustomModuleResponse.
            #   p result
            #
            def validate_event_threat_detection_custom_module request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenterManagement::V1::ValidateEventThreatDetectionCustomModuleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.validate_event_threat_detection_custom_module.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenterManagement::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.validate_event_threat_detection_custom_module.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.validate_event_threat_detection_custom_module.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_management_stub.call_rpc :validate_event_threat_detection_custom_module, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets service settings for the specified Security Command Center service.
            #
            # @overload get_security_center_service(request, options = nil)
            #   Pass arguments to `get_security_center_service` via a request object, either of type
            #   {::Google::Cloud::SecurityCenterManagement::V1::GetSecurityCenterServiceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenterManagement::V1::GetSecurityCenterServiceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_security_center_service(name: nil, show_eligible_modules_only: nil)
            #   Pass arguments to `get_security_center_service` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The Security Command Center service to retrieve, in one of the
            #     following formats:
            #
            #     * organizations/\\{organization}/locations/\\{location}/securityCenterServices/\\{service}
            #     * folders/\\{folder}/locations/\\{location}/securityCenterServices/\\{service}
            #     * projects/\\{project}/locations/\\{location}/securityCenterServices/\\{service}
            #
            #     The following values are valid for `{service}`:
            #
            #     * `container-threat-detection`
            #     * `event-threat-detection`
            #     * `security-health-analytics`
            #     * `vm-threat-detection`
            #     * `web-security-scanner`
            #   @param show_eligible_modules_only [::Boolean]
            #     Set to `true` to show only modules that are in scope. By default, all
            #     modules are shown.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterService]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterService]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center_management/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenterManagement::V1::GetSecurityCenterServiceRequest.new
            #
            #   # Call the get_security_center_service method.
            #   result = client.get_security_center_service request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenterManagement::V1::SecurityCenterService.
            #   p result
            #
            def get_security_center_service request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenterManagement::V1::GetSecurityCenterServiceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_security_center_service.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenterManagement::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_security_center_service.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_security_center_service.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_management_stub.call_rpc :get_security_center_service, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns a list of all Security Command Center services for the given
            # parent.
            #
            # @overload list_security_center_services(request, options = nil)
            #   Pass arguments to `list_security_center_services` via a request object, either of type
            #   {::Google::Cloud::SecurityCenterManagement::V1::ListSecurityCenterServicesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenterManagement::V1::ListSecurityCenterServicesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_security_center_services(parent: nil, page_size: nil, page_token: nil, show_eligible_modules_only: nil)
            #   Pass arguments to `list_security_center_services` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The name of the parent to list Security Command Center services,
            #     in one of the following formats:
            #
            #     * `organizations/{organization}/locations/{location}`
            #     * `folders/{folder}/locations/{location}`
            #     * `projects/{project}/locations/{location}`
            #   @param page_size [::Integer]
            #     Optional. The maximum number of results to return in a single response.
            #     Default is 10, minimum is 1, maximum is 1000.
            #   @param page_token [::String]
            #     Optional. A pagination token returned from a previous request. Provide this
            #     token to retrieve the next page of results.
            #
            #     When paginating, the rest of the request must match the request that
            #     generated the page token.
            #   @param show_eligible_modules_only [::Boolean]
            #     Flag that, when set, is used to filter the module settings that are shown.
            #     The default setting is that all modules are shown.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterService>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterService>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center_management/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenterManagement::V1::ListSecurityCenterServicesRequest.new
            #
            #   # Call the list_security_center_services method.
            #   result = client.list_security_center_services request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterService.
            #     p item
            #   end
            #
            def list_security_center_services request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenterManagement::V1::ListSecurityCenterServicesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_security_center_services.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenterManagement::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_security_center_services.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_security_center_services.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_management_stub.call_rpc :list_security_center_services, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @security_center_management_stub, :list_security_center_services, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a Security Command Center service using the given update mask.
            #
            # @overload update_security_center_service(request, options = nil)
            #   Pass arguments to `update_security_center_service` via a request object, either of type
            #   {::Google::Cloud::SecurityCenterManagement::V1::UpdateSecurityCenterServiceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenterManagement::V1::UpdateSecurityCenterServiceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_security_center_service(security_center_service: nil, update_mask: nil, validate_only: nil)
            #   Pass arguments to `update_security_center_service` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param security_center_service [::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterService, ::Hash]
            #     Required. The updated service.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. The fields to update. Accepts the following values:
            #
            #     * `intended_enablement_state`
            #     * `modules`
            #
            #     If omitted, then all eligible fields are updated.
            #   @param validate_only [::Boolean]
            #     Optional. When set to `true`, the request will be validated (including IAM
            #     checks), but no service will be updated. An `OK` response indicates that
            #     the request is valid, while an error response indicates that the request is
            #     invalid.
            #
            #     If the request is valid, a subsequent request to update the service could
            #     still fail for one of the following reasons:
            #
            #     *  The state of your cloud resources changed; for example, you lost a
            #        required IAM permission
            #     *  An error occurred during update of the service
            #
            #     Defaults to `false`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterService]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterService]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center_management/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenterManagement::V1::UpdateSecurityCenterServiceRequest.new
            #
            #   # Call the update_security_center_service method.
            #   result = client.update_security_center_service request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenterManagement::V1::SecurityCenterService.
            #   p result
            #
            def update_security_center_service request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenterManagement::V1::UpdateSecurityCenterServiceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_security_center_service.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenterManagement::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.security_center_service&.name
                header_params["security_center_service.name"] = request.security_center_service.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_security_center_service.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_security_center_service.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_management_stub.call_rpc :update_security_center_service, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the SecurityCenterManagement API.
            #
            # This class represents the configuration for SecurityCenterManagement,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # list_effective_security_health_analytics_custom_modules to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_effective_security_health_analytics_custom_modules.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_effective_security_health_analytics_custom_modules.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::SecurityCenterManagement::V1::SecurityCenterManagement::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "securitycentermanagement.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the SecurityCenterManagement API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `list_effective_security_health_analytics_custom_modules`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_effective_security_health_analytics_custom_modules
                ##
                # RPC-specific configuration for `get_effective_security_health_analytics_custom_module`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_effective_security_health_analytics_custom_module
                ##
                # RPC-specific configuration for `list_security_health_analytics_custom_modules`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_security_health_analytics_custom_modules
                ##
                # RPC-specific configuration for `list_descendant_security_health_analytics_custom_modules`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_descendant_security_health_analytics_custom_modules
                ##
                # RPC-specific configuration for `get_security_health_analytics_custom_module`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_security_health_analytics_custom_module
                ##
                # RPC-specific configuration for `create_security_health_analytics_custom_module`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_security_health_analytics_custom_module
                ##
                # RPC-specific configuration for `update_security_health_analytics_custom_module`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_security_health_analytics_custom_module
                ##
                # RPC-specific configuration for `delete_security_health_analytics_custom_module`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_security_health_analytics_custom_module
                ##
                # RPC-specific configuration for `simulate_security_health_analytics_custom_module`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :simulate_security_health_analytics_custom_module
                ##
                # RPC-specific configuration for `list_effective_event_threat_detection_custom_modules`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_effective_event_threat_detection_custom_modules
                ##
                # RPC-specific configuration for `get_effective_event_threat_detection_custom_module`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_effective_event_threat_detection_custom_module
                ##
                # RPC-specific configuration for `list_event_threat_detection_custom_modules`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_event_threat_detection_custom_modules
                ##
                # RPC-specific configuration for `list_descendant_event_threat_detection_custom_modules`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_descendant_event_threat_detection_custom_modules
                ##
                # RPC-specific configuration for `get_event_threat_detection_custom_module`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_event_threat_detection_custom_module
                ##
                # RPC-specific configuration for `create_event_threat_detection_custom_module`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_event_threat_detection_custom_module
                ##
                # RPC-specific configuration for `update_event_threat_detection_custom_module`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_event_threat_detection_custom_module
                ##
                # RPC-specific configuration for `delete_event_threat_detection_custom_module`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_event_threat_detection_custom_module
                ##
                # RPC-specific configuration for `validate_event_threat_detection_custom_module`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :validate_event_threat_detection_custom_module
                ##
                # RPC-specific configuration for `get_security_center_service`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_security_center_service
                ##
                # RPC-specific configuration for `list_security_center_services`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_security_center_services
                ##
                # RPC-specific configuration for `update_security_center_service`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_security_center_service

                # @private
                def initialize parent_rpcs = nil
                  list_effective_security_health_analytics_custom_modules_config = parent_rpcs.list_effective_security_health_analytics_custom_modules if parent_rpcs.respond_to? :list_effective_security_health_analytics_custom_modules
                  @list_effective_security_health_analytics_custom_modules = ::Gapic::Config::Method.new list_effective_security_health_analytics_custom_modules_config
                  get_effective_security_health_analytics_custom_module_config = parent_rpcs.get_effective_security_health_analytics_custom_module if parent_rpcs.respond_to? :get_effective_security_health_analytics_custom_module
                  @get_effective_security_health_analytics_custom_module = ::Gapic::Config::Method.new get_effective_security_health_analytics_custom_module_config
                  list_security_health_analytics_custom_modules_config = parent_rpcs.list_security_health_analytics_custom_modules if parent_rpcs.respond_to? :list_security_health_analytics_custom_modules
                  @list_security_health_analytics_custom_modules = ::Gapic::Config::Method.new list_security_health_analytics_custom_modules_config
                  list_descendant_security_health_analytics_custom_modules_config = parent_rpcs.list_descendant_security_health_analytics_custom_modules if parent_rpcs.respond_to? :list_descendant_security_health_analytics_custom_modules
                  @list_descendant_security_health_analytics_custom_modules = ::Gapic::Config::Method.new list_descendant_security_health_analytics_custom_modules_config
                  get_security_health_analytics_custom_module_config = parent_rpcs.get_security_health_analytics_custom_module if parent_rpcs.respond_to? :get_security_health_analytics_custom_module
                  @get_security_health_analytics_custom_module = ::Gapic::Config::Method.new get_security_health_analytics_custom_module_config
                  create_security_health_analytics_custom_module_config = parent_rpcs.create_security_health_analytics_custom_module if parent_rpcs.respond_to? :create_security_health_analytics_custom_module
                  @create_security_health_analytics_custom_module = ::Gapic::Config::Method.new create_security_health_analytics_custom_module_config
                  update_security_health_analytics_custom_module_config = parent_rpcs.update_security_health_analytics_custom_module if parent_rpcs.respond_to? :update_security_health_analytics_custom_module
                  @update_security_health_analytics_custom_module = ::Gapic::Config::Method.new update_security_health_analytics_custom_module_config
                  delete_security_health_analytics_custom_module_config = parent_rpcs.delete_security_health_analytics_custom_module if parent_rpcs.respond_to? :delete_security_health_analytics_custom_module
                  @delete_security_health_analytics_custom_module = ::Gapic::Config::Method.new delete_security_health_analytics_custom_module_config
                  simulate_security_health_analytics_custom_module_config = parent_rpcs.simulate_security_health_analytics_custom_module if parent_rpcs.respond_to? :simulate_security_health_analytics_custom_module
                  @simulate_security_health_analytics_custom_module = ::Gapic::Config::Method.new simulate_security_health_analytics_custom_module_config
                  list_effective_event_threat_detection_custom_modules_config = parent_rpcs.list_effective_event_threat_detection_custom_modules if parent_rpcs.respond_to? :list_effective_event_threat_detection_custom_modules
                  @list_effective_event_threat_detection_custom_modules = ::Gapic::Config::Method.new list_effective_event_threat_detection_custom_modules_config
                  get_effective_event_threat_detection_custom_module_config = parent_rpcs.get_effective_event_threat_detection_custom_module if parent_rpcs.respond_to? :get_effective_event_threat_detection_custom_module
                  @get_effective_event_threat_detection_custom_module = ::Gapic::Config::Method.new get_effective_event_threat_detection_custom_module_config
                  list_event_threat_detection_custom_modules_config = parent_rpcs.list_event_threat_detection_custom_modules if parent_rpcs.respond_to? :list_event_threat_detection_custom_modules
                  @list_event_threat_detection_custom_modules = ::Gapic::Config::Method.new list_event_threat_detection_custom_modules_config
                  list_descendant_event_threat_detection_custom_modules_config = parent_rpcs.list_descendant_event_threat_detection_custom_modules if parent_rpcs.respond_to? :list_descendant_event_threat_detection_custom_modules
                  @list_descendant_event_threat_detection_custom_modules = ::Gapic::Config::Method.new list_descendant_event_threat_detection_custom_modules_config
                  get_event_threat_detection_custom_module_config = parent_rpcs.get_event_threat_detection_custom_module if parent_rpcs.respond_to? :get_event_threat_detection_custom_module
                  @get_event_threat_detection_custom_module = ::Gapic::Config::Method.new get_event_threat_detection_custom_module_config
                  create_event_threat_detection_custom_module_config = parent_rpcs.create_event_threat_detection_custom_module if parent_rpcs.respond_to? :create_event_threat_detection_custom_module
                  @create_event_threat_detection_custom_module = ::Gapic::Config::Method.new create_event_threat_detection_custom_module_config
                  update_event_threat_detection_custom_module_config = parent_rpcs.update_event_threat_detection_custom_module if parent_rpcs.respond_to? :update_event_threat_detection_custom_module
                  @update_event_threat_detection_custom_module = ::Gapic::Config::Method.new update_event_threat_detection_custom_module_config
                  delete_event_threat_detection_custom_module_config = parent_rpcs.delete_event_threat_detection_custom_module if parent_rpcs.respond_to? :delete_event_threat_detection_custom_module
                  @delete_event_threat_detection_custom_module = ::Gapic::Config::Method.new delete_event_threat_detection_custom_module_config
                  validate_event_threat_detection_custom_module_config = parent_rpcs.validate_event_threat_detection_custom_module if parent_rpcs.respond_to? :validate_event_threat_detection_custom_module
                  @validate_event_threat_detection_custom_module = ::Gapic::Config::Method.new validate_event_threat_detection_custom_module_config
                  get_security_center_service_config = parent_rpcs.get_security_center_service if parent_rpcs.respond_to? :get_security_center_service
                  @get_security_center_service = ::Gapic::Config::Method.new get_security_center_service_config
                  list_security_center_services_config = parent_rpcs.list_security_center_services if parent_rpcs.respond_to? :list_security_center_services
                  @list_security_center_services = ::Gapic::Config::Method.new list_security_center_services_config
                  update_security_center_service_config = parent_rpcs.update_security_center_service if parent_rpcs.respond_to? :update_security_center_service
                  @update_security_center_service = ::Gapic::Config::Method.new update_security_center_service_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
