# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/securitycenter/v2/securitycenter_service_pb"
require "google/cloud/security_center/v2/security_center"

class ::Google::Cloud::SecurityCenter::V2::SecurityCenter::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_batch_create_resource_value_configs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V2::BatchCreateResourceValueConfigsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    requests = [{}]

    batch_create_resource_value_configs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :batch_create_resource_value_configs, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V2::BatchCreateResourceValueConfigsRequest, request
      assert_equal "hello world", request["parent"]
      assert_kind_of ::Google::Cloud::SecurityCenter::V2::CreateResourceValueConfigRequest, request["requests"].first
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, batch_create_resource_value_configs_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.batch_create_resource_value_configs({ parent: parent, requests: requests }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.batch_create_resource_value_configs parent: parent, requests: requests do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.batch_create_resource_value_configs ::Google::Cloud::SecurityCenter::V2::BatchCreateResourceValueConfigsRequest.new(parent: parent, requests: requests) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.batch_create_resource_value_configs({ parent: parent, requests: requests }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.batch_create_resource_value_configs(::Google::Cloud::SecurityCenter::V2::BatchCreateResourceValueConfigsRequest.new(parent: parent, requests: requests), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, batch_create_resource_value_configs_client_stub.call_rpc_count
    end
  end

  def test_bulk_mute_findings
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    mute_state = :MUTE_STATE_UNSPECIFIED

    bulk_mute_findings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :bulk_mute_findings, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V2::BulkMuteFindingsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal :MUTE_STATE_UNSPECIFIED, request["mute_state"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, bulk_mute_findings_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.bulk_mute_findings({ parent: parent, filter: filter, mute_state: mute_state }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.bulk_mute_findings parent: parent, filter: filter, mute_state: mute_state do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.bulk_mute_findings ::Google::Cloud::SecurityCenter::V2::BulkMuteFindingsRequest.new(parent: parent, filter: filter, mute_state: mute_state) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.bulk_mute_findings({ parent: parent, filter: filter, mute_state: mute_state }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.bulk_mute_findings(::Google::Cloud::SecurityCenter::V2::BulkMuteFindingsRequest.new(parent: parent, filter: filter, mute_state: mute_state), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, bulk_mute_findings_client_stub.call_rpc_count
    end
  end

  def test_create_big_query_export
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V2::BigQueryExport.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    big_query_export = {}
    big_query_export_id = "hello world"

    create_big_query_export_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_big_query_export, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V2::CreateBigQueryExportRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecurityCenter::V2::BigQueryExport), request["big_query_export"]
      assert_equal "hello world", request["big_query_export_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_big_query_export_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_big_query_export({ parent: parent, big_query_export: big_query_export, big_query_export_id: big_query_export_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_big_query_export parent: parent, big_query_export: big_query_export, big_query_export_id: big_query_export_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_big_query_export ::Google::Cloud::SecurityCenter::V2::CreateBigQueryExportRequest.new(parent: parent, big_query_export: big_query_export, big_query_export_id: big_query_export_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_big_query_export({ parent: parent, big_query_export: big_query_export, big_query_export_id: big_query_export_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_big_query_export(::Google::Cloud::SecurityCenter::V2::CreateBigQueryExportRequest.new(parent: parent, big_query_export: big_query_export, big_query_export_id: big_query_export_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_big_query_export_client_stub.call_rpc_count
    end
  end

  def test_create_finding
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V2::Finding.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    finding_id = "hello world"
    finding = {}

    create_finding_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_finding, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V2::CreateFindingRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["finding_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecurityCenter::V2::Finding), request["finding"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_finding_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_finding({ parent: parent, finding_id: finding_id, finding: finding }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_finding parent: parent, finding_id: finding_id, finding: finding do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_finding ::Google::Cloud::SecurityCenter::V2::CreateFindingRequest.new(parent: parent, finding_id: finding_id, finding: finding) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_finding({ parent: parent, finding_id: finding_id, finding: finding }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_finding(::Google::Cloud::SecurityCenter::V2::CreateFindingRequest.new(parent: parent, finding_id: finding_id, finding: finding), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_finding_client_stub.call_rpc_count
    end
  end

  def test_create_mute_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V2::MuteConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    mute_config = {}
    mute_config_id = "hello world"

    create_mute_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_mute_config, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V2::CreateMuteConfigRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecurityCenter::V2::MuteConfig), request["mute_config"]
      assert_equal "hello world", request["mute_config_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_mute_config_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_mute_config({ parent: parent, mute_config: mute_config, mute_config_id: mute_config_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_mute_config parent: parent, mute_config: mute_config, mute_config_id: mute_config_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_mute_config ::Google::Cloud::SecurityCenter::V2::CreateMuteConfigRequest.new(parent: parent, mute_config: mute_config, mute_config_id: mute_config_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_mute_config({ parent: parent, mute_config: mute_config, mute_config_id: mute_config_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_mute_config(::Google::Cloud::SecurityCenter::V2::CreateMuteConfigRequest.new(parent: parent, mute_config: mute_config, mute_config_id: mute_config_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_mute_config_client_stub.call_rpc_count
    end
  end

  def test_create_notification_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V2::NotificationConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    config_id = "hello world"
    notification_config = {}

    create_notification_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_notification_config, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V2::CreateNotificationConfigRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["config_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecurityCenter::V2::NotificationConfig), request["notification_config"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_notification_config_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_notification_config({ parent: parent, config_id: config_id, notification_config: notification_config }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_notification_config parent: parent, config_id: config_id, notification_config: notification_config do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_notification_config ::Google::Cloud::SecurityCenter::V2::CreateNotificationConfigRequest.new(parent: parent, config_id: config_id, notification_config: notification_config) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_notification_config({ parent: parent, config_id: config_id, notification_config: notification_config }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_notification_config(::Google::Cloud::SecurityCenter::V2::CreateNotificationConfigRequest.new(parent: parent, config_id: config_id, notification_config: notification_config), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_notification_config_client_stub.call_rpc_count
    end
  end

  def test_create_source
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V2::Source.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    source = {}

    create_source_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_source, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V2::CreateSourceRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecurityCenter::V2::Source), request["source"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_source_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_source({ parent: parent, source: source }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_source parent: parent, source: source do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_source ::Google::Cloud::SecurityCenter::V2::CreateSourceRequest.new(parent: parent, source: source) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_source({ parent: parent, source: source }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_source(::Google::Cloud::SecurityCenter::V2::CreateSourceRequest.new(parent: parent, source: source), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_source_client_stub.call_rpc_count
    end
  end

  def test_delete_big_query_export
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_big_query_export_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_big_query_export, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V2::DeleteBigQueryExportRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_big_query_export_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_big_query_export({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_big_query_export name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_big_query_export ::Google::Cloud::SecurityCenter::V2::DeleteBigQueryExportRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_big_query_export({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_big_query_export(::Google::Cloud::SecurityCenter::V2::DeleteBigQueryExportRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_big_query_export_client_stub.call_rpc_count
    end
  end

  def test_delete_mute_config
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_mute_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_mute_config, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V2::DeleteMuteConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_mute_config_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_mute_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_mute_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_mute_config ::Google::Cloud::SecurityCenter::V2::DeleteMuteConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_mute_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_mute_config(::Google::Cloud::SecurityCenter::V2::DeleteMuteConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_mute_config_client_stub.call_rpc_count
    end
  end

  def test_delete_notification_config
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_notification_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_notification_config, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V2::DeleteNotificationConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_notification_config_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_notification_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_notification_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_notification_config ::Google::Cloud::SecurityCenter::V2::DeleteNotificationConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_notification_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_notification_config(::Google::Cloud::SecurityCenter::V2::DeleteNotificationConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_notification_config_client_stub.call_rpc_count
    end
  end

  def test_delete_resource_value_config
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_resource_value_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_resource_value_config, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V2::DeleteResourceValueConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_resource_value_config_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_resource_value_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_resource_value_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_resource_value_config ::Google::Cloud::SecurityCenter::V2::DeleteResourceValueConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_resource_value_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_resource_value_config(::Google::Cloud::SecurityCenter::V2::DeleteResourceValueConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_resource_value_config_client_stub.call_rpc_count
    end
  end

  def test_get_big_query_export
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V2::BigQueryExport.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_big_query_export_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_big_query_export, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V2::GetBigQueryExportRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_big_query_export_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_big_query_export({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_big_query_export name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_big_query_export ::Google::Cloud::SecurityCenter::V2::GetBigQueryExportRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_big_query_export({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_big_query_export(::Google::Cloud::SecurityCenter::V2::GetBigQueryExportRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_big_query_export_client_stub.call_rpc_count
    end
  end

  def test_get_simulation
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V2::Simulation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_simulation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_simulation, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V2::GetSimulationRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_simulation_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_simulation({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_simulation name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_simulation ::Google::Cloud::SecurityCenter::V2::GetSimulationRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_simulation({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_simulation(::Google::Cloud::SecurityCenter::V2::GetSimulationRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_simulation_client_stub.call_rpc_count
    end
  end

  def test_get_valued_resource
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V2::ValuedResource.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_valued_resource_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_valued_resource, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V2::GetValuedResourceRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_valued_resource_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_valued_resource({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_valued_resource name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_valued_resource ::Google::Cloud::SecurityCenter::V2::GetValuedResourceRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_valued_resource({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_valued_resource(::Google::Cloud::SecurityCenter::V2::GetValuedResourceRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_valued_resource_client_stub.call_rpc_count
    end
  end

  def test_get_iam_policy
    # Create GRPC objects.
    grpc_response = ::Google::Iam::V1::Policy.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    options = {}

    get_iam_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_iam_policy, name
      assert_kind_of ::Google::Iam::V1::GetIamPolicyRequest, request
      assert_equal "hello world", request["resource"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Iam::V1::GetPolicyOptions), request["options"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_iam_policy_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_iam_policy({ resource: resource, options: options }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_iam_policy resource: resource, options: options do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_iam_policy ::Google::Iam::V1::GetIamPolicyRequest.new(resource: resource, options: options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_iam_policy({ resource: resource, options: options }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_iam_policy(::Google::Iam::V1::GetIamPolicyRequest.new(resource: resource, options: options), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_iam_policy_client_stub.call_rpc_count
    end
  end

  def test_get_mute_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V2::MuteConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_mute_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_mute_config, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V2::GetMuteConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_mute_config_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_mute_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_mute_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_mute_config ::Google::Cloud::SecurityCenter::V2::GetMuteConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_mute_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_mute_config(::Google::Cloud::SecurityCenter::V2::GetMuteConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_mute_config_client_stub.call_rpc_count
    end
  end

  def test_get_notification_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V2::NotificationConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_notification_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_notification_config, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V2::GetNotificationConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_notification_config_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_notification_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_notification_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_notification_config ::Google::Cloud::SecurityCenter::V2::GetNotificationConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_notification_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_notification_config(::Google::Cloud::SecurityCenter::V2::GetNotificationConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_notification_config_client_stub.call_rpc_count
    end
  end

  def test_get_resource_value_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V2::ResourceValueConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_resource_value_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_resource_value_config, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V2::GetResourceValueConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_resource_value_config_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_resource_value_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_resource_value_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_resource_value_config ::Google::Cloud::SecurityCenter::V2::GetResourceValueConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_resource_value_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_resource_value_config(::Google::Cloud::SecurityCenter::V2::GetResourceValueConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_resource_value_config_client_stub.call_rpc_count
    end
  end

  def test_get_source
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V2::Source.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_source_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_source, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V2::GetSourceRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_source_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_source({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_source name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_source ::Google::Cloud::SecurityCenter::V2::GetSourceRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_source({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_source(::Google::Cloud::SecurityCenter::V2::GetSourceRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_source_client_stub.call_rpc_count
    end
  end

  def test_group_findings
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V2::GroupFindingsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    group_by = "hello world"
    page_token = "hello world"
    page_size = 42

    group_findings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :group_findings, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V2::GroupFindingsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["group_by"]
      assert_equal "hello world", request["page_token"]
      assert_equal 42, request["page_size"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, group_findings_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.group_findings({ parent: parent, filter: filter, group_by: group_by, page_token: page_token, page_size: page_size }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.group_findings parent: parent, filter: filter, group_by: group_by, page_token: page_token, page_size: page_size do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.group_findings ::Google::Cloud::SecurityCenter::V2::GroupFindingsRequest.new(parent: parent, filter: filter, group_by: group_by, page_token: page_token, page_size: page_size) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.group_findings({ parent: parent, filter: filter, group_by: group_by, page_token: page_token, page_size: page_size }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.group_findings(::Google::Cloud::SecurityCenter::V2::GroupFindingsRequest.new(parent: parent, filter: filter, group_by: group_by, page_token: page_token, page_size: page_size), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, group_findings_client_stub.call_rpc_count
    end
  end

  def test_list_attack_paths
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V2::ListAttackPathsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_token = "hello world"
    page_size = 42

    list_attack_paths_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_attack_paths, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V2::ListAttackPathsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["page_token"]
      assert_equal 42, request["page_size"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_attack_paths_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_attack_paths({ parent: parent, filter: filter, page_token: page_token, page_size: page_size }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_attack_paths parent: parent, filter: filter, page_token: page_token, page_size: page_size do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_attack_paths ::Google::Cloud::SecurityCenter::V2::ListAttackPathsRequest.new(parent: parent, filter: filter, page_token: page_token, page_size: page_size) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_attack_paths({ parent: parent, filter: filter, page_token: page_token, page_size: page_size }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_attack_paths(::Google::Cloud::SecurityCenter::V2::ListAttackPathsRequest.new(parent: parent, filter: filter, page_token: page_token, page_size: page_size), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_attack_paths_client_stub.call_rpc_count
    end
  end

  def test_list_big_query_exports
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V2::ListBigQueryExportsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_big_query_exports_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_big_query_exports, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V2::ListBigQueryExportsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_big_query_exports_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_big_query_exports({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_big_query_exports parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_big_query_exports ::Google::Cloud::SecurityCenter::V2::ListBigQueryExportsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_big_query_exports({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_big_query_exports(::Google::Cloud::SecurityCenter::V2::ListBigQueryExportsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_big_query_exports_client_stub.call_rpc_count
    end
  end

  def test_list_findings
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V2::ListFindingsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    order_by = "hello world"
    field_mask = {}
    page_token = "hello world"
    page_size = 42

    list_findings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_findings, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V2::ListFindingsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["field_mask"]
      assert_equal "hello world", request["page_token"]
      assert_equal 42, request["page_size"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_findings_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_findings({ parent: parent, filter: filter, order_by: order_by, field_mask: field_mask, page_token: page_token, page_size: page_size }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_findings parent: parent, filter: filter, order_by: order_by, field_mask: field_mask, page_token: page_token, page_size: page_size do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_findings ::Google::Cloud::SecurityCenter::V2::ListFindingsRequest.new(parent: parent, filter: filter, order_by: order_by, field_mask: field_mask, page_token: page_token, page_size: page_size) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_findings({ parent: parent, filter: filter, order_by: order_by, field_mask: field_mask, page_token: page_token, page_size: page_size }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_findings(::Google::Cloud::SecurityCenter::V2::ListFindingsRequest.new(parent: parent, filter: filter, order_by: order_by, field_mask: field_mask, page_token: page_token, page_size: page_size), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_findings_client_stub.call_rpc_count
    end
  end

  def test_list_mute_configs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V2::ListMuteConfigsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_mute_configs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_mute_configs, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V2::ListMuteConfigsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_mute_configs_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_mute_configs({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_mute_configs parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_mute_configs ::Google::Cloud::SecurityCenter::V2::ListMuteConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_mute_configs({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_mute_configs(::Google::Cloud::SecurityCenter::V2::ListMuteConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_mute_configs_client_stub.call_rpc_count
    end
  end

  def test_list_notification_configs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V2::ListNotificationConfigsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_token = "hello world"
    page_size = 42

    list_notification_configs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_notification_configs, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V2::ListNotificationConfigsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["page_token"]
      assert_equal 42, request["page_size"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_notification_configs_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_notification_configs({ parent: parent, page_token: page_token, page_size: page_size }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_notification_configs parent: parent, page_token: page_token, page_size: page_size do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_notification_configs ::Google::Cloud::SecurityCenter::V2::ListNotificationConfigsRequest.new(parent: parent, page_token: page_token, page_size: page_size) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_notification_configs({ parent: parent, page_token: page_token, page_size: page_size }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_notification_configs(::Google::Cloud::SecurityCenter::V2::ListNotificationConfigsRequest.new(parent: parent, page_token: page_token, page_size: page_size), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_notification_configs_client_stub.call_rpc_count
    end
  end

  def test_list_resource_value_configs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V2::ListResourceValueConfigsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_resource_value_configs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_resource_value_configs, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V2::ListResourceValueConfigsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_resource_value_configs_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_resource_value_configs({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_resource_value_configs parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_resource_value_configs ::Google::Cloud::SecurityCenter::V2::ListResourceValueConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_resource_value_configs({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_resource_value_configs(::Google::Cloud::SecurityCenter::V2::ListResourceValueConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_resource_value_configs_client_stub.call_rpc_count
    end
  end

  def test_list_sources
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V2::ListSourcesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_token = "hello world"
    page_size = 42

    list_sources_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_sources, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V2::ListSourcesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["page_token"]
      assert_equal 42, request["page_size"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_sources_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_sources({ parent: parent, page_token: page_token, page_size: page_size }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_sources parent: parent, page_token: page_token, page_size: page_size do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_sources ::Google::Cloud::SecurityCenter::V2::ListSourcesRequest.new(parent: parent, page_token: page_token, page_size: page_size) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_sources({ parent: parent, page_token: page_token, page_size: page_size }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_sources(::Google::Cloud::SecurityCenter::V2::ListSourcesRequest.new(parent: parent, page_token: page_token, page_size: page_size), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_sources_client_stub.call_rpc_count
    end
  end

  def test_list_valued_resources
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V2::ListValuedResourcesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_token = "hello world"
    page_size = 42
    order_by = "hello world"

    list_valued_resources_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_valued_resources, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V2::ListValuedResourcesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["page_token"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_valued_resources_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_valued_resources({ parent: parent, filter: filter, page_token: page_token, page_size: page_size, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_valued_resources parent: parent, filter: filter, page_token: page_token, page_size: page_size, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_valued_resources ::Google::Cloud::SecurityCenter::V2::ListValuedResourcesRequest.new(parent: parent, filter: filter, page_token: page_token, page_size: page_size, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_valued_resources({ parent: parent, filter: filter, page_token: page_token, page_size: page_size, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_valued_resources(::Google::Cloud::SecurityCenter::V2::ListValuedResourcesRequest.new(parent: parent, filter: filter, page_token: page_token, page_size: page_size, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_valued_resources_client_stub.call_rpc_count
    end
  end

  def test_set_finding_state
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V2::Finding.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    state = :STATE_UNSPECIFIED

    set_finding_state_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :set_finding_state, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V2::SetFindingStateRequest, request
      assert_equal "hello world", request["name"]
      assert_equal :STATE_UNSPECIFIED, request["state"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, set_finding_state_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.set_finding_state({ name: name, state: state }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.set_finding_state name: name, state: state do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.set_finding_state ::Google::Cloud::SecurityCenter::V2::SetFindingStateRequest.new(name: name, state: state) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.set_finding_state({ name: name, state: state }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.set_finding_state(::Google::Cloud::SecurityCenter::V2::SetFindingStateRequest.new(name: name, state: state), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, set_finding_state_client_stub.call_rpc_count
    end
  end

  def test_set_iam_policy
    # Create GRPC objects.
    grpc_response = ::Google::Iam::V1::Policy.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    policy = {}
    update_mask = {}

    set_iam_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :set_iam_policy, name
      assert_kind_of ::Google::Iam::V1::SetIamPolicyRequest, request
      assert_equal "hello world", request["resource"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Iam::V1::Policy), request["policy"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, set_iam_policy_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.set_iam_policy({ resource: resource, policy: policy, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.set_iam_policy resource: resource, policy: policy, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.set_iam_policy ::Google::Iam::V1::SetIamPolicyRequest.new(resource: resource, policy: policy, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.set_iam_policy({ resource: resource, policy: policy, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.set_iam_policy(::Google::Iam::V1::SetIamPolicyRequest.new(resource: resource, policy: policy, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, set_iam_policy_client_stub.call_rpc_count
    end
  end

  def test_set_mute
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V2::Finding.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    mute = :MUTE_UNSPECIFIED

    set_mute_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :set_mute, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V2::SetMuteRequest, request
      assert_equal "hello world", request["name"]
      assert_equal :MUTE_UNSPECIFIED, request["mute"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, set_mute_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.set_mute({ name: name, mute: mute }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.set_mute name: name, mute: mute do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.set_mute ::Google::Cloud::SecurityCenter::V2::SetMuteRequest.new(name: name, mute: mute) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.set_mute({ name: name, mute: mute }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.set_mute(::Google::Cloud::SecurityCenter::V2::SetMuteRequest.new(name: name, mute: mute), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, set_mute_client_stub.call_rpc_count
    end
  end

  def test_test_iam_permissions
    # Create GRPC objects.
    grpc_response = ::Google::Iam::V1::TestIamPermissionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    permissions = ["hello world"]

    test_iam_permissions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :test_iam_permissions, name
      assert_kind_of ::Google::Iam::V1::TestIamPermissionsRequest, request
      assert_equal "hello world", request["resource"]
      assert_equal ["hello world"], request["permissions"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, test_iam_permissions_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.test_iam_permissions({ resource: resource, permissions: permissions }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.test_iam_permissions resource: resource, permissions: permissions do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.test_iam_permissions ::Google::Iam::V1::TestIamPermissionsRequest.new(resource: resource, permissions: permissions) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.test_iam_permissions({ resource: resource, permissions: permissions }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.test_iam_permissions(::Google::Iam::V1::TestIamPermissionsRequest.new(resource: resource, permissions: permissions), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, test_iam_permissions_client_stub.call_rpc_count
    end
  end

  def test_update_big_query_export
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V2::BigQueryExport.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    big_query_export = {}
    update_mask = {}

    update_big_query_export_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_big_query_export, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V2::UpdateBigQueryExportRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecurityCenter::V2::BigQueryExport), request["big_query_export"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_big_query_export_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_big_query_export({ big_query_export: big_query_export, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_big_query_export big_query_export: big_query_export, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_big_query_export ::Google::Cloud::SecurityCenter::V2::UpdateBigQueryExportRequest.new(big_query_export: big_query_export, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_big_query_export({ big_query_export: big_query_export, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_big_query_export(::Google::Cloud::SecurityCenter::V2::UpdateBigQueryExportRequest.new(big_query_export: big_query_export, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_big_query_export_client_stub.call_rpc_count
    end
  end

  def test_update_external_system
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V2::ExternalSystem.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    external_system = {}
    update_mask = {}

    update_external_system_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_external_system, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V2::UpdateExternalSystemRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecurityCenter::V2::ExternalSystem), request["external_system"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_external_system_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_external_system({ external_system: external_system, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_external_system external_system: external_system, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_external_system ::Google::Cloud::SecurityCenter::V2::UpdateExternalSystemRequest.new(external_system: external_system, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_external_system({ external_system: external_system, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_external_system(::Google::Cloud::SecurityCenter::V2::UpdateExternalSystemRequest.new(external_system: external_system, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_external_system_client_stub.call_rpc_count
    end
  end

  def test_update_finding
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V2::Finding.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    finding = {}
    update_mask = {}

    update_finding_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_finding, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V2::UpdateFindingRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecurityCenter::V2::Finding), request["finding"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_finding_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_finding({ finding: finding, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_finding finding: finding, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_finding ::Google::Cloud::SecurityCenter::V2::UpdateFindingRequest.new(finding: finding, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_finding({ finding: finding, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_finding(::Google::Cloud::SecurityCenter::V2::UpdateFindingRequest.new(finding: finding, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_finding_client_stub.call_rpc_count
    end
  end

  def test_update_mute_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V2::MuteConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    mute_config = {}
    update_mask = {}

    update_mute_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_mute_config, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V2::UpdateMuteConfigRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecurityCenter::V2::MuteConfig), request["mute_config"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_mute_config_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_mute_config({ mute_config: mute_config, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_mute_config mute_config: mute_config, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_mute_config ::Google::Cloud::SecurityCenter::V2::UpdateMuteConfigRequest.new(mute_config: mute_config, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_mute_config({ mute_config: mute_config, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_mute_config(::Google::Cloud::SecurityCenter::V2::UpdateMuteConfigRequest.new(mute_config: mute_config, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_mute_config_client_stub.call_rpc_count
    end
  end

  def test_update_notification_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V2::NotificationConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    notification_config = {}
    update_mask = {}

    update_notification_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_notification_config, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V2::UpdateNotificationConfigRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecurityCenter::V2::NotificationConfig), request["notification_config"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_notification_config_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_notification_config({ notification_config: notification_config, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_notification_config notification_config: notification_config, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_notification_config ::Google::Cloud::SecurityCenter::V2::UpdateNotificationConfigRequest.new(notification_config: notification_config, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_notification_config({ notification_config: notification_config, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_notification_config(::Google::Cloud::SecurityCenter::V2::UpdateNotificationConfigRequest.new(notification_config: notification_config, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_notification_config_client_stub.call_rpc_count
    end
  end

  def test_update_resource_value_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V2::ResourceValueConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    resource_value_config = {}
    update_mask = {}

    update_resource_value_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_resource_value_config, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V2::UpdateResourceValueConfigRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecurityCenter::V2::ResourceValueConfig), request["resource_value_config"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_resource_value_config_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_resource_value_config({ resource_value_config: resource_value_config, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_resource_value_config resource_value_config: resource_value_config, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_resource_value_config ::Google::Cloud::SecurityCenter::V2::UpdateResourceValueConfigRequest.new(resource_value_config: resource_value_config, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_resource_value_config({ resource_value_config: resource_value_config, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_resource_value_config(::Google::Cloud::SecurityCenter::V2::UpdateResourceValueConfigRequest.new(resource_value_config: resource_value_config, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_resource_value_config_client_stub.call_rpc_count
    end
  end

  def test_update_security_marks
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V2::SecurityMarks.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    security_marks = {}
    update_mask = {}

    update_security_marks_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_security_marks, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V2::UpdateSecurityMarksRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecurityCenter::V2::SecurityMarks), request["security_marks"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_security_marks_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_security_marks({ security_marks: security_marks, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_security_marks security_marks: security_marks, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_security_marks ::Google::Cloud::SecurityCenter::V2::UpdateSecurityMarksRequest.new(security_marks: security_marks, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_security_marks({ security_marks: security_marks, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_security_marks(::Google::Cloud::SecurityCenter::V2::UpdateSecurityMarksRequest.new(security_marks: security_marks, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_security_marks_client_stub.call_rpc_count
    end
  end

  def test_update_source
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V2::Source.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    source = {}
    update_mask = {}

    update_source_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_source, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V2::UpdateSourceRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecurityCenter::V2::Source), request["source"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_source_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_source({ source: source, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_source source: source, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_source ::Google::Cloud::SecurityCenter::V2::UpdateSourceRequest.new(source: source, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_source({ source: source, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_source(::Google::Cloud::SecurityCenter::V2::UpdateSourceRequest.new(source: source, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_source_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Operations, client.operations_client
  end
end
