# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/securitycenter/v2/securitycenter_service_pb"
require "google/cloud/security_center/v2/security_center/rest"


class ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_batch_create_resource_value_configs
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V2::BatchCreateResourceValueConfigsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    requests = [{}]

    batch_create_resource_value_configs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::ServiceStub.stub :transcode_batch_create_resource_value_configs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, batch_create_resource_value_configs_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.batch_create_resource_value_configs({ parent: parent, requests: requests }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.batch_create_resource_value_configs parent: parent, requests: requests do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.batch_create_resource_value_configs ::Google::Cloud::SecurityCenter::V2::BatchCreateResourceValueConfigsRequest.new(parent: parent, requests: requests) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.batch_create_resource_value_configs({ parent: parent, requests: requests }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.batch_create_resource_value_configs(::Google::Cloud::SecurityCenter::V2::BatchCreateResourceValueConfigsRequest.new(parent: parent, requests: requests), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, batch_create_resource_value_configs_client_stub.call_count
      end
    end
  end

  def test_bulk_mute_findings
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    mute_state = :MUTE_STATE_UNSPECIFIED

    bulk_mute_findings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::ServiceStub.stub :transcode_bulk_mute_findings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, bulk_mute_findings_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.bulk_mute_findings({ parent: parent, filter: filter, mute_state: mute_state }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.bulk_mute_findings parent: parent, filter: filter, mute_state: mute_state do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.bulk_mute_findings ::Google::Cloud::SecurityCenter::V2::BulkMuteFindingsRequest.new(parent: parent, filter: filter, mute_state: mute_state) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.bulk_mute_findings({ parent: parent, filter: filter, mute_state: mute_state }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.bulk_mute_findings(::Google::Cloud::SecurityCenter::V2::BulkMuteFindingsRequest.new(parent: parent, filter: filter, mute_state: mute_state), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, bulk_mute_findings_client_stub.call_count
      end
    end
  end

  def test_create_big_query_export
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V2::BigQueryExport.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    big_query_export = {}
    big_query_export_id = "hello world"

    create_big_query_export_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::ServiceStub.stub :transcode_create_big_query_export_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_big_query_export_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_big_query_export({ parent: parent, big_query_export: big_query_export, big_query_export_id: big_query_export_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_big_query_export parent: parent, big_query_export: big_query_export, big_query_export_id: big_query_export_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_big_query_export ::Google::Cloud::SecurityCenter::V2::CreateBigQueryExportRequest.new(parent: parent, big_query_export: big_query_export, big_query_export_id: big_query_export_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_big_query_export({ parent: parent, big_query_export: big_query_export, big_query_export_id: big_query_export_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_big_query_export(::Google::Cloud::SecurityCenter::V2::CreateBigQueryExportRequest.new(parent: parent, big_query_export: big_query_export, big_query_export_id: big_query_export_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_big_query_export_client_stub.call_count
      end
    end
  end

  def test_create_finding
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V2::Finding.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    finding_id = "hello world"
    finding = {}

    create_finding_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::ServiceStub.stub :transcode_create_finding_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_finding_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_finding({ parent: parent, finding_id: finding_id, finding: finding }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_finding parent: parent, finding_id: finding_id, finding: finding do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_finding ::Google::Cloud::SecurityCenter::V2::CreateFindingRequest.new(parent: parent, finding_id: finding_id, finding: finding) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_finding({ parent: parent, finding_id: finding_id, finding: finding }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_finding(::Google::Cloud::SecurityCenter::V2::CreateFindingRequest.new(parent: parent, finding_id: finding_id, finding: finding), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_finding_client_stub.call_count
      end
    end
  end

  def test_create_mute_config
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V2::MuteConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    mute_config = {}
    mute_config_id = "hello world"

    create_mute_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::ServiceStub.stub :transcode_create_mute_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_mute_config_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_mute_config({ parent: parent, mute_config: mute_config, mute_config_id: mute_config_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_mute_config parent: parent, mute_config: mute_config, mute_config_id: mute_config_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_mute_config ::Google::Cloud::SecurityCenter::V2::CreateMuteConfigRequest.new(parent: parent, mute_config: mute_config, mute_config_id: mute_config_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_mute_config({ parent: parent, mute_config: mute_config, mute_config_id: mute_config_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_mute_config(::Google::Cloud::SecurityCenter::V2::CreateMuteConfigRequest.new(parent: parent, mute_config: mute_config, mute_config_id: mute_config_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_mute_config_client_stub.call_count
      end
    end
  end

  def test_create_notification_config
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V2::NotificationConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    config_id = "hello world"
    notification_config = {}

    create_notification_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::ServiceStub.stub :transcode_create_notification_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_notification_config_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_notification_config({ parent: parent, config_id: config_id, notification_config: notification_config }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_notification_config parent: parent, config_id: config_id, notification_config: notification_config do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_notification_config ::Google::Cloud::SecurityCenter::V2::CreateNotificationConfigRequest.new(parent: parent, config_id: config_id, notification_config: notification_config) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_notification_config({ parent: parent, config_id: config_id, notification_config: notification_config }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_notification_config(::Google::Cloud::SecurityCenter::V2::CreateNotificationConfigRequest.new(parent: parent, config_id: config_id, notification_config: notification_config), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_notification_config_client_stub.call_count
      end
    end
  end

  def test_create_source
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V2::Source.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    source = {}

    create_source_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::ServiceStub.stub :transcode_create_source_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_source_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_source({ parent: parent, source: source }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_source parent: parent, source: source do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_source ::Google::Cloud::SecurityCenter::V2::CreateSourceRequest.new(parent: parent, source: source) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_source({ parent: parent, source: source }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_source(::Google::Cloud::SecurityCenter::V2::CreateSourceRequest.new(parent: parent, source: source), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_source_client_stub.call_count
      end
    end
  end

  def test_delete_big_query_export
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_big_query_export_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::ServiceStub.stub :transcode_delete_big_query_export_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_big_query_export_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_big_query_export({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_big_query_export name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_big_query_export ::Google::Cloud::SecurityCenter::V2::DeleteBigQueryExportRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_big_query_export({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_big_query_export(::Google::Cloud::SecurityCenter::V2::DeleteBigQueryExportRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_big_query_export_client_stub.call_count
      end
    end
  end

  def test_delete_mute_config
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_mute_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::ServiceStub.stub :transcode_delete_mute_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_mute_config_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_mute_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_mute_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_mute_config ::Google::Cloud::SecurityCenter::V2::DeleteMuteConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_mute_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_mute_config(::Google::Cloud::SecurityCenter::V2::DeleteMuteConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_mute_config_client_stub.call_count
      end
    end
  end

  def test_delete_notification_config
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_notification_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::ServiceStub.stub :transcode_delete_notification_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_notification_config_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_notification_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_notification_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_notification_config ::Google::Cloud::SecurityCenter::V2::DeleteNotificationConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_notification_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_notification_config(::Google::Cloud::SecurityCenter::V2::DeleteNotificationConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_notification_config_client_stub.call_count
      end
    end
  end

  def test_delete_resource_value_config
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_resource_value_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::ServiceStub.stub :transcode_delete_resource_value_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_resource_value_config_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_resource_value_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_resource_value_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_resource_value_config ::Google::Cloud::SecurityCenter::V2::DeleteResourceValueConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_resource_value_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_resource_value_config(::Google::Cloud::SecurityCenter::V2::DeleteResourceValueConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_resource_value_config_client_stub.call_count
      end
    end
  end

  def test_get_big_query_export
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V2::BigQueryExport.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_big_query_export_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::ServiceStub.stub :transcode_get_big_query_export_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_big_query_export_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_big_query_export({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_big_query_export name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_big_query_export ::Google::Cloud::SecurityCenter::V2::GetBigQueryExportRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_big_query_export({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_big_query_export(::Google::Cloud::SecurityCenter::V2::GetBigQueryExportRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_big_query_export_client_stub.call_count
      end
    end
  end

  def test_get_simulation
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V2::Simulation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_simulation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::ServiceStub.stub :transcode_get_simulation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_simulation_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_simulation({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_simulation name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_simulation ::Google::Cloud::SecurityCenter::V2::GetSimulationRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_simulation({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_simulation(::Google::Cloud::SecurityCenter::V2::GetSimulationRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_simulation_client_stub.call_count
      end
    end
  end

  def test_get_valued_resource
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V2::ValuedResource.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_valued_resource_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::ServiceStub.stub :transcode_get_valued_resource_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_valued_resource_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_valued_resource({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_valued_resource name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_valued_resource ::Google::Cloud::SecurityCenter::V2::GetValuedResourceRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_valued_resource({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_valued_resource(::Google::Cloud::SecurityCenter::V2::GetValuedResourceRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_valued_resource_client_stub.call_count
      end
    end
  end

  def test_get_iam_policy
    # Create test objects.
    client_result = ::Google::Iam::V1::Policy.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    options = {}

    get_iam_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::ServiceStub.stub :transcode_get_iam_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_iam_policy_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_iam_policy({ resource: resource, options: options }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_iam_policy resource: resource, options: options do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_iam_policy ::Google::Iam::V1::GetIamPolicyRequest.new(resource: resource, options: options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_iam_policy({ resource: resource, options: options }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_iam_policy(::Google::Iam::V1::GetIamPolicyRequest.new(resource: resource, options: options), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_iam_policy_client_stub.call_count
      end
    end
  end

  def test_get_mute_config
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V2::MuteConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_mute_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::ServiceStub.stub :transcode_get_mute_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_mute_config_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_mute_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_mute_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_mute_config ::Google::Cloud::SecurityCenter::V2::GetMuteConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_mute_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_mute_config(::Google::Cloud::SecurityCenter::V2::GetMuteConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_mute_config_client_stub.call_count
      end
    end
  end

  def test_get_notification_config
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V2::NotificationConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_notification_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::ServiceStub.stub :transcode_get_notification_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_notification_config_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_notification_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_notification_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_notification_config ::Google::Cloud::SecurityCenter::V2::GetNotificationConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_notification_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_notification_config(::Google::Cloud::SecurityCenter::V2::GetNotificationConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_notification_config_client_stub.call_count
      end
    end
  end

  def test_get_resource_value_config
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V2::ResourceValueConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_resource_value_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::ServiceStub.stub :transcode_get_resource_value_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_resource_value_config_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_resource_value_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_resource_value_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_resource_value_config ::Google::Cloud::SecurityCenter::V2::GetResourceValueConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_resource_value_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_resource_value_config(::Google::Cloud::SecurityCenter::V2::GetResourceValueConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_resource_value_config_client_stub.call_count
      end
    end
  end

  def test_get_source
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V2::Source.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_source_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::ServiceStub.stub :transcode_get_source_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_source_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_source({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_source name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_source ::Google::Cloud::SecurityCenter::V2::GetSourceRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_source({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_source(::Google::Cloud::SecurityCenter::V2::GetSourceRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_source_client_stub.call_count
      end
    end
  end

  def test_group_findings
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V2::GroupFindingsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    group_by = "hello world"
    page_token = "hello world"
    page_size = 42

    group_findings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::ServiceStub.stub :transcode_group_findings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, group_findings_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.group_findings({ parent: parent, filter: filter, group_by: group_by, page_token: page_token, page_size: page_size }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.group_findings parent: parent, filter: filter, group_by: group_by, page_token: page_token, page_size: page_size do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.group_findings ::Google::Cloud::SecurityCenter::V2::GroupFindingsRequest.new(parent: parent, filter: filter, group_by: group_by, page_token: page_token, page_size: page_size) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.group_findings({ parent: parent, filter: filter, group_by: group_by, page_token: page_token, page_size: page_size }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.group_findings(::Google::Cloud::SecurityCenter::V2::GroupFindingsRequest.new(parent: parent, filter: filter, group_by: group_by, page_token: page_token, page_size: page_size), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, group_findings_client_stub.call_count
      end
    end
  end

  def test_list_attack_paths
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V2::ListAttackPathsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_token = "hello world"
    page_size = 42

    list_attack_paths_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::ServiceStub.stub :transcode_list_attack_paths_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_attack_paths_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_attack_paths({ parent: parent, filter: filter, page_token: page_token, page_size: page_size }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_attack_paths parent: parent, filter: filter, page_token: page_token, page_size: page_size do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_attack_paths ::Google::Cloud::SecurityCenter::V2::ListAttackPathsRequest.new(parent: parent, filter: filter, page_token: page_token, page_size: page_size) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_attack_paths({ parent: parent, filter: filter, page_token: page_token, page_size: page_size }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_attack_paths(::Google::Cloud::SecurityCenter::V2::ListAttackPathsRequest.new(parent: parent, filter: filter, page_token: page_token, page_size: page_size), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_attack_paths_client_stub.call_count
      end
    end
  end

  def test_list_big_query_exports
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V2::ListBigQueryExportsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_big_query_exports_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::ServiceStub.stub :transcode_list_big_query_exports_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_big_query_exports_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_big_query_exports({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_big_query_exports parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_big_query_exports ::Google::Cloud::SecurityCenter::V2::ListBigQueryExportsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_big_query_exports({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_big_query_exports(::Google::Cloud::SecurityCenter::V2::ListBigQueryExportsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_big_query_exports_client_stub.call_count
      end
    end
  end

  def test_list_findings
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V2::ListFindingsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    order_by = "hello world"
    field_mask = {}
    page_token = "hello world"
    page_size = 42

    list_findings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::ServiceStub.stub :transcode_list_findings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_findings_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_findings({ parent: parent, filter: filter, order_by: order_by, field_mask: field_mask, page_token: page_token, page_size: page_size }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_findings parent: parent, filter: filter, order_by: order_by, field_mask: field_mask, page_token: page_token, page_size: page_size do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_findings ::Google::Cloud::SecurityCenter::V2::ListFindingsRequest.new(parent: parent, filter: filter, order_by: order_by, field_mask: field_mask, page_token: page_token, page_size: page_size) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_findings({ parent: parent, filter: filter, order_by: order_by, field_mask: field_mask, page_token: page_token, page_size: page_size }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_findings(::Google::Cloud::SecurityCenter::V2::ListFindingsRequest.new(parent: parent, filter: filter, order_by: order_by, field_mask: field_mask, page_token: page_token, page_size: page_size), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_findings_client_stub.call_count
      end
    end
  end

  def test_list_mute_configs
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V2::ListMuteConfigsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_mute_configs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::ServiceStub.stub :transcode_list_mute_configs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_mute_configs_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_mute_configs({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_mute_configs parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_mute_configs ::Google::Cloud::SecurityCenter::V2::ListMuteConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_mute_configs({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_mute_configs(::Google::Cloud::SecurityCenter::V2::ListMuteConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_mute_configs_client_stub.call_count
      end
    end
  end

  def test_list_notification_configs
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V2::ListNotificationConfigsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_token = "hello world"
    page_size = 42

    list_notification_configs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::ServiceStub.stub :transcode_list_notification_configs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_notification_configs_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_notification_configs({ parent: parent, page_token: page_token, page_size: page_size }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_notification_configs parent: parent, page_token: page_token, page_size: page_size do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_notification_configs ::Google::Cloud::SecurityCenter::V2::ListNotificationConfigsRequest.new(parent: parent, page_token: page_token, page_size: page_size) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_notification_configs({ parent: parent, page_token: page_token, page_size: page_size }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_notification_configs(::Google::Cloud::SecurityCenter::V2::ListNotificationConfigsRequest.new(parent: parent, page_token: page_token, page_size: page_size), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_notification_configs_client_stub.call_count
      end
    end
  end

  def test_list_resource_value_configs
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V2::ListResourceValueConfigsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_resource_value_configs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::ServiceStub.stub :transcode_list_resource_value_configs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_resource_value_configs_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_resource_value_configs({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_resource_value_configs parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_resource_value_configs ::Google::Cloud::SecurityCenter::V2::ListResourceValueConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_resource_value_configs({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_resource_value_configs(::Google::Cloud::SecurityCenter::V2::ListResourceValueConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_resource_value_configs_client_stub.call_count
      end
    end
  end

  def test_list_sources
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V2::ListSourcesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_token = "hello world"
    page_size = 42

    list_sources_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::ServiceStub.stub :transcode_list_sources_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_sources_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_sources({ parent: parent, page_token: page_token, page_size: page_size }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_sources parent: parent, page_token: page_token, page_size: page_size do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_sources ::Google::Cloud::SecurityCenter::V2::ListSourcesRequest.new(parent: parent, page_token: page_token, page_size: page_size) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_sources({ parent: parent, page_token: page_token, page_size: page_size }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_sources(::Google::Cloud::SecurityCenter::V2::ListSourcesRequest.new(parent: parent, page_token: page_token, page_size: page_size), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_sources_client_stub.call_count
      end
    end
  end

  def test_list_valued_resources
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V2::ListValuedResourcesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_token = "hello world"
    page_size = 42
    order_by = "hello world"

    list_valued_resources_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::ServiceStub.stub :transcode_list_valued_resources_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_valued_resources_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_valued_resources({ parent: parent, filter: filter, page_token: page_token, page_size: page_size, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_valued_resources parent: parent, filter: filter, page_token: page_token, page_size: page_size, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_valued_resources ::Google::Cloud::SecurityCenter::V2::ListValuedResourcesRequest.new(parent: parent, filter: filter, page_token: page_token, page_size: page_size, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_valued_resources({ parent: parent, filter: filter, page_token: page_token, page_size: page_size, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_valued_resources(::Google::Cloud::SecurityCenter::V2::ListValuedResourcesRequest.new(parent: parent, filter: filter, page_token: page_token, page_size: page_size, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_valued_resources_client_stub.call_count
      end
    end
  end

  def test_set_finding_state
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V2::Finding.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    state = :STATE_UNSPECIFIED

    set_finding_state_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::ServiceStub.stub :transcode_set_finding_state_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_finding_state_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_finding_state({ name: name, state: state }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_finding_state name: name, state: state do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_finding_state ::Google::Cloud::SecurityCenter::V2::SetFindingStateRequest.new(name: name, state: state) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_finding_state({ name: name, state: state }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_finding_state(::Google::Cloud::SecurityCenter::V2::SetFindingStateRequest.new(name: name, state: state), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_finding_state_client_stub.call_count
      end
    end
  end

  def test_set_iam_policy
    # Create test objects.
    client_result = ::Google::Iam::V1::Policy.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    policy = {}
    update_mask = {}

    set_iam_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::ServiceStub.stub :transcode_set_iam_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_iam_policy_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_iam_policy({ resource: resource, policy: policy, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_iam_policy resource: resource, policy: policy, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_iam_policy ::Google::Iam::V1::SetIamPolicyRequest.new(resource: resource, policy: policy, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_iam_policy({ resource: resource, policy: policy, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_iam_policy(::Google::Iam::V1::SetIamPolicyRequest.new(resource: resource, policy: policy, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_iam_policy_client_stub.call_count
      end
    end
  end

  def test_set_mute
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V2::Finding.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    mute = :MUTE_UNSPECIFIED

    set_mute_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::ServiceStub.stub :transcode_set_mute_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_mute_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_mute({ name: name, mute: mute }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_mute name: name, mute: mute do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_mute ::Google::Cloud::SecurityCenter::V2::SetMuteRequest.new(name: name, mute: mute) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_mute({ name: name, mute: mute }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_mute(::Google::Cloud::SecurityCenter::V2::SetMuteRequest.new(name: name, mute: mute), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_mute_client_stub.call_count
      end
    end
  end

  def test_test_iam_permissions
    # Create test objects.
    client_result = ::Google::Iam::V1::TestIamPermissionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    permissions = ["hello world"]

    test_iam_permissions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::ServiceStub.stub :transcode_test_iam_permissions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, test_iam_permissions_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.test_iam_permissions({ resource: resource, permissions: permissions }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.test_iam_permissions resource: resource, permissions: permissions do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.test_iam_permissions ::Google::Iam::V1::TestIamPermissionsRequest.new(resource: resource, permissions: permissions) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.test_iam_permissions({ resource: resource, permissions: permissions }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.test_iam_permissions(::Google::Iam::V1::TestIamPermissionsRequest.new(resource: resource, permissions: permissions), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, test_iam_permissions_client_stub.call_count
      end
    end
  end

  def test_update_big_query_export
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V2::BigQueryExport.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    big_query_export = {}
    update_mask = {}

    update_big_query_export_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::ServiceStub.stub :transcode_update_big_query_export_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_big_query_export_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_big_query_export({ big_query_export: big_query_export, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_big_query_export big_query_export: big_query_export, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_big_query_export ::Google::Cloud::SecurityCenter::V2::UpdateBigQueryExportRequest.new(big_query_export: big_query_export, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_big_query_export({ big_query_export: big_query_export, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_big_query_export(::Google::Cloud::SecurityCenter::V2::UpdateBigQueryExportRequest.new(big_query_export: big_query_export, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_big_query_export_client_stub.call_count
      end
    end
  end

  def test_update_external_system
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V2::ExternalSystem.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    external_system = {}
    update_mask = {}

    update_external_system_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::ServiceStub.stub :transcode_update_external_system_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_external_system_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_external_system({ external_system: external_system, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_external_system external_system: external_system, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_external_system ::Google::Cloud::SecurityCenter::V2::UpdateExternalSystemRequest.new(external_system: external_system, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_external_system({ external_system: external_system, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_external_system(::Google::Cloud::SecurityCenter::V2::UpdateExternalSystemRequest.new(external_system: external_system, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_external_system_client_stub.call_count
      end
    end
  end

  def test_update_finding
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V2::Finding.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    finding = {}
    update_mask = {}

    update_finding_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::ServiceStub.stub :transcode_update_finding_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_finding_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_finding({ finding: finding, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_finding finding: finding, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_finding ::Google::Cloud::SecurityCenter::V2::UpdateFindingRequest.new(finding: finding, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_finding({ finding: finding, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_finding(::Google::Cloud::SecurityCenter::V2::UpdateFindingRequest.new(finding: finding, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_finding_client_stub.call_count
      end
    end
  end

  def test_update_mute_config
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V2::MuteConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    mute_config = {}
    update_mask = {}

    update_mute_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::ServiceStub.stub :transcode_update_mute_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_mute_config_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_mute_config({ mute_config: mute_config, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_mute_config mute_config: mute_config, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_mute_config ::Google::Cloud::SecurityCenter::V2::UpdateMuteConfigRequest.new(mute_config: mute_config, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_mute_config({ mute_config: mute_config, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_mute_config(::Google::Cloud::SecurityCenter::V2::UpdateMuteConfigRequest.new(mute_config: mute_config, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_mute_config_client_stub.call_count
      end
    end
  end

  def test_update_notification_config
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V2::NotificationConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    notification_config = {}
    update_mask = {}

    update_notification_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::ServiceStub.stub :transcode_update_notification_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_notification_config_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_notification_config({ notification_config: notification_config, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_notification_config notification_config: notification_config, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_notification_config ::Google::Cloud::SecurityCenter::V2::UpdateNotificationConfigRequest.new(notification_config: notification_config, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_notification_config({ notification_config: notification_config, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_notification_config(::Google::Cloud::SecurityCenter::V2::UpdateNotificationConfigRequest.new(notification_config: notification_config, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_notification_config_client_stub.call_count
      end
    end
  end

  def test_update_resource_value_config
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V2::ResourceValueConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    resource_value_config = {}
    update_mask = {}

    update_resource_value_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::ServiceStub.stub :transcode_update_resource_value_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_resource_value_config_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_resource_value_config({ resource_value_config: resource_value_config, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_resource_value_config resource_value_config: resource_value_config, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_resource_value_config ::Google::Cloud::SecurityCenter::V2::UpdateResourceValueConfigRequest.new(resource_value_config: resource_value_config, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_resource_value_config({ resource_value_config: resource_value_config, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_resource_value_config(::Google::Cloud::SecurityCenter::V2::UpdateResourceValueConfigRequest.new(resource_value_config: resource_value_config, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_resource_value_config_client_stub.call_count
      end
    end
  end

  def test_update_security_marks
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V2::SecurityMarks.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    security_marks = {}
    update_mask = {}

    update_security_marks_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::ServiceStub.stub :transcode_update_security_marks_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_security_marks_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_security_marks({ security_marks: security_marks, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_security_marks security_marks: security_marks, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_security_marks ::Google::Cloud::SecurityCenter::V2::UpdateSecurityMarksRequest.new(security_marks: security_marks, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_security_marks({ security_marks: security_marks, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_security_marks(::Google::Cloud::SecurityCenter::V2::UpdateSecurityMarksRequest.new(security_marks: security_marks, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_security_marks_client_stub.call_count
      end
    end
  end

  def test_update_source
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V2::Source.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    source = {}
    update_mask = {}

    update_source_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::ServiceStub.stub :transcode_update_source_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_source_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_source({ source: source, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_source source: source, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_source ::Google::Cloud::SecurityCenter::V2::UpdateSourceRequest.new(source: source, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_source({ source: source, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_source(::Google::Cloud::SecurityCenter::V2::UpdateSourceRequest.new(source: source, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_source_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Rest::Client::Configuration, config
  end
end
