# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module SecurityCenter
      module V2
        # Vertex AI-related information associated with the finding.
        # @!attribute [rw] datasets
        #   @return [::Array<::Google::Cloud::SecurityCenter::V2::VertexAi::Dataset>]
        #     Datasets associated with the finding.
        # @!attribute [rw] pipelines
        #   @return [::Array<::Google::Cloud::SecurityCenter::V2::VertexAi::Pipeline>]
        #     Pipelines associated with the finding.
        class VertexAi
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Vertex AI dataset associated with the finding.
          # @!attribute [rw] name
          #   @return [::String]
          #     Resource name of the dataset, e.g.
          #     projects/\\{project}/locations/\\{location}/datasets/2094040236064505856
          # @!attribute [rw] display_name
          #   @return [::String]
          #     The user defined display name of dataset, e.g. plants-dataset
          # @!attribute [rw] source
          #   @return [::String]
          #     Data source, such as a BigQuery source URI, e.g.
          #     bq://scc-nexus-test.AIPPtest.gsod
          class Dataset
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Vertex AI training pipeline associated with the finding.
          # @!attribute [rw] name
          #   @return [::String]
          #     Resource name of the pipeline, e.g.
          #     projects/\\{project}/locations/\\{location}/trainingPipelines/5253428229225578496
          # @!attribute [rw] display_name
          #   @return [::String]
          #     The user-defined display name of pipeline, e.g. plants-classification
          class Pipeline
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
