# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module SecurityCenter
      module V2
        # Request message to create multiple resource value configs
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Resource name of the new ResourceValueConfig's parent.
        #     The parent field in the CreateResourceValueConfigRequest
        #     messages must either be empty or match this field.
        # @!attribute [rw] requests
        #   @return [::Array<::Google::Cloud::SecurityCenter::V2::CreateResourceValueConfigRequest>]
        #     Required. The resource value configs to be created.
        class BatchCreateResourceValueConfigsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for BatchCreateResourceValueConfigs
        # @!attribute [rw] resource_value_configs
        #   @return [::Array<::Google::Cloud::SecurityCenter::V2::ResourceValueConfig>]
        #     The resource value configs created
        class BatchCreateResourceValueConfigsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for bulk findings update.
        #
        # Note:
        # 1. If multiple bulk update requests match the same resource, the order in
        # which they get executed is not defined.
        # 2. Once a bulk operation is started, there is no way to stop it.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, at which bulk action needs to be applied. If no
        #     location is specified, findings are updated in global. The following list
        #     shows some examples:
        #
        #     + `organizations/[organization_id]`
        #     + `organizations/[organization_id]/locations/[location_id]`
        #     + `folders/[folder_id]`
        #     + `folders/[folder_id]/locations/[location_id]`
        #     + `projects/[project_id]`
        #     + `projects/[project_id]/locations/[location_id]`
        # @!attribute [rw] filter
        #   @return [::String]
        #     Expression that identifies findings that should be updated.
        #     The expression is a list of zero or more restrictions combined
        #     via logical operators `AND` and `OR`. Parentheses are supported, and `OR`
        #     has higher precedence than `AND`.
        #
        #     Restrictions have the form `<field> <operator> <value>` and may have a
        #     `-` character in front of them to indicate negation. The fields map to
        #     those defined in the corresponding resource.
        #
        #     The supported operators are:
        #
        #     * `=` for all value types.
        #     * `>`, `<`, `>=`, `<=` for integer values.
        #     * `:`, meaning substring matching, for strings.
        #
        #     The supported value types are:
        #
        #     * string literals in quotes.
        #     * integer literals without quotes.
        #     * boolean literals `true` and `false` without quotes.
        # @!attribute [rw] mute_state
        #   @return [::Google::Cloud::SecurityCenter::V2::BulkMuteFindingsRequest::MuteState]
        #     Optional. All findings matching the given filter will have their mute state
        #     set to this value. The default value is `MUTED`. Setting this to
        #     `UNDEFINED` will clear the mute state on all matching findings.
        class BulkMuteFindingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The mute state.
          module MuteState
            # Unused.
            MUTE_STATE_UNSPECIFIED = 0

            # Matching findings will be muted (default).
            MUTED = 1

            # Matching findings will have their mute state cleared.
            UNDEFINED = 2
          end
        end

        # The response to a BulkMute request. Contains the LRO information.
        class BulkMuteFindingsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for creating a BigQuery export.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the parent resource of the new BigQuery export. Its
        #     format is `organizations/[organization_id]/locations/[location_id]`,
        #     `folders/[folder_id]/locations/[location_id]`, or
        #     `projects/[project_id]/locations/[location_id]`.
        # @!attribute [rw] big_query_export
        #   @return [::Google::Cloud::SecurityCenter::V2::BigQueryExport]
        #     Required. The BigQuery export being created.
        # @!attribute [rw] big_query_export_id
        #   @return [::String]
        #     Required. Unique identifier provided by the client within the parent scope.
        #     It must consist of only lowercase letters, numbers, and hyphens, must start
        #     with a letter, must end with either a letter or a number, and must be 63
        #     characters or less.
        class CreateBigQueryExportRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for creating a finding.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Resource name of the new finding's parent. The following list
        #     shows some examples of the format:
        #     +
        #     `organizations/[organization_id]/sources/[source_id]`
        #     +
        #     `organizations/[organization_id]/sources/[source_id]/locations/[location_id]`
        # @!attribute [rw] finding_id
        #   @return [::String]
        #     Required. Unique identifier provided by the client within the parent scope.
        #     It must be alphanumeric and less than or equal to 32 characters and
        #     greater than 0 characters in length.
        # @!attribute [rw] finding
        #   @return [::Google::Cloud::SecurityCenter::V2::Finding]
        #     Required. The Finding being created. The name and security_marks will be
        #     ignored as they are both output only fields on this resource.
        class CreateFindingRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for creating a mute config.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Resource name of the new mute configs's parent. Its format is
        #     `organizations/[organization_id]/locations/[location_id]`,
        #     `folders/[folder_id]/locations/[location_id]`, or
        #     `projects/[project_id]/locations/[location_id]`.
        # @!attribute [rw] mute_config
        #   @return [::Google::Cloud::SecurityCenter::V2::MuteConfig]
        #     Required. The mute config being created.
        # @!attribute [rw] mute_config_id
        #   @return [::String]
        #     Required. Unique identifier provided by the client within the parent scope.
        #     It must consist of only lowercase letters, numbers, and hyphens, must start
        #     with a letter, must end with either a letter or a number, and must be 63
        #     characters or less.
        class CreateMuteConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for creating a notification config.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Resource name of the new notification config's parent. Its format
        #     is `organizations/[organization_id]/locations/[location_id]`,
        #     `folders/[folder_id]/locations/[location_id]`, or
        #     `projects/[project_id]/locations/[location_id]`.
        # @!attribute [rw] config_id
        #   @return [::String]
        #     Required.
        #     Unique identifier provided by the client within the parent scope.
        #     It must be between 1 and 128 characters and contain alphanumeric
        #     characters, underscores, or hyphens only.
        # @!attribute [rw] notification_config
        #   @return [::Google::Cloud::SecurityCenter::V2::NotificationConfig]
        #     Required. The notification config being created. The name and the service
        #     account will be ignored as they are both output only fields on this
        #     resource.
        class CreateNotificationConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message to create single resource value config
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Resource name of the new ResourceValueConfig's parent.
        # @!attribute [rw] resource_value_config
        #   @return [::Google::Cloud::SecurityCenter::V2::ResourceValueConfig]
        #     Required. The resource value config being created.
        class CreateResourceValueConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for creating a source.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Resource name of the new source's parent. Its format should be
        #     `organizations/[organization_id]`.
        # @!attribute [rw] source
        #   @return [::Google::Cloud::SecurityCenter::V2::Source]
        #     Required. The Source being created, only the display_name and description
        #     will be used. All other fields will be ignored.
        class CreateSourceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for deleting a BigQuery export.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the BigQuery export to delete. The following list
        #     shows some examples of the format:
        #
        #     +
        #     `organizations/{organization}/locations/{location}/bigQueryExports/{export_id}`
        #     + `folders/{folder}/locations/{location}/bigQueryExports/{export_id}`
        #     + `projects/{project}/locations/{location}/bigQueryExports/{export_id}`
        class DeleteBigQueryExportRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for deleting a mute config. If no location is specified,
        # default is global.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the mute config to delete. The following list shows some
        #     examples of the format:
        #
        #     + `organizations/{organization}/muteConfigs/{config_id}`
        #     +
        #     `organizations/{organization}/locations/{location}/muteConfigs/{config_id}`
        #     + `folders/{folder}/muteConfigs/{config_id}`
        #     + `folders/{folder}/locations/{location}/muteConfigs/{config_id}`
        #     + `projects/{project}/muteConfigs/{config_id}`
        #     + `projects/{project}/locations/{location}/muteConfigs/{config_id}`
        class DeleteMuteConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for deleting a notification config.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the notification config to delete. The following list
        #     shows some examples of the format:
        #
        #     +
        #     `organizations/[organization_id]/locations/[location_id]/notificationConfigs/[config_id]`
        #     +
        #     `folders/[folder_id]/locations/[location_id]notificationConfigs/[config_id]`
        #     +
        #     `projects/[project_id]/locations/[location_id]notificationConfigs/[config_id]`
        class DeleteNotificationConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message to delete resource value config
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the ResourceValueConfig to delete
        class DeleteResourceValueConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The destination big query dataset to export findings to.
        # @!attribute [rw] dataset
        #   @return [::String]
        #     Required. The relative resource name of the destination dataset, in the
        #     form projects/\\{projectId}/datasets/\\{datasetId}.
        class BigQueryDestination
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The LRO metadata for a ExportFindings request.
        # @!attribute [rw] export_start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. Timestamp at which export was started
        # @!attribute [rw] big_query_destination
        #   @return [::Google::Cloud::SecurityCenter::V2::BigQueryDestination]
        #     Required. The destination big query dataset to export findings to.
        class ExportFindingsMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response to a ExportFindings request. Contains the LRO information.
        class ExportFindingsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for retrieving a BigQuery export.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the BigQuery export to retrieve. The following list shows
        #     some examples of the format:
        #
        #     +
        #     `organizations/{organization}/locations/{location}/bigQueryExports/{export_id}`
        #     + `folders/{folder}/locations/{location}/bigQueryExports/{export_id}`
        #     + `projects/{project}locations/{location}//bigQueryExports/{export_id}`
        class GetBigQueryExportRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for retrieving a mute config. If no location is specified,
        # default is global.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the mute config to retrieve. The following list shows
        #     some examples of the format:
        #
        #     + `organizations/{organization}/muteConfigs/{config_id}`
        #     +
        #     `organizations/{organization}/locations/{location}/muteConfigs/{config_id}`
        #     + `folders/{folder}/muteConfigs/{config_id}`
        #     + `folders/{folder}/locations/{location}/muteConfigs/{config_id}`
        #     + `projects/{project}/muteConfigs/{config_id}`
        #     + `projects/{project}/locations/{location}/muteConfigs/{config_id}`
        class GetMuteConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for getting a notification config.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the notification config to get. The following list shows
        #     some examples of the format:
        #
        #     +
        #     `organizations/[organization_id]/locations/[location_id]/notificationConfigs/[config_id]`
        #     +
        #     `folders/[folder_id]/locations/[location_id]/notificationConfigs/[config_id]`
        #     +
        #     `projects/[project_id]/locations/[location_id]/notificationConfigs/[config_id]`
        class GetNotificationConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message to get resource value config
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource value config to retrieve. Its format is
        #     organizations/\\{organization}/resourceValueConfigs/\\{config_id}.
        class GetResourceValueConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for getting a source.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Relative resource name of the source. Its format is
        #     `organizations/[organization_id]/source/[source_id]`.
        class GetSourceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for grouping by findings.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Name of the source to groupBy. If no location is specified,
        #     finding is assumed to be in global.
        #      The following list shows some examples:
        #
        #     + `organizations/[organization_id]/sources/[source_id]`
        #     +
        #     `organizations/[organization_id]/sources/[source_id]/locations/[location_id]`
        #     + `folders/[folder_id]/sources/[source_id]`
        #     + `folders/[folder_id]/sources/[source_id]/locations/[location_id]`
        #     + `projects/[project_id]/sources/[source_id]`
        #     + `projects/[project_id]/sources/[source_id]/locations/[location_id]`
        #
        #     To groupBy across all sources provide a source_id of `-`. The following
        #     list shows some examples:
        #
        #     + `organizations/{organization_id}/sources/-`
        #     + `organizations/{organization_id}/sources/-/locations/[location_id]`
        #     + `folders/{folder_id}/sources/-`
        #     + `folders/{folder_id}/sources/-/locations/[location_id]`
        #     + `projects/{project_id}/sources/-`
        #     + `projects/{project_id}/sources/-/locations/[location_id]`
        # @!attribute [rw] filter
        #   @return [::String]
        #     Expression that defines the filter to apply across findings.
        #     The expression is a list of one or more restrictions combined via logical
        #     operators `AND` and `OR`.
        #     Parentheses are supported, and `OR` has higher precedence than `AND`.
        #
        #     Restrictions have the form `<field> <operator> <value>` and may have a `-`
        #     character in front of them to indicate negation. Examples include:
        #
        #      * name
        #      * security_marks.marks.marka
        #
        #     The supported operators are:
        #
        #     * `=` for all value types.
        #     * `>`, `<`, `>=`, `<=` for integer values.
        #     * `:`, meaning substring matching, for strings.
        #
        #     The supported value types are:
        #
        #     * string literals in quotes.
        #     * integer literals without quotes.
        #     * boolean literals `true` and `false` without quotes.
        #
        #     The following field and operator combinations are supported:
        #
        #     * name: `=`
        #     * parent: `=`, `:`
        #     * resource_name: `=`, `:`
        #     * state: `=`, `:`
        #     * category: `=`, `:`
        #     * external_uri: `=`, `:`
        #     * event_time: `=`, `>`, `<`, `>=`, `<=`
        #
        #       Usage: This should be milliseconds since epoch or an RFC3339 string.
        #       Examples:
        #         `event_time = "2019-06-10T16:07:18-07:00"`
        #         `event_time = 1560208038000`
        #
        #     * severity: `=`, `:`
        #     * security_marks.marks: `=`, `:`
        #     * resource:
        #       * resource.name: `=`, `:`
        #       * resource.parent_name: `=`, `:`
        #       * resource.parent_display_name: `=`, `:`
        #       * resource.project_name: `=`, `:`
        #       * resource.project_display_name: `=`, `:`
        #       * resource.type: `=`, `:`
        # @!attribute [rw] group_by
        #   @return [::String]
        #     Required. Expression that defines what assets fields to use for grouping.
        #     The string value should follow SQL syntax: comma separated list of fields.
        #     For example: "parent,resource_name".
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The value returned by the last `GroupFindingsResponse`; indicates
        #     that this is a continuation of a prior `GroupFindings` call, and
        #     that the system should return the next page of data.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of results to return in a single response. Default is
        #     10, minimum is 1, maximum is 1000.
        class GroupFindingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for group by findings.
        # @!attribute [rw] group_by_results
        #   @return [::Array<::Google::Cloud::SecurityCenter::V2::GroupResult>]
        #     Group results. There exists an element for each existing unique
        #     combination of property/values. The element contains a count for the number
        #     of times those specific property/values appear.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results.
        # @!attribute [rw] total_size
        #   @return [::Integer]
        #     The total number of results matching the query.
        class GroupFindingsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Result containing the properties and count of a groupBy request.
        # @!attribute [rw] properties
        #   @return [::Google::Protobuf::Map{::String => ::Google::Protobuf::Value}]
        #     Properties matching the groupBy fields in the request.
        # @!attribute [rw] count
        #   @return [::Integer]
        #     Total count of resources for the given properties.
        class GroupResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Protobuf::Value]
          class PropertiesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request message for listing the attack paths for a given simulation or valued
        # resource.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Name of parent to list attack paths.
        #
        #     Valid formats:
        #     `organizations/{organization}`,
        #     `organizations/{organization}/simulations/{simulation}`
        #     `organizations/{organization}/simulations/{simulation}/attackExposureResults/{attack_exposure_result_v2}`
        #     `organizations/{organization}/simulations/{simulation}/valuedResources/{valued_resource}`
        # @!attribute [rw] filter
        #   @return [::String]
        #     The filter expression that filters the attack path in the response.
        #     Supported fields:
        #
        #       * `valued_resources` supports =
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The value returned by the last `ListAttackPathsResponse`; indicates
        #     that this is a continuation of a prior `ListAttackPaths` call, and
        #     that the system should return the next page of data.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of results to return in a single response. Default is
        #     10, minimum is 1, maximum is 1000.
        class ListAttackPathsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for listing the attack paths for a given simulation or
        # valued resource.
        # @!attribute [rw] attack_paths
        #   @return [::Array<::Google::Cloud::SecurityCenter::V2::AttackPath>]
        #     The attack paths that the attack path simulation identified.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results.
        class ListAttackPathsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for getting simulation.
        # Simulation name can include "latest" to retrieve the latest simulation
        # For example, "organizations/123/simulations/latest"
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The organization name or simulation name of this simulation
        #
        #     Valid format:
        #     `organizations/{organization}/simulations/latest`
        #     `organizations/{organization}/simulations/{simulation}`
        class GetSimulationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for getting a valued resource.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of this valued resource
        #
        #     Valid format:
        #     `organizations/{organization}/simulations/{simulation}/valuedResources/{valued_resource}`
        class GetValuedResourceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for listing BigQuery exports at a given scope e.g.
        # organization, folder or project.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns the collection of BigQuery exports. Its
        #     format is `organizations/[organization_id]/locations/[location_id]`,
        #     `folders/[folder_id]/locations/[location_id]`, or
        #     `projects/[project_id]/locations/[location_id]`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of configs to return. The service may return fewer than
        #     this value.
        #     If unspecified, at most 10 configs will be returned.
        #     The maximum value is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListBigQueryExports` call.
        #     Provide this to retrieve the subsequent page.
        #     When paginating, all other parameters provided to `ListBigQueryExports`
        #     must match the call that provided the page token.
        class ListBigQueryExportsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for listing BigQuery exports.
        # @!attribute [rw] big_query_exports
        #   @return [::Array<::Google::Cloud::SecurityCenter::V2::BigQueryExport>]
        #     The BigQuery exports from the specified parent.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListBigQueryExportsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for listing findings.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Name of the source the findings belong to. If no location is
        #     specified, the default is global. The following list shows some examples:
        #
        #     + `organizations/[organization_id]/sources/[source_id]`
        #     +
        #     `organizations/[organization_id]/sources/[source_id]/locations/[location_id]`
        #     + `folders/[folder_id]/sources/[source_id]`
        #     + `folders/[folder_id]/sources/[source_id]/locations/[location_id]`
        #     + `projects/[project_id]/sources/[source_id]`
        #     + `projects/[project_id]/sources/[source_id]/locations/[location_id]`
        #
        #     To list across all sources provide a source_id of `-`. The following
        #     list shows some examples:
        #
        #     + `organizations/{organization_id}/sources/-`
        #     + `organizations/{organization_id}/sources/-/locations/{location_id}`
        #     + `folders/{folder_id}/sources/-`
        #     + `folders/{folder_id}/sources/-locations/{location_id}`
        #     + `projects/{projects_id}/sources/-`
        #     + `projects/{projects_id}/sources/-/locations/{location_id}`
        # @!attribute [rw] filter
        #   @return [::String]
        #     Expression that defines the filter to apply across findings.
        #     The expression is a list of one or more restrictions combined via logical
        #     operators `AND` and `OR`.
        #     Parentheses are supported, and `OR` has higher precedence than `AND`.
        #
        #     Restrictions have the form `<field> <operator> <value>` and may have a `-`
        #     character in front of them to indicate negation. Examples include:
        #
        #      * name
        #      * security_marks.marks.marka
        #
        #     The supported operators are:
        #
        #     * `=` for all value types.
        #     * `>`, `<`, `>=`, `<=` for integer values.
        #     * `:`, meaning substring matching, for strings.
        #
        #     The supported value types are:
        #
        #     * string literals in quotes.
        #     * integer literals without quotes.
        #     * boolean literals `true` and `false` without quotes.
        #
        #     The following field and operator combinations are supported:
        #
        #     * name: `=`
        #     * parent: `=`, `:`
        #     * resource_name: `=`, `:`
        #     * state: `=`, `:`
        #     * category: `=`, `:`
        #     * external_uri: `=`, `:`
        #     * event_time: `=`, `>`, `<`, `>=`, `<=`
        #
        #       Usage: This should be milliseconds since epoch or an RFC3339 string.
        #       Examples:
        #         `event_time = "2019-06-10T16:07:18-07:00"`
        #         `event_time = 1560208038000`
        #
        #     * severity: `=`, `:`
        #     * security_marks.marks: `=`, `:`
        #     * resource:
        #       * resource.name: `=`, `:`
        #       * resource.parent_name: `=`, `:`
        #       * resource.parent_display_name: `=`, `:`
        #       * resource.project_name: `=`, `:`
        #       * resource.project_display_name: `=`, `:`
        #       * resource.type: `=`, `:`
        #       * resource.folders.resource_folder: `=`, `:`
        #       * resource.display_name: `=`, `:`
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Expression that defines what fields and order to use for sorting. The
        #     string value should follow SQL syntax: comma separated list of fields. For
        #     example: "name,parent". The default sorting order
        #     is ascending. To specify descending order for a field, a suffix " desc"
        #     should be appended to the field name. For example: "name
        #     desc,parent". Redundant space characters in the
        #     syntax are insignificant. "name desc,parent" and "
        #     name     desc  ,   parent  " are equivalent.
        #
        #     The following fields are supported:
        #     name
        #     parent
        #     state
        #     category
        #     resource_name
        #     event_time
        #     security_marks.marks
        # @!attribute [rw] field_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     A field mask to specify the Finding fields to be listed in the response.
        #     An empty field mask will list all fields.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The value returned by the last `ListFindingsResponse`; indicates
        #     that this is a continuation of a prior `ListFindings` call, and
        #     that the system should return the next page of data.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of results to return in a single response. Default is
        #     10, minimum is 1, maximum is 1000.
        class ListFindingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for listing findings.
        # @!attribute [rw] list_findings_results
        #   @return [::Array<::Google::Cloud::SecurityCenter::V2::ListFindingsResponse::ListFindingsResult>]
        #     Findings matching the list request.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results.
        # @!attribute [rw] total_size
        #   @return [::Integer]
        #     The total number of findings matching the query.
        class ListFindingsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Result containing the Finding.
          # @!attribute [rw] finding
          #   @return [::Google::Cloud::SecurityCenter::V2::Finding]
          #     Finding matching the search request.
          # @!attribute [r] resource
          #   @return [::Google::Cloud::SecurityCenter::V2::ListFindingsResponse::ListFindingsResult::Resource]
          #     Output only. Resource that is associated with this finding.
          class ListFindingsResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Information related to the Google Cloud resource that is
            # associated with this finding.
            # @!attribute [rw] name
            #   @return [::String]
            #     The full resource name of the resource. See:
            #     https://cloud.google.com/apis/design/resource_names#full_resource_name
            # @!attribute [rw] display_name
            #   @return [::String]
            #     The human readable name of the resource.
            # @!attribute [rw] type
            #   @return [::String]
            #     The full resource type of the resource.
            # @!attribute [rw] cloud_provider
            #   @return [::Google::Cloud::SecurityCenter::V2::CloudProvider]
            #     Indicates which cloud provider the finding is from.
            # @!attribute [rw] service
            #   @return [::String]
            #     The service or resource provider associated with the resource.
            # @!attribute [rw] location
            #   @return [::String]
            #     The region or location of the service (if applicable).
            # @!attribute [rw] gcp_metadata
            #   @return [::Google::Cloud::SecurityCenter::V2::GcpMetadata]
            #     The GCP metadata associated with the finding.
            #
            #     Note: The following fields are mutually exclusive: `gcp_metadata`, `aws_metadata`, `azure_metadata`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] aws_metadata
            #   @return [::Google::Cloud::SecurityCenter::V2::AwsMetadata]
            #     The AWS metadata associated with the finding.
            #
            #     Note: The following fields are mutually exclusive: `aws_metadata`, `gcp_metadata`, `azure_metadata`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] azure_metadata
            #   @return [::Google::Cloud::SecurityCenter::V2::AzureMetadata]
            #     The Azure metadata associated with the finding.
            #
            #     Note: The following fields are mutually exclusive: `azure_metadata`, `gcp_metadata`, `aws_metadata`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] resource_path
            #   @return [::Google::Cloud::SecurityCenter::V2::ResourcePath]
            #     Provides the path to the resource within the resource hierarchy.
            # @!attribute [rw] resource_path_string
            #   @return [::String]
            #     A string representation of the resource path.
            #     For Google Cloud, it has the format of
            #     `organizations/{organization_id}/folders/{folder_id}/folders/{folder_id}/projects/{project_id}`
            #     where there can be any number of folders.
            #     For AWS, it has the format of
            #     `org/{organization_id}/ou/{organizational_unit_id}/ou/{organizational_unit_id}/account/{account_id}`
            #     where there can be any number of organizational units.
            #     For Azure, it has the format of
            #     `mg/{management_group_id}/mg/{management_group_id}/subscription/{subscription_id}/rg/{resource_group_name}`
            #     where there can be any number of management groups.
            class Resource
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end

        # Request message for listing  mute configs at a given scope e.g. organization,
        # folder or project. If no location is specified, default is
        # global.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns the collection of mute configs. Its format
        #     is `organizations/[organization_id]", "folders/[folder_id]`,
        #     `projects/[project_id]`,
        #     `organizations/[organization_id]/locations/[location_id]`,
        #     `folders/[folder_id]/locations/[location_id]`,
        #     `projects/[project_id]/locations/[location_id]`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of configs to return. The service may return fewer than
        #     this value.
        #     If unspecified, at most 10 configs will be returned.
        #     The maximum value is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListMuteConfigs` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListMuteConfigs` must
        #     match the call that provided the page token.
        class ListMuteConfigsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for listing mute configs.
        # @!attribute [rw] mute_configs
        #   @return [::Array<::Google::Cloud::SecurityCenter::V2::MuteConfig>]
        #     The mute configs from the specified parent.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListMuteConfigsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for listing notification configs.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the parent in which to list the notification
        #     configurations. Its format is
        #     "organizations/[organization_id]/locations/[location_id]",
        #     "folders/[folder_id]/locations/[location_id]", or
        #     "projects/[project_id]/locations/[location_id]".
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The value returned by the last `ListNotificationConfigsResponse`; indicates
        #     that this is a continuation of a prior `ListNotificationConfigs` call, and
        #     that the system should return the next page of data.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of results to return in a single response. Default is
        #     10, minimum is 1, maximum is 1000.
        class ListNotificationConfigsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for listing notification configs.
        # @!attribute [rw] notification_configs
        #   @return [::Array<::Google::Cloud::SecurityCenter::V2::NotificationConfig>]
        #     Notification configs belonging to the requested parent.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results.
        class ListNotificationConfigsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message to list resource value configs of a parent
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns the collection of resource value configs.
        #     Its format is
        #     `organizations/[organization_id]`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of configs to return. The service may return fewer than
        #     this value.
        #     If unspecified, at most 10 configs will be returned.
        #     The maximum value is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListResourceValueConfigs` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `ListResourceValueConfigs` must match the call that provided the
        #     page token.
        #
        #     page_size can be specified, and the new page_size will be used.
        class ListResourceValueConfigsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message to list resource value configs
        # @!attribute [rw] resource_value_configs
        #   @return [::Array<::Google::Cloud::SecurityCenter::V2::ResourceValueConfig>]
        #     The resource value configs from the specified parent.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is empty, there are no subsequent pages.
        class ListResourceValueConfigsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for listing sources.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Resource name of the parent of sources to list. Its format should
        #     be `organizations/[organization_id]`, `folders/[folder_id]`, or
        #     `projects/[project_id]`.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The value returned by the last `ListSourcesResponse`; indicates
        #     that this is a continuation of a prior `ListSources` call, and
        #     that the system should return the next page of data.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of results to return in a single response. Default is
        #     10, minimum is 1, maximum is 1000.
        class ListSourcesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for listing sources.
        # @!attribute [rw] sources
        #   @return [::Array<::Google::Cloud::SecurityCenter::V2::Source>]
        #     Sources belonging to the requested parent.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results.
        class ListSourcesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for listing the valued resources for a given simulation.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Name of parent to list exposed resources.
        #
        #     Valid formats:
        #     `organizations/{organization}`,
        #     `organizations/{organization}/simulations/{simulation}`
        #     `organizations/{organization}/simulations/{simulation}/attackExposureResults/{attack_exposure_result_v2}`
        # @!attribute [rw] filter
        #   @return [::String]
        #     The filter expression that filters the valued resources in the response.
        #     Supported fields:
        #
        #       * `resource_value` supports =
        #       * `resource_type` supports =
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The value returned by the last `ListValuedResourcesResponse`; indicates
        #     that this is a continuation of a prior `ListValuedResources` call, and
        #     that the system should return the next page of data.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of results to return in a single response. Default is
        #     10, minimum is 1, maximum is 1000.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. The fields by which to order the valued resources response.
        #
        #     Supported fields:
        #
        #       * `exposed_score`
        #
        #       * `resource_value`
        #
        #       * `resource_type`
        #
        #     Values should be a comma separated list of fields. For example:
        #     `exposed_score,resource_value`.
        #
        #     The default sorting order is descending. To specify ascending or descending
        #     order for a field, append a " ASC" or a " DESC" suffix, respectively; for
        #     example: `exposed_score DESC`.
        class ListValuedResourcesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for listing the valued resources for a given simulation.
        # @!attribute [rw] valued_resources
        #   @return [::Array<::Google::Cloud::SecurityCenter::V2::ValuedResource>]
        #     The valued resources that the attack path simulation identified.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results.
        # @!attribute [rw] total_size
        #   @return [::Integer]
        #     The estimated total number of results matching the query.
        class ListValuedResourcesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for updating a finding's state.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The [relative resource
        #     name](https://cloud.google.com/apis/design/resource_names#relative_resource_name)
        #     of the finding. If no location is specified, finding is assumed to be in
        #     global. The following list shows some examples:
        #
        #     +
        #     `organizations/{organization_id}/sources/{source_id}/findings/{finding_id}`
        #     +
        #     `organizations/{organization_id}/sources/{source_id}/locations/{location_id}/findings/{finding_id}`
        #     + `folders/{folder_id}/sources/{source_id}/findings/{finding_id}`
        #     +
        #     `folders/{folder_id}/sources/{source_id}/locations/{location_id}/findings/{finding_id}`
        #     + `projects/{project_id}/sources/{source_id}/findings/{finding_id}`
        #     +
        #     `projects/{project_id}/sources/{source_id}/locations/{location_id}/findings/{finding_id}`
        # @!attribute [rw] state
        #   @return [::Google::Cloud::SecurityCenter::V2::Finding::State]
        #     Required. The desired State of the finding.
        class SetFindingStateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for updating a finding's mute status.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The [relative resource
        #     name](https://cloud.google.com/apis/design/resource_names#relative_resource_name)
        #     of the finding. If no location is specified, finding is assumed to be in
        #     global. The following list shows some examples:
        #
        #     +
        #     `organizations/{organization_id}/sources/{source_id}/findings/{finding_id}`
        #     +
        #     `organizations/{organization_id}/sources/{source_id}/locations/{location_id}/findings/{finding_id}`
        #     + `folders/{folder_id}/sources/{source_id}/findings/{finding_id}`
        #     +
        #     `folders/{folder_id}/sources/{source_id}/locations/{location_id}/findings/{finding_id}`
        #     + `projects/{project_id}/sources/{source_id}/findings/{finding_id}`
        #     +
        #     `projects/{project_id}/sources/{source_id}/locations/{location_id}/findings/{finding_id}`
        # @!attribute [rw] mute
        #   @return [::Google::Cloud::SecurityCenter::V2::Finding::Mute]
        #     Required. The desired state of the Mute.
        class SetMuteRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for updating a BigQuery export.
        # @!attribute [rw] big_query_export
        #   @return [::Google::Cloud::SecurityCenter::V2::BigQueryExport]
        #     Required. The BigQuery export being updated.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The list of fields to be updated.
        #     If empty all mutable fields will be updated.
        class UpdateBigQueryExportRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for updating a ExternalSystem resource.
        # @!attribute [rw] external_system
        #   @return [::Google::Cloud::SecurityCenter::V2::ExternalSystem]
        #     Required. The external system resource to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The FieldMask to use when updating the external system resource.
        #
        #     If empty all mutable fields will be updated.
        class UpdateExternalSystemRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for updating or creating a finding.
        # @!attribute [rw] finding
        #   @return [::Google::Cloud::SecurityCenter::V2::Finding]
        #     Required. The finding resource to update or create if it does not already
        #     exist. parent, security_marks, and update_time will be ignored.
        #
        #     In the case of creation, the finding id portion of the name must be
        #     alphanumeric and less than or equal to 32 characters and greater than 0
        #     characters in length.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The FieldMask to use when updating the finding resource. This field should
        #     not be specified when creating a finding.
        #
        #     When updating a finding, an empty mask is treated as updating all mutable
        #     fields and replacing source_properties.  Individual source_properties can
        #     be added/updated by using "source_properties.<property key>" in the field
        #     mask.
        class UpdateFindingRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for updating a mute config.
        # @!attribute [rw] mute_config
        #   @return [::Google::Cloud::SecurityCenter::V2::MuteConfig]
        #     Required. The mute config being updated.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The list of fields to be updated.
        #     If empty all mutable fields will be updated.
        class UpdateMuteConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for updating a notification config.
        # @!attribute [rw] notification_config
        #   @return [::Google::Cloud::SecurityCenter::V2::NotificationConfig]
        #     Required. The notification config to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The FieldMask to use when updating the notification config.
        #
        #     If empty all mutable fields will be updated.
        class UpdateNotificationConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message to update resource value config
        # @!attribute [rw] resource_value_config
        #   @return [::Google::Cloud::SecurityCenter::V2::ResourceValueConfig]
        #     Required. The resource value config being updated.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The list of fields to be updated.
        #     If empty all mutable fields will be updated.
        #
        #     To update nested fields, include the top level field in the mask
        #     For example, to update gcp_metadata.resource_type, include the
        #     "gcp_metadata" field mask
        class UpdateResourceValueConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for updating a SecurityMarks resource.
        # @!attribute [rw] security_marks
        #   @return [::Google::Cloud::SecurityCenter::V2::SecurityMarks]
        #     Required. The security marks resource to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The FieldMask to use when updating the security marks resource.
        #
        #     The field mask must not contain duplicate fields.
        #     If empty or set to "marks", all marks will be replaced.  Individual
        #     marks can be updated using "marks.<mark_key>".
        class UpdateSecurityMarksRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for updating a source.
        # @!attribute [rw] source
        #   @return [::Google::Cloud::SecurityCenter::V2::Source]
        #     Required. The source resource to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The FieldMask to use when updating the source resource.
        #
        #     If empty all mutable fields will be updated.
        class UpdateSourceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
