# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module SecurityCenter
      module V2
        # Represents a posture that is deployed on Google Cloud by the
        # Security Command Center Posture Management service.
        # A posture contains one or more policy sets. A policy set is a
        # group of policies that enforce a set of security rules on Google
        # Cloud.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the posture, for example, `CIS-Posture`.
        # @!attribute [rw] revision_id
        #   @return [::String]
        #     The version of the posture, for example, `c7cfa2a8`.
        # @!attribute [rw] posture_deployment_resource
        #   @return [::String]
        #     The project, folder, or organization on which the posture is deployed,
        #     for example, `projects/{project_number}`.
        # @!attribute [rw] posture_deployment
        #   @return [::String]
        #     The name of the posture deployment, for example,
        #     `organizations/{org_id}/posturedeployments/{posture_deployment_id}`.
        # @!attribute [rw] changed_policy
        #   @return [::String]
        #     The name of the updated policy, for example,
        #     `projects/{project_id}/policies/{constraint_name}`.
        # @!attribute [rw] policy_set
        #   @return [::String]
        #     The name of the updated policy set, for example, `cis-policyset`.
        # @!attribute [rw] policy
        #   @return [::String]
        #     The ID of the updated policy, for example, `compute-policy-1`.
        # @!attribute [rw] policy_drift_details
        #   @return [::Array<::Google::Cloud::SecurityCenter::V2::SecurityPosture::PolicyDriftDetails>]
        #     The details about a change in an updated policy that violates the deployed
        #     posture.
        class SecurityPosture
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The policy field that violates the deployed posture and its expected and
          # detected values.
          # @!attribute [rw] field
          #   @return [::String]
          #     The name of the updated field, for example
          #     constraint.implementation.policy_rules[0].enforce
          # @!attribute [rw] expected_value
          #   @return [::String]
          #     The value of this field that was configured in a posture, for example,
          #     `true` or `allowed_values={"projects/29831892"}`.
          # @!attribute [rw] detected_value
          #   @return [::String]
          #     The detected value that violates the deployed posture, for example,
          #     `false` or `allowed_values={"projects/22831892"}`.
          class PolicyDriftDetails
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
