# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module SecurityCenter
      module V2
        # A mute config is a Cloud SCC resource that contains the configuration
        # to mute create/update events of findings.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. This field will be ignored if provided on config creation. The
        #     following list shows some examples of the format:
        #
        #     + `organizations/{organization}/muteConfigs/{mute_config}`
        #     +
        #     `organizations/{organization}locations/{location}//muteConfigs/{mute_config}`
        #     + `folders/{folder}/muteConfigs/{mute_config}`
        #     + `folders/{folder}/locations/{location}/muteConfigs/{mute_config}`
        #     + `projects/{project}/muteConfigs/{mute_config}`
        #     + `projects/{project}/locations/{location}/muteConfigs/{mute_config}`
        # @!attribute [rw] description
        #   @return [::String]
        #     A description of the mute config.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Required. An expression that defines the filter to apply across
        #     create/update events of findings. While creating a filter string, be
        #     mindful of the scope in which the mute configuration is being created.
        #     E.g., If a filter contains project = X but is created under the project = Y
        #     scope, it might not match any findings.
        #
        #     The following field and operator combinations are supported:
        #
        #     * severity: `=`, `:`
        #     * category: `=`, `:`
        #     * resource.name: `=`, `:`
        #     * resource.project_name: `=`, `:`
        #     * resource.project_display_name: `=`, `:`
        #     * resource.folders.resource_folder: `=`, `:`
        #     * resource.parent_name: `=`, `:`
        #     * resource.parent_display_name: `=`, `:`
        #     * resource.type: `=`, `:`
        #     * finding_class: `=`, `:`
        #     * indicator.ip_addresses: `=`, `:`
        #     * indicator.domains: `=`, `:`
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which the mute config was created.
        #     This field is set by the server and will be ignored if provided on config
        #     creation.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The most recent time at which the mute config was updated.
        #     This field is set by the server and will be ignored if provided on config
        #     creation or update.
        # @!attribute [r] most_recent_editor
        #   @return [::String]
        #     Output only. Email address of the user who last edited the mute config.
        #     This field is set by the server and will be ignored if provided on config
        #     creation or update.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::SecurityCenter::V2::MuteConfig::MuteConfigType]
        #     Required. The type of the mute config, which determines what type of mute
        #     state the config affects. Immutable after creation.
        # @!attribute [rw] expiry_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. The expiry of the mute config. Only applicable for dynamic
        #     configs. If the expiry is set, when the config expires, it is removed from
        #     all findings.
        class MuteConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The type of MuteConfig.
          module MuteConfigType
            # Unused.
            MUTE_CONFIG_TYPE_UNSPECIFIED = 0

            # A static mute config, which sets the static mute state of future matching
            # findings to muted. Once the static mute state has been set, finding or
            # config modifications will not affect the state.
            STATIC = 1

            # A dynamic mute config, which is applied to existing and future matching
            # findings, setting their dynamic mute state to "muted". If the config is
            # updated or deleted, or a matching finding is updated, such that the
            # finding doesn't match the config, the config will be removed from the
            # finding, and the finding's dynamic mute state may become "unmuted"
            # (unless other configs still match).
            DYNAMIC = 2
          end
        end
      end
    end
  end
end
