# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module SecurityCenter
      module V2
        # MITRE ATT&CK tactics and techniques related to this finding.
        # See: https://attack.mitre.org
        # @!attribute [rw] primary_tactic
        #   @return [::Google::Cloud::SecurityCenter::V2::MitreAttack::Tactic]
        #     The MITRE ATT&CK tactic most closely represented by this finding, if any.
        # @!attribute [rw] primary_techniques
        #   @return [::Array<::Google::Cloud::SecurityCenter::V2::MitreAttack::Technique>]
        #     The MITRE ATT&CK technique most closely represented by this finding, if
        #     any. primary_techniques is a repeated field because there are multiple
        #     levels of MITRE ATT&CK techniques.  If the technique most closely
        #     represented by this finding is a sub-technique (e.g. `SCANNING_IP_BLOCKS`),
        #     both the sub-technique and its parent technique(s) will be listed (e.g.
        #     `SCANNING_IP_BLOCKS`, `ACTIVE_SCANNING`).
        # @!attribute [rw] additional_tactics
        #   @return [::Array<::Google::Cloud::SecurityCenter::V2::MitreAttack::Tactic>]
        #     Additional MITRE ATT&CK tactics related to this finding, if any.
        # @!attribute [rw] additional_techniques
        #   @return [::Array<::Google::Cloud::SecurityCenter::V2::MitreAttack::Technique>]
        #     Additional MITRE ATT&CK techniques related to this finding, if any, along
        #     with any of their respective parent techniques.
        # @!attribute [rw] version
        #   @return [::String]
        #     The MITRE ATT&CK version referenced by the above fields. E.g. "8".
        class MitreAttack
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # MITRE ATT&CK tactics that can be referenced by SCC findings.
          # See: https://attack.mitre.org/tactics/enterprise/
          module Tactic
            # Unspecified value.
            TACTIC_UNSPECIFIED = 0

            # TA0043
            RECONNAISSANCE = 1

            # TA0042
            RESOURCE_DEVELOPMENT = 2

            # TA0001
            INITIAL_ACCESS = 5

            # TA0002
            EXECUTION = 3

            # TA0003
            PERSISTENCE = 6

            # TA0004
            PRIVILEGE_ESCALATION = 8

            # TA0005
            DEFENSE_EVASION = 7

            # TA0006
            CREDENTIAL_ACCESS = 9

            # TA0007
            DISCOVERY = 10

            # TA0008
            LATERAL_MOVEMENT = 11

            # TA0009
            COLLECTION = 12

            # TA0011
            COMMAND_AND_CONTROL = 4

            # TA0010
            EXFILTRATION = 13

            # TA0040
            IMPACT = 14
          end

          # MITRE ATT&CK techniques that can be referenced by Security Command Center
          # findings. See: https://attack.mitre.org/techniques/enterprise/
          module Technique
            # Unspecified value.
            TECHNIQUE_UNSPECIFIED = 0

            # T1001
            DATA_OBFUSCATION = 70

            # T1001.002
            DATA_OBFUSCATION_STEGANOGRAPHY = 71

            # T1003
            OS_CREDENTIAL_DUMPING = 114

            # T1003.007
            OS_CREDENTIAL_DUMPING_PROC_FILESYSTEM = 115

            # T1003.008
            OS_CREDENTIAL_DUMPING_ETC_PASSWORD_AND_ETC_SHADOW = 122

            # T1005
            DATA_FROM_LOCAL_SYSTEM = 117

            # T1020
            AUTOMATED_EXFILTRATION = 68

            # T1027
            OBFUSCATED_FILES_OR_INFO = 72

            # T1027.003
            STEGANOGRAPHY = 73

            # T1027.004
            COMPILE_AFTER_DELIVERY = 74

            # T1027.010
            COMMAND_OBFUSCATION = 75

            # T1029
            SCHEDULED_TRANSFER = 120

            # T1033
            SYSTEM_OWNER_USER_DISCOVERY = 118

            # T1036
            MASQUERADING = 49

            # T1036.005
            MATCH_LEGITIMATE_NAME_OR_LOCATION = 50

            # T1037
            BOOT_OR_LOGON_INITIALIZATION_SCRIPTS = 37

            # T1037.005
            STARTUP_ITEMS = 38

            # T1046
            NETWORK_SERVICE_DISCOVERY = 32

            # T1053
            SCHEDULED_TASK_JOB = 89

            # T1053.003
            SCHEDULED_TASK_JOB_CRON = 119

            # T1053.007
            CONTAINER_ORCHESTRATION_JOB = 90

            # T1055
            PROCESS_INJECTION = 93

            # T1056
            INPUT_CAPTURE = 103

            # T1056.001
            INPUT_CAPTURE_KEYLOGGING = 104

            # T1057
            PROCESS_DISCOVERY = 56

            # T1059
            COMMAND_AND_SCRIPTING_INTERPRETER = 6

            # T1059.004
            UNIX_SHELL = 7

            # T1059.006
            PYTHON = 59

            # T1068
            EXPLOITATION_FOR_PRIVILEGE_ESCALATION = 63

            # T1069
            PERMISSION_GROUPS_DISCOVERY = 18

            # T1069.003
            CLOUD_GROUPS = 19

            # T1070
            INDICATOR_REMOVAL = 123

            # T1070.002
            INDICATOR_REMOVAL_CLEAR_LINUX_OR_MAC_SYSTEM_LOGS = 124

            # T1070.003
            INDICATOR_REMOVAL_CLEAR_COMMAND_HISTORY = 125

            # T1070.004
            INDICATOR_REMOVAL_FILE_DELETION = 64

            # T1070.006
            INDICATOR_REMOVAL_TIMESTOMP = 128

            # T1070.008
            INDICATOR_REMOVAL_CLEAR_MAILBOX_DATA = 126

            # T1071
            APPLICATION_LAYER_PROTOCOL = 45

            # T1071.004
            DNS = 46

            # T1072
            SOFTWARE_DEPLOYMENT_TOOLS = 47

            # T1078
            VALID_ACCOUNTS = 14

            # T1078.001
            DEFAULT_ACCOUNTS = 35

            # T1078.003
            LOCAL_ACCOUNTS = 15

            # T1078.004
            CLOUD_ACCOUNTS = 16

            # T1083
            FILE_AND_DIRECTORY_DISCOVERY = 121

            # T1087.001
            ACCOUNT_DISCOVERY_LOCAL_ACCOUNT = 116

            # T1090
            PROXY = 9

            # T1090.002
            EXTERNAL_PROXY = 10

            # T1090.003
            MULTI_HOP_PROXY = 11

            # T1098
            ACCOUNT_MANIPULATION = 22

            # T1098.001
            ADDITIONAL_CLOUD_CREDENTIALS = 40

            # T1098.003
            ADDITIONAL_CLOUD_ROLES = 67

            # T1098.004
            SSH_AUTHORIZED_KEYS = 23

            # T1098.006
            ADDITIONAL_CONTAINER_CLUSTER_ROLES = 58

            # T1104
            MULTI_STAGE_CHANNELS = 76

            # T1105
            INGRESS_TOOL_TRANSFER = 3

            # T1106
            NATIVE_API = 4

            # T1110
            BRUTE_FORCE = 44

            # T1119
            AUTOMATED_COLLECTION = 94

            # T1129
            SHARED_MODULES = 5

            # T1132
            DATA_ENCODING = 77

            # T1132.001
            STANDARD_ENCODING = 78

            # T1134
            ACCESS_TOKEN_MANIPULATION = 33

            # T1134.001
            TOKEN_IMPERSONATION_OR_THEFT = 39

            # T1136
            CREATE_ACCOUNT = 79

            # T1136.001
            LOCAL_ACCOUNT = 80

            # T1140
            DEOBFUSCATE_DECODE_FILES_OR_INFO = 95

            # T1190
            EXPLOIT_PUBLIC_FACING_APPLICATION = 27

            # T1195
            SUPPLY_CHAIN_COMPROMISE = 129

            # T1195.001
            COMPROMISE_SOFTWARE_DEPENDENCIES_AND_DEVELOPMENT_TOOLS = 130

            # T1203
            EXPLOITATION_FOR_CLIENT_EXECUTION = 134

            # T1204
            USER_EXECUTION = 69

            # T1222.002
            LINUX_AND_MAC_FILE_AND_DIRECTORY_PERMISSIONS_MODIFICATION = 135

            # T1484
            DOMAIN_POLICY_MODIFICATION = 30

            # T1485
            DATA_DESTRUCTION = 29

            # T1486
            DATA_ENCRYPTED_FOR_IMPACT = 132

            # T1489
            SERVICE_STOP = 52

            # T1490
            INHIBIT_SYSTEM_RECOVERY = 36

            # T1495
            FIRMWARE_CORRUPTION = 81

            # T1496
            RESOURCE_HIJACKING = 8

            # T1498
            NETWORK_DENIAL_OF_SERVICE = 17

            # T1526
            CLOUD_SERVICE_DISCOVERY = 48

            # T1528
            STEAL_APPLICATION_ACCESS_TOKEN = 42

            # T1531
            ACCOUNT_ACCESS_REMOVAL = 51

            # T1537
            TRANSFER_DATA_TO_CLOUD_ACCOUNT = 91

            # T1539
            STEAL_WEB_SESSION_COOKIE = 25

            # T1543
            CREATE_OR_MODIFY_SYSTEM_PROCESS = 24

            # T1546
            EVENT_TRIGGERED_EXECUTION = 65

            # T1547
            BOOT_OR_LOGON_AUTOSTART_EXECUTION = 82

            # T1547.006
            KERNEL_MODULES_AND_EXTENSIONS = 83

            # T1547.009
            SHORTCUT_MODIFICATION = 127

            # T1548
            ABUSE_ELEVATION_CONTROL_MECHANISM = 34

            # T1548.001
            ABUSE_ELEVATION_CONTROL_MECHANISM_SETUID_AND_SETGID = 136

            # T1548.003
            ABUSE_ELEVATION_CONTROL_MECHANISM_SUDO_AND_SUDO_CACHING = 109

            # T1552
            UNSECURED_CREDENTIALS = 13

            # T1552.001
            CREDENTIALS_IN_FILES = 105

            # T1552.003
            BASH_HISTORY = 96

            # T1552.004
            PRIVATE_KEYS = 97

            # T1553
            SUBVERT_TRUST_CONTROL = 106

            # T1553.004
            INSTALL_ROOT_CERTIFICATE = 107

            # T1554
            COMPROMISE_HOST_SOFTWARE_BINARY = 84

            # T1555
            CREDENTIALS_FROM_PASSWORD_STORES = 98

            # T1556
            MODIFY_AUTHENTICATION_PROCESS = 28

            # T1556.003
            PLUGGABLE_AUTHENTICATION_MODULES = 108

            # T1556.006
            MULTI_FACTOR_AUTHENTICATION = 137

            # T1562
            IMPAIR_DEFENSES = 31

            # T1562.001
            DISABLE_OR_MODIFY_TOOLS = 55

            # T1562.006
            INDICATOR_BLOCKING = 110

            # T1562.012
            DISABLE_OR_MODIFY_LINUX_AUDIT_SYSTEM = 111

            # T1564
            HIDE_ARTIFACTS = 85

            # T1564.001
            HIDDEN_FILES_AND_DIRECTORIES = 86

            # T1564.002
            HIDDEN_USERS = 87

            # T1567
            EXFILTRATION_OVER_WEB_SERVICE = 20

            # T1567.002
            EXFILTRATION_TO_CLOUD_STORAGE = 21

            # T1568
            DYNAMIC_RESOLUTION = 12

            # T1570
            LATERAL_TOOL_TRANSFER = 41

            # T1574
            HIJACK_EXECUTION_FLOW = 112

            # T1574.006
            HIJACK_EXECUTION_FLOW_DYNAMIC_LINKER_HIJACKING = 113

            # T1578
            MODIFY_CLOUD_COMPUTE_INFRASTRUCTURE = 26

            # T1578.001
            CREATE_SNAPSHOT = 54

            # T1580
            CLOUD_INFRASTRUCTURE_DISCOVERY = 53

            # T1587
            DEVELOP_CAPABILITIES = 99

            # T1587.001
            DEVELOP_CAPABILITIES_MALWARE = 100

            # T1588
            OBTAIN_CAPABILITIES = 43

            # T1588.001
            OBTAIN_CAPABILITIES_MALWARE = 101

            # T1588.006
            OBTAIN_CAPABILITIES_VULNERABILITIES = 133

            # T1595
            ACTIVE_SCANNING = 1

            # T1595.001
            SCANNING_IP_BLOCKS = 2

            # T1608
            STAGE_CAPABILITIES = 88

            # T1608.001
            UPLOAD_MALWARE = 102

            # T1609
            CONTAINER_ADMINISTRATION_COMMAND = 60

            # T1610
            DEPLOY_CONTAINER = 66

            # T1611
            ESCAPE_TO_HOST = 61

            # T1613
            CONTAINER_AND_RESOURCE_DISCOVERY = 57

            # T1620
            REFLECTIVE_CODE_LOADING = 92

            # T1649
            STEAL_OR_FORGE_AUTHENTICATION_CERTIFICATES = 62

            # T1657
            FINANCIAL_THEFT = 131
          end
        end
      end
    end
  end
end
