# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module SecurityCenter
      module V2
        # An individual entry in a log.
        # @!attribute [rw] cloud_logging_entry
        #   @return [::Google::Cloud::SecurityCenter::V2::CloudLoggingEntry]
        #     An individual entry in a log stored in Cloud Logging.
        class LogEntry
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata taken from a [Cloud Logging
        # LogEntry](https://cloud.google.com/logging/docs/reference/v2/rest/v2/LogEntry)
        # @!attribute [rw] insert_id
        #   @return [::String]
        #     A unique identifier for the log entry.
        # @!attribute [rw] log_id
        #   @return [::String]
        #     The type of the log (part of `log_name`. `log_name` is the resource name of
        #     the log to which this log entry belongs). For example:
        #     `cloudresourcemanager.googleapis.com/activity` Note that this field is not
        #     URL-encoded, unlike in `LogEntry`.
        # @!attribute [rw] resource_container
        #   @return [::String]
        #     The organization, folder, or project of the monitored resource that
        #     produced this log entry.
        # @!attribute [rw] timestamp
        #   @return [::Google::Protobuf::Timestamp]
        #     The time the event described by the log entry occurred.
        class CloudLoggingEntry
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
