# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module SecurityCenter
      module V2
        # Kernel mode rootkit signatures.
        # @!attribute [rw] name
        #   @return [::String]
        #     Rootkit name, when available.
        # @!attribute [rw] unexpected_code_modification
        #   @return [::Boolean]
        #     True if unexpected modifications of kernel code memory are present.
        # @!attribute [rw] unexpected_read_only_data_modification
        #   @return [::Boolean]
        #     True if unexpected modifications of kernel read-only data memory are
        #     present.
        # @!attribute [rw] unexpected_ftrace_handler
        #   @return [::Boolean]
        #     True if `ftrace` points are present with callbacks pointing to regions
        #     that are not in the expected kernel or module code range.
        # @!attribute [rw] unexpected_kprobe_handler
        #   @return [::Boolean]
        #     True if `kprobe` points are present with callbacks pointing to regions
        #     that are not in the expected kernel or module code range.
        # @!attribute [rw] unexpected_kernel_code_pages
        #   @return [::Boolean]
        #     True if kernel code pages that are not in the expected kernel or module
        #     code regions are present.
        # @!attribute [rw] unexpected_system_call_handler
        #   @return [::Boolean]
        #     True if system call handlers that are are not in the expected kernel or
        #     module code regions are present.
        # @!attribute [rw] unexpected_interrupt_handler
        #   @return [::Boolean]
        #     True if interrupt handlers that are are not in the expected kernel or
        #     module code regions are present.
        # @!attribute [rw] unexpected_processes_in_runqueue
        #   @return [::Boolean]
        #     True if unexpected processes in the scheduler run queue are present. Such
        #     processes are in the run queue, but not in the process task list.
        class KernelRootkit
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
