# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module SecurityCenter
      module V2
        # Describes a job
        # @!attribute [rw] name
        #   @return [::String]
        #     The fully-qualified name for a job.
        #     e.g. `projects/<project_id>/jobs/<job_id>`
        # @!attribute [r] state
        #   @return [::Google::Cloud::SecurityCenter::V2::JobState]
        #     Output only. State of the job, such as `RUNNING` or `PENDING`.
        # @!attribute [rw] error_code
        #   @return [::Integer]
        #     Optional. If the job did not complete successfully, this field describes
        #     why.
        # @!attribute [rw] location
        #   @return [::String]
        #     Optional. Gives the location where the job ran, such as `US` or
        #     `europe-west1`
        class Job
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # JobState represents the state of the job.
        module JobState
          # Unspecified represents an unknown state and should not be used.
          JOB_STATE_UNSPECIFIED = 0

          # Job is scheduled and pending for run
          PENDING = 1

          # Job in progress
          RUNNING = 2

          # Job has completed with success
          SUCCEEDED = 3

          # Job has completed but with failure
          FAILED = 4
        end
      end
    end
  end
end
