# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module SecurityCenter
      module V2
        # IP rules associated with the finding.
        # @!attribute [rw] direction
        #   @return [::Google::Cloud::SecurityCenter::V2::IpRules::Direction]
        #     The direction that the rule is applicable to, one of ingress or egress.
        # @!attribute [rw] allowed
        #   @return [::Google::Cloud::SecurityCenter::V2::Allowed]
        #     Tuple with allowed rules.
        #
        #     Note: The following fields are mutually exclusive: `allowed`, `denied`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] denied
        #   @return [::Google::Cloud::SecurityCenter::V2::Denied]
        #     Tuple with denied rules.
        #
        #     Note: The following fields are mutually exclusive: `denied`, `allowed`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] source_ip_ranges
        #   @return [::Array<::String>]
        #     If source IP ranges are specified, the firewall rule applies only to
        #     traffic that has a source IP address in these ranges. These ranges must be
        #     expressed in CIDR format. Only supports IPv4.
        # @!attribute [rw] destination_ip_ranges
        #   @return [::Array<::String>]
        #     If destination IP ranges are specified, the firewall rule applies only to
        #     traffic that has a destination IP address in these ranges. These ranges
        #     must be expressed in CIDR format. Only supports IPv4.
        # @!attribute [rw] exposed_services
        #   @return [::Array<::String>]
        #     Name of the network protocol service, such as FTP, that is exposed by the
        #     open port. Follows the naming convention available at:
        #     https://www.iana.org/assignments/service-names-port-numbers/service-names-port-numbers.xhtml.
        class IpRules
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The type of direction that the rule is applicable to, one of ingress or
          # egress. Not applicable to OPEN_X_PORT findings.
          module Direction
            # Unspecified direction value.
            DIRECTION_UNSPECIFIED = 0

            # Ingress direction value.
            INGRESS = 1

            # Egress direction value.
            EGRESS = 2
          end
        end

        # IP rule information.
        # @!attribute [rw] protocol
        #   @return [::String]
        #     The IP protocol this rule applies to. This value can either be one of the
        #     following well known protocol strings (TCP, UDP, ICMP, ESP, AH, IPIP,
        #     SCTP) or a string representation of the integer value.
        # @!attribute [rw] port_ranges
        #   @return [::Array<::Google::Cloud::SecurityCenter::V2::IpRule::PortRange>]
        #     Optional. An optional list of ports to which this rule applies. This field
        #     is only applicable for the UDP or (S)TCP protocols. Each entry must be
        #     either an integer or a range including a min and max port number.
        class IpRule
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A port range which is inclusive of the min and max values.
          # Values are between 0 and 2^16-1. The max can be equal / must be not smaller
          # than the min value. If min and max are equal this indicates that it is a
          # single port.
          # @!attribute [rw] min
          #   @return [::Integer]
          #     Minimum port value.
          # @!attribute [rw] max
          #   @return [::Integer]
          #     Maximum port value.
          class PortRange
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Allowed IP rule.
        # @!attribute [rw] ip_rules
        #   @return [::Array<::Google::Cloud::SecurityCenter::V2::IpRule>]
        #     Optional. Optional list of allowed IP rules.
        class Allowed
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Denied IP rule.
        # @!attribute [rw] ip_rules
        #   @return [::Array<::Google::Cloud::SecurityCenter::V2::IpRule>]
        #     Optional. Optional list of denied IP rules.
        class Denied
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
