# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module SecurityCenter
      module V2
        # File information about the related binary/library used by an executable, or
        # the script used by a script interpreter
        # @!attribute [rw] path
        #   @return [::String]
        #     Absolute path of the file as a JSON encoded string.
        # @!attribute [rw] size
        #   @return [::Integer]
        #     Size of the file in bytes.
        # @!attribute [rw] sha256
        #   @return [::String]
        #     SHA256 hash of the first hashed_size bytes of the file encoded as a
        #     hex string.  If hashed_size == size, sha256 represents the SHA256 hash
        #     of the entire file.
        # @!attribute [rw] hashed_size
        #   @return [::Integer]
        #     The length in bytes of the file prefix that was hashed.  If
        #     hashed_size == size, any hashes reported represent the entire
        #     file.
        # @!attribute [rw] partially_hashed
        #   @return [::Boolean]
        #     True when the hash covers only a prefix of the file.
        # @!attribute [rw] contents
        #   @return [::String]
        #     Prefix of the file contents as a JSON-encoded string.
        # @!attribute [rw] disk_path
        #   @return [::Google::Cloud::SecurityCenter::V2::File::DiskPath]
        #     Path of the file in terms of underlying disk/partition identifiers.
        # @!attribute [rw] operations
        #   @return [::Array<::Google::Cloud::SecurityCenter::V2::File::FileOperation>]
        #     Operation(s) performed on a file.
        class File
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Path of the file in terms of underlying disk/partition identifiers.
          # @!attribute [rw] partition_uuid
          #   @return [::String]
          #     UUID of the partition (format
          #     https://wiki.archlinux.org/title/persistent_block_device_naming#by-uuid)
          # @!attribute [rw] relative_path
          #   @return [::String]
          #     Relative path of the file in the partition as a JSON encoded string.
          #     Example: /home/user1/executable_file.sh
          class DiskPath
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Operation(s) performed on a file.
          # @!attribute [rw] type
          #   @return [::Google::Cloud::SecurityCenter::V2::File::FileOperation::OperationType]
          #     The type of the operation
          class FileOperation
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The type of the operation
            module OperationType
              # The operation is unspecified.
              OPERATION_TYPE_UNSPECIFIED = 0

              # Represents an open operation.
              OPEN = 1

              # Represents a read operation.
              READ = 2

              # Represents a rename operation.
              RENAME = 3

              # Represents a write operation.
              WRITE = 4

              # Represents an execute operation.
              EXECUTE = 5
            end
          end
        end
      end
    end
  end
end
