# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module SecurityCenter
      module V2
        # Details about data retention deletion violations, in which the data is
        # non-compliant based on their retention or deletion time, as defined in the
        # applicable data security policy. The Data Retention Deletion (DRD) control is
        # a control of the DSPM (Data Security Posture Management) suite that enables
        # organizations to manage data retention and deletion policies in compliance
        # with regulations, such as GDPR and CRPA. DRD supports two primary policy
        # types: maximum storage length (max TTL) and minimum storage length (min TTL).
        # Both are aimed at helping organizations meet regulatory and data management
        # commitments.
        # @!attribute [rw] event_detection_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Timestamp indicating when the event was detected.
        # @!attribute [rw] data_object_count
        #   @return [::Integer]
        #     Number of objects that violated the policy for this resource. If the number
        #     is less than 1,000, then the value of this field is the exact number. If
        #     the number of objects that violated the policy is greater than or equal to
        #     1,000, then the value of this field is 1000.
        # @!attribute [rw] max_retention_allowed
        #   @return [::Google::Protobuf::Duration]
        #     Maximum duration of retention allowed from the DRD control. This comes
        #     from the DRD control where users set a max TTL for their data. For example,
        #     suppose that a user sets the max TTL for a Cloud Storage bucket to 90 days.
        #     However, an object in that bucket is 100 days old. In this case, a
        #     DataRetentionDeletionEvent will be generated for that Cloud Storage bucket,
        #     and the max_retention_allowed is 90 days.
        # @!attribute [rw] event_type
        #   @return [::Google::Cloud::SecurityCenter::V2::DataRetentionDeletionEvent::EventType]
        #     Type of the DRD event.
        class DataRetentionDeletionEvent
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Type of the DRD event.
          module EventType
            # Unspecified event type.
            EVENT_TYPE_UNSPECIFIED = 0

            # The maximum retention time has been exceeded.
            EVENT_TYPE_MAX_TTL_EXCEEDED = 1
          end
        end
      end
    end
  end
end
