# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module SecurityCenter
      module V2
        # Details about a data access attempt made by a principal not authorized under
        # applicable data security policy.
        # @!attribute [rw] event_id
        #   @return [::String]
        #     Unique identifier for data access event.
        # @!attribute [rw] principal_email
        #   @return [::String]
        #     The email address of the principal that accessed the data. The principal
        #     could be a user account, service account, Google group, or other.
        # @!attribute [rw] operation
        #   @return [::Google::Cloud::SecurityCenter::V2::DataAccessEvent::Operation]
        #     The operation performed by the principal to access the data.
        # @!attribute [rw] event_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Timestamp of data access event.
        class DataAccessEvent
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The operation of a data access event.
          module Operation
            # The operation is unspecified.
            OPERATION_UNSPECIFIED = 0

            # Represents a read operation.
            READ = 1

            # Represents a move operation.
            MOVE = 2

            # Represents a copy operation.
            COPY = 3
          end
        end
      end
    end
  end
end
