# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module SecurityCenter
      module V2
        # Fields related to Google Cloud Armor findings.
        # @!attribute [rw] security_policy
        #   @return [::Google::Cloud::SecurityCenter::V2::SecurityPolicy]
        #     Information about the [Google Cloud Armor security
        #     policy](https://cloud.google.com/armor/docs/security-policy-overview)
        #     relevant to the finding.
        # @!attribute [rw] requests
        #   @return [::Google::Cloud::SecurityCenter::V2::Requests]
        #     Information about incoming requests evaluated by [Google Cloud Armor
        #     security
        #     policies](https://cloud.google.com/armor/docs/security-policy-overview).
        # @!attribute [rw] adaptive_protection
        #   @return [::Google::Cloud::SecurityCenter::V2::AdaptiveProtection]
        #     Information about potential Layer 7 DDoS attacks identified by [Google
        #     Cloud Armor Adaptive
        #     Protection](https://cloud.google.com/armor/docs/adaptive-protection-overview).
        # @!attribute [rw] attack
        #   @return [::Google::Cloud::SecurityCenter::V2::Attack]
        #     Information about DDoS attack volume and classification.
        # @!attribute [rw] threat_vector
        #   @return [::String]
        #     Distinguish between volumetric & protocol DDoS attack and
        #     application layer attacks. For example, "L3_4" for Layer 3 and Layer 4 DDoS
        #     attacks, or "L_7" for Layer 7 DDoS attacks.
        # @!attribute [rw] duration
        #   @return [::Google::Protobuf::Duration]
        #     Duration of attack from the start until the current moment (updated every 5
        #     minutes).
        class CloudArmor
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Information about the [Google Cloud Armor security
        # policy](https://cloud.google.com/armor/docs/security-policy-overview)
        # relevant to the finding.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of the Google Cloud Armor security policy, for example,
        #     "my-security-policy".
        # @!attribute [rw] type
        #   @return [::String]
        #     The type of Google Cloud Armor security policy for example, 'backend
        #     security policy', 'edge security policy', 'network edge security policy',
        #     or 'always-on DDoS protection'.
        # @!attribute [rw] preview
        #   @return [::Boolean]
        #     Whether or not the associated rule or policy is in preview mode.
        class SecurityPolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Information about the requests relevant to the finding.
        # @!attribute [rw] ratio
        #   @return [::Float]
        #     For 'Increasing deny ratio', the ratio is the denied traffic divided by the
        #     allowed traffic. For 'Allowed traffic spike', the ratio is the allowed
        #     traffic in the short term divided by allowed traffic in the long term.
        # @!attribute [rw] short_term_allowed
        #   @return [::Integer]
        #     Allowed RPS (requests per second) in the short term.
        # @!attribute [rw] long_term_allowed
        #   @return [::Integer]
        #     Allowed RPS (requests per second) over the long term.
        # @!attribute [rw] long_term_denied
        #   @return [::Integer]
        #     Denied RPS (requests per second) over the long term.
        class Requests
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Information about [Google Cloud Armor Adaptive
        # Protection](https://cloud.google.com/armor/docs/cloud-armor-overview#google-cloud-armor-adaptive-protection).
        # @!attribute [rw] confidence
        #   @return [::Float]
        #     A score of 0 means that there is low confidence that the detected event is
        #     an actual attack. A score of 1 means that there is high confidence that the
        #     detected event is an attack. See the [Adaptive Protection
        #     documentation](https://cloud.google.com/armor/docs/adaptive-protection-overview#configure-alert-tuning)
        #     for further explanation.
        class AdaptiveProtection
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Information about DDoS attack volume and classification.
        # @!attribute [rw] volume_pps_long
        #   @return [::Integer]
        #     Total PPS (packets per second) volume of attack.
        # @!attribute [rw] volume_bps_long
        #   @return [::Integer]
        #     Total BPS (bytes per second) volume of attack.
        # @!attribute [rw] classification
        #   @return [::String]
        #     Type of attack, for example, 'SYN-flood', 'NTP-udp', or 'CHARGEN-udp'.
        # @!attribute [rw] volume_pps
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Integer]
        #     Total PPS (packets per second) volume of attack. Deprecated - refer to
        #     volume_pps_long instead.
        # @!attribute [rw] volume_bps
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Integer]
        #     Total BPS (bytes per second) volume of attack. Deprecated - refer to
        #     volume_bps_long instead.
        class Attack
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
