# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module SecurityCenter
      module V2
        # An attack exposure contains the results of an attack path simulation run.
        # @!attribute [rw] score
        #   @return [::Float]
        #     A number between 0 (inclusive) and infinity that represents how important
        #     this finding is to remediate. The higher the score, the more important it
        #     is to remediate.
        # @!attribute [rw] latest_calculation_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The most recent time the attack exposure was updated on this finding.
        # @!attribute [rw] attack_exposure_result
        #   @return [::String]
        #     The resource name of the attack path simulation result that contains the
        #     details regarding this attack exposure score.
        #     Example: `organizations/123/simulations/456/attackExposureResults/789`
        # @!attribute [r] state
        #   @return [::Google::Cloud::SecurityCenter::V2::AttackExposure::State]
        #     Output only. What state this AttackExposure is in. This captures whether or
        #     not an attack exposure has been calculated or not.
        # @!attribute [rw] exposed_high_value_resources_count
        #   @return [::Integer]
        #     The number of high value resources that are exposed as a result of this
        #     finding.
        # @!attribute [rw] exposed_medium_value_resources_count
        #   @return [::Integer]
        #     The number of medium value resources that are exposed as a result of this
        #     finding.
        # @!attribute [rw] exposed_low_value_resources_count
        #   @return [::Integer]
        #     The number of high value resources that are exposed as a result of this
        #     finding.
        class AttackExposure
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # This enum defines the various states an AttackExposure can be in.
          module State
            # The state is not specified.
            STATE_UNSPECIFIED = 0

            # The attack exposure has been calculated.
            CALCULATED = 1

            # The attack exposure has not been calculated.
            NOT_CALCULATED = 2
          end
        end
      end
    end
  end
end
